<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:c1')->mergeCells('A2:c2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:c2', 'BDBDBD'); 
cellColor('A1:c1', 'BDBDBD'); 
cellColor('A3:c3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE INVENTARIO PRECIO COMBOS')
            ->setCellValue('A2', '')
            ->setCellValue('A3', 'REF')
            ->setCellValue('B3', 'NOMBRE')
            ->setCellValue('C3', 'PRECIO');

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(10);   
$sheet->getColumnDimension('B')->setWidth(20);  
$sheet->getColumnDimension('C')->setWidth(20);

    $cel=4;//Numero de fila donde empezara a crear  el reporte
$query=mysqli_query($con,"SELECT * FROM combos where empresa='$empresa' ORDER BY com_nombre ASC ");

 while ($roww=mysqli_fetch_array($query))   
    {
        $com_id=$roww['com_id'];
        $sumador_total=0;
        $sql1=mysqli_query($con,"SELECT * FROM  combos_articulos where combos_com_id='$com_id'");
        while($row1=mysqli_fetch_array($sql1))
        {
            $coma_art_id=$row1['coma_art_id'];
            $coma_art_cantidad=$row1['coma_art_cantidad'];
            $coma_art_precio=$row1['coma_art_precio'];
            $art_pvp=$coma_art_cantidad*$coma_art_precio;
            $sumador_total+=$art_pvp;//Sumador
        }

        
         
    $a="A".$cel;
    $b="B".$cel;
    $c="C".$cel;
    $d="D".$cel;
    $e="E".$cel;
    $f="F".$cel;
       
    // Agregar datos
    $sheet
    ->setCellValue($a, $roww['com_referencia'])
    ->setCellValue($b, $roww['com_nombre'])
    ->setCellValue($c, number_format($sumador_total,0));
    
    
    $cel+=1;

      
}


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE INVENTARIO PRECIO COMBOS.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>