<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];
$cot_estado=$_GET['estado'];
$vendedores=$_GET['vendedores'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:K1')->mergeCells('A2:K2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:K2', 'BDBDBD'); 
cellColor('A1:K1', 'BDBDBD'); 
cellColor('A3:K3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE FACTURACION POR LOTE')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta);
            

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(10);   
$sheet->getColumnDimension('B')->setWidth(25);  
$sheet->getColumnDimension('C')->setWidth(30); 
$sheet->getColumnDimension('D')->setWidth(8); 
$sheet->getColumnDimension('E')->setWidth(8);
$sheet->getColumnDimension('F')->setWidth(12);
$sheet->getColumnDimension('G')->setWidth(10);
$sheet->getColumnDimension('H')->setWidth(10);
$sheet->getColumnDimension('I')->setWidth(10);
$sheet->getColumnDimension('J')->setWidth(15);
$sheet->getColumnDimension('K')->setWidth(15);


    $cel=3;//Numero de fila donde empezara a crear  el reporte

    $a="A".$cel;
    $b="B".$cel;
    $c="C".$cel;
    $d="D".$cel;
    $e="E".$cel;
    $f="F".$cel;
    $g="G".$cel;
    $h="H".$cel;
    $i="I".$cel;
    $j="J".$cel;
    $k="K".$cel;

    $sheet->setCellValue($a, '# REF')
    ->setCellValue($b, 'NOMBRE')
    ->setCellValue($c, 'PROVEEDOR')
    ->setCellValue($d, 'CANT')
    ->setCellValue($e, 'STOCK')
    ->setCellValue($f, 'FALTANTES')
    ->setCellValue($g, 'COSTO FALTANTES')
    ->setCellValue($h, 'COSTO U')
    ->setCellValue($i, 'COSTO T')
    ->setCellValue($j, 'VENTA U')
    ->setCellValue($k, 'VENTA T');
   
    cellColor('A'.$cel.':K'.$cel, 'FF4D00');
  
    $cel+=1;


$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";

$global_costo=0;
$global_venta=0;
$global_faltante=0;

$sql1p=mysqli_query($con, "SELECT * from proveedor where empresa='$empresa' order by pro_nombre asc");
while ($cosp=mysqli_fetch_array($sql1p))
{
    $pro_id=$cosp['pro_id'];
    $pro_nombre=$cosp['pro_nombre'];

    $costo_t=0;
    $venta_t=0;
    $faltante_t=0;
   
    $sql=mysqli_query($con, "SELECT *, sum(cd.cotd_cantidad) as can,  AVG(cd.cotd_precio) as pv from cotizacion c, cotizacion_detalle cd,articulos a  WHERE c.cot_fecha BETWEEN '$desde' AND '$hasta' and c.sucursal='$sucursal' and c.empresa='$empresa' and c.cot_id=cd.cotizacion_cot_id  and a.proveedor_pro_id='$pro_id' and a.art_id=cd.cotd_art_id and c.cot_estado='$cot_estado' and c.vendedor  IN('".$vendedores."') group by cd.cotd_art_id, cd.cotd_precio order by a.art_nombre asc ");

    while ($row=mysqli_fetch_array($sql))
    {
        $cotd_art_id=$row['cotd_art_id'];
        $art_id_bod=$row['art_id_bod'];
        $cantidad=$row['can'];
        $venta=$row['pv'];
        $venta_item=$cantidad*$venta;

        $venta_t+=$venta_item;

        $sql1=mysqli_query($con, "SELECT * from articulos where art_id='$cotd_art_id' and empresa='$empresa' ");
        $cos=mysqli_fetch_array($sql1);
        $art_referencia=$cos['art_referencia'];
        $art_nombre=$cos['art_nombre'];
        $art_costo=$cos['art_precio_costo'];
        $total_costo=$art_costo*$cantidad;
        $costo_t+=$total_costo;

        $artb=mysqli_query($con, "SELECT * from articulos_has_bodegas where art_id='$art_id_bod' ");
        $artbo=mysqli_fetch_array($artb);
        $art_cantidad=$artbo['art_cantidad'];

        

        if($art_cantidad>$cantidad)
        {
            $faltante=0;
        } else 
        {
            $faltante=$cantidad-$art_cantidad;
        }

        $costo_faltante=$faltante*$art_costo;
        $faltante_t+=$costo_faltante;

            $a="A".$cel;
            $b="B".$cel;
            $c="C".$cel;
            $d="D".$cel;
            $e="E".$cel;
            $f="F".$cel;
            $g="G".$cel;
            $h="H".$cel;
            $i="I".$cel;
            $j="J".$cel;
            $k="K".$cel;

            
           
            // Agregar datos
            $sheet->setCellValue($a, $art_referencia)
            ->setCellValue($b, $art_nombre)
            ->setCellValue($c, $pro_nombre)
            ->setCellValue($d, $cantidad)
            ->setCellValue($e, $art_cantidad)
            ->setCellValue($f, $faltante)
            ->setCellValue($g, $costo_faltante)
            ->setCellValue($h, $art_costo)
            ->setCellValue($i, $total_costo)
            ->setCellValue($j, $venta)
            ->setCellValue($k, $venta_item);
            
             $cel+=1;

    }

    if( $venta_t<>0)
    {
        $f="F".$cel;
        $g="G".$cel;
        $h="H".$cel;
        $i="I".$cel;
        $j="J".$cel;
        $k="K".$cel;
       
        // Agregar datos
        $sheet->mergeCells("A".($cel).":E".($cel))
        ->setCellValue($f, 'TOTAL')
        ->setCellValue($g, $faltante_t)
        ->setCellValue($h, '')
        ->setCellValue($i, $costo_t)
        ->setCellValue($j, '')
        ->setCellValue($k, $venta_t);


        cellColor('F'.$cel.':K'.$cel, 'BDBDBD');
       $cel+=1;
    }
        $global_faltante+=$faltante_t;
        $global_costo+=$costo_t;
        $global_venta+=$venta_t;
           
} 


        $f="F".$cel;
        $g="G".$cel;
        $h="H".$cel;
        $i="I".$cel;
        $j="J".$cel;
        $k="K".$cel;
       
         // Agregar datos
        $sheet->mergeCells("A".($cel).":E".($cel))
        ->setCellValue($f, 'TOTAL GENERAL')
        ->setCellValue($g, $global_faltante)
        ->setCellValue($h, '')
        ->setCellValue($i, $global_costo)
        ->setCellValue($j, '')
        ->setCellValue($k, $global_venta);


        cellColor('F'.$cel.':K'.$cel, 'BDBDBD');


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE FACTURACION POR LOTE.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>