<?php
session_start();
require('../fpdf/fpdf.php');
require('plantilla_orden.php');
require '../../../conexion.php';
require_once('../../../include/sesiones.php');

// Creación del objeto de la clase heredada
$pdf = new PDF_MC_Table();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Times','',10);
$pdf->Ln();

$pdf->Image('../../../img/'.$empresa.'.png',10,5,60);
$pdf->SetFont('Arial','B',12);
// Movernos a la derecha
$pdf->Cell(130);
$pdf->Cell(50,4,utf8_decode($emp_nombre),0,0,'C');
$pdf->Ln();
$pdf->SetFont('Arial','B',9);
$pdf->Cell(130);
$pdf->Cell(50,4,'Nit: '.$emp_nit,0,0,'C');
$pdf->Ln();
$pdf->Cell(130);
$pdf->Cell(50,4,utf8_decode("Régimen ").$emp_regimen,0,0,'C');
$pdf->Ln();
$pdf->Cell(130);
$pdf->Cell(50,4,$emp_direccion,0,0,'C');
$pdf->Ln();
$pdf->Cell(130);
$pdf->Cell(50,4,'E-mail:'.$emp_correo,0,0,'C');
$pdf->Ln();
$pdf->Cell(130);
$pdf->Cell(50,4,'Cel:'.$emp_cel.' / Tel:'.$emp_telefono,0,0,'C');
$pdf->Ln();


$to=0;
$ord_id=$_GET['ord_id'];
$query=mysqli_query($con, "SELECT * from orden_servicios where ord_id='$ord_id' and empresa='$empresa' ");
$row1=mysqli_fetch_array($query);
$ord_clie_id=$row1['ord_clie_id'];

$dir=mysqli_query($con,"SELECT * FROM cliente  where clie_id='$ord_clie_id'  ") or die(mysqli_error($con)); 
$dire=mysqli_fetch_array($dir);


$pdf->nombre($dire['clie_nombre']);
$pdf->cc($dire['clie_cc']);
$pdf->tel($dire['clie_telefono']);
$pdf->fact_dev($row1['ord_numero']);

$pdf->direccion(strtoupper($dire['clie_direccion']));
$pdf->fecha($row1['ord_fecha_recibo']);


$pdf->Ln(9);

if($negocio_neg_id=='1') 
{
    $pdf->SetFillColor(255,255,255);
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(47,4,utf8_decode('DESCRIPCIÓN DEL EQUIPO:') ,0,0,'L',1);
    $pdf->Ln();

    $pdf->Ln();
    $pdf->Cell(30,2,'TIPO DE EQUIPO:' ,0,0,'L',1);
    $pdf->Cell(160,2,utf8_decode($row1['ord_tipo_equipo']),0,1,'L',1);
    $pdf->Ln(); 
    $pdf->Cell(30,2,'MARCA:' ,0,0,'L',1);
    $pdf->Cell(160,2,utf8_decode($row1['ord_marca']),0,1,'L',1);
    $pdf->Ln(); 
    $pdf->Cell(30,2,'NRO DE SERIE:' ,0,0,'L',1);
    $pdf->Cell(160,2,utf8_decode($row1['ord_num_serie']),0,1,'L',1);
    $pdf->Ln();
    $pdf->Cell(30,2,'MODELO:' ,0,0,'L',1);
    $pdf->Cell(160,2,utf8_decode($row1['ord_modelo']),0,1,'L',1);
    $pdf->Ln();
    $pdf->Cell(30,2,'ACCESORIOS:' ,0,0,'L',1);
    $pdf->Cell(160,2,utf8_decode($row1['ord_accesorios']),0,1,'L',1);
    $pdf->Ln(5);
    $pdf->Cell(20,2,'INFORME:' ,0,0,'L',1);
    $pdf->multicell(170,3,$row1['ord_informe'],0,1,'R',1);
    $pdf->Ln();
    $pdf->Rect(10, 67, 93, 30, 'D');
    $pdf->Rect(10, 99, 190, 10, 'D');
    $pdf->Ln(3);
} 
else if($negocio_neg_id=='8') 
{ 
    $pdf->SetFillColor(255,255,255);
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(47,4,utf8_decode('DETALLES') ,0,0,'L',1);
    $pdf->Ln();

    $pdf->Ln();
    $pdf->Cell(30,2,utf8_decode('DISEÑO:') ,0,0,'L',1);
    $pdf->Cell(160,2,utf8_decode($row1['ord_diseno']),0,1,'L',1);
    $pdf->Ln(); 
    $pdf->Cell(30,2,'GRAMOS:' ,0,0,'L',1);
    $pdf->Cell(160,2,utf8_decode($row1['ord_gramos']),0,1,'L',1);
    $pdf->Ln(); 
    $pdf->Cell(30,2,'TALLA:' ,0,0,'L',1);
    $pdf->Cell(160,2,utf8_decode($row1['ord_talla']),0,1,'L',1);
    $pdf->Ln(3);
   
    $pdf->Rect(10, 67, 93, 25, 'D');
    $pdf->Rect(10, 94, 190, 15, 'D');
    $pdf->Ln(3);
}    
$cot_id=$row1['ord_id'];
$sql=mysqli_query($con, "SELECT * from orden_detalle where orden_servicios_ord_id='$ord_id' ");
$row=mysqli_fetch_array($sql);
$ordt_id=$row['ordt_id'];
if ($ordt_id<=0) 
{    

}
else
{
    $pdf->SetFillColor(235,225,215);
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(20,6,'CANT' ,1,0,'C',1);
    $pdf->Cell(105,6,utf8_decode('DESCRIPCIÓN'),1,0,'C',1);
    $pdf->Cell(25,6,'PRECIO U',1,0,'C',1);
    $pdf->Cell(15,6,'DESC %',1,0,'C',1);
    $pdf->Cell(25,6,'TOTAL',1,0,'C',1);
    $pdf->Ln();    
 
    $descuentof=0;
    $descuento=0;
    $neto=0;
    $sumador_total=0;
    $iva_total=0;
    $sumador_total=0;

    $sql=mysqli_query($con, "SELECT * from orden_detalle where orden_servicios_ord_id='$ord_id'");
    while ($row=mysqli_fetch_array($sql))
       {
            $id=$row["ordt_id"];
            $ordt_id=$row["ordt_id"];
            $ordt_referencia=$row['ordt_referencia'];
            $ordt_cantidad=$row['ordt_cantidad'];
            $ordt_nombre=$row['ordt_nombre'];
            $ordt_precio=$row['ordt_precio'];
            $ordt_iva=$row['ordt_iva'];
            $ordt_descuento=$row['ordt_desc'];

            $ivaf=$ordt_iva/100;
            $precio_total=$ordt_precio*$ordt_cantidad;
            $sumador_total+=$precio_total;//Sumador
            $descuento=($ordt_descuento/100)*$precio_total;
            $descuentof+=$descuento;
            $iva=$ordt_precio*$ivaf;
            $ivat=$iva*$ordt_cantidad;
            $sin_iva=($ordt_precio-$iva);
            $sin_ivat=($ordt_precio-$iva)*$ordt_cantidad;
            $iva_total+=$ivat;
            $neto+=$precio_total-$ivat-$descuento;

            $pdf->SetWidths(array(20,105,25,15,25));
            srand(time()*1000000);
            $pdf->Row(array($ordt_cantidad,utf8_decode($ordt_nombre),number_format($sin_ivat,0),$descuento,number_format($precio_total,0)));
        }
    $to+=$sumador_total;
    $pdf->SetFillColor(255,255,255);
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(150,4,'',1,0,'C',1);
    $pdf->Cell(15,4,'TOTAL',1,0,'C',1);
    $pdf->Cell(25,4,number_format($sumador_total-$descuentof,0),1,0,'C',1);
    $pdf->Ln();

    $sql1=mysqli_query($con,"SELECT sum(ord_abono) as abono from orden_abonos where orden_servicios_ord_id='$ord_id' ");
    if ($abo=mysqli_fetch_array($sql1))
        $abono=$abo['abono'];
    $pdf->SetFillColor(255,255,255);
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(150,4,'',1,0,'C',1);
    $pdf->Cell(15,4,'ABONO',1,0,'C',1);
    $pdf->Cell(25,4,number_format($abono,0),1,0,'C',1);
    $pdf->Ln();
    $pdf->SetFillColor(255,255,255);
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(150,4,'',1,0,'C',1);
    $pdf->Cell(15,4,'SALDO',1,0,'C',1);
    $pdf->Cell(25,4,number_format($sumador_total-$descuentof-$abono,0),1,0,'C',1);
} 
    $pdf->Ln(10);
    $pdf->SetFont('Arial','B',8);
    // Movernos a la derecha
    $pdf->Cell(73);
    $pdf->Cell(60,0,'___________________________________',0,0,'L');
    $pdf->Cell(70,0,'___________________________________',0,0,'L');
    $pdf->Ln(2);

    $pdf->Cell(73);
    $pdf->Cell(60,2,'Cliente C.C',0,0,'L');


    if($negocio_neg_id=='1') { 
    $pdf->Cell(70,2,'Tecnico C.C',0,0,'L');
    } else { 
    $pdf->Cell(70,2,'Vendedor C.C',0,0,'L');
    } 


    $pdf->Ln(5);



if($negocio_neg_id=='1')
{ 
    $pdf->SetXY(105, 70 );
    $pdf->Cell(30,2,'OBSERVACIONES:' ,0,0,'L',1);
    $pdf->Ln();
    $pdf->SetXY(105, 75 );
    $pdf->multicell(90,3,$row1['ord_falla'],0,1,'R',1);
    $pdf->Rect(105, 67, 95, 30, 'D');   
}
 else if ($negocio_neg_id=='8')
{
    $pdf->SetXY(105, 70 );
    $pdf->Cell(30,2,'OBSERVACIONES:' ,0,0,'L',1);
    $pdf->Ln();
    $pdf->SetXY(105, 75 );
    $pdf->multicell(90,3,$row1['ord_observaciones'],0,1,'R',1);
    $pdf->Rect(105, 67, 95, 25, 'D'); 
}

$pdf->Output();
?>