<?php
session_start();
require('../fpdf/fpdf.php');
require('factura_venta4_plantilla.php');
require '../../../conexion.php';
require_once('../../../include/sesiones.php');

class PDF_AutoPrint extends PDF_JavaScript
{
    function AutoPrint($printer='')
    {
        // Open the print dialog
        if($printer)
        {
            $printer = str_replace('\\', '\\\\', $printer);
            $script = "var pp = getPrintParams();";
            $script .= "pp.interactive = pp.constants.interactionLevel.full;";
            $script .= "pp.printerName = '$printer'";
            $script .= "print(pp);";
        }
        else
            $script = 'print(true);';
        $this->IncludeJS($script);
    }
}

$pdf = new PDF_AutoPrint();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Times','',10);
$pdf->Ln();

$pdf->Image('../../../img/'.$empresa.'.png',10,5,60);
//$pdf->Image('../../../img/'.$empresa.'.jpg',75,15,60); 

$pdf->SetFont('Arial','B',12);
$pdf->Cell(130);
$pdf->Cell(50,4,utf8_decode($emp_nombre),0,0,'C');
$pdf->Ln();
$pdf->SetFont('Arial','B',9);
$pdf->Cell(130);
$pdf->Cell(50,4,'Nit: '.$emp_nit,0,0,'C');
$pdf->Ln();
$pdf->Cell(130);
$pdf->Cell(50,4,utf8_decode("Régimen ").$emp_regimen,0,0,'C');
$pdf->Ln();
$pdf->Cell(130);
$pdf->Cell(50,4,$emp_direccion,0,0,'C');
$pdf->Ln();
$pdf->Cell(130);
$pdf->Cell(50,4,'E-mail:'.$emp_correo,0,0,'C');
$pdf->Ln();
$pdf->Cell(130);
$pdf->Cell(50,4,'Cel:'.$emp_cel.' / Tel:'.$emp_telefono,0,0,'C');
$pdf->Ln(2);
      
   
$to=0;
$ven_id=$_GET['ven_id'];
$query=mysqli_query($con, "SELECT * , DATE_FORMAT(`ven_fecha`,'%d-%m-%Y') as ven_fecha FROM  ventas where   ven_id='$ven_id' and empresa='$empresa' ");
$roww=mysqli_fetch_array($query);
$ven_cc=$roww['ven_cc'];
$Cliente_clie_id=$roww['Cliente_clie_id'];
$ven_nombre=$roww['ven_nombre'];
$ven_telefono=$roww['ven_telefono'];
$ven_telefono=$roww['ven_telefono'];
$ven_fecha=$roww['ven_fecha'];
$ven_estado=$roww['ven_estado'];
$ven_prefijo=$roww['ven_prefijo']; 
$ven_n_venta=$roww['ven_n_venta']; 
$ven_forma_de_pago=$roww['ven_forma_de_pago'];
$ven_dias=$roww['ven_dias'];
$vendedor=$roww['vendedor'];

$dir=mysqli_query($con,"SELECT * FROM cliente where clie_id='$Cliente_clie_id'") or die(mysqli_error($con)); 
$dire=mysqli_fetch_array($dir);
$clie_direccion=$dire['clie_direccion'];

$sql3=mysqli_query($con,"SELECT * from usuario where usu_id='$vendedor'");
$usu=mysqli_fetch_array($sql3);
$usu_nombre=$usu['usu_nombre'];

$vence=strtotime($ven_fecha."+ ".$ven_dias." days");
date("Y-m-d",$vence) . "\n";
$fecha=date('Y-m-d ');

$hasta=date("d-m-Y",$vence) . "\n";
if($ven_estado=='anulada')
{
    $pdf->Image('../img/factura/anulado.png',55,23,100); 
}

$pdf->nombre($ven_nombre);
$pdf->cc($ven_cc);
$pdf->tel($ven_telefono);
$pdf->fact_dev(''.$ven_prefijo.''.$ven_n_venta.'');
$pdf->pago(strtoupper($ven_forma_de_pago));
$pdf->vendedor(strtoupper($usu_nombre));
//$pdf->plazo($ven_dias);
$pdf->fecha($ven_fecha);
//$pdf->vencimiento($hasta);
$pdf->direccion($clie_direccion);
$pdf->Ln(7);

$hex = $color;
list($r, $g, $b) = sscanf($hex, "#%02x%02x%02x");
$pdf->SetFillColor($r,$g,$b );
$pdf->SetFont('Arial','B',8);
$pdf->Cell(20,6,'REF' ,1,0,'C',1);
$pdf->Cell(13,6,'CANT',1,0,'C',1);
$pdf->Cell(87,6,utf8_decode('DESCRIPCIÓN'),1,0,'C',1);
$pdf->Cell(22,6,'PRECIO U',1,0,'C',1);
$pdf->Cell(13,6,'IMP %',1,0,'C',1);
$pdf->Cell(15,6,'DESC %',1,0,'C',1);
$pdf->Cell(20,6,'TOTAL',1,0,'C',1);
$pdf->Ln();    

$ven_id=$roww['ven_id'];
$suma=0;
$sumador_total=0;
$neto=0;
$descuento_global=0;
$iva_global=0;
$retencion_global=0;

$ret=mysqli_query($con,"SELECT * FROM retencion_venta where ventas_ven_id='$ven_id' ") or die(mysqli_error($con)); 
$rets=mysqli_fetch_array($ret);
$ret_porcentaje=$rets['porcentaje'];

$pdf->SetLineWidth(0.5);
$pdf->SetTextColor(0,0,0);
$pdf->SetFillColor(255,255,255);
$pdf->SetDrawColor(80,80,80);

$sql=mysqli_query($con,"SELECT * from venta_detalle where ventas_ven_id='$ven_id'");
while ($row=mysqli_fetch_array($sql))
{
    $vend_referencia=$row['vend_referencia'];
    $vend_nombre=$row['vend_nombre'];
    $vend_cantidad=$row['vend_cantidad'];
    $vend_precio=$row['vend_precio']; //1.000.000
    $vend_iva=$row['vend_iva']; //19%
    $vend_descuento=$row['vend_desc']; //10%
    $suma+=$row['vend_cantidad'];

    $iva0=$vend_iva/100; //0.19
    $iva1=1+$iva0; //1.19

    $precio_unitario_sin_iva=$vend_precio/$iva1;  //840.336
    $precio_total_sin_iva=$precio_unitario_sin_iva*$vend_cantidad;

    $descuento_unitario=($vend_descuento/100)*$precio_unitario_sin_iva;  //84033
    
    $descuento_item=$descuento_unitario*$vend_cantidad;  //84033
    $neto_item=$precio_total_sin_iva;
    $iva_item=($vend_precio-$precio_unitario_sin_iva)*$vend_cantidad;

    $neto+=$precio_total_sin_iva;
    $descuento_global+=$descuento_item;
    $iva_global+=$iva_item;


    $retencion_unitaria=(($precio_unitario_sin_iva*$ret_porcentaje)/(100-$ret_porcentaje));
    $retencion_item=$retencion_unitaria*$vend_cantidad; 
    $retencion_global+=$retencion_item;

   /* $precio_descuento_t=$precio_t_sin_iva-$descuento;
    $total_iva_u=$precio_descuento_t*$iva0;
    $iva_total+=$total_iva_u;*/

    $pdf->SetWidths(array(20,13,87,22,13,15,20));
    srand(time()*1000000);
    $pdf->Row(array($vend_referencia,$vend_cantidad,utf8_decode($vend_nombre),number_format($precio_unitario_sin_iva,0),$vend_iva,$vend_descuento,number_format($precio_total_sin_iva,0)));

   /* $pdf->Cell(20, 5, $vend_referencia, 'B', 0, 'C', 1);
    $pdf->Cell(13, 5, $vend_cantidad, 'B', 0, 'C', 1);
    $pdf->Cell(87, 5, utf8_decode($vend_nombre), 'B', 0, 'C', 1);
    $pdf->Cell(22, 5, number_format($precio_unitario_sin_iva,0), 'B', 0, 'C', 1);
    $pdf->Cell(13, 5, $vend_iva, 'B', 0, 'C', 1);
    $pdf->Cell(15, 5, $vend_descuento, 'B', 0, 'C', 1);
    $pdf->Cell(20, 5, number_format($precio_total_sin_iva,0), 'B', 0, 'C', 1);*/
    $pdf->Ln();


}


$pdf->Ln(10);

$pdf->SetTextColor(0,0,0);
$pdf->SetFillColor(255,255,255);
$pdf->SetDrawColor(80,80,80);


$pdf->SetWidths(Array(20,40,40,30,20,40));
$pdf->SetAligns(Array('','R','C','','',''));
//set font to bold
$pdf->SetFont('Arial','B',14);
$pdf->Cell(20,5,"ID",1,0);
$pdf->Cell(40,5,"First Name",1,0);
$pdf->Cell(40,5,"Last Name",1,0);
$pdf->Cell(30,5,"Email",1,0);
$pdf->Cell(20,5,"Gender",1,0);
$pdf->Cell(40,5,"Address",1,0);
//add a new line
$pdf->Ln();
//reset font
$pdf->SetFont('Arial','',14);

 //write data using Row() method containing array of values.
 $pdf->Row(Array(
  'sfgrfg ertg ert erer te rter terter',
  $vend_referencia,
  $vend_referencia,
  $vend_referencia,
  $vend_referencia,
  $vend_referencia,
 ));
 

$pdf->Ln(10);



$sumador_total=($neto+$iva_global)-$descuento_global;


$pdf->SetFillColor(255,255,255);
$pdf->SetFont('Arial','B',8);
$pdf->Cell(155,4,'',1,0,'C',1);
$pdf->Cell(15,4,'NETO',1,0,'C',1);
$pdf->Cell(20,4,number_format($neto,0),1,0,'C',1);
$pdf->Ln();
$pdf->SetTextColor(254,0,0);
$pdf->SetFont('Arial','B',8);
$pdf->Cell(155,4,'',1,0,'C',1);
$pdf->Cell(15,4,'DESC',1,0,'C',1);
$pdf->Cell(20,4,number_format($descuento_global,0),1,0,'C',1);
$pdf->Ln();
$pdf->SetTextColor(0,0,0);
$pdf->SetFillColor(255,255,255);
$pdf->SetFont('Arial','B',8);
$pdf->Cell(155,4,'',1,0,'C',1);
$pdf->Cell(15,4,'IMPUESTO',1,0,'C',1);
$pdf->Cell(20,4,number_format($iva_global,0),1,0,'C',1);
$pdf->Ln();

$pdf->SetFillColor(255,255,255);
$pdf->SetFont('Arial','B',8);
$pdf->Cell(155,4,'',1,0,'C',1);
$pdf->Cell(15,4,'RF',1,0,'C',1);
$pdf->Cell(20,4,number_format($retencion_global,0),1,0,'C',1);
$pdf->Ln();


$pdf->SetFillColor(255,255,255);
$pdf->SetFont('Arial','B',8);
$pdf->Cell(155,4,'',1,0,'C',1);
$pdf->Cell(15,4,'TOTAL',1,0,'C',1);
$pdf->Cell(20,4,number_format($sumador_total,0),1,0,'C',1);
$pdf->Ln(7);

$pdf->Cell(35,4,'TOTAL DE UNIDADES:',0,0,'L',1);
$pdf->Cell(20,4,$suma,0,0,'L',1);
$pdf->Ln();
          
            $sql2=mysqli_query($con, "SELECT * from seriales where  venta_detalle_ventas_ven_id='$ven_id'  LIMIT 0,7;");
            $result = mysqli_num_rows($sql2);
            if($result>0)
               {
                $pdf->SetFillColor(255,255,255);
                $pdf->SetFont('Arial','B',8);
                $pdf->Cell(20,4,'SERIAL(ES):',0,0,'L',1);
                       
                 while ($row2=mysqli_fetch_array($sql2))
                 {
                        $ser_codigo=$row2['ser_codigo'];
                        $pdf->Cell(25.5,4,$ser_codigo,0,0,'L',1);
                  }
                   $pdf->Ln();
                } 
           
            $sql3=mysqli_query($con, "SELECT * from seriales where  venta_detalle_ventas_ven_id='$ven_id'  LIMIT 7,14;");
            $result3 = mysqli_num_rows($sql3);
            if($result3>0)
               {
                $pdf->SetFillColor(255,255,255);
                $pdf->SetFont('Arial','B',8);
                $pdf->Cell(20,4,'',0,0,'L',1);
                       
                 while ($row3=mysqli_fetch_array($sql3))
                 {
                        $ser_codigo=$row3['ser_codigo'];
                        $pdf->Cell(25.5,4,$ser_codigo,0,0,'L',1);
                  }
                   $pdf->Ln();
                }
           
            $sql4=mysqli_query($con, "SELECT * from seriales where  venta_detalle_ventas_ven_id='$ven_id'  LIMIT 14,21;");
            $result4 = mysqli_num_rows($sql4);
            if($result4>0)
               {
                $pdf->SetFillColor(255,255,255);
                $pdf->SetFont('Arial','B',8);
                $pdf->Cell(20,4,'',0,0,'L',1);
                       
                 while ($row4=mysqli_fetch_array($sql4))
                 {
                        $ser_codigo=$row4['ser_codigo'];
                        $pdf->Cell(25.5,4,$ser_codigo,0,0,'L',1);
                  }
                  $pdf->Ln();
                }    
             
            $sql4=mysqli_query($con, "SELECT * from seriales where  venta_detalle_ventas_ven_id='$ven_id'  LIMIT 21,28;");
            $result4 = mysqli_num_rows($sql4);
            if($result4>0)
               {
                $pdf->SetFillColor(255,255,255);
                $pdf->SetFont('Arial','B',8);
                $pdf->Cell(20,4,'',0,0,'L',1);
                       
                 while ($row4=mysqli_fetch_array($sql4))
                 {
                        $ser_codigo=$row4['ser_codigo'];
                        $pdf->Cell(25.5,4,$ser_codigo,0,0,'L',1);
                  }
                   $pdf->Ln();
                }    
            $pdf->Ln(10);
            $pdf->Ln(2);
            $pdf->SetFont('Arial','B',8);
            // Movernos a la derecha
            $pdf->Cell(73);
            $pdf->Cell(60,0,'___________________________________',0,0,'L');
            $pdf->Cell(70,0,'___________________________________',0,0,'L');
            $pdf->Ln(2);

            $pdf->Cell(73);
            $pdf->Cell(60,2,'Cliente C.C',0,0,'L');
            $pdf->Cell(70,2,'Vendedor C.C',0,0,'L');
            $pdf->Ln(5);
            $pdf->SetFont('Arial','B',5);
            $pdf->SetMargins(23, 44, 11.7);
            $pdf->MultiCell(190, 2.5, $condiciones,1, 1, 'L');
            $pdf->Ln(2);



            $pdf->SetFont('Arial','B',6);
            $pdf->Cell(180,4,utf8_decode('Esta factura de venta se asimila en sus efectos legales a una letra de cambio. Art. 774 del Código del Comercio.'),0,0,'C');
            $pdf->Ln();
            $pdf->Cell(180,4,utf8_decode('Impreso por | '.$emp_nombre. '  -  VICPOS  -  V 2.5.    '.$emp_url.''),0,0,'C');

            // $pdf->SetFont('Arial','',8);
            // $pdf->RotatedText(205,90,'Impreso por | www.vicpos.com',90);

            $pdf->AutoPrint();
             $pdf->Output($ven_nombre.'-'.$ven_n_venta.'.pdf', 'I');

?>
