<?php
session_start();
require('../fpdf/fpdf.php');
require('factura_venta2_plantilla.php');
require '../../../conexion.php';
require_once('../../../include/sesiones.php');

class PDF_AutoPrint extends PDF_JavaScript
{
    function AutoPrint($printer='')
    {
        // Open the print dialog
        if($printer)
        {
            $printer = str_replace('\\', '\\\\', $printer);
            $script = "var pp = getPrintParams();";
            $script .= "pp.interactive = pp.constants.interactionLevel.full;";
            $script .= "pp.printerName = '$printer'";
            $script .= "print(pp);";
        }
        else
            $script = 'print(true);';
        $this->IncludeJS($script);
    }
}

$pdf = new PDF_AutoPrint();
$pdf->SetAutoPageBreak(true,5);  
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Times','',10);
$pdf->Ln();


    $pdf->Image('../../../img/'.$empresa.'.png',10,5,60);
  //  $pdf->Image('../img/'.$empresa.'.jpg',75,15,60); 
    // Arial bold 15
    $pdf->SetFont('Arial','B',12);
    // Movernos a la derecha
    $pdf->Cell(130);
    $pdf->Cell(50,4,utf8_decode($emp_nombre),0,0,'C');
    $pdf->Ln();
    $pdf->SetFont('Arial','B',9);
    $pdf->Cell(130);
    $pdf->Cell(50,4,'Nit: '.$emp_nit,0,0,'C');
    $pdf->Ln();
    $pdf->Cell(130);
    $pdf->Cell(50,4,utf8_decode("Régimen ").$emp_regimen,0,0,'C');
    $pdf->Ln();
    $pdf->Cell(130);
    $pdf->Cell(50,4,utf8_decode($emp_direccion),0,0,'C');
    $pdf->Ln();
    $pdf->Cell(130);
    $pdf->Cell(50,4,'E-mail:'.$emp_correo,0,0,'C');
    $pdf->Ln();
    $pdf->Cell(130);
    $pdf->Cell(50,4,'Cel:'.$emp_cel.' / Tel:'.$emp_telefono,0,0,'C');
    $pdf->Ln(6);

  

     if($emp_regimen=='Comun')
        {

            $pdf->SetFont('Arial','B',7);
            $pdf->Cell(180,4, utf8_decode("RESOL.DIAN ".$ser_resolucion." FECHA ".$ser_fecha." DEL ".$ser_inicio." AL ".$ser_fin." VIGENCIA 24 MESES"), 0, 0, "R");
            $pdf->Line(10, 40, 200, 40);
            $pdf->Line(10, 35, 200, 35);

           
        }



$to=0;
$ven_id=$_GET['ven_id'];
$query=mysqli_query($con, "SELECT *, DATE_FORMAT(`ven_fecha`,'%d-%m-%Y') as ven_fecha FROM  ventas where   ven_id='$ven_id' and empresa='$empresa' ");
$roww=mysqli_fetch_array($query);
$ven_cc=$roww['ven_cc'];
$ven_nombre=$roww['ven_nombre'];
$ven_telefono=$roww['ven_telefono'];
$ven_fecha=$roww['ven_fecha'];
$ven_prefijo=$roww['ven_prefijo']; 
$ven_n_venta=$roww['ven_n_venta']; 
$ven_forma_de_pago=$roww['ven_forma_de_pago'];
$ven_dias=$roww['ven_dias'];

$vence = strtotime($ven_fecha."+ ".$ven_dias." days");
                date("Y-m-d",$vence) . "\n";
                $fecha=date('Y-m-d ');


 $hasta=date("d-m-Y",$vence) . "\n";


$pdf->fact_dev(''.$ven_prefijo.''.$ven_n_venta.'');

$pdf->nombre(utf8_decode($ven_nombre));
$pdf->fecha($ven_fecha);
$pdf->cc($ven_cc);
$pdf->tel($ven_telefono);

$pdf->pago(strtoupper($ven_forma_de_pago));
$pdf->plazo($ven_dias);
$pdf->fecha($ven_fecha);
$pdf->vencimiento($hasta);
$pdf->Ln(7);

$cols=array( "REF"    => 23,
            "CANT"     => 15,
             utf8_decode("DESCRIPCIÓN")  => 78,
             "PRECIO"      => 21,
             "DESC %" => 15,
              "IMP %" => 15,
             "TOTAL"          => 23 );
$pdf->addCols( $cols);
$cols=array( "REF"    => "L",
            "CANT"     => "C",
             utf8_decode("DESCRIPCIÓN")  => "L",
             "PRECIO"      => "R",
             "DESC %" => "R",
              "IMP %" => "R",
             "TOTAL"          => "R" );
$pdf->addLineFormat( $cols);
$pdf->addLineFormat($cols);
$y    = 74;

        $descuento=0;
        $sumador_total=0;
        $neto=0;
        $descuentof=0;
        $iva_total=0;
        $suma=0;

        $total_ret=0;
        $ret=mysqli_query($con, "SELECT * FROM retencion_venta where ventas_ven_id='$ven_id' ") or die(mysqli_error($con)); 
        $rets=mysqli_fetch_array($ret);
        $ret_porcentaje=$rets['porcentaje'];

        $sql=mysqli_query($con, "SELECT * from  venta_detalle where ventas_ven_id='$ven_id'");
        while ($row=mysqli_fetch_array($sql))
          {
            $vend_referencia=$row['vend_referencia'];
            $vend_nombre=$row['vend_nombre'];
            $vend_cantidad=$row['vend_cantidad'];
            $vend_precio=$row['vend_precio'];
            $vend_iva=$row['vend_iva'];
            $vend_descuento=$row['vend_desc'];
            $suma+=$row['vend_cantidad'];

              $iva0=$vend_iva/100; //0.19
              $iva1=1+$iva0; //1.19
              
              $precio_u_sin_iva=$vend_precio/$iva1;

              $precio_retencion=(($precio_u_sin_iva*$ret_porcentaje)/(100-$ret_porcentaje));
              $precio_unidad=(($precio_u_sin_iva*$ret_porcentaje)/(100-$ret_porcentaje))+$precio_u_sin_iva;

              $precio_t_sin_iva=$precio_unidad*$vend_cantidad;

              $descuento=($vend_descuento/100)*$precio_t_sin_iva;

              $precio_descuento_t=$precio_t_sin_iva-$descuento;

              $total_iva_u=$precio_descuento_t*$iva0;

              $iva_total+=$total_iva_u;

              $neto+=$precio_t_sin_iva;

              $descuentof+=$descuento;
               
              $sumador_total=($neto+$iva_total)-$descuentof;
              $total_ret+=$precio_retencion*$vend_cantidad;
         


            $line = array(  "REF"    =>$vend_referencia,
                            "CANT"     =>$vend_cantidad,
               utf8_decode("DESCRIPCIÓN")  =>utf8_decode($vend_nombre) ,
                            "PRECIO"=> number_format($precio_unidad,0),
                            "DESC %"=> $vend_descuento,
                            "IMP %"=> $vend_iva,
                            "TOTAL" => number_format($precio_t_sin_iva,0) );
            $size = $pdf->addLine( $y, $line );
            $y   += $size + 2; 
        }
         $to+=$sumador_total;

           
    $pdf->total( "", "" );
    $pdf->observacion( "", "" );
  
 
    $pdf->SetFont( "Arial", "B", 10);
    $pdf->SetXY( 20, 225 );
    $pdf->Cell(15,3, "OBSERVACIONES:", 0, 0, "C");

    $pdf->SetXY( 148, 221 );
    $pdf->Cell(15,3, "NETO", 0, 0, "C");
    $pdf->SetXY( 180, 221 );
    $pdf->Cell(20,3, "$  ".number_format($neto,0), 0, 0, "R");

    $pdf->SetXY( 148, 226 );
    $pdf->Cell(15,3, "RETEFUENTE", 0, 0, "C");
    $pdf->SetXY( 180, 226 );
    $pdf->Cell(20,3, "$  ".number_format($total_ret,0), 0, 0, "R");

    $pdf->SetXY( 148, 231 );
    $pdf->Cell(15,3, "IMPUESTO", 0, 0, "C");
    $pdf->SetXY( 180, 231 );
    $pdf->Cell(20,3, "$  ".number_format($iva_total,0), 0, 0, "R");

    $pdf->SetTextColor(254,0,0);
    $pdf->SetXY( 148, 236 );
    $pdf->Cell(15,3, "DESCUENTO", 0, 0, "C");
    $pdf->SetXY( 180, 236 );
    $pdf->Cell(20,3,"$  ". number_format($descuentof,0), 0, 0, "R");

    
    $pdf->SetTextColor(0,0,0);
    $pdf->SetXY( 148, 241 );
    $pdf->Cell(15,3, "TOTAL", 0, 0, "C");
    $pdf->SetXY( 180, 241 );
    $pdf->Cell(20,3, "$  ".number_format($to-$total_ret,0), 0, 0, "R");
    $pdf->Ln(22);

    $pdf->SetFont('Arial','B',5);
    $pdf->MultiCell(190, 2.5, $condiciones,1, 1, 'L');

    $pdf->SetXY( 180, 196 );
    $pdf->SetFont('Arial','B',6);
    $pdf->Cell(180,4,utf8_decode('Impreso por | '.$emp_nombre. '  -  VICPOS  -  V 2.5.    '.$emp_url.''),0,0,'C');
    

    $pdf->AutoPrint();
    $pdf->Output($ven_nombre.'.pdf', 'I');
?>