<?php
session_start();
require('../fpdf/fpdf.php');
require('cotizacion2_plantilla.php');
require '../../../conexion.php';
require_once('../../../include/sesiones.php');

// (c) Xavier Nicolay
// Exemple de génération de devis/facture PDF

//require('invoice.php');

$pdf = new PDF_Invoice( 'P', 'mm', 'A4' );


$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Times','',10);
$pdf->Ln();


    $pdf->Image('../../../img/'.$empresa.'.png',10,5,60);
    // Arial bold 15
    $pdf->SetFont('Arial','B',12);
    // Movernos a la derecha
    $pdf->Cell(130);
    $pdf->Cell(50,4,utf8_decode($emp_nombre),0,0,'C');
    $pdf->Ln();
    $pdf->SetFont('Arial','B',9);
    $pdf->Cell(130);
    $pdf->Cell(50,4,'Nit: '.$emp_nit,0,0,'C');
    $pdf->Ln();
    $pdf->Cell(130);
    $pdf->Cell(50,4,utf8_decode("Régimen ").$emp_regimen,0,0,'C');
    $pdf->Ln();
    $pdf->Cell(130);
    $pdf->Cell(50,4,$emp_direccion,0,0,'C');
    $pdf->Ln();
    $pdf->Cell(130);
    $pdf->Cell(50,4,'E-mail:'.$emp_correo,0,0,'C');
    $pdf->Ln();
    $pdf->Cell(130);
    $pdf->Cell(50,4,'Cel:'.$emp_cel.' / Tel:'.$emp_telefono,0,0,'C');
    $pdf->Ln(6);

   

$to=0;
$cot_id=$_GET['cot_id'];
$query=mysqli_query($con, "select *  , DATE_FORMAT(cot_fecha, '%d-%m-%Y') AS nueva_fecha  from cotizacion where cot_id='$cot_id' ");
$roww=mysqli_fetch_array($query);
$ven_cc=$roww['cot_cc'];
$ven_nombre=$roww['cot_nombre'];
$ven_telefono=$roww['cot_telefono'];
$ven_fecha=$roww['nueva_fecha'];
$ven_n_venta=$roww['cot_n_cotizacion'];
$observaciones=$roww['observaciones'];



$pdf->fact_dev( "", utf8_decode("COTIZACIÓN N: ").$ven_n_venta );

$pdf->nombre($ven_nombre);
$pdf->fecha($ven_fecha);
$pdf->cc($ven_cc);
$pdf->tel($ven_telefono);
$pdf->Ln(8);

$pdf->Cell(180,4, utf8_decode("A continuación Presentamos nuestra oferta que esperamos sea de su conformidad."), 0, 0, "L");
   


$cols=array( "REF"    => 23,
            "CANT"     => 15,
             utf8_decode("DESCRIPCIÓN")  => 78,
             "PRECIO"      => 21,
             "DESC %" => 15,
             "IMP %" => 15,
             "TOTAL"          => 23 );
$pdf->addCols( $cols);
$cols=array( "REF"    => "L",
            "CANT"     => "C",
             utf8_decode("DESCRIPCIÓN")  => "L",
             "PRECIO"      => "R",
             "DESC %" => "R",
             "IMP %" => "R",
             "TOTAL"          => "R" );
$pdf->addLineFormat( $cols);
$pdf->addLineFormat($cols);
$y    = 73;

        $cot_id=$roww['cot_id'];
        $descuentof=0;
        $descuento=0;
        $neto=0;
        $sumador_total=0;
        $iva_total=0;

        $total_ret=0;
        $ret=mysqli_query($con, "SELECT * FROM retencion_cotizacion where cotizacion_cot_id='$cot_id' ") or die(mysqli_error($con)); 
        $rets=mysqli_fetch_array($ret);
            
        $ret_porcentaje=$rets['porcentaje'];
        $sql=mysqli_query($con, "SELECT * from  cotizacion_detalle where cotizacion_cot_id='$cot_id'");
        while ($row=mysqli_fetch_array($sql))
          {
    $cotd_referencia=$row['cotd_referencia'];
    $cotd_nombre=$row['cotd_nombre'];
    $cotd_cantidad=$row['cotd_cantidad'];
    $cotd_precio=$row['cotd_precio'];
    $cotd_iva=$row['cotd_iva'];
    $cotd_descuento=$row['cotd_desc'];

    $iva0=$cotd_iva/100; //0.19
    $iva1=1+$iva0; //1.19

    $precio_u_sin_iva=$cotd_precio/$iva1;
    $precio_retencion=(($precio_u_sin_iva*$ret_porcentaje)/(100-$ret_porcentaje));
    $precio_unidad=(($precio_u_sin_iva*$ret_porcentaje)/(100-$ret_porcentaje))+$precio_u_sin_iva;

    $precio_t_sin_iva=$precio_unidad*$cotd_cantidad;

    $descuento=($cotd_descuento/100)*$precio_t_sin_iva;

    $precio_descuento_t=$precio_t_sin_iva-$descuento;

    $total_iva_u=$precio_descuento_t*$iva0;

    $iva_total+=$total_iva_u;

    $neto+=$precio_t_sin_iva;

    $descuentof+=$descuento;
    $total_ret+=$precio_retencion*$cotd_cantidad;

    $sumador_total=($neto+$iva_total)-$descuentof;
         

            $line = array(  "REF"    =>$cotd_referencia,
                            "CANT"     =>$cotd_cantidad,
               utf8_decode("DESCRIPCIÓN")  =>$cotd_nombre ,
                            "PRECIO"=> number_format($precio_unidad,0),
                            "DESC %"=> $cotd_descuento,
                            "IMP %"=> $cotd_iva,
                            "TOTAL" => number_format($precio_t_sin_iva,0) );
            $size = $pdf->addLine( $y, $line );
            $y   += $size + 2; 
        }
    $to+=$sumador_total;
    
    $pdf->total( "", "" );
    $pdf->observacion( "", "" );
  
 
    $pdf->SetFont( "Arial", "B", 10);
    $pdf->SetXY( 20, 225 );
    $pdf->Cell(15,3, "OBSERVACIONES:", 0, 0, "C");
    $pdf->Ln();
    $pdf->SetFont( "Arial", "B", 7);
    $pdf->MultiCell(110, 2.5, $observaciones,0, 1, 'L');

    $pdf->SetFont( "Arial", "B", 10);
    $pdf->SetXY( 148, 221 );
    $pdf->Cell(15,3, "NETO", 0, 0, "C");
    $pdf->SetXY( 180, 221 );
    $pdf->Cell(20,3, "$  ".number_format($neto,0), 0, 0, "R");

    $pdf->SetXY( 148, 226 );
    $pdf->Cell(15,3, "RETEFUENTE", 0, 0, "C");
    $pdf->SetXY( 180, 226 );
    $pdf->Cell(20,3, "$  ".number_format($total_ret,0), 0, 0, "R");

    $pdf->SetXY( 148, 231 );
    $pdf->Cell(15,3, "IMPUESTO", 0, 0, "C");
    $pdf->SetXY( 180, 231 );
    $pdf->Cell(20,3, "$  ".number_format($iva_total,0), 0, 0, "R");

    $pdf->SetTextColor(254,0,0);
    $pdf->SetXY( 148, 236 );
    $pdf->Cell(15,3, "DESCUENTO", 0, 0, "C");
    $pdf->SetXY( 180, 236 );
    $pdf->Cell(20,3,"$  ". number_format($descuentof,0), 0, 0, "R");

    
    $pdf->SetTextColor(0,0,0);
    $pdf->SetXY( 148, 241 );
    $pdf->Cell(15,3, "TOTAL", 0, 0, "C");
    $pdf->SetXY( 180, 241 );
    $pdf->Cell(20,3, "$  ".number_format($to-$total_ret,0), 0, 0, "R");
    $pdf->Ln(5);


    $pdf->SetFont('Arial','B',5);
    $pdf->MultiCell(190, 2.5, $condiciones_cot,1, 1, 'L');
  
    $pdf->SetFont('Arial','B',6);
    $pdf->Cell(180,4,utf8_decode('Impreso por | '.$emp_nombre. '  -  VICPOS  -  V 2.5.    '.$emp_url.''),0,0,'C');

    $pdf->Output($ven_nombre.'.pdf', 'I');
?>