<?php 

?>
<style>
/*-----------------------------------------------------------------------------------

    
    CSS INDEX
    =========================================
    01. header css here
    02. slider area css here
    03. product section css here
    04. banner section css here 
    05. blog area css here
    06. newsletter area css here
    07. footer area css here
    08. shop page css here
    09. error page css heer 
    10. about page css here
    11. blog page css here 
    12. blog details css here
    13. cart page css here
    14. checkout page css here
    15. contact page css here
    16. faq page css here
    17. login page css here
    18. my account css here
    19. portfolio page css here
    20. services page css here
    21. shipping css here
    22. wishlist css here
    23. newsletter popup css here
    24. modal css here
    25. portfolio css here
    
    

-----------------------------------------------------------------------------------*/
@import url("https://fonts.googleapis.com/css?family=Lato:100,100i,300,300i,400,400i,700,700i,900,900i|Poppins:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,900,900i");
* {
  box-sizing: border-box;
}

/* transition */
/* flex */
/* transform */
/* opacity */
/*----------------------------------------*/
/*  01. Theme default CSS
/*----------------------------------------*/
/*-- Google Font --*/
/*-- Common Style --*/
*, *::after, *::before {
  box-sizing: border-box;
}

html, body {
  height: 100%;
}

body {
  line-height: 24px;
  font-size: 13px;
  font-style: normal;
  font-weight: 400;
  visibility: visible;
  font-family: "Lato", sans-serif;
  color: #262626;
}

h1, h2, h3, h4, h5, h6 {
  font-weight: 400;
  margin-top: 0;
}

h1 {
  font-size: 48px;
  line-height: 1;
  font-weight: 700;
}

h2 {
  font-size: 36px;
  line-height: 36px;
}

h3 {
  font-size: 30px;
  line-height: 30px;
}

h4 {
  font-size: 16px;
  line-height: 19px;
  font-weight: 700;
}

h5 {
  font-size: 14px;
  line-height: 18px;
}

h6 {
  font-size: 12px;
  line-height: 14px;
}

p:last-child {
  margin-bottom: 0;
}

a, button {
  color: inherit;
  line-height: inherit;
  text-decoration: none;
  cursor: pointer;
}


a, button, img, input, span {
  transition: all 0.3s ease 0s;
}

*:focus {
  outline: none !important;
}

a:focus {
  color: inherit;
  outline: none;
  text-decoration: none;
}

a:hover {
  text-decoration: none;
}


button, input[type="submit"] {
  cursor: pointer;
}

img {
  max-width: 100%;
  height: auto;
}

ul {
  list-style: outside none none;
  margin: 0;
  padding: 0;
}

/*-- 
    - Common Classes
-----------------------------------------*/
.fix {
  overflow: hidden;
}

.hidden {
  display: none;
}

.clear {
  clear: both;
}

.container {
  max-width: 1200px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .container {
    max-width: 970px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .container {
    max-width: 750px;
  }
}

@media only screen and (max-width: 767px) {
  .container {
    width: 450px;
  }
}
@media only screen and (max-width: 479px) {
  .container {
    width: 100%;
  }
}
.capitalize {
  text-transform: capitalize;
}

.uppercase {
  text-transform: uppercase;
}

.no-gutters > .col, .no-gutters > [class*="col-"] {
  padding-right: 0;
  padding-left: 0;
  margin: 0;
}

/*-- 
    - Background color
-----------------------------------------*/
.bg-white {
  background-color: #ffffff;
}

.bg-light-grey {
  background-color: #f6fafb;
}

.bg-grey {
  background-color: #f8f8f8;
}

.bluewood-bg {
  background:rgb(0, 0, 0);
}

/*- Overlay Color BG -*/
.bluewood-bg-overlay {
  position: relative;
}
.bluewood-bg-overlay::before {
  background: rgba(0, 0, 0, 0.9);
  content: "";
  position: absolute;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
}

.overly-bg-black {
  position: relative;
}
.overly-bg-black::after {
  background: rgba(0, 0, 0, 0.3);
  content: "";
  position: absolute;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
}

/*-- 
    - color
-----------------------------------------*/
/*-- 
    - Input Placeholder
-----------------------------------------*/
input:-moz-placeholder, textarea:-moz-placeholder {
  opacity: 1;
  -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=100)";
}

input::-webkit-input-placeholder, textarea::-webkit-input-placeholder {
  opacity: 1;
  -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=100)";
}

input::-moz-placeholder, textarea::-moz-placeholder {
  opacity: 1;
  -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=100)";
}

input:-ms-input-placeholder, textarea:-ms-input-placeholder {
  opacity: 1;
  -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=100)";
}

/*-- 
    Scroll Up 
-----------------------------------------*/
#scrollUp {
  background: #<?php echo $conf_color;?> none repeat scroll 0 0;
  bottom: 150px; /* Ajusta este valor para subirlo más */
  color: #ffffff;
  cursor: pointer;
  display: none;
  font-size: 20px;
  height: 45px;
  line-height: 39px;
  position: fixed;
  right: 12px;
  text-align: center;
  width: 45px;
  z-index: 9999;
  border-radius: 50%;
  border: 2px solid #fff;
  -webkit-transition: .3s;
  transition: .3s;
}

#scrollUp:hover i {
  animation-name: fadeInUp;
  animation-duration: 1s;
  animation-fill-mode: both;
  animation-iteration-count: infinite;
}


/*-- 
    - Main Wrapper
-----------------------------------------*/
.main-wrapper.header-transparent {
  padding: 0 !important;
  margin: 0 !important;
}

/*-- 
    - Section Padding
-------------------------------------*/
.section-ptb {
  padding: 100px 0;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .section-ptb {
    padding: 90px 0;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .section-ptb {
    padding: 80px 0;
  }
}
@media only screen and (max-width: 767px) {
  .section-ptb {
    padding: 70px 0;
  }
}
@media only screen and (max-width: 479px) {
  .section-ptb {
    padding: 60px 0;
  }
}

.section-pt {
  padding-top: 100px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .section-pt {
    padding-top: 90px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .section-pt {
    padding-top: 80px;
  }
}
@media only screen and (max-width: 767px) {
  .section-pt {
    padding-top: 70px;
  }
}
@media only screen and (max-width: 479px) {
  .section-pt {
    padding-top: 60px;
  }
}
.section-pt-70 {
  padding-top: 70px;
}
.section-pt-70 {
  padding-top: 70px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .section-pt-70 {
    padding-top: 60px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .section-pt-70 {
    padding-top: 50px;
  }
}
@media only screen and (max-width: 767px) {
  .section-pt-70 {
    padding-top: 40px;
  }
}
@media only screen and (max-width: 479px) {
  .section-pt-70 {
    padding-top: 30px;
  }
}

.section-pb-70 {
  padding-bottom: 80px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .section-pb-70 {
    padding-bottom: 60px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .section-pb-70 {
    padding-bottom: 50px;
  }
}
@media only screen and (max-width: 767px) {
  .section-pb-70 {
    padding-bottom: 40px;
  }
}
@media only screen and (max-width: 479px) {
  .section-pb-70 {
    padding-bottom: 30px;
  }
}

.section-pb {
  padding-bottom: 100px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .section-pb {
    padding-bottom: 90px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .section-pb {
    padding-bottom: 80px;
  }
}
@media only screen and (max-width: 767px) {
  .section-pb {
    padding-bottom: 70px;
  }
}
@media only screen and (max-width: 479px) {
  .section-pb {
    padding-bottom: 60px;
  }
}

.mt-10 {
  margin-top: 10px;
}

.mt-15 {
  margin-top: 15px;
}

.mt-17 {
  margin-top: 17px;
}

.mt-20 {
  margin-top: 20px;
}

.mt-23 {
  margin-top: 23px;
}

.mt-30 {
  margin-top: 30px;
}

.mt-32 {
  margin-top: 32px;
}

.mt-47 {
  margin-top: 47px;
}

.mt-50 {
  margin-top: 50px;
}

.mt-57 {
  margin-top: 57px;
}

.mt-60 {
  margin-top: 60px;
}

.mb-0 {
  margin-bottom: 0;
}

.mb-10 {
  margin-bottom: 10px;
}

.mb-15 {
  margin-bottom: 15px;
}

.mb-42 {
  margin-bottom: 42px;
}

.mb-45 {
  margin-bottom: 45px;
}

.mb-47 {
  margin-bottom: 47px;
}

.mb-50 {
  margin-bottom: 50px;
}

.mb-30 {
  margin-bottom: 30px;
}

.mb-53 {
  margin-bottom: 53px;
}

.mb-55 {
  margin-bottom: 55px;
}

.mb-57 {
  margin-bottom: 57px;
}

.mb-60 {
  margin-bottom: 60px;
}

/* 02. Element */
.button {
  background: #<?php echo $conf_color;?>;
  box-shadow: none;
  color: #ffffff;
  display: inline-block;
  height: 45px;
  line-height: 45px;
  padding: 0 22px;
  text-transform: uppercase;
  font-size: 13px;
  border-radius: 3px;
}

/* 2. Home 1 Header css here */
/* 01. header css here */
.off_canvars_overlay {
  width: 100%;
  height: 100%;
  position: fixed;
  z-index: 99;
  opacity: 0;
  visibility: hidden;
  cursor: crosshair;
  background: #080808;
  top: 0;
}
.off_canvars_overlay.active {
  opacity: 0.5;
  visibility: visible;
}

.Offcanvas_menu {
  display: none;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .Offcanvas_menu {
    display: block;
    margin-bottom: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .Offcanvas_menu {
    display: block;
    margin-bottom: 25px;
  }
}

.Offcanvas_menu_wrapper {
  width: 290px;
  position: fixed;
  background: #fff;
  z-index: 99;
  top: 0;
  height: 100vh;
  transition: .5s;
  left: 0;
  margin-left: -300px;
  padding: 30px 20px 30px;
  overflow-y: auto;
}
.Offcanvas_menu_wrapper.active {
  margin-left: 0;
}
.Offcanvas_menu_wrapper .slinky-theme-default {
  background: inherit;
  min-height: 300px;
  overflow-y: auto;
}
.Offcanvas_menu_wrapper .top_right {
  display: block;
  padding-left: 0;
  text-align: center;
  margin-bottom: 19px;
}
.Offcanvas_menu_wrapper .top_right > ul > li {
  padding-right: 0;
  margin-right: 9px;
}
.Offcanvas_menu_wrapper .top_right > ul > li::before {
  display: none;
}
.Offcanvas_menu_wrapper .top_right > ul > li > a {
  line-height: 20px;
  font-size: 12px;
}
.Offcanvas_menu_wrapper .welcome_text {
  display: block;
  margin-bottom: 10px;
}
.Offcanvas_menu_wrapper .search-container {
  display: block;
}
.Offcanvas_menu_wrapper .mini_cart_wrapper {
  display: block;
  margin-bottom: 22px;
}
.Offcanvas_menu_wrapper .mini_cart_wrapper > a {
  display: inline-block;
  padding: 5px 20px;
  line-height: 25px;
}
.Offcanvas_menu_wrapper .mini_cart_wrapper > a i {
  font-size: 24px;
  margin-right: 5px;
}

.offcanvas_main_menu li {
  position: relative;
}
.offcanvas_main_menu li:last-child {
  margin: 0;
}
.offcanvas_main_menu li span.menu-expand {
  position: absolute;
  right: 0;
}
.offcanvas_main_menu li a {
  font-size: 14px;
  font-weight: 400;
  text-transform: capitalize;
  display: block;
  padding-bottom: 10px;
  margin-bottom: 10px;
  border-bottom: 1px solid #e5e5e5;
}
.offcanvas_main_menu li a:hover {
  color: #<?php echo $conf_color;?>;
}
.offcanvas_main_menu li ul.sub-menu {
  padding-left: 20px;
}

.Offcanvas_footer {
  margin-top: 50px;
  padding-bottom: 50px;
  text-align: center;
}
.Offcanvas_footer span a {
  font-size: 14px;
}
.Offcanvas_footer span a:hover {
  color: #<?php echo $conf_color;?>;
}
.Offcanvas_footer ul {
  margin-top: 20px;
}
.Offcanvas_footer ul li {
  display: inline-block;
  margin-right: 4px;
}
.Offcanvas_footer ul li:last-child {
  margin-right: 0;
}
.Offcanvas_footer ul li a {
  display: inline-block;
  width: 30px;
  height: 30px;
  text-align: center;
  line-height: 30px;
  border-radius: 50%;
  font-size: 13px;
  color: #ffffff;
}
.Offcanvas_footer ul li.facebook a {
  background:rgb(0, 0, 0);
}
.Offcanvas_footer ul li.facebook a:hover {
  background: #<?php echo $conf_color;?>;
}
.Offcanvas_footer ul li.whatsapp a {
  background: #229954;
}
.Offcanvas_footer ul li.whatsapp a:hover {
  background: #229954;
}
.Offcanvas_footer ul li.pinterest a {
  background: #BD081B;
}
.Offcanvas_footer ul li.pinterest a:hover {
  background: #<?php echo $conf_color;?>;
}
.Offcanvas_footer ul li.google-plus a {
  background: #DD4D42;
}
.Offcanvas_footer ul li.google-plus a:hover {
  background: #<?php echo $conf_color;?>;
}
.Offcanvas_footer ul li.linkedin a {
  background: #010103;
}
.Offcanvas_footer ul li.linkedin a:hover {
  background: #<?php echo $conf_color;?>;
}

.slinky-theme-default a:not(.back) {
  padding: 10px 0;
  text-transform: capitalize;
  font-size: 16px;
  font-weight: 400;
}
.slinky-theme-default a:not(.back):hover {
  background: inherit;
  color: #<?php echo $conf_color;?>;
}

.canvas_close {
  position: absolute;
  top: 10px;
  right: 13px;
}
.canvas_close a {
  font-size: 18px;
  text-transform: uppercase;
  font-weight: 500;
  width: 32px;
  height: 32px;
  display: block;
  text-align: center;
  line-height: 31px;
  border: 1px solid #e5e5e5;
  border-radius: 50%;
}
.canvas_close a:hover {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  color: #fff;
}

.canvas_open {
  display: flex;
  justify-content: space-between;
  border: 1px solid #e5e5e5;
  padding: 7px 20px 6px;
}
.canvas_open span {
  font-size: 18px;
  font-weight: 500;
  line-height: 27px;
}
.canvas_open a {
  font-size: 28px;
  color: #262626;
}

.Offcanvas_two {
  margin-bottom: 0;
  margin-top: 30px;
}
@media only screen and (max-width: 767px) {
  .Offcanvas_two {
    margin-top: 25px;
  }
}

.Offcanvas_three {
  margin-top: 30px;
}
@media only screen and (max-width: 767px) {
  .Offcanvas_three {
    margin-top: 25px;
  }
}

.sticky-header.sticky {
  position: fixed;
  z-index: 99;
  width: 100%;
  top: 0;
  background: rgba(38, 38, 38, 0.7);
  box-shadow: 0 0 2px rgba(0, 0, 0, 0.1);
  -webkit-animation-name: fadeInDown;
  animation-name: fadeInDown;
  -webkit-animation-duration: 900ms;
  animation-duration: 900ms;
  -webkit-animation-timing-function: cubic-bezier(0.2, 1, 0.22, 1);
  animation-timing-function: cubic-bezier(0.2, 1, 0.22, 1);
  -webkit-animation-delay: 0s;
  animation-delay: 0s;
  -webkit-animation-iteration-count: 1;
  animation-iteration-count: 1;
  -webkit-animation-direction: normal;
  animation-direction: normal;
  -webkit-animation-fill-mode: none;
  animation-fill-mode: none;
  -webkit-animation-play-state: running;
  animation-play-state: running;
  border-bottom: 0;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .sticky-header.sticky {
    position: inherit;
    -webkit-box-shadow: inherit;
    box-shadow: inherit;
    -webkit-animation-name: inherit;
    animation-name: inherit;
    padding: 0;
    background: inherit;
    opacity: inherit;
  }
}
@media only screen and (max-width: 767px) {
  .sticky-header.sticky {
    position: inherit;
    -webkit-box-shadow: inherit;
    box-shadow: inherit;
    -webkit-animation-name: inherit;
    animation-name: inherit;
    padding: 0;
    background: inherit;
    opacity: inherit;
  }
}

.header_top {
  border-bottom: 1px solid #e5e5e5;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .header_top {
    border-bottom: 0;
  }
}
@media only screen and (max-width: 767px) {
  .header_top {
    border-bottom: 0;
  }
}

.top_inner {
  border-bottom: 1px solid rgba(0, 0, 0, 0.1);
}
@media only screen and (max-width: 767px) {
  .top_inner {
    border: 0;
  }
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .welcome_text {
    display: none;
  }
}
@media only screen and (max-width: 767px) {
  .welcome_text {
    display: none;
  }
}
.welcome_text p {
  font-size: 13px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .welcome_text p {
    text-align: center;
  }
}
@media only screen and (max-width: 767px) {
  .welcome_text p {
    text-align: center;
  }
}
.welcome_text p span {
  color:#<?php echo $conf_color;?>;
}

.top_right.text-right {
  text-align: right;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .top_right {
    display: none;
  }
}
@media only screen and (max-width: 767px) {
  .top_right {
    display: none;
  }
}
.top_right > ul > li {
  display: inline-block;
  position: relative;
  padding-right: 20px;
  margin-right: 20px;
}
.top_right > ul > li:hover ul.dropdown_currency, .top_right > ul > li:hover ul.dropdown_language, .top_right > ul > li:hover ul.dropdown_links {
  top: 100%;
  opacity: 1;
  visibility: visible;
}
.top_right > ul > li:hover ul.dropdown_language {
  top: 100%;
  opacity: 1;
  visibility: visible;
}
.top_right > ul > li:hover ul.dropdown_links {
  top: 100%;
  opacity: 1;
  visibility: visible;
}
.top_right > ul > li:hover > a {
  color: #<?php echo $conf_color;?>;
}
@media only screen and (max-width: 767px) {
  .top_right > ul > li {
    padding-right: 15px;
    margin-right: 15px;
  }
}
.top_right > ul > li:last-child {
  padding-right: 0;
  margin-right: 0;
}
.top_right > ul > li > a {
  text-transform: capitalize;
  line-height: 40px;
  font-size: 13px;
  cursor: pointer;
  display: inline-block;
  font-weight: 400;
  letter-spacing: 0.3px;
}
@media only screen and (max-width: 767px) {
  .top_right > ul > li > a {
    line-height: 22px;
  }
}
.top_right > ul > li > a i.ion-ios-arrow-down {
  margin-left: 6px;
  font-size: 11px;
}

.top_right > ul > li:hover a:not([href]):not([tabindex]) {
  color: #<?php echo $conf_color;?>;
}

.dropdown_currency, .dropdown_language, .dropdown_links {
  position: absolute;
  background: #fff;
  box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
  min-width: 130px;
  text-align: left;
  top: 125%;
  left: -9px;
  -webkit-transition: all .3s ease-out;
  transition: all .3s ease-out;
  overflow: hidden;
  z-index: 9999;
  padding: 9px 18px 8px;
  border-radius: 3px;
  opacity: 0;
  visibility: hidden;
  border: 1px solid #<?php echo $conf_color;?>;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .dropdown_currency, .dropdown_language, .dropdown_links {
    left: 0;
    min-width: 115px;
  }
}
@media only screen and (max-width: 767px) {
  .dropdown_currency, .dropdown_language, .dropdown_links {
    left: 0;
    min-width: 142px;
    padding: 0 6px;
    min-width: 115px;
  }
}
.dropdown_currency li, .dropdown_language li, .dropdown_links li {
  border-bottom: 1px solid #<?php echo $conf_color;?>;
}
.dropdown_currency li:last-child, .dropdown_language li:last-child, .dropdown_links li:last-child {
  border-bottom: 0;
}
.dropdown_currency li a, .dropdown_language li a, .dropdown_links li a {
  text-transform: capitalize;
  display: block;
  font-size: 13px;
  white-space: nowrap;
  padding: 7px 0;
  line-height: 20px;
}
.dropdown_currency li a:hover, .dropdown_language li a:hover, .dropdown_links li a:hover {
  color: #<?php echo $conf_color;?>;
}

.dropdown_language {
  right: 0;
  left: auto;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .dropdown_language {
    left: -20px;
    right: auto;
  }
}
@media only screen and (max-width: 767px) {
  .dropdown_language {
    left: -20px;
    right: auto;
  }
}

.dropdown_links {
  right: 0;
  left: auto;
}

/*header top css end*/
/* 2.2 header middel css here */
.header_middle {
  padding: 16px 0;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .header_middle {
    padding: 19px 0;
  }
}
@media only screen and (max-width: 767px) {
  .header_middle {
    padding: 17px 0;
  }
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .logo {
    text-align: center;
  }
}
@media only screen and (max-width: 767px) {
  .logo {
    text-align: center;
  }
}
@media only screen and (max-width: 767px) {
  .logo a img {
    max-width: 155px;
  }
}

.header_middle_inner {
  display: flex;
  justify-content: space-between;
  align-items: center;
}

.hover_category {
  width: 155px;
  position: relative;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .hover_category {
    width: 140px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .hover_category {
    width: 125px;
  }
}
@media only screen and (max-width: 767px) {
  .hover_category {
    width: 125px;
  }
}
.hover_category::before {
  content: "";
  width: 1px;
  height: 16px;
  background: #a1a1a1;
  position: absolute;
  top: 50%;
  margin-top: -8px;
  right: 0;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .hover_category::before {
    right: -2px;
  }
}
@media only screen and (max-width: 767px) {
  .hover_category::before {
    right: -2px;
  }
}
.hover_category .select_option {
  border: 0;
  background: inherit;
  height: 49px;
  line-height: 49px;
  width: 100%;
  font-size: 14px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .hover_category .select_option {
    height: 34px;
    line-height: 35px;
    font-size: 11px;
    padding-left: 10px;
    padding-right: 18px;
  }
}
@media only screen and (max-width: 767px) {
  .hover_category .select_option {
    height: 34px;
    line-height: 35px;
    font-size: 11px;
    padding-left: 10px;
    padding-right: 18px;
  }
}
.hover_category .select_option::after {
  top: 54%;
  right: 20px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .hover_category .select_option::after {
    right: 15px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .hover_category .select_option::after {
    right: 6px;
  }
}
@media only screen and (max-width: 767px) {
  .hover_category .select_option::after {
    right: 6px;
  }
}
.hover_category .select_option ul.list {
  max-height: 300px;
  overflow: auto;
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .search-container {
    margin-bottom: 25px;
    display: none;
  }
}
@media only screen and (max-width: 767px) {
  .search-container {
    margin-bottom: 25px;
    display: none;
  }
}
.search-container form {
  display: flex;
  border-radius: 50px;
  border: 2px solid #e5e5e5;
  background: #fff;
}

.search_box {
  
}

.search_box {
  position: relative;
  width: 415px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .search_box {
    width: 335px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .search_box {
    width: 100%;
  }
}
@media only screen and (max-width: 767px) {
  .search_box {
    width: 100%;
  }
}
.search_box input {
  border: 0;
  background: inherit;
  width: 100%;
  height: 49px;
  color: #262626;
  font-size: 14px;
  font-weight: 400;
  padding: 0 80px 0 20px;
  opacity: 0.4;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .search_box input {
    font-size: 12px;
    padding: 0 45px 0 10px;
    width: 100%;
    height: 34px;
  }
}
@media only screen and (max-width: 767px) {
  .search_box input {
    font-size: 12px;
    padding: 0 45px 0 10px;
    width: 100%;
    height: 34px;
  }
}
.search_box button {
  border: 0;
  position: absolute;
  top: -2px;
  bottom: -2px;
  right: -2px;
  background: #<?php echo $conf_color;?>;;
  width: 62px;
  color: #fff;
  font-size: 24px;
  font-weight: 500;
  border-radius: 0 35px 35px 0;
  -webkit-transition: 0.3s;
  transition: 0.3s;
}
.search_box button:hover {
  background: #262626;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .search_box button {
    font-size: 20px;
    width: 33px;
  }
}
@media only screen and (max-width: 767px) {
  .search_box button {
    font-size: 20px;
    width: 33px;
  }
}

.mini_cart_wrapper {
  position: relative;
  text-align: center;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .mini_cart_wrapper {
    display: none;
  }
}
@media only screen and (max-width: 767px) {
  .mini_cart_wrapper {
    display: none;
  }
}
.mini_cart_wrapper:hover > a {
  color: #fff;
  background: #fff;
  border-color: #<?php echo $conf_color;?>;;
}
.mini_cart_wrapper:hover > a i {
  
}
.mini_cart_wrapper > a {
  word-spacing: 3px;
  letter-spacing: 0.5px;
  font-weight: 400;
  text-transform: capitalize;
  display: block;
  padding: 11px 20px;
  line-height: 29px;
  border: 1px solid #<?php echo $conf_color;?>;;
  border-radius: 30px;
}
.mini_cart_wrapper > a i {
  -webkit-transition: 0.3s;
  transition: 0.3s;
  font-size: 30px;
  color: #<?php echo $conf_color;?>;
  vertical-align: middle;
  line-height: 26px;
  margin-right: 7px;
}
.mini_cart_wrapper:hover .mini_cart {
  opacity: 1;
  visibility: visible;
  top: 100%;
}

.mini_cart {
  position: absolute;
  min-width: 355px;
  padding: 32px 28px;
  background: #fff;
  box-shadow: 0 0 7px 0 rgba(0, 0, 0, 0.1);
  border-top: 1px solid #<?php echo $conf_color;?>;;
  z-index: 999;
  right: 0;
  text-align: left;
  top: 130%;
  opacity: 0;
  visibility: hidden;
  -webkit-transition: 0.3s;
  transition: 0.3s;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .mini_cart {
    display: none;
    opacity: inherit;
    visibility: inherit;
    top: 100%;
    transition: unset;
    min-width: 255px;
    right: 0;
    padding: 18px 8px 33px;
  }
}
@media only screen and (max-width: 767px) {
  .mini_cart {
    min-width: 255px;
    right: 0;
    display: none;
    opacity: inherit;
    visibility: inherit;
    top: 100%;
    padding: 18px 8px 33px;
    transition: unset;
  }
}

.cart_img {
  width: 32%;
  margin-right: 20px;
  border: 1px solid #fff;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .cart_img {
    margin-right: 11px;
  }
}
@media only screen and (max-width: 767px) {
  .cart_img {
    margin-right: 11px;
  }
}

.cart_info {
  width: 56%;
}
.cart_info a {
  font-weight: 400;
  text-transform: capitalize;
  font-size: 14px;
  line-height: 20px;
  display: block;
  margin-bottom: 6px;
}
.cart_info a h4{
  font-weight: 400;
  text-transform: capitalize;
  font-size: 14px;
  line-height: 20px;
  display: block;
  margin-bottom: 6px;
  color:red;
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .cart_info a {
    font-size: 13px;
  }
}
@media only screen and (max-width: 767px) {
  .cart_info a {
    font-size: 13px;
  }
}
.cart_info a:hover {
  color: #<?php echo $conf_color;?>;
}
.cart_info a:hover h4 {
  color: #000000;
}
.cart_info span {
  display: block;
}
.cart_info span.quantity {
  margin-bottom: 5px;
  font-size: 12px;
}
.cart_info span.price_cart {
  font-weight: 600;
  color: #fff;
}

.cart_remove {
  width: 10%;
  text-align: right;
}
.cart_remove a {
  font-size: 18px;
}
.cart_remove a:hover {
  color: #<?php echo $conf_color;?>
;
}

.cart_item {
  overflow: hidden;
  border-bottom: 1px solid #e5e5e5;
  display: flex;
  justify-content: space-between;
  padding-bottom: 20px;
  margin-bottom: 20px;
}

.mini_cart_table {
  padding: 3px 0 23px;
}

.cart_total {
  display: flex;
  justify-content: space-between;
}
.cart_total span {
  font-size: 14px;
  font-weight: 400;
  text-transform: uppercase;
  font-weight: 600;
}

.cart_button {
  display: flex;
}
.cart_button a {
  text-transform: capitalize;
  border-radius: 25px;
  background: #262626;
  color: #fff;
  display: block;
  text-align: center;
  margin-bottom: 0;
  line-height: 40px;
  padding: 0 25px;
  margin-right: 17px;
}
.cart_button a:last-child {
  margin-right: 0;
}
.cart_button a:hover {
  background: #<?php echo $conf_color;?>;
}

/*header middel css end*/
/* 2.4 main menu css here */
.header_bottom {
  background: #262626;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .header_bottom {
    background: inherit;
  }
}
@media only screen and (max-width: 767px) {
  .header_bottom {
    background: inherit;
  }
}

.header_position {
  position: relative;
}

@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .main_menu {
    margin-left: 32px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .main_menu {
    display: none;
  }
}
@media only screen and (max-width: 767px) {
  .main_menu {
    display: none;
  }
}
.main_menu nav > ul > li {
  display: inline-block;
  position: relative;
}
.main_menu nav > ul > li:hover ul.sub_menu {
  opacity: 1;
  visibility: visible;
  transform: perspective(600px) rotateX(0deg);
}
.main_menu nav > ul > li:hover .mega_menu {
  opacity: 1;
  visibility: visible;
  transform: perspective(600px) rotateX(0deg);
}
.main_menu nav > ul > li:hover > a i {
  color: #ffffff;
}
.main_menu nav > ul > li > a {
  display: block;
  padding: 0 20px;
  font-size: 13px;
  line-height: 59px;
  text-transform: uppercase;
  font-weight: 700;
  color: #ffffff;
}
.main_menu nav > ul > li > a i {
  -webkit-transition: 0.5s;
  transition: 0.5s;
  margin-right: 5px;
  font-size: 16px;
  color: #<?php echo $conf_color;?>;
}
.main_menu nav > ul > li > a i.zmdi-caret-down {
  color: #ffffff;
  margin-right: 0;
  margin-left: 3px;
}
.main_menu nav > ul > li.active > a i {
  color: #ffffff;
}
.main_menu nav > ul > li ul.sub_menu {
  position: absolute;
  min-width: 200px;
  padding: 25px 20px;
  background: #fff;
  box-shadow: 0 3px 11px 0 rgba(0, 0, 0, 0.1);
  -webkit-transform: perspective(600px) rotateX(-90deg);
  transform: perspective(600px) rotateX(-90deg);
  -webkit-transform-origin: 0 0 0;
  transform-origin: 0 0 0;
  left: 0;
  right: auto;
  opacity: 0;
  visibility: hidden;
  -webkit-transition: 0.5s;
  transition: 0.5s;
  z-index: 99;
  top: 100%;
  text-align: left;
}
.main_menu nav > ul > li ul.sub_menu li a {
  font-weight: 400;
  display: block;
  line-height: 30px;
  text-transform: capitalize;
  font-size: 14px;
}
.main_menu nav > ul > li ul.sub_menu li a:hover {
  color: #<?php echo $conf_color;?>;
}
.main_menu nav > ul > li .mega_menu {
  position: absolute;
  min-width: 100%;
  padding: 25px 20px 30px 20px;
  background: #fff;
  box-shadow: 0 3px 11px 0 rgba(0, 0, 0, 0.1);
  -webkit-transform: perspective(600px) rotateX(-90deg);
  transform: perspective(600px) rotateX(-90deg);
  -webkit-transform-origin: 0 0 0;
  transform-origin: 0 0 0;
  left: 0;
  right: auto;
  opacity: 0;
  visibility: hidden;
  -webkit-transition: 0.5s;
  transition: 0.5s;
  z-index: 99;
  top: 100%;
  text-align: left;
  width: 600px;
}

.mega_menu_inner {
  display: flex;
  justify-content: space-between;
}
.mega_menu_inner > li > a {
  font-size: 14px;
  line-height: 24px;
  text-transform: uppercase;
  font-weight: 600;
  display: block;
  margin-bottom: 8px;
  border-bottom: 1px solid #e5e5e5;
  padding-bottom: 8px;
}
.mega_menu_inner > li > a:hover {
  color: #<?php echo $conf_color;?>;
}
.mega_menu_inner > li ul li {
  display: block;
}
.mega_menu_inner > li ul li a {
  font-weight: 400;
  display: block;
  line-height: 28px;
  text-transform: capitalize;
}
.mega_menu_inner > li ul li a:hover {
  color: #<?php echo $conf_color;?>;
}

/*main menu css end*/
/*mobaile menu css here*/
.mean-container .mean-bar {
  background: inherit;
  position: absolute;
  z-index: 9;
  top: 43px;
  left: 0;
  width: 100%;
}
.mean-container .mean-bar::after {
  top: -33px;
  left: 22px;
  color: #fff;
}
@media only screen and (max-width: 767px) {
  .mean-container .mean-bar::after {
    left: 22px;
    font-size: 15px;
  }
}
.mean-container .mean-nav {
  max-height: 300px;
  overflow: auto;
}
.mean-container .mean-nav ul li a {
  font-weight: 400;
}
.mean-container a.meanmenu-reveal {
  float: left;
  right: 17px;
  top: -34px;
  color: #fff;
}
@media only screen and (max-width: 767px) {
  .mean-container a.meanmenu-reveal {
    right: 15px;
    top: -34px;
  }
}
.mean-container a.meanmenu-reveal span {
  background: #fff;
}

.mobile-menu {
  border: 1px solid #ddd;
  height: 45px;
  top: -31px;
  position: relative;
}
@media only screen and (max-width: 767px) {
  .mobile-menu {
    top: 19px;
  }
}

/*-- 2.3 Categories menu css here --*/
.categories_menu {
  position: relative;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_menu {
    margin-bottom: 27px;
  }
}
@media only screen and (max-width: 767px) {
  .categories_menu {
    margin-bottom: 23px;
  }
}

.categories_title {
  background: #<?php echo $conf_color;?>;
  padding-left: 30px;
  position: relative;
  cursor: pointer;
  height: 54px;
  line-height: 56px;
  border-radius: 4px 4px 0 0;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_title {
    height: 46px;
    line-height: 46px;
    border-radius: 0;
  }
}
@media only screen and (max-width: 767px) {
  .categories_title {
    height: 44px;
    line-height: 44px;
    border-radius: 0;
  }
}
.categories_title::after {
  content: "\f23b";
  color: #fff;
  display: inline-block;
  font-family: 'Material-Design-Iconic-Font';
  position: absolute;
  font-size: 18px;
  line-height: 0px;
  right: 20px;
  top: 50%;
  transform: translatey(-50%);
}
.categories_title h2 {
  font-size: 16px;
  font-weight: 900;
  line-height: 26px;
  color: #fff;
  cursor: pointer;
  margin-bottom: 0;
  display: inline-block;
  text-transform: uppercase;
  letter-spacing: 0.1px;
}

.categories_menu_toggle {
  padding: 15px 0 9px;
  box-shadow: 0 1px 5px 1px rgba(0, 0, 0, 0.1);
  background: #fff;
  position: absolute;
  width: 100%;
  top: 100%;
  z-index: 9;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_menu_toggle {
    display: none;
    max-height: 350px;
    overflow: auto;
  }
}
@media only screen and (max-width: 767px) {
  .categories_menu_toggle {
    display: none;
    max-height: 350px;
    overflow: auto;
  }
}
.categories_menu_toggle > ul > li {
  position: relative;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_menu_toggle > ul > li.menu_item_children > a {
    position: relative;
  }
  .categories_menu_toggle > ul > li.menu_item_children > a::before {
    position: absolute;
    content: "+";
    right: 15px;
    top: 50%;
    transform: translatey(-50%);
    font-size: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .categories_menu_toggle > ul > li.menu_item_children > a {
    position: relative;
  }
  .categories_menu_toggle > ul > li.menu_item_children > a::before {
    position: absolute;
    content: "+";
    right: 15px;
    top: 50%;
    transform: translatey(-50%);
    font-size: 20px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_menu_toggle > ul > li.menu_item_children.open > a::before {
    display: none;
  }
  .categories_menu_toggle > ul > li.menu_item_children.open > a::after {
    position: absolute;
    content: "-";
    right: 15px;
    top: 50%;
    transform: translatey(-50%);
    font-size: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .categories_menu_toggle > ul > li.menu_item_children.open > a::before {
    display: none;
  }
  .categories_menu_toggle > ul > li.menu_item_children.open > a::after {
    position: absolute;
    content: "-";
    right: 15px;
    top: 50%;
    transform: translatey(-50%);
    font-size: 30px;
  }
}
.categories_menu_toggle > ul > li > a {
  font-size: 14px;
  line-height: 47px;
  text-transform: capitalize;
  font-weight: 400;
  display: block;
  cursor: pointer;
  padding: 0 15px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .categories_menu_toggle > ul > li > a {
    line-height: 42px;
  }
}
@media only screen and (max-width: 767px) {
  .categories_menu_toggle > ul > li > a {
    line-height: 35px;
  }
}
.categories_menu_toggle > ul > li > a span {
  margin-right: 8px;
}
.categories_menu_toggle > ul > li > a span i {
  font-size: 17px;
}
.categories_menu_toggle > ul > li > a i.fa-angle-right {
  float: right;
  color: #262626;
  font-size: 15px;
  line-height: 35px;
  transition: .3s;
  -webkit-transition: .3s;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_menu_toggle > ul > li > a i.fa-angle-right {
    display: none;
  }
}
@media only screen and (max-width: 767px) {
  .categories_menu_toggle > ul > li > a i.fa-angle-right {
    display: none;
  }
}
.categories_menu_toggle > ul > li:last-child > a {
  border-bottom: 0;
}


.categories_menu_toggle > ul > li:hover ul.categories_mega_menu {
  opacity: 1;
  visibility: visible;
  left: 100%;
}
.categories_menu_toggle > ul > li:hover > a {
  background: #e7e7e7;
  color: #<?php echo $conf_color;?>;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_menu_toggle > ul > li:hover > a {
    background: inherit;
    color: #<?php echo $conf_color;?>;
  }
}
@media only screen and (max-width: 767px) {
  .categories_menu_toggle > ul > li:hover > a {
    background: inherit;
    color: #<?php echo $conf_color;?>;
  }
}
.categories_menu_toggle > ul > li ul.categories_mega_menu {
  position: absolute;
  left: 120%;
  width: 630px;
  -webkit-box-shadow: 1px 0 6px 0 rgba(0, 0, 0, 0.3);
  box-shadow: 1px 0 6px 0 rgba(0, 0, 0, 0.3);
  background: #fff;
  padding: 20px 20px 16px;
  overflow: hidden;
  top: 0;
  -webkit-transition: .3s;
  transition: .3s;
  z-index: 99;
  opacity: 0;
  visibility: hidden;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .categories_menu_toggle > ul > li ul.categories_mega_menu {
    width: 680px;
  }
}
@media only screen and (max-width: 767px) {
  .categories_menu_toggle > ul > li ul.categories_mega_menu {
    display: none;
    opacity: inherit !important;
    visibility: inherit !important;
    left: inherit !important;
    width: 100%;
    top: 100%;
    max-height: 350px;
    overflow: auto;
    transition: unset;
    box-shadow: inherit;
    position: inherit;
    padding: 6px 20px 0px 40px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_menu_toggle > ul > li ul.categories_mega_menu {
    display: none;
    opacity: inherit !important;
    visibility: inherit !important;
    left: inherit !important;
    width: 100%;
    top: 100%;
    max-height: 350px;
    overflow: auto;
    transition: unset;
    box-shadow: inherit;
    position: inherit;
    padding: 6px 20px 0px 40px;
  }
}
.categories_menu_toggle > ul > li ul.categories_mega_menu.open {
  display: block;
  left: 0;
}
.categories_menu_toggle > ul > li ul.categories_mega_menu > li {
  padding: 0 15px;
  width: 33%;
  float: left;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_menu_toggle > ul > li ul.categories_mega_menu > li {
    width: 100%;
    padding: 0;
  }
}
@media only screen and (max-width: 767px) {
  .categories_menu_toggle > ul > li ul.categories_mega_menu > li {
    width: 100%;
    padding: 0;
  }
}
.categories_menu_toggle > ul > li ul.categories_mega_menu > li > a {
  line-height: 30px;
  font-size: 14px;
  font-weight: 500;
  text-transform: uppercase;
  display: block;
  margin-bottom: 5px;
}
.categories_menu_toggle > ul > li ul.categories_mega_menu > li > a:hover {
  color: #<?php echo $conf_color;?>;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_menu_toggle > ul > li ul.categories_mega_menu > li.menu_item_children > a {
    text-transform: capitalize;
    font-weight: 400;
  }
}
@media only screen and (max-width: 767px) {
  .categories_menu_toggle > ul > li ul.categories_mega_menu > li.menu_item_children > a {
    text-transform: capitalize;
    font-weight: 400;
  }
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_menu_toggle ul li.categorie_list ul.categories_mega_menu > li.menu_item_children > a {
    position: relative;
  }
  .categories_menu_toggle ul li.categorie_list ul.categories_mega_menu > li.menu_item_children > a::before {
    position: absolute;
    content: "+";
    right: 15px;
    top: 50%;
    transform: translatey(-50%);
    font-size: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .categories_menu_toggle ul li.categorie_list ul.categories_mega_menu > li.menu_item_children > a {
    position: relative;
  }
  .categories_menu_toggle ul li.categorie_list ul.categories_mega_menu > li.menu_item_children > a::before {
    position: absolute;
    content: "+";
    right: 15px;
    top: 50%;
    transform: translatey(-50%);
    font-size: 20px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_menu_toggle ul li.categorie_list ul.categories_mega_menu > li.menu_item_children.open > a::before {
    display: none;
  }
  .categories_menu_toggle ul li.categorie_list ul.categories_mega_menu > li.menu_item_children.open > a::after {
    position: absolute;
    content: "-";
    right: 15px;
    top: 50%;
    transform: translatey(-50%);
    font-size: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .categories_menu_toggle ul li.categorie_list ul.categories_mega_menu > li.menu_item_children.open > a::before {
    display: none;
  }
  .categories_menu_toggle ul li.categorie_list ul.categories_mega_menu > li.menu_item_children.open > a::after {
    position: absolute;
    content: "-";
    right: 15px;
    top: 50%;
    transform: translatey(-50%);
    font-size: 30px;
  }
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categorie_sub_menu {
    display: none;
    padding: 1px 0 9px 30px;
  }
}
@media only screen and (max-width: 767px) {
  .categorie_sub_menu {
    display: none;
    padding: 1px 0 9px 30px;
  }
}

.categorie_sub_menu li a {
  text-transform: capitalize;
  display: block;
  font-size: 14px;
  font-weight: 400;
  line-height: 34px;
}
.categorie_sub_menu li a:hover {
  color: #<?php echo $conf_color;?>;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categorie_sub_menu li a {
    line-height: 33px;
  }
}
@media only screen and (max-width: 767px) {
  .categorie_sub_menu li a {
    line-height: 33px;
  }
}

.categories_menu_toggle ul li ul.categories_mega_menu.column_3 {
  width: 550px;
}
@media only screen and (max-width: 767px) {
  .categories_menu_toggle ul li ul.categories_mega_menu.column_3 {
    width: 100%;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_menu_toggle ul li ul.categories_mega_menu.column_3 {
    width: 100%;
  }
}

.categories_menu_toggle ul li ul.categories_mega_menu.column_3 > li {
  width: 33.33%;
}
@media only screen and (max-width: 767px) {
  .categories_menu_toggle ul li ul.categories_mega_menu.column_3 > li {
    width: 100%;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_menu_toggle ul li ul.categories_mega_menu.column_3 > li {
    width: 100%;
  }
}

.categories_menu_toggle ul li ul.categories_mega_menu.column_2 {
  width: 400px;
}

.categories_menu_toggle ul li ul.categories_mega_menu.column_2 > li {
  width: 50%;
}
@media only screen and (max-width: 767px) {
  .categories_menu_toggle ul li ul.categories_mega_menu.column_2 > li {
    width: 100%;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_menu_toggle ul li ul.categories_mega_menu.column_2 > li {
    width: 100%;
  }
}

.categorie_sub {
  opacity: 0;
  z-index: 999;
  position: absolute;
  width: 100%;
  left: 0;
  border: lef;
  background: #fff;
  -webkit-transition: .3s;
  transition: .3s;
  top: 65%;
  visibility: hidden;
  box-shadow: 0 2px 5px -1px rgba(0, 0, 0, 0.1);
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categorie_sub {
    width: 100%;
    left: 0px;
  }
}
.categorie_sub.open {
  top: 95%;
  opacity: 1;
  visibility: visible;
}
.categorie_sub li a span {
  margin-right: 8px;
}

.categories_menu_toggle ul li.has-sub > a::before {
  position: absolute;
  content: "\f055";
  font-family: FontAwesome;
  top: 0;
  left: 15px;
  font-size: 18px;
  pointer-events: none;
}

.categories_menu_toggle ul li.has-sub > a.open::before {
  content: "\f056";
}

.categories_menu_toggle ul li.has-sub ul.categorie_sub li a {
  text-transform: capitalize;
  font-size: 14px;
  font-weight: 400;
  padding-left: 15px;
  line-height: 43px;
  display: block;
}

.categories_menu_toggle ul li.has-sub ul.categorie_sub li {
  padding-bottom: 16px;
}

.categories_menu_toggle ul li.has-sub ul.categorie_sub li a:hover {
  background: #f9f9f9;
  color: #<?php echo $conf_color;?>;
}

.categories_menu_toggle ul li.has-sub {
  padding-bottom: 10px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .categories_menu_toggle ul li.has-sub {
    padding-bottom: 0;
  }
}
.categories_menu_toggle ul li.has-sub a {
  padding-left: 38px;
}

.categories_menu_toggle ul li ul.categories_mega_menu > li:first-child {
  padding-left: 0;
}

.categories_menu_toggle ul li ul.categories_mega_menu > li:last-child {
  padding-right: 0;
}

.categorie_banner {
  position: absolute;
  bottom: 0;
  right: 20px;
  width: 500px;
}
@media only screen and (max-width: 767px) {
  .categorie_banner {
    display: none;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categorie_banner {
    display: none;
  }
}
.categorie_banner a img:hover {
  opacity: 0.8;
}

/*-- 2.7 Categories menu css end --*/
/*home two css here*/
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .menu_two {
    margin-left: 0;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .menu_two nav > ul > li > a {
    padding: 0 16px;
  }
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categori_two {
    margin-bottom: 30px;
  }
}
.categori_two .categories_title {
  height: 59px;
  line-height: 59px;
  border-radius: 0;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categori_two .categories_title {
    height: 46px;
    line-height: 46px;
  }
}
@media only screen and (max-width: 767px) {
  .categori_two .categories_title {
    height: 42px;
    line-height: 42px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .categori_two .categories_menu_toggle > ul > li > a {
    line-height: 44px;
  }
}

/*home three css here*/
.header_color .welcome_text p span {
  color: #ffb400;
}
.header_color .top_right > ul > li:hover > a {
  color: #<?php echo $conf_color;?>;
}
.header_color .dropdown_currency li a:hover, .header_color .dropdown_language li a:hover, .header_color .dropdown_links li a:hover {
  color: #<?php echo $conf_color;?>;
}
.header_color .header_middle {
  padding: 44px 0;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .header_color .header_middle {
    padding: 28px 0;
  }
}
@media only screen and (max-width: 767px) {
  .header_color .header_middle {
    padding: 23px 0;
  }
}
.header_color .search_box button {
  background: #ffb400;
}
.header_color .search_box button:hover {
  background: #262626;
}

.header_color .mini_cart_wrapper:hover > a {
  background: #ffb400;
  border-color: #ffb400;
}
.header_color .mini_cart_wrapper:hover > a i {
  color: #fff;
}
.header_color .mini_cart_wrapper > a i {
  color: #ffb400;
}
.header_color .mini_cart {
  border-top: 1px solid #ffb400;
}
.header_color .cart_info a:hover {
  color: #ffb400;
}
.header_color .cart_remove a:hover {
  color: #ffb400;
}
.header_color .cart_button a:hover {
  background: #ffb400;
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categori_three {
    margin-bottom: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .categori_three {
    margin-bottom: 25px;
  }
}
.categori_three .categories_title {
  height: 59px;
  line-height: 59px;
  border-radius: 0;
  background: #ffb400;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categori_three .categories_title {
    height: 46px;
    line-height: 46px;
  }
}
@media only screen and (max-width: 767px) {
  .categori_three .categories_title {
    height: 44px;
    line-height: 44px;
  }
}
.categori_three .categories_menu_toggle {
  display: none;
}
.categori_three .categories_menu_toggle > ul > li:hover > a {
  color: #ffb400;
}
.categori_three .categories_menu_toggle > ul > li ul.categories_mega_menu > li > a:hover {
  color: #ffb400;
}
.categori_three .categories_menu_toggle > ul > li.has-sub ul.categorie_sub li a:hover {
  color: #ffb400;
}
.categori_three .categorie_sub_menu li a:hover {
  color: #ffb400;
}

@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .menu_three {
    margin-left: 0;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .menu_three nav > ul > li > a {
    padding: 0 16px;
  }
}
.menu_three nav > ul > li > a i {
  color: #ffb400;
}
.menu_three nav > ul > li ul.sub_menu li a:hover {
  color: #ffb400;
}
.menu_three .mega_menu_inner li a:hover {
  color: #ffb400;
}

/*home four css here*/
.header_bottom_four {
  background: inherit;
}

@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .menu_four {
    margin-left: 0;
  }
}
.menu_four nav > ul > li.active > a {
  color: #<?php echo $conf_color;?>;
}
.menu_four nav > ul > li.active > a i {
  color: #<?php echo $conf_color;?>;
}
.menu_four nav > ul > li.active > a i.zmdi-caret-down {
  color: #<?php echo $conf_color;?>;
}
.menu_four nav > ul > li > a {
  color: #262626;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .menu_four nav > ul > li > a {
    padding: 0 16px;
  }
}
.menu_four nav > ul > li > a i {
  color: #262626;
}
.menu_four nav > ul > li > a i.zmdi-caret-down {
  color: #262626;
}
.menu_four nav > ul > li:hover > a {
  color: #<?php echo $conf_color;?>;
}
.menu_four nav > ul > li:hover > a i {
  color: #<?php echo $conf_color;?>;
}
.menu_four nav > ul > li:hover > a i.zmdi-caret-down {
  color: #<?php echo $conf_color;?>;
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categori_four {
    margin-bottom: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .categori_four {
    margin-bottom: 25px;
  }
}
.categori_four .categories_title {
  height: 59px;
  line-height: 59px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categori_four .categories_title {
    height: 46px;
    line-height: 46px;
  }
}
@media only screen and (max-width: 767px) {
  .categori_four .categories_title {
    height: 44px;
    line-height: 44px;
  }
}
.categori_four .categories_menu_toggle {
  display: none;
}

/*home five css here*/
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categorie_five {
    margin-bottom: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .categorie_five {
    margin-bottom: 25px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .categorie_five .categories_title {
    height: 48px;
    line-height: 48px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .categorie_five .categories_menu_toggle > ul > li > a {
    line-height: 36px;
  }
}

/*home six css here*/
.header_top_six .welcome_text p span {
  color: #ffb400;
}
.header_top_six .top_right > ul > li:hover > a {
  color: #ffb400;
}
.header_top_six .dropdown_currency li a:hover, .header_top_six .dropdown_language li a:hover, .header_top_six .dropdown_links li a:hover {
  color: #ffb400;
}

.header_middle_six {
  background: #262626;
  border-bottom: 1px solid rgba(255, 255, 255, 0.15);
  padding: 44px 0;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .header_middle_six {
    background: inherit;
    border-bottom: 0;
    padding: 0;
  }
}
@media only screen and (max-width: 767px) {
  .header_middle_six {
    background: inherit;
    border-bottom: 0;
    padding: 0;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .header_middle_six .logo {
    background: #262626;
    padding: 30px 0;
    margin-bottom: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .header_middle_six .logo {
    background: #262626;
    padding: 25px 0;
    margin-bottom: 25px;
  }
}
.header_middle_six .search_box button {
  background: #ffb400;
}
.header_middle_six .search_box button:hover {
  background: #262626;
}
.header_middle_six .mini_cart_wrapper:hover > a {
  background: #ffb400;
  border-color: #ffb400;
}
.header_middle_six .mini_cart_wrapper:hover > a i {
  color: #fff;
}
.header_middle_six .mini_cart_wrapper > a {
  color: #fff;
}
.header_middle_six .mini_cart_wrapper > a i {
  color: #ffb400;
}

.mini_cart_six {
  border-top: 1px solid #ffb400;
}
.mini_cart_six .cart_info a:hover {
  color: #ffb400;
}
.mini_cart_six .cart_remove a:hover {
  color: #ffb400;
}
.mini_cart_six .cart_button a:hover {
  background: #ffb400;
}

@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .menu_six {
    margin-left: 0;
  }
}
.menu_six nav > ul > li.active > a {
  color: #ffb400;
}
.menu_six nav > ul > li.active > a i {
  color: #ffb400;
}
.menu_six nav > ul > li:hover > a {
  color: #ffb400;
}
.menu_six nav > ul > li:hover > a i {
  color: #ffb400;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .menu_six nav > ul > li > a {
    padding: 0 17px;
  }
}
.menu_six nav > ul > li > a i {
  color: #fff;
}
.menu_six nav > ul > li ul.sub_menu li a:hover {
  color: #ffb400;
}
.menu_six .mega_menu_inner > li > a:hover {
  color: #ffb400;
}
.menu_six .mega_menu_inner > li ul li a:hover {
  color: #ffb400;
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categorie_six {
    margin-bottom: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .categorie_six {
    margin-bottom: 25px;
  }
}
.categorie_six .categories_title {
  height: 59px;
  line-height: 59px;
  background: #ffb400;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categorie_six .categories_title {
    height: 46px;
    line-height: 46px;
  }
}
@media only screen and (max-width: 767px) {
  .categorie_six .categories_title {
    height: 44px;
    line-height: 44px;
  }
}
.categorie_six .categories_menu_toggle > ul > li:hover > a {
  color: #ffb400;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .categorie_six .categories_menu_toggle > ul > li > a {
    line-height: 38px;
    font-size: 13px;
  }
}
.categorie_six .categories_menu_toggle > ul > li ul.categories_mega_menu > li > a:hover {
  color: #ffb400;
}
.categorie_six .categories_menu_toggle > ul > li.has-sub ul.categorie_sub li a:hover {
  color: #ffb400;
}
.categorie_six .categorie_sub_menu li a:hover {
  color: #ffb400;
}

/*home seven css here*/
.header_seven {
  background: #262626;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .header_seven {
    background: inherit;
  }
}
@media only screen and (max-width: 767px) {
  .header_seven {
    background: inherit;
  }
}

.header_top_seven {
  border: 0;
  background: #1b1b1b;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .header_top_seven {
    display: none;
  }
}
@media only screen and (max-width: 767px) {
  .header_top_seven {
    display: none;
  }
}
.header_top_seven .welcome_text p {
  color: #ffffff;
}
.header_top_seven .welcome_text p span {
  color: #20a385;
}
.header_top_seven .top_right > ul > li:hover > a {
  color: #20a385;
}
.header_top_seven .top_right > ul > li > a {
  color: #ffffff;
}
.header_top_seven .dropdown_currency li a:hover, .header_top_seven .dropdown_language li a:hover, .header_top_seven .dropdown_links li a:hover {
  color: #20a385;
}

.header_middle_seven {
  padding: 44px 0;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .header_middle_seven {
    padding: 0;
  }
}
@media only screen and (max-width: 767px) {
  .header_middle_seven {
    padding: 0;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .header_middle_seven .logo {
    padding: 30px 0;
    margin-bottom: 30px;
    background: #262626;
  }
}
@media only screen and (max-width: 767px) {
  .header_middle_seven .logo {
    padding: 25px 0;
    margin-bottom: 25px;
    background: #262626;
  }
}
.header_middle_seven .search_box button {
  background: #20a385;
}
.header_middle_seven .search_box button:hover {
  background: #262626;
}
.header_middle_seven .mini_cart_wrapper:hover > a {
  background: #20a385;
  border-color: #20a385;
}
.header_middle_seven .mini_cart_wrapper:hover > a i {
  color: #ffffff;
}
.header_middle_seven .mini_cart_wrapper > a {
  color: #ffffff;
}
.header_middle_seven .mini_cart_wrapper > a i {
  color: #20a385;
}

.mini_cart_seven {
  border-top: 1px solid #20a385;
}
.mini_cart_seven .cart_info a:hover {
  color: #20a385;
}
.mini_cart_seven .cart_remove a:hover {
  color: #20a385;
}
.mini_cart_seven .cart_button a:hover {
  background: #20a385;
}

.header_bottom_seven {
  border-top: 1px solid rgba(255, 255, 255, 0.15);
}

@media only screen and (max-width: 767px) {
  .categori_seven {
    margin-bottom: 25px;
  }
}
.categori_seven .categories_title {
  height: 59px;
  line-height: 59px;
  border-radius: 0;
  background: #20a385;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categori_seven .categories_title {
    height: 46px;
    line-height: 46px;
  }
}
@media only screen and (max-width: 767px) {
  .categori_seven .categories_title {
    height: 44px;
    line-height: 44px;
  }
}
.categori_seven .categories_menu_toggle {
  display: none;
}
.categori_seven .categories_menu_toggle > ul > li:hover > a {
  color: #20a385;
}
.categori_seven .categories_menu_toggle > ul > li ul.categories_mega_menu > li > a:hover {
  color: #20a385;
}
.categori_seven .categories_menu_toggle > ul > li.has-sub ul.categorie_sub li a:hover {
  color: #20a385;
}
.categori_seven .categorie_sub_menu li a:hover {
  color: #20a385;
}

@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .menu_seven {
    margin-left: 0;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .menu_seven nav > ul > li > a {
    margin-left: 0;
    padding: 0 17px;
  }
}
.menu_seven nav > ul > li > a i {
  color: #20a385;
}
.menu_seven nav > ul > li ul.sub_menu li a:hover {
  color: #20a385;
}
.menu_seven .mega_menu_inner > li > a:hover {
  color: #20a385;
}
.menu_seven .mega_menu_inner > li ul li a:hover {
  color: #20a385;
}

/*home eight css here*/
.header_top_eight .welcome_text p span {
  color: #02a8f3;
}
.header_top_eight .top_right > ul > li:hover > a {
  color: #02a8f3;
}
.header_top_eight .dropdown_currency li a:hover, .header_top_eight .dropdown_language li a:hover, .header_top_eight .dropdown_links li a:hover {
  color: #02a8f3;
}

.middle_eight_container {
  display: flex;
  justify-content: space-between;
  align-items: center;
}

.menu_eight nav > ul > li:hover > a {
  color: #02a8f3;
}
.menu_eight nav > ul > li:hover > a i {
  color: #02a8f3;
}
.menu_eight nav > ul > li:hover > a i.zmdi-caret-down {
  color: #02a8f3;
}
.menu_eight nav > ul > li.active > a {
  color: #02a8f3;
}
.menu_eight nav > ul > li.active > a i {
  color: #02a8f3;
}
.menu_eight nav > ul > li.active > a i.zmdi-caret-down {
  color: #02a8f3;
}
.menu_eight nav > ul > li > a {
  color: #262626;
  padding: 0 12px;
}
.menu_eight nav > ul > li > a i {
  color: #262626;
}
.menu_eight nav > ul > li > a i.zmdi-caret-down {
  color: #262626;
}
.menu_eight nav > ul > li ul.sub_menu li a:hover {
  color: #02a8f3;
}
.menu_eight .mega_menu_inner > li > a:hover {
  color: #02a8f3;
}
.menu_eight .mega_menu_inner > li ul li a:hover {
  color: #02a8f3;
}

@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .header_support {
    display: none;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .header_support {
    display: none;
  }
}
@media only screen and (max-width: 767px) {
  .header_support {
    display: none;
  }
}
.header_support a {
  font-size: 14px;
}
.header_support a:hover {
  color: #02a8f3;
}
.header_support a i {
  font-size: 23px;
  color: #02a8f3;
  margin-right: 3px;
}

.search_version_eight {
  display: flex;
  justify-content: space-between;
  align-items: center;
}
.search_version_eight .search-container form {
  border: 1px solid #e5e5e5;
}
.search_version_eight .search_box button {
  top: -1px;
  bottom: -1px;
  right: -1px;
  background: #02a8f3;
}
.search_version_eight .search_box button:hover {
  background: #262626;
}
.search_version_eight .mini_cart_wrapper:hover > a {
  background: #02a8f3;
  border-color: #02a8f3;
}
.search_version_eight .mini_cart_wrapper:hover > a i {
  color: #ffffff;
}
.search_version_eight .mini_cart_wrapper > a {
  color: #ffffff;
  padding: 8px 20px;
}
.search_version_eight .mini_cart_wrapper > a i {
  color: #02a8f3;
}

.header_middle_eight {
  padding: 41px 0;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .header_middle_eight {
    padding: 27px 0 28px;
  }
}
@media only screen and (max-width: 767px) {
  .header_middle_eight {
    padding: 25px 0;
  }
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categori_eight {
    margin-bottom: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .categori_eight {
    margin-bottom: 25px;
  }
}
.categori_eight .categories_title {
  height: 59px;
  line-height: 59px;
  border-radius: 0;
  background: #02a8f3;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categori_eight .categories_title {
    height: 46px;
    line-height: 46px;
  }
}
@media only screen and (max-width: 767px) {
  .categori_eight .categories_title {
    height: 44px;
    line-height: 44px;
  }
}
.categori_eight .categories_menu_toggle {
  display: none;
}
.categori_eight .categories_menu_toggle > ul > li:hover > a {
  color: #02a8f3;
}
.categori_eight .categories_menu_toggle > ul > li ul.categories_mega_menu > li > a:hover {
  color: #02a8f3;
}
.categori_eight .categories_menu_toggle > ul > li.has-sub ul.categorie_sub li a:hover {
  color: #02a8f3;
}
.categori_eight .categorie_sub_menu li a:hover {
  color: #02a8f3;
}

.mini_cart_eight {
  border-top: 1px solid #02a8f3;
}
.mini_cart_eight .cart_info a:hover {
  color: #02a8f3;
}
.mini_cart_eight .cart_remove a:hover {
  color: #02a8f3;
}
.mini_cart_eight .cart_button a:hover {
  background: #02a8f3;
}

/* 02. slider area css here */
.single_slider {
  background-repeat: no-repeat;
  background-attachment: scroll;
  background-position: center center;
  background-size: cover;
  height: 510px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .single_slider {
    height: 460px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .single_slider {
    height: 420px;
  }
}
@media only screen and (max-width: 767px) {
  .single_slider {
    background-position: 10%;
    height: 350px;
  }
}
@media only screen and (max-width: 767px) {
  .single_slider.slider_bottom {
    background-position: 52%;
  }
}

.slider_area:hover .owl-dots {
  opacity: 1;
  visibility: visible;
}
.slider_area .owl-dots {
  position: absolute;
  bottom: 10px;
  left: 50%;
  transform: translatex(-50%);
  opacity: 0;
  visibility: hidden;
  -webkit-transition: 0.3s;
  transition: 0.3s;
}
.slider_area .owl-dots .owl-dot {
  width: 14px;
  height: 14px;
  border-radius: 100%;
  background: #fff;
  display: inline-block;
  margin-right: 12px;
  -webkit-transition: 0.3s;
  transition: 0.3s;
}
.slider_area .owl-dots .owl-dot:hover {
  background: #262626;
}
.slider_area .owl-dots .owl-dot.active {
  background: #262626;
}
.slider_area .owl-dots .owl-dot:last-child {
  margin-right: 0;
}

.slider_content h1 {
  font-size: 44px;
  line-height: 44px;
  color: #<?php echo $conf_color;?>;
  font-weight: 700;
  font-family: "Poppins", sans-serif;
  margin-bottom: 10px;
}
@media only screen and (max-width: 767px) {
  .slider_content h1 {
    font-size: 30px;
    line-height: 30px;
  }
}
.slider_content h2 {
  font-size: 36px;
  line-height: 36px;
  text-transform: uppercase;
  font-family: "Poppins", sans-serif;
  margin-bottom: 10px;
}
@media only screen and (max-width: 767px) {
  .slider_content h2 {
    font-size: 22px;
    line-height: 24px;
  }
}
.slider_content > span {
  font-size: 30px;
  line-height: 30px;
  color: #<?php echo $conf_color;?>;
  font-family: "Poppins", sans-serif;
  font-weight: 300;
  display: block;
  margin-bottom: 25px;
}
@media only screen and (max-width: 767px) {
  .slider_content > span {
    font-size: 20px;
    line-height: 20px;
    margin-bottom: 18px;
  }
}
.slider_content a {
  text-transform: uppercase;
  padding: 6px 25px;
  background: #262626;
  color: #ffffff;
  border-radius: 30px;
  display: inline-block;
}
@media only screen and (max-width: 767px) {
  .slider_content a {
    padding: 5px 22px 6px;
    font-size: 12px;
  }
}
.slider_content a:hover {
  background: #ffffff;
  color: #262626;
}

.content_position_center {
  padding-top: 33px;
  margin-left: 70px;
  max-width: 370px;
  text-align: center;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .content_position_center {
    margin-left: 0;
    max-width: 100%;
  }
}
@media only screen and (max-width: 767px) {
  .content_position_center {
    margin-left: 0;
    max-width: 100%;
  }
}

.content_position_left {
  text-align: left;
  margin-left: 35px;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .content_position_left {
    margin-left: 70px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .content_position_left {
    margin-left: 70px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .content_position_left {
    margin-left: 70px;
  }
}
@media only screen and (max-width: 767px) {
  .content_position_left {
    text-align: center;
    width: 100%;
    margin-left: 0;
  }
}
.content_position_left h1 {
  color: #ffffff;
}
.content_position_left h2 {
  color: #fdd600;
}
.content_position_left span {
  color: #ffffff;
}

.active .slider_content h1, .active .slider_content h2, .active .slider_content span, .active .slider_content a {
  -webkit-animation-fill-mode: both;
  animation-fill-mode: both;
  -webkit-animation-duration: 1s;
  animation-duration: 1s;
  -webkit-animation-name: fadeInDown;
  animation-name: fadeInDown;
  -webkit-animation-delay: 0.3s;
  animation-delay: 0.3s;
}

.active .slider_content span {
  -webkit-animation-delay: 0.7s;
  animation-delay: 0.7s;
}

.active .slider_content h2 {
  -webkit-animation-delay: 0.5s;
  animation-delay: 0.5s;
}

.active .slider_content a {
  -webkit-animation-delay: 0.9s;
  animation-delay: 0.9s;
}

/*home two css here*/
.slider_two .single_slider {
  height: 480px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_two .single_slider {
    height: 446px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_two .single_slider {
    height: 400px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_two .single_slider {
    height: 345px;
  }
}

.slider_content_two.content_position_center {
  max-width: inherit;
  width: 100%;
  text-align: right;
  margin-left: 0;
  margin-right: 30px;
  padding-top: 0;
}
@media only screen and (max-width: 767px) {
  .slider_content_two.content_position_center {
    text-align: center;
    margin-right: 0;
  }
}
.slider_content_two.content_position_center a {
  background: #fff;
  color: #<?php echo $conf_color;?>;
}
.slider_content_two.content_position_center a:hover {
  color: #262626;
}
.slider_content_two h1 {
  color: #fff;
  font-size: 40px;
  font-weight: 600;
}
@media only screen and (max-width: 767px) {
  .slider_content_two h1 {
    font-size: 30px;
  }
}
.slider_content_two > span {
  color: #fff;
  font-size: 26px;
  margin-bottom: 15px;
}
@media only screen and (max-width: 767px) {
  .slider_content_two > span {
    font-size: 18px;
    margin-bottom: 9px;
  }
}
.slider_content_two h2 {
  color: #fff;
  font-size: 61px;
  line-height: 61px;
  font-weight: 600;
  margin-bottom: 23px;
}
@media only screen and (max-width: 767px) {
  .slider_content_two h2 {
    font-size: 45px;
    line-height: 54px;
    margin-bottom: 16px;
  }
}
.slider_content_two h2 span {
  font-size: 18px;
  line-height: 18px;
  font-weight: 300;
  position: relative;
  top: -28px;
}
@media only screen and (max-width: 767px) {
  .slider_content_two h2 span {
    font-size: 16px;
    top: -20px;
  }
}
.slider_content_two.content_position_left h2 {
  color: #efe20c;
}

/*home three css here*/
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_section.mt-30 {
    margin-top: 25px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_section.mt-30 {
    margin-top: 25px;
  }
}

.slider_content_three {
  text-align: left;
  margin-left: 35%;
  padding-top: 0;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_three {
    margin-left: 25%;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_three {
    margin-left: 22%;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_three {
    margin-left: 0;
    text-align: center;
    width: 100%;
  }
}
.slider_content_three h1 {
  font-size: 40px;
  line-height: 40px;
  color: #262626;
  text-transform: uppercase;
  font-weight: 400;
  margin-bottom: 8px;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_three h1 {
    font-size: 28px;
    line-height: 28px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_three h1 {
    font-size: 28px;
    line-height: 28px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_three h1 {
    font-size: 28px;
    line-height: 28px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_three h1 {
    font-size: 24px;
    line-height: 24px;
  }
}
.slider_content_three h1 span {
  font-weight: 600;
  font-size: 28px;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_three h1 span {
    font-size: 20px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_three h1 span {
    font-size: 20px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_three h1 span {
    font-size: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_three h1 span {
    font-size: 20px;
  }
}
.slider_content_three > span {
  font-size: 30px;
  line-height: 30px;
  font-weight: 300;
  color: #262626;
  margin-bottom: 15px;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_three > span {
    font-size: 21px;
    line-height: 21px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_three > span {
    font-size: 21px;
    line-height: 21px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_three > span {
    font-size: 21px;
    line-height: 21px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_three > span {
    font-size: 19px;
    line-height: 25px;
    margin-bottom: 10px;
  }
}
.slider_content_three h2 {
  font-size: 60px;
  line-height: 60px;
  font-weight: 600;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_three h2 {
    font-size: 42px;
    line-height: 42px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_three h2 {
    font-size: 42px;
    line-height: 42px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_three h2 {
    font-size: 42px;
    line-height: 42px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_three h2 {
    font-size: 38px;
    line-height: 38px;
  }
}
.slider_content_three h2 span {
  font-size: 24px;
  line-height: 24px;
  top: -26px;
  position: relative;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_three h2 span {
    font-size: 13px;
    line-height: 13px;
    top: -18px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_three h2 span {
    font-size: 13px;
    line-height: 13px;
    top: -18px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_three h2 span {
    font-size: 13px;
    line-height: 13px;
    top: -18px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_three h2 span {
    font-size: 13px;
    line-height: 13px;
    top: -15px;
  }
}
.slider_content_three.content_position_left h1 {
  font-size: 28px;
  line-height: 28px;
  font-weight: 400;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_three.content_position_left h1 {
    font-size: 20px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_three.content_position_left h1 {
    font-size: 20px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_three.content_position_left h1 {
    font-size: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_three.content_position_left h1 {
    font-size: 20px;
  }
}
.slider_content_three.content_position_left h1 span {
  font-size: 40px;
  line-height: 40px;
  font-weight: 600;
  color: #262626;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_three.content_position_left h1 span {
    font-size: 28px;
    line-height: 28px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_three.content_position_left h1 span {
    font-size: 28px;
    line-height: 28px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_three.content_position_left h1 span {
    font-size: 28px;
    line-height: 28px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_three.content_position_left h1 span {
    font-size: 24px;
    line-height: 24px;
  }
}
.slider_content_three.content_position_left h2 {
  color: #262626;
}
.slider_content_three.content_position_left h2 span {
  color: #262626;
}

.slider_three .single_slider {
  height: 508px;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_three .single_slider {
    height: 360px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_three .single_slider {
    height: 360px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_three .single_slider {
    height: 360px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_three .single_slider {
    height: 340px;
  }
}

/*home four css here*/
.slider_four .single_slider {
  height: 535px;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_four .single_slider {
    height: 382px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_four .single_slider {
    height: 360px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_four .single_slider {
    height: 360px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_four .single_slider {
    height: 340px;
  }
}

.slider_content_four {
  margin-left: 35%;
  max-width: 100%;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_four {
    margin-left: 31%;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_four {
    margin-left: 25%;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_four {
    margin-left: 22%;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_four {
    margin-left: 0;
    text-align: center;
    width: 100%;
    padding-top: 0;
  }
}
.slider_content_four.content_position_center {
  text-align: left;
}
@media only screen and (max-width: 767px) {
  .slider_content_four.content_position_center {
    text-align: center;
  }
}
.slider_content_four.content_position_center h1 {
  font-size: 36px;
  line-height: 36px;
  color: #262626;
  font-weight: 400;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_four.content_position_center h1 {
    font-size: 27px;
    line-height: 27px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_four.content_position_center h1 {
    font-size: 27px;
    line-height: 27px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_four.content_position_center h1 {
    font-size: 27px;
    line-height: 27px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_four.content_position_center h1 {
    font-size: 24px;
    line-height: 24px;
  }
}
.slider_content_four.content_position_center span {
  font-size: 18px;
  line-height: 25px;
  color: #262626;
  margin-bottom: 20px;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_four.content_position_center span {
    font-size: 16px;
    line-height: 20px;
    margin-bottom: 18px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_four.content_position_center span {
    font-size: 14px;
    line-height: 20px;
    margin-bottom: 18px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_four.content_position_center span {
    font-size: 14px;
    line-height: 20px;
    margin-bottom: 18px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_four.content_position_center span {
    font-size: 14px;
    line-height: 20px;
    margin-bottom: 18px;
  }
}
.slider_content_four.content_position_center h2 {
  font-size: 40px;
  line-height: 40px;
  color: #<?php echo $conf_color;?>;
  font-weight: 600;
  margin-bottom: 25px;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_four.content_position_center h2 {
    font-size: 30px;
    line-height: 30px;
    margin-bottom: 18px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_four.content_position_center h2 {
    font-size: 30px;
    line-height: 30px;
    margin-bottom: 18px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_four.content_position_center h2 {
    font-size: 30px;
    line-height: 30px;
    margin-bottom: 18px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_four.content_position_center h2 {
    font-size: 25px;
    line-height: 25px;
    margin-bottom: 18px;
  }
}
.slider_content_four.content_position_center h2 span {
  font-size: 13px;
  line-height: 25px;
  color: #262626;
  font-weight: 300;
  position: relative;
  top: -18px;
  margin-right: 10px;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_four.content_position_center h2 span {
    top: -11px;
    margin-right: 7px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_four.content_position_center h2 span {
    top: -11px;
    margin-right: 7px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_four.content_position_center h2 span {
    top: -11px;
    margin-right: 7px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_four.content_position_center h2 span {
    font-size: 12px;
    line-height: 17px;
    top: -8px;
    margin-right: 7px;
  }
}
.slider_content_four.content_position_left h1 {
  font-size: 36px;
  line-height: 36px;
  color: #262626;
  font-weight: 400;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_four.content_position_left h1 {
    font-size: 27px;
    line-height: 27px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_four.content_position_left h1 {
    font-size: 27px;
    line-height: 27px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_four.content_position_left h1 {
    font-size: 27px;
    line-height: 27px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_four.content_position_left h1 {
    font-size: 24px;
    line-height: 24px;
  }
}
.slider_content_four.content_position_left span {
  font-size: 18px;
  line-height: 25px;
  color: #262626;
  margin-bottom: 20px;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_four.content_position_left span {
    font-size: 15px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_four.content_position_left span {
    font-size: 15px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_four.content_position_left span {
    font-size: 15px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_four.content_position_left span {
    font-size: 15px;
  }
}

/*home five css here*/
.slider_five .single_slider {
  height: 560px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_five .single_slider {
    height: 443px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_five .single_slider {
    height: 360px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_five .single_slider {
    height: 340px;
  }
}

.slider_content_five.content_position_left {
  text-align: left;
}
@media only screen and (max-width: 767px) {
  .slider_content_five.content_position_left {
    text-align: center;
  }
}
.slider_content_five.content_position_left h1 {
  font-size: 48px;
  line-height: 48px;
  font-weight: 400;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_five.content_position_left h1 {
    font-size: 34px;
    line-height: 34px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_five.content_position_left h1 {
    font-size: 25px;
    line-height: 25px;
  }
}
.slider_content_five.content_position_left h1 span {
  font-weight: 600;
  text-transform: uppercase;
  color: #<?php echo $conf_color;?>;
}
.slider_content_five.content_position_left > span {
  font-size: 36px;
  line-height: 36px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_five.content_position_left > span {
    font-size: 22px;
    line-height: 24px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_five.content_position_left > span {
    font-size: 18px;
    line-height: 18px;
  }
}
.slider_content_five.content_position_left a {
  background: inherit;
  border: 1px solid #fff;
}
.slider_content_five.content_position_left a:hover {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  color: #fff;
}
.slider_content_five.content_position_center {
  max-width: 100%;
  margin-left: 0;
  padding-top: 100px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_five.content_position_center {
    padding-top: 38px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_five.content_position_center {
    padding-top: 58px;
  }
}
.slider_content_five.content_position_center h1 {
  font-size: 44px;
  line-height: 44px;
  color: #262626;
  font-weight: 600;
  text-transform: uppercase;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_five.content_position_center h1 {
    font-size: 30px;
    line-height: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_five.content_position_center h1 {
    font-size: 22px;
    line-height: 24px;
  }
}
.slider_content_five.content_position_center span {
  font-size: 36px;
  line-height: 36px;
  text-transform: uppercase;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_five.content_position_center span {
    font-size: 21px;
    line-height: 22px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_five.content_position_center span {
    font-size: 18px;
    line-height: 18px;
  }
}
.slider_content_five.content_position_center a:hover {
  background: #<?php echo $conf_color;?>;
  color: #fff;
}

/*home six css here*/
.slider_six .single_slider {
  height: 480px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_six .single_slider {
    height: 386px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_six .single_slider {
    height: 360px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_six .single_slider {
    height: 330px;
  }
}

.slider_content_six.content_position_left {
  margin-left: 43%;
  padding-top: 40px;
}
@media only screen and (max-width: 767px) {
  .slider_content_six.content_position_left {
    margin-left: 0;
    padding-top: 50px;
  }
}
.slider_content_six.content_position_center {
  margin-left: 0;
  width: 100%;
  max-width: inherit;
  padding-top: 0;
}
.slider_content_six h1 {
  font-size: 40px;
  line-height: 40px;
  color: #fff;
  font-weight: 600;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_six h1 {
    font-size: 30px;
    line-height: 30px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_six h1 {
    font-size: 30px;
    line-height: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_six h1 {
    font-size: 25px;
    line-height: 25px;
  }
}
.slider_content_six h1 span {
  font-size: 20px;
  line-height: 22px;
  color: #262626;
  font-weight: 400;
  text-transform: uppercase;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_six h1 span {
    font-size: 18px;
    line-height: 20px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_six h1 span {
    font-size: 18px;
    line-height: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_six h1 span {
    font-size: 16px;
    line-height: 16px;
  }
}
.slider_content_six > span {
  font-size: 26px;
  line-height: 28px;
  color: #262626;
  margin-bottom: 12px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_six > span {
    font-size: 20px;
    line-height: 20px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_six > span {
    font-size: 20px;
    line-height: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_six > span {
    font-size: 18px;
    line-height: 20px;
  }
}
.slider_content_six h2 {
  font-size: 61px;
  line-height: 61px;
  color: #fff;
  margin-bottom: 15px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_six h2 {
    font-size: 40px;
    line-height: 40px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_six h2 {
    font-size: 40px;
    line-height: 40px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_six h2 {
    font-size: 35px;
    line-height: 35px;
  }
}
.slider_content_six h2 span {
  font-size: 18px;
  line-height: 18px;
  position: relative;
  top: -27px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_six h2 span {
    font-size: 16px;
    line-height: 18px;
    top: -16px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_six h2 span {
    font-size: 16px;
    line-height: 18px;
    top: -16px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_six h2 span {
    top: -15px;
    font-size: 14px;
    line-height: 18px;
  }
}
.slider_content_six a {
  background: #ffb400;
  color: #262626;
}

/*home seven css here*/
.slider_seven .single_slider {
  height: 532px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_seven .single_slider {
    height: 466px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_seven .single_slider {
    height: 360px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_seven .single_slider {
    height: 330px;
  }
}

.slider_content_seven.style_1 {
  margin-left: 60px;
  padding-top: 80px;
}
@media only screen and (max-width: 767px) {
  .slider_content_seven.style_1 {
    margin-left: 0;
    padding-top: 50px;
    text-align: center;
  }
}
.slider_content_seven.style_1 h1 {
  font-size: 40px;
  line-height: 40px;
  color: #fff;
  font-weight: 600;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_seven.style_1 h1 {
    font-size: 30px;
    line-height: 30px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_seven.style_1 h1 {
    font-size: 30px;
    line-height: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_seven.style_1 h1 {
    font-size: 25px;
    line-height: 25px;
  }
}
.slider_content_seven.style_1 h1 span {
  font-size: 20px;
  line-height: 22px;
  font-weight: 400;
  text-transform: uppercase;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_seven.style_1 h1 span {
    font-size: 18px;
    line-height: 20px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_seven.style_1 h1 span {
    font-size: 18px;
    line-height: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_seven.style_1 h1 span {
    font-size: 16px;
    line-height: 16px;
  }
}
.slider_content_seven.style_1 > span {
  font-size: 24px;
  line-height: 28px;
  color: #fff;
  margin-bottom: 12px;
  text-transform: uppercase;
  font-weight: 600;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_seven.style_1 > span {
    font-size: 20px;
    line-height: 20px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_seven.style_1 > span {
    font-size: 20px;
    line-height: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_seven.style_1 > span {
    font-size: 18px;
    line-height: 20px;
  }
}
.slider_content_seven.style_1 h2 {
  font-size: 61px;
  line-height: 61px;
  color: #FED629;
  margin-bottom: 15px;
  font-weight: 600;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_seven.style_1 h2 {
    font-size: 40px;
    line-height: 40px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_seven.style_1 h2 {
    font-size: 40px;
    line-height: 40px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_seven.style_1 h2 {
    font-size: 35px;
    line-height: 35px;
  }
}
.slider_content_seven.style_1 h2 span {
  font-size: 18px;
  line-height: 18px;
  position: relative;
  top: -27px;
  font-weight: 300;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_seven.style_1 h2 span {
    font-size: 16px;
    line-height: 18px;
    top: -16px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_seven.style_1 h2 span {
    font-size: 16px;
    line-height: 18px;
    top: -16px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_seven.style_1 h2 span {
    top: -15px;
    font-size: 14px;
    line-height: 18px;
  }
}
.slider_content_seven.style_1 a {
  background: #FED629;
  color: #262626;
}
.slider_content_seven.style_2 {
  margin-left: 60px;
}
@media only screen and (max-width: 767px) {
  .slider_content_seven.style_2 {
    margin-left: 0;
    text-align: center;
    width: 100%;
  }
}
.slider_content_seven.style_2 > span {
  font-size: 24px;
  line-height: 28px;
  color: #fff;
  margin-bottom: 16px;
  text-transform: capitalize;
  font-weight: 500;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_seven.style_2 > span {
    font-size: 20px;
    line-height: 20px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_seven.style_2 > span {
    font-size: 20px;
    line-height: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_seven.style_2 > span {
    font-size: 18px;
    line-height: 20px;
  }
}
.slider_content_seven.style_2 h1 {
  font-size: 48px;
  line-height: 48px;
  color: #262626;
  font-weight: 600;
  text-transform: capitalize;
  margin-bottom: 16px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_seven.style_2 h1 {
    font-size: 35px;
    line-height: 35px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_seven.style_2 h1 {
    font-size: 35px;
    line-height: 35px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_seven.style_2 h1 {
    font-size: 25px;
    line-height: 25px;
  }
}
.slider_content_seven.style_2 h2 {
  font-size: 36px;
  line-height: 36px;
  color: #fff;
  font-weight: 600;
  margin-bottom: 23px;
  text-transform: uppercase;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_seven.style_2 h2 {
    font-size: 30px;
    line-height: 30px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_seven.style_2 h2 {
    font-size: 30px;
    line-height: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_seven.style_2 h2 {
    font-size: 25px;
    line-height: 25px;
  }
}
.slider_content_seven.style_2 a {
  background: #20a385;
}
.slider_content_seven.style_2 a:hover {
  background: #fff;
}

/*home eight css here*/
.slider_eight .single_slider {
  height: 507px;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_eight .single_slider {
    height: 360px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_eight .single_slider {
    height: 360px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_eight .single_slider {
    height: 360px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_eight .single_slider {
    height: 340px;
  }
}

@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_eight {
    margin-left: 180px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_eight {
    margin-left: 150px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_eight {
    margin-left: 80px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_eight {
    text-align: center;
  }
}
.slider_content_eight h1 {
  font-size: 48px;
  line-height: 58px;
  color: #262626;
  font-weight: 600;
  text-transform: uppercase;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_eight h1 {
    font-size: 34px;
    line-height: 44px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_eight h1 {
    font-size: 34px;
    line-height: 44px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_eight h1 {
    font-size: 30px;
    line-height: 35px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_eight h1 {
    font-size: 20px;
    line-height: 20px;
  }
}
.slider_content_eight h2 {
  font-size: 48px;
  line-height: 58px;
  color: #262626;
  font-weight: 600;
  text-transform: uppercase;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_eight h2 {
    font-size: 34px;
    line-height: 34px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_eight h2 {
    font-size: 34px;
    line-height: 34px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_eight h2 {
    font-size: 30px;
    line-height: 35px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_eight h2 {
    font-size: 20px;
    line-height: 20px;
  }
}
.slider_content_eight h2 span {
  font-size: 30px;
  line-height: 42px;
  color: #fff;
  text-transform: capitalize;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_eight h2 span {
    font-size: 21px;
    line-height: 23px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_eight h2 span {
    font-size: 18px;
    line-height: 20px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_eight h2 span {
    font-size: 18px;
    line-height: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_eight h2 span {
    font-size: 16px;
    line-height: 16px;
  }
}
.slider_content_eight > span {
  font-size: 30px;
  line-height: 30px;
  font-weight: 300;
  color: #262626;
  text-transform: capitalize;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .slider_content_eight > span {
    font-size: 21px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .slider_content_eight > span {
    font-size: 18px;
    line-height: 20px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .slider_content_eight > span {
    font-size: 18px;
    line-height: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .slider_content_eight > span {
    font-size: 16px;
    line-height: 16px;
  }
}
.slider_content_eight a {
  background: #02a8f3;
}

/*  04. banner section css here  */
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .sidebar_banner_six {
    display: flex;
    margin-top: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .sidebar_banner_six {
    margin-top: 30px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .sidebar_banner_six .single_banner {
    margin-bottom: 0;
    margin-right: 30px;
    width: 50%;
  }
  .sidebar_banner_six .single_banner:last-child {
    margin-right: 0;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .sidebar_banner_six .single_banner a {
    width: 100%;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .sidebar_banner_six .single_banner a img {
    width: 100%;
  }
}

.sidebar_banner_thumb {
  overflow: hidden;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .sidebar_banner_thumb {
    text-align: center;
  }
}
@media only screen and (max-width: 767px) {
  .sidebar_banner_thumb {
    text-align: center;
  }
}
.sidebar_banner_thumb a:hover img {
  -moz-transform: scale(1.1);
  -webkit-transform: scale(1.1);
  -o-transform: scale(1.1);
  -ms-transform: scale(1.1);
  transform: scale(1.1);
}
@media only screen and (max-width: 767px) {
  .sidebar_banner_thumb a {
    width: 100%;
  }
}
.sidebar_banner_thumb a img {
  -webkit-transition: 0.3s;
  transition: 0.3s;
}
@media only screen and (max-width: 767px) {
  .sidebar_banner_thumb a img {
    width: 100%;
  }
}

.banner_thumb {
  overflow: hidden;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .banner_thumb {
    text-align: center;
  }
}
@media only screen and (max-width: 767px) {
  .banner_thumb {
    text-align: center;
  }
}
.banner_thumb a:hover img {
  -moz-transform: scale(1.1);
  -webkit-transform: scale(1.1);
  -o-transform: scale(1.1);
  -ms-transform: scale(1.1);
  transform: scale(1.1);
}
@media only screen and (max-width: 767px) {
  .banner_thumb a {
    width: 100%;
  }
}
.banner_thumb a img {
  -webkit-transition: 0.5s;
  transition: 0.5s;
}
@media only screen and (max-width: 767px) {
  .banner_thumb a img {
    width: 100%;
  }
}

@media only screen and (max-width: 767px) {
  .banner_column2 {
    margin-bottom: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .banner_column2 .single_banner {
    margin-bottom: 30px;
  }
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .sidebar_banner_eight {
    margin-top: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .sidebar_banner_eight {
    margin-top: 30px;
  }
}

/* 03. product section css here */
.tab-content > .tab-pane.active {
  display: block;
  height: auto;
  opacity: 1;
  overflow: visible;
}

.tab-content > .tab-pane {
  display: block;
  height: 0;
  opacity: 0;
  overflow: hidden;
}

/*category product css here*/
.category_product_carousel {
  border: 1px solid #e5e5e5;
}
.category_product_carousel .category_product_thumb {
  text-align: center;
}
.category_product_carousel .category_product_thumb a img {
  width: inherit;
  margin: 0 auto;
}

.owl-item.active.last .single_category_product {
  border-right: 0;
}

.single_category_product {
  border-right: 1px solid #e5e5e5;
}

.category_product_name {
  text-align: center;
  padding: 15px 0;
}
.category_product_name h2 {
  font-size: 14px;
  line-height: 18px;
  text-transform: uppercase;
  margin-bottom: 0;
}
.category_product_name h2 a:hover {
  color: #<?php echo $conf_color;?>;
}

/*deals product area css here*/
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .deals_product_container {
    margin-bottom: 50px;
  }
}
@media only screen and (max-width: 767px) {
  .deals_product_container {
    margin-bottom: 50px;
  }
}

.deals_product_section {
  background: #f3f3f3;
  padding: 50px 0;
}

.deals_product_wrapper {
  margin-left: 113px;
  background: #fff;
  border: 1px solid #e5e5e5;
}
@media only screen and (max-width: 767px) {
  .deals_product_wrapper {
    margin-left: 0;
  }
}

.deals_tab_list {
  background: #fff;
  width: 102px;
  border: 1px solid #e5e5e5;
  text-align: center;
  border-radius: 4px;
  float: left;
}
@media only screen and (max-width: 767px) {
  .deals_tab_list {
    width: inherit;
    float: inherit;
    margin-bottom: 30px;
  }
}
.deals_tab_list ul.nav {
  flex-direction: column;
}
@media only screen and (max-width: 767px) {
  .deals_tab_list ul.nav {
    flex-direction: row;
    justify-content: center;
  }
}
.deals_tab_list ul.nav li:last-child a {
  border-bottom: 0;
}
.deals_tab_list ul.nav li a {
  padding: 14px 0;
  display: block;
  border-bottom: 1px solid #e5e5e5;
  position: relative;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .deals_tab_list ul.nav li a {
    padding: 10px 0;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .deals_tab_list ul.nav li a {
    padding: 10px 0;
  }
}
@media only screen and (max-width: 767px) {
  .deals_tab_list ul.nav li a {
    width: 65px;
    border-bottom: 0;
  }
}
.deals_tab_list ul.nav li a::before {
  position: absolute;
  content: "";
  width: 100%;
  height: 100%;
  border: 1px solid transparent;
  top: 0;
  left: 0;
  -webkit-transition: 0.5s;
  transition: 0.5s;
}
.deals_tab_list ul.nav li a::after {
  content: "";
  border-color: transparent;
  border-right-color: transparent;
  border-style: solid;
  border-width: 5px 5px 5px 0;
  display: block;
  position: absolute;
  top: 50%;
  -webkit-transform: translate(0, -50%);
  -moz-transform: translate(0, -50%);
  -ms-transform: translate(0, -50%);
  -o-transform: translate(0, -50%);
  right: 0;
  -webkit-transition: 0.5s;
  transition: 0.5s;
}
.deals_tab_list ul.nav li a:hover {
  color: #<?php echo $conf_color;?>;
}
.deals_tab_list ul.nav li a:hover::before {
  border-color: #<?php echo $conf_color;?>;
}
.deals_tab_list ul.nav li a:hover::after {
  border-right-color: #<?php echo $conf_color;?>;
}
.deals_tab_list ul.nav li a.active {
  color: #<?php echo $conf_color;?>;
}
.deals_tab_list ul.nav li a.active::before {
  border-color: #<?php echo $conf_color;?>;
}
.deals_tab_list ul.nav li a.active::after {
  border-right-color: #<?php echo $conf_color;?>;
}
.deals_tab_list ul.nav li a i {
  font-size: 24px;
  margin-bottom: 10px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .deals_tab_list ul.nav li a i {
    font-size: 22px;
    margin-bottom: 8px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .deals_tab_list ul.nav li a i {
    margin-bottom: 7px;
  }
}
.deals_tab_list ul.nav li a h3 {
  font-size: 13px;
  line-height: 17px;
  text-transform: capitalize;
  margin-bottom: 0;
}

.section_title {
  margin-bottom: 30px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .section_title {
    margin-bottom: 25px;
  }
}
@media only screen and (max-width: 767px) {
  .section_title {
    margin-bottom: 22px;
  }
}
.section_title h2 {
  font-size: 18px;
  line-height: 17px;
  text-transform: uppercase;
  font-weight: 700;
  padding: 12px 0;
  margin-bottom: 0;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .section_title h2 {
    font-size: 16px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .section_title h2 {
    font-size: 16px;
  }
}
@media only screen and (max-width: 767px) {
  .section_title h2 {
    font-size: 15px;
    line-height: 15px;
  }
}
.section_title h2 span {
  padding: 8px 15px 8px 3px;
  color: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  border-width: 1px 1px 1px 0;
  border-style: solid;
  position: relative;
}
.section_title h2 span::before {
  content: "";
  border-left: 1px solid #<?php echo $conf_color;?>;
  height: 5px;
  width: 1px;
  display: block;
  position: absolute;
  top: 0;
  left: 0;
}
.section_title h2 span::after {
  content: "";
  border-left: 1px solid #<?php echo $conf_color;?>;
  height: 5px;
  width: 1px;
  display: block;
  position: absolute;
  bottom: 0;
  left: 0;
}

.product_thumb {
  position: relative;
  -webkit-transition: 0.5s;
  transition: 0.5s;
}
@media only screen and (max-width: 767px) {
  .product_thumb {
    text-align: center;
  }
}

.single_deals_product {
  display: flex;
  border-bottom: 1px solid #e5e5e5;
  align-items: center;
  padding: 23px 0;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .single_deals_product {
    padding: 32px 0;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .single_deals_product {
    padding: 30px 0;
  }
}
@media only screen and (max-width: 767px) {
  .single_deals_product {
    flex-direction: column;
  }
}
.single_deals_product:hover .quick_button {
  opacity: 1;
  visibility: visible;
}
.single_deals_product:last-child {
  border-bottom: 0;
}
.single_deals_product .product_thumb {
  width: 46%;
  padding: 0 12px;
}
@media only screen and (max-width: 767px) {
  .single_deals_product .product_thumb {
    width: 100%;
    margin-bottom: 19px;
  }
}
.single_deals_product .product_content {
  width: 54%;
  padding-left: 20px;
}
@media only screen and (max-width: 767px) {
  .single_deals_product .product_content {
    width: 100%;
    padding-left: 0;
    text-align: center;
  }
}

.product_name h3 {
  font-size: 17px;
  line-height: 24px;
  text-transform: capitalize;
  margin-bottom: 10px;
}
.product_name h3 a:hover {
  color: #<?php echo $conf_color;?>;
}

.product_rating {
  margin-bottom: 10px;
}
.product_rating ul li {
  display: inline-block;
}
.product_rating ul li a {
  font-size: 16px;
  color: #f9bb00;
}

.price_box {
  margin-bottom: 17px;
}
.price_box span.current_price {
  font-size: 24px;
  line-height: 25px;
  color: #<?php echo $conf_color;?>;
}
.price_box span.old_price {
  font-size: 13px;
  line-height: 25px;
  text-decoration: line-through;
  margin-left: 6px;
}

.action_links ul li {
  display: inline-block;
  margin-right: 4px;
}
.action_links ul li:last-child {
  margin-right: 0;
}
.action_links ul li.wishlist a, .action_links ul li.compare a {
  width: 41px;
  height: 41px;
  border-radius: 50%;
  text-align: center;
}
.action_links ul li a {
  text-transform: capitalize;
  border: 1px solid #e5e5e5;
  line-height: 39px;
  display: block;
  font-size: 14px;
  background: #fff;
}

.action_links ul li a.active {
  text-transform: capitalize;
  border: 1px solid #<?php echo $conf_color;?>;
  line-height: 39px;
  display: block;
  font-size: 14px;
  background: #fff;
} 


.action_links ul li a:hover {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  color: #ffffff;
 
}

.single_product .action_links ul li.wishlist a.active  {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  color: #ffffff;
}

.product_details .action_links ul li.wishlist a.active  {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  color: #ffffff;
}

.cart_item  a i.fa_heart_o  {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  color: #ffffff;
}

.product_details .action_links ul li.add_to_cart a  {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  color: #ffffff;
}

.action_links ul li.add_to_cart a {
  padding: 0 20px;

  word-spacing: 1px;
}
.action_links ul li.add_to_cart a i {
  margin-right: 5px;
}



.action_links ul li.add_to_cart_bus a {
  width: 41px;
  height: 41px;
  border-radius: 50%;
  text-align: center;
}

.action_links ul li.add_to_cart_bus a i {
  margin-right: 0px;
}




.action_links ul button {
  display: inline-block;
  margin-right: 4px;
}
.action_links ul button:last-child {
  margin-right: 0;
}

.action_links ul button a {
  text-transform: capitalize;
  border: 1px solid #e5e5e5;
  line-height: 39px;
  display: block;
  font-size: 14px;
  background: #fff;
}

.action_links ul button.active {
  text-transform: capitalize;
  border: 1px solid #<?php echo $conf_color;?>;
  line-height: 39px;
  display: block;
  font-size: 44px;
  background: #fff;
} 


.action_links ul button:hover {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  color: #ffffff;
 
}


.product_details .action_links ul button.add_to_cart   {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  color: #ffffff;
}

.action_links ul button.add_to_cart  {
  padding: 0 20px;
  word-spacing: 1px;
}
.action_links ul button.add_to_cart i {
  margin-right: 5px;
}

.action_links ul button.add_to_cart  {
  width: 181px;
  height: 41px;

  text-align: center;
}

.action_links ul button.add_to_cart_bus i {
  margin-right: 0px;
}




@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .action_links ul button.add_to_cart a {
    padding: 0 15px;
  }
}

.product_timing {
  background: rgba(220, 220, 220, 0.9);
  border-radius: 4px;
  padding: 10px;
  text-align: center;
  position: absolute;
  bottom: 0;
  left: 30px;
  right: 30px;
}

.countdown_area {
  display: flex;
  justify-content: space-around;
}

.countdown_title {
  text-transform: uppercase;
  font-size: 12px;
}

.quick_button {
  position: absolute;
  top: 50%;
  transform: translatey(-50%);
  left: 0;
  right: 0;
  opacity: 0;
  visibility: hidden;
  -webkit-transition: 0.5s;
  transition: 0.5s;
}
.quick_button a {
  width: 41px;
  height: 41px;
  border: 1px solid #e5e5e5;
  line-height: 39px;
  border-radius: 50%;
  text-align: center;
  display: block;
  background: #ffffff;
  margin: 0 auto;
  font-size: 16px;
}
.quick_button a:hover {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  color: #ffffff;
}

/*small product css here*/
.small_product_wrapper {
  background: #ffffff;
  border-left: 1px solid #e5e5e5;
  border-right: 1px solid #e5e5e5;
  border-bottom: 1px solid #e5e5e5;
}
.small_product_wrapper button {
  position: absolute;
  top: -63px;
  right: 40px;
  width: 32px;
  height: 32px;
  border: 1px solid #e5e5e5;
  background: #fff;
  border-radius: 100%;
  -webkit-transition: 0.5s;
  transition: 0.5s;
}
.small_product_wrapper button:hover {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  color: #ffffff;
}
.small_product_wrapper button.next_arrow {
  right: 0;
}

.small_product_items {
  display: flex !important;
  padding: 17px 0;
  border-top: 1px solid #e5e5e5;
}
.small_product_items .product_thumb {
  width: 40%;
}
.small_product_items .product_content {
  width: 55%;
  margin-left: 20px;
}
.small_product_items .product_name h3 {
  font-size: 13px;
  line-height: 15px;
  margin-bottom: 8px;
}
.small_product_items .price_box {
  margin-bottom: 0;
}
.small_product_items .price_box span.current_price {
  font-size: 15px;
  line-height: 18px;
}
.small_product_items .product_rating {
  margin-bottom: 5px;
}

/*new product area css here*/
.product_carousel:hover .owl-nav > * {
  opacity: 1;
  visibility: visible;
}
.product_carousel .owl-nav > * {
  position: absolute;
  top: 50%;
  transform: translatey(-50%);
  left: 10px;
  width: 32px;
  height: 32px;
  line-height: 30px;
  border: 1px solid #e5e5e5 !important;
  background: #fff;
  text-align: center;
  border-radius: 100%;
  -webkit-transition: 0.5s;
  transition: 0.5s;
  opacity: 0;
  visibility: hidden;
}
.product_carousel .owl-nav > *:hover {
  background: #<?php echo $conf_color;?> !important;
  border-color: #<?php echo $conf_color;?> !important;
  color: #fff !important;
}
.product_carousel .owl-nav > *.owl-next {
  right: 10px;
  left: auto;
}
@media only screen and (max-width: 767px) {
  .product_carousel .action_links ul li.wishlist a, .product_carousel .action_links ul li.compare a {
    width: 35px;
    height: 35px;
    line-height: 33px;
  }
}
@media only screen and (max-width: 767px) {
  .product_carousel .action_links ul li.add_to_cart a {
    padding: 0 10px;
    word-spacing: 0px;
    line-height: 33px;
  }
}
.product_carousel .product_thumb a img {
  width: inherit;
}
@media only screen and (max-width: 767px) {
  .product_carousel .product_thumb a img {
    margin: 0 auto;
  }
}

.new_product_wrapper {
  border: 1px solid #e5e5e5;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .new_product_wrapper {
    border: 0;
  }
}
.new_product_wrapper .single_product {
  padding: 0 10px 20px;
}
@media only screen and (max-width: 767px) {
  .new_product_wrapper .single_product.product_center {
    border-top: 1px solid #e5e5e5;
    border-bottom: 1px solid #e5e5e5;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .new_product_wrapper .action_links ul li.wishlist a, .new_product_wrapper .action_links ul li.compare a {
    width: 36px;
    height: 36px;
    line-height: 34px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .new_product_wrapper .action_links ul li.add_to_cart a {
    padding: 0 12px;
    word-spacing: 0;
    font-size: 12px;
    line-height: 34px;
  }
}

.single_product:hover .quick_button {
  opacity: 1;
  visibility: visible;
}
.single_product:hover .action_links ul li.wishlist, .single_product:hover .action_links ul li.compare {
  transform: translate(0, 0);
  opacity: 1;
  visibility: visible;
}
.single_product:hover .product_thumb {
  opacity: 0.7;
}
.single_product .product_content {
  text-align: center;
  margin-top: 10px;
}
.single_product .product_name h3 {
  font-size: 14px;
  line-height: 17px;
}
.single_product .price_box span.current_price {
  font-size: 15px;
}

/*
.single_product .action_links ul li.wishlist, .single_product .action_links ul li.compare {
  transform: translate(100%, 0);
  transition: all .4s ease-out;
  opacity: 0;
  visibility: visible;
}*/


.single_product .action_links ul li.compare {
  transform: translate(-100%, 0);
  transition: all .4s ease-out;
}
.single_product .action_links ul li.add_to_cart {
  z-index: 2;
  position: relative;
}

.single_product_left_sidebar {
  border-right: 1px solid #e5e5e5;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .single_product_left_sidebar {
    display: flex;
    border-right: 0;
    border: 1px solid #e5e5e5;
    margin-bottom: 50px;
  }
}
.single_product_left_sidebar .single_product {
  border-bottom: 1px solid #e5e5e5;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .single_product_left_sidebar .single_product {
    border-bottom: 0;
    width: 500%;
    border-right: 1px solid #e5e5e5;
  }
  .single_product_left_sidebar .single_product:last-child {
    border-right: 0;
  }
}
.single_product_left_sidebar .single_product:last-child {
  border-bottom: 0;
}

.single_product_right_sidebar {
  border-left: 1px solid #e5e5e5;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .single_product_right_sidebar {
    display: flex;
    border-left: 0;
    border: 1px solid #e5e5e5;
  }
}
.single_product_right_sidebar .single_product {
  border-bottom: 1px solid #e5e5e5;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .single_product_right_sidebar .single_product {
    border-bottom: 0;
    width: 500%;
    border-right: 1px solid #e5e5e5;
  }
  .single_product_right_sidebar .single_product:last-child {
    border-right: 0;
  }
}
.single_product_right_sidebar .single_product:last-child {
  border-bottom: 0;
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .product_center {
    border: 1px solid #e5e5e5;
    margin-bottom: 50px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .product_center .product_thumb {
    text-align: center;
  }
}
.product_center .product_content {
  margin-top: 40px;
}
.product_center .product_name h3 {
  font-size: 17px;
  line-height: 24px;
}
.product_center .price_box span.current_price {
  font-size: 24px;
}

.product_header {
  display: flex;
  justify-content: space-between;
}
@media only screen and (max-width: 767px) {
  .product_header {
    flex-direction: column;
  }
}

@media only screen and (max-width: 767px) {
  .product_tab_button {
    margin-bottom: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .product_tab_button ul.nav {
    justify-content: center;
  }
}
.product_tab_button ul li {
  margin-right: 8px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .product_tab_button ul li {
    margin-right: 5px;
  }
}
@media only screen and (max-width: 767px) {
  .product_tab_button ul li {
    margin-right: 5px;
  }
}
.product_tab_button ul li:last-child {
  margin-right: 0;
}
.product_tab_button ul li a {
  text-transform: capitalize;
  border: 1px solid transparent;
  border-radius: 20px;
  line-height: 30px;
  padding: 0 15px;
  display: block;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .product_tab_button ul li a {
    padding: 0 5px;
    line-height: 23px;
  }
}
@media only screen and (max-width: 767px) {
  .product_tab_button ul li a {
    line-height: 26px;
    padding: 0 7px;
  }
}
.product_tab_button ul li a:hover {
  border-color: #<?php echo $conf_color;?>;
  color: #<?php echo $conf_color;?>;
}
.product_tab_button ul li a.active {
  border-color: #<?php echo $conf_color;?>;
  color: #<?php echo $conf_color;?>;
}

.owl-item.last .single_product {
  border-right: 0;
}

.product_carousel {
  border: 1px solid #e5e5e5;
}
.product_carousel .single_product {
  border-right: 1px solid #e5e5e5;
}
.product_carousel .single_product {
  padding: 20px 0;
}

.label_product {
  position: absolute;
  top: 20px;
  right: 20px;
}
.label_product span {
  line-height: 20px;
  padding: 0 10px;
  text-transform: uppercase;
  background: #<?php echo $conf_color;?>;
  color: #ffffff;
  display: block;
  font-size: 10px;
}

/*custom paroduct css here*/
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .custom_product_area {
    margin-bottom: 0;
  }
}
@media only screen and (max-width: 767px) {
  .custom_product_area {
    margin-bottom: 0;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .custom_product_area .small_product_area {
    margin-bottom: 50px;
  }
}
@media only screen and (max-width: 767px) {
  .custom_product_area .small_product_area {
    margin-bottom: 50px;
  }
}
.custom_product_area .small_product_items {
  padding: 17px 15px;
}
.custom_product_area .product_thumb {
  width: 35%;
}
.custom_product_area .product_content {
  width: 58%;
}

/*home two css here*/
.deals_product_carousel .single_deals_product {
  flex-direction: column;
  border-right: 1px solid #e5e5e5;
  padding: 29px 0;
}
.deals_product_carousel .product_thumb {
  width: 100%;
  padding-top: 40px;
}
.deals_product_carousel .product_thumb a img {
  width: inherit;
  margin: 0 auto;
}
.deals_product_carousel .product_content {
  width: 100%;
  padding-left: 0;
  padding: 0 25px;
  position: relative;
}
.deals_product_carousel .product_timing {
  top: 0;
  bottom: auto;
}
.deals_product_carousel .action_links {
  position: absolute;
  right: 25px;
  bottom: 0;
}
@media only screen and (max-width: 767px) {
  .deals_product_carousel .action_links {
    position: inherit;
    right: 0;
  }
}
.deals_product_carousel .price_box {
  margin-bottom: 0;
}
@media only screen and (max-width: 767px) {
  .deals_product_carousel .price_box {
    margin-bottom: 17px;
  }
}
.deals_product_carousel .owl-nav > * {
  position: absolute;
  top: -63px;
  right: 40px;
  width: 32px;
  height: 32px;
  line-height: 30px;
  text-align: center;
  border: 1px solid #e5e5e5 !important;
  background: #fff;
  border-radius: 100%;
  -webkit-transition: 0.5s;
  transition: 0.5s;
}
.deals_product_carousel .owl-nav > *:hover {
  background: #<?php echo $conf_color;?> !important;
  border-color: #<?php echo $conf_color;?> !important;
  color: #ffffff !important;
}
@media only screen and (max-width: 767px) {
  .deals_product_carousel .owl-nav > * {
    display: none;
  }
}
.deals_product_carousel .owl-nav > *.owl-next {
  right: 0;
}
.deals_product_carousel .product_timing {
  max-width: 350px;
  margin: 0 auto;
}
@media only screen and (max-width: 767px) {
  .deals_product_carousel .product_timing {
    max-width: 260px;
  }
}
@media only screen and (max-width: 479px) {
  .deals_product_carousel .label_product {
    display: none;
  }
}

.deals_tab_two ul.nav li a {
  padding: 11px 0;
}
.deals_tab_two ul.nav li a i {
  font-size: 20px;
  margin-bottom: 6px;
}

.alarm_icone {
  width: 50px;
  float: left;
  border-right: 1px solid #ffffff;
  padding-right: 15px;
  margin-right: 15px;
}
.alarm_icone i {
  font-size: 38px;
  line-height: 48px;
  color: #;
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .product_column3 {
    margin-bottom: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .product_column3 {
    margin-bottom: 30px;
  }
}
.product_column3 .owl-nav > * {
  top: -50px;
  right: 40px;
  opacity: inherit;
  visibility: inherit;
  left: auto;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_column3 .owl-nav > * {
    top: -55px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .product_column3 .owl-nav > * {
    top: -49px;
  }
}
@media only screen and (max-width: 767px) {
  .product_column3 .owl-nav > * {
    top: -49px;
  }
}
.product_column3 .owl-nav > *.owl-next {
  right: 0;
}
.product_column3 .single_product {
  padding: 23px 0;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_column3 .single_product {
    padding: 5px 0 15px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_column3 .product_thumb a img {
    max-width: 196px;
    margin: 0 auto;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_column3 .action_links ul li.add_to_cart a {
    padding: 0 17px;
  }
}

.new_product_two_container .banner_thumb {
  text-align: center;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .new_product_two_container .row {
    flex-direction: column-reverse;
  }
}
@media only screen and (max-width: 767px) {
  .new_product_two_container .row {
    flex-direction: column-reverse;
  }
}

/*home three css here*/
.section_title_two h2 {
  padding: 0 0 14px;
  position: relative;
}
.section_title_two h2::before {
  position: absolute;
  content: "";
  width: 80px;
  height: 2px;
  background: #ffb400;
  bottom: 0;
  left: 0;
}

.new_product_three_container .owl-nav > * {
  top: -46px;
}
.new_product_three_container .single_product {
  padding: 25px 0;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .new_product_three_container .banner_thumb {
    text-align: center;
  }
}
@media only screen and (max-width: 767px) {
  .new_product_three_container .banner_thumb {
    text-align: center;
  }
}
.new_product_three_container .label_product span {
  background: #ffb400;
}
.new_product_three_container .owl-nav > *:hover {
  border-color: #ffb400 !important;
  background: #ffb400 !important;
}
.new_product_three_container .quick_button a:hover {
  background: #ffb400;
  border-color: #ffb400;
}
.new_product_three_container .product_name h3 a:hover {
  color: #ffb400;
}
.new_product_three_container .action_links ul li a:hover {
  background: #ffb400;
  border-color: #ffb400;
}

.deals_section_three {
  padding: 0;
  background: none;
}
.deals_section_three .deals_tab_list ul.nav li a.active {
  color: #ffb400;
}
.deals_section_three .deals_tab_list ul.nav li a.active::before {
  border-color: #ffb400;
}
.deals_section_three .deals_tab_list ul.nav li a.active::after {
  border-right-color: #ffb400;
}
.deals_section_three .deals_tab_list ul.nav li a:hover {
  color: #ffb400;
}
.deals_section_three .deals_tab_list ul.nav li a:hover::after {
  border-right-color: #ffb400;
}
.deals_section_three .deals_tab_list ul.nav li a:hover::before {
  border-color: #ffb400;
}
.deals_section_three .alarm_icone i {
  color: #ffb400;
}
.deals_section_three .label_product span {
  background: #ffb400;
}
.deals_section_three .quick_button a:hover {
  background: #ffb400;
  border-color: #ffb400;
}
.deals_section_three .product_name h3 a:hover {
  color: #ffb400;
}
.deals_section_three .action_links ul li a:hover {
  background: #ffb400;
  border-color: #ffb400;
}
.deals_section_three .owl-nav > *:hover {
  background: #ffb400 !important;
  border-color: #ffb400 !important;
}

.home_product_three .product_tab_button ul li a.active {
  border-color: #ffb400;
  color: #ffb400;
}
.home_product_three .product_tab_button ul li a:hover {
  border-color: #ffb400;
  color: #ffb400;
}
.home_product_three .label_product span {
  background: #ffb400;
}
.home_product_three .quick_button a:hover {
  background: #ffb400;
  border-color: #ffb400;
}
.home_product_three .owl-nav > *:hover {
  background: #ffb400 !important;
  border-color: #ffb400 !important;
}
.home_product_three .product_name h3 a:hover {
  color: #ffb400;
}
.home_product_three .action_links ul li a:hover {
  background: #ffb400;
  border-color: #ffb400;
}

.custom_product_three .small_product_wrapper button:hover {
  background: #ffb400;
  border-color: #ffb400;
}
.custom_product_three .product_name h3 a:hover {
  color: #ffb400;
}

.section_style_three h2 {
  padding: 0;
}
.section_style_three h2 span {
  border: 0;
}
.section_style_three h2 span::before {
  display: none;
}
.section_style_three h2 span::after {
  display: none;
}

.new_product_four:hover .owl-nav > * {
  opacity: 1;
  visibility: visible;
}
.new_product_four .owl-nav > * {
  top: 50%;
  left: 10px;
  opacity: 0;
  visibility: hidden;
}
.new_product_four .owl-nav > *.owl-next {
  right: 10px;
  left: auto;
}
.new_product_four .single_product {
  padding: 20px 0;
}

.small_product_four button {
  top: -52px;
}
@media only screen and (max-width: 767px) {
  .small_product_four button {
    top: -42px;
  }
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .deals_container_four {
    margin-top: 48px;
    margin-bottom: 0;
  }
}
@media only screen and (max-width: 767px) {
  .deals_container_four {
    margin-top: 48px;
    margin-bottom: 0;
  }
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .new_product_reverse {
    flex-direction: column-reverse;
  }
}
@media only screen and (max-width: 767px) {
  .new_product_reverse {
    flex-direction: column-reverse;
  }
}

.home_section_right_sidebar .product_column3 .owl-nav * > {
  top: -39px;
}
@media only screen and (max-width: 767px) {
  .home_section_right_sidebar .product_column3 .owl-nav * > {
    top: -30px;
  }
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .deals_sidebar_product {
    margin-top: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .deals_sidebar_product {
    margin-top: 20px;
  }
}

.product_timing_six {
  background: #ffb400;
  padding: 10px 0;
}
.product_timing_six .single_countdown {
  color: #fff;
}

.deals_product_column1:hover .quick_button {
  opacity: 1;
  visibility: visible;
}
.deals_product_column1 .owl-nav > * {
  top: -58px;
  right: 40px;
  position: absolute;
  width: 32px;
  height: 32px;
  line-height: 30px;
  text-align: center;
  border: 1px solid #e5e5e5 !important;
  background: #fff;
  text-align: center;
  border-radius: 100%;
  -webkit-transition: 0.5s;
  transition: 0.5s;
}
.deals_product_column1 .owl-nav > *:hover {
  color: #fff !important;
  background: #ffb400 !important;
  border-color: #ffb400 !important;
}
.deals_product_column1 .owl-nav > *.owl-next {
  right: 0;
}
.deals_product_column1 .deals_product_list {
  border: 1px solid #e5e5e5;
}
.deals_product_column1 .product_content {
  text-align: center;
}
.deals_product_column1 .product_thumb {
  padding: 25px 0 33px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .deals_product_column1 .product_thumb {
    padding: 18px 0 22px;
  }
}

.category_product_six .category_product_name h2 a:hover {
  color: #ffb400;
}

.product_color_six .quick_button a:hover {
  background: #ffb400;
  border-color: #ffb400;
}
.product_color_six .label_product span {
  background: #ffb400;
}
.product_color_six .product_name h3 a:hover {
  color: #ffb400;
}
.product_color_six .owl-nav > * {
  top: -48px;
}
@media only screen and (max-width: 767px) {
  .product_color_six .owl-nav > * {
    top: -42px;
  }
}
.product_color_six .owl-nav > *:hover {
  background: #ffb400 !important;
  border-color: #ffb400 !important;
  color: #ffffff !important;
}
.product_color_six .action_links ul li a:hover {
  background: #ffb400;
  border-color: #ffb400;
}

.small_product_six button:hover {
  background: #ffb400;
  border-color: #ffb400;
  color: #ffffff;
}
.small_product_six .product_name h3 a:hover {
  color: #ffb400;
}

/*home seven css here*/
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .deals_s_p_seven {
    margin-top: 50px;
    margin-bottom: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .deals_s_p_seven {
    margin-top: 50px;
    margin-bottom: 20px;
  }
}
.deals_s_p_seven .section_title_two h2::before {
  width: 40px;
  background: #20a385;
}
.deals_s_p_seven .owl-nav > *:hover {
  background: #20a385 !important;
  border-color: #20a385 !important;
}
.deals_s_p_seven .label_product span {
  background: #20a385;
}
.deals_s_p_seven .product_name h3 a:hover {
  color: #20a385;
}
.deals_s_p_seven .quick_button a:hover {
  background: #20a385;
  border-color: #20a385;
}

.product_timing_seven {
  background: #20a385;
  padding: 10px 0;
}
.product_timing_seven .single_countdown {
  color: #ffffff;
}

.tab_button_seven {
  margin-bottom: 20px;
}
.tab_button_seven ul li {
  margin-right: 40px;
}
.tab_button_seven ul li:last-child {
  margin-right: 0;
}
@media only screen and (max-width: 767px) {
  .tab_button_seven ul li {
    margin-right: 20px;
  }
}
.tab_button_seven ul li a {
  padding: 0 0 14px;
  border: 0;
  border-radius: 0;
  font-size: 17px;
  line-height: 17px;
  text-transform: uppercase;
  font-weight: 700;
  position: relative;
}
@media only screen and (max-width: 767px) {
  .tab_button_seven ul li a {
    margin-bottom: 10px;
    padding: 0 0 10px;
    font-size: 15px;
  }
}
.tab_button_seven ul li a:hover {
  color: inherit;
}
.tab_button_seven ul li a:hover::before {
  width: 40px;
}
.tab_button_seven ul li a.active {
  color: inherit;
}
.tab_button_seven ul li a.active::before {
  width: 40px;
}
.tab_button_seven ul li a::before {
  position: absolute;
  content: "";
  bottom: 0;
  left: 0;
  height: 2px;
  width: 0;
  background: #20a385;
  -webkit-transition: 0.5s;
  transition: 0.5s;
}

.product_style7 {
  border: 0;
}
.product_style7 .single_product {
  border: 1px solid #e5e5e5;
}
.product_style7 .owl-item.last .single_product {
  border-right: 1px solid #e5e5e5;
}
.product_style7.product_column4 .owl-nav > * {
  top: -42px;
  right: 51px;
  left: auto;
  opacity: inherit;
  visibility: inherit;
}
@media only screen and (max-width: 767px) {
  .product_style7.product_column4 .owl-nav > * {
    display: none;
  }
}
.product_style7.product_column4 .owl-nav > *:hover {
  background: #20a385 !important;
  border-color: #20a385 !important;
}
.product_style7.product_column4 .owl-nav > *.owl-next {
  right: 10px;
}
.product_style7:hover.product_column3 .owl-nav > * {
  opacity: 1;
  visibility: visible;
}
.product_style7.product_column3 .owl-nav > * {
  top: 50%;
  left: 25px;
  opacity: 0;
  visibility: hidden;
}
.product_style7.product_column3 .owl-nav > *:hover {
  background: #20a385 !important;
  border-color: #20a385 !important;
}
.product_style7.product_column3 .owl-nav > *.owl-next {
  right: 25px;
  left: auto;
}
.product_style7 .product_thumb a img {
  max-width: 248px;
  margin: 0 auto;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_style7 .product_thumb a img {
    max-width: 100%;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .product_style7 .product_thumb a img {
    max-width: 100%;
  }
}
@media only screen and (max-width: 767px) {
  .product_style7 .product_thumb a img {
    max-width: 100%;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_style7 .action_links ul li.wishlist a, .product_style7 .action_links ul li.compare a {
    width: 35px;
    height: 35px;
    line-height: 33px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .product_style7 .action_links ul li.wishlist a, .product_style7 .action_links ul li.compare a {
    width: 35px;
    height: 35px;
    line-height: 33px;
  }
}
@media only screen and (max-width: 767px) {
  .product_style7 .action_links ul li.wishlist a, .product_style7 .action_links ul li.compare a {
    width: 32px;
    height: 32px;
    line-height: 31px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_style7 .action_links ul li.add_to_cart a {
    padding: 0 14px;
    line-height: 33px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .product_style7 .action_links ul li.add_to_cart a {
    padding: 0 14px;
    line-height: 33px;
  }
}
@media only screen and (max-width: 767px) {
  .product_style7 .action_links ul li.add_to_cart a {
    padding: 0 10px;
    line-height: 31px;
  }
}

.product_carousel .col-lg-3 {
  flex: 0 0 100%;
  width: 100%;
}

.product_color_seven .label_product span {
  background: #20a385;
}
.product_color_seven .quick_button a:hover {
  background: #20a385;
  border-color: #20a385;
}
.product_color_seven .product_name h3 a:hover {
  color: #20a385;
}
.product_color_seven .action_links ul li a:hover {
  background: #20a385;
  border-color: #20a385;
}

.product_tab_button.button_color ul li a.active {
  border-color: #20a385;
  color: #20a385;
}
.product_tab_button.button_color ul li a:hover {
  border-color: #20a385;
  color: #20a385;
}

.section_title_seven h2 {
  font-size: 17px;
  line-height: 17px;
  text-transform: uppercase;
  padding: 0;
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .row.home_product_reverse {
    flex-direction: column-reverse;
  }
}
@media only screen and (max-width: 767px) {
  .row.home_product_reverse {
    flex-direction: column-reverse;
  }
}

/*home eight css here*/
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .deals_product_eight {
    margin-top: 0;
    margin-bottom: 50px;
  }
}
@media only screen and (max-width: 767px) {
  .deals_product_eight {
    margin-top: 0;
    margin-bottom: 50px;
  }
}
.deals_product_eight .section_title_two h2::before {
  background: #02a8f3;
}
.deals_product_eight .owl-nav > *:hover {
  background: #02a8f3 !important;
  border-color: #02a8f3 !important;
}
.deals_product_eight .label_product span {
  background: #02a8f3;
}
.deals_product_eight .product_name h3 a:hover {
  color: #02a8f3;
}
.deals_product_eight .quick_button a:hover {
  background: #02a8f3;
  border-color: #02a8f3;
}

.product_timing_eight {
  background: #02a8f3;
  padding: 10px 0;
}
.product_timing_eight .single_countdown {
  color: #ffffff;
}

.product_version_eight .section_title_two h2::before {
  background: #02a8f3;
}
.product_version_eight .owl-nav > * {
  top: -42px;
}
.product_version_eight .owl-nav > *:hover {
  background: #02a8f3 !important;
  border-color: #02a8f3 !important;
}
.product_version_eight .single_product {
  padding: 8px 0 18px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_version_eight .single_product {
    padding: 10px 0 21px;
  }
}
.product_version_eight .price_box {
  margin-bottom: 0px;
}
.product_version_eight .label_product span {
  background: #02a8f3;
}
.product_version_eight .quick_button a:hover {
  background: #02a8f3;
  border-color: #02a8f3;
}
.product_version_eight .product_name h3 a:hover {
  color: #02a8f3;
}

.tab_row_list {
  background: #fff;
  border: 1px solid #e5e5e5;
  text-align: center;
  border-radius: 4px;
  margin-bottom: 20px;
}
.tab_row_list ul.nav {
  justify-content: center;
}
.tab_row_list ul.nav li:last-child a {
  border-right: 0;
}
.tab_row_list ul.nav li a {
  padding: 14px 0;
  display: block;
  border-right: 1px solid #e5e5e5;
  position: relative;
  width: 116px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .tab_row_list ul.nav li a {
    width: 92px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .tab_row_list ul.nav li a {
    padding: 10px 0;
    width: 71px;
  }
}
@media only screen and (max-width: 767px) {
  .tab_row_list ul.nav li a {
    width: 70px;
    border: 0;
  }
}
.tab_row_list ul.nav li a:hover {
  color: #02a8f3;
  background: #efefef;
}
.tab_row_list ul.nav li a.active {
  color: #02a8f3;
  background: #efefef;
}
.tab_row_list ul.nav li a i {
  font-size: 24px;
  margin-bottom: 10px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .tab_row_list ul.nav li a i {
    font-size: 22px;
    margin-bottom: 8px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .tab_row_list ul.nav li a i {
    margin-bottom: 7px;
  }
}
.tab_row_list ul.nav li a h3 {
  font-size: 13px;
  line-height: 17px;
  text-transform: capitalize;
  margin-bottom: 0;
}

.home_product_eight .section_title_two h2::before {
  background: #02a8f3;
}
.home_product_eight .label_product span {
  background: #02a8f3;
}
.home_product_eight .quick_button a:hover {
  background: #02a8f3;
  border-color: #02a8f3;
}
.home_product_eight .owl-nav > *:hover {
  background: #02a8f3 !important;
  border-color: #02a8f3 !important;
}
.home_product_eight .product_name h3 a:hover {
  color: #02a8f3;
}
.home_product_eight .action_links ul li a:hover {
  background: #02a8f3;
  border-color: #02a8f3;
}
.home_product_eight .small_product_wrapper button:hover {
  background: #02a8f3;
  border-color: #02a8f3;
}

/* 05. blog area css here */
.sidebar_blog_carousel {
  border: 1px solid #e5e5e5;
  border-radius: 4px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .sidebar_blog_carousel {
    border: 0;
  }
}
.sidebar_blog_carousel .owl-nav > * {
  position: absolute;
  top: -53px;
  right: 40px;
  width: 32px;
  height: 32px;
  border: 1px solid #e5e5e5 !important;
  background: #fff;
  border-radius: 100%;
  -webkit-transition: 0.5s;
  transition: 0.5s;
  text-align: center;
  line-height: 30px;
}
@media only screen and (max-width: 767px) {
  .sidebar_blog_carousel .owl-nav > * {
    top: -48px;
  }
}
.sidebar_blog_carousel .owl-nav > *:hover {
  background: #<?php echo $conf_color;?> !important;
  border-color: #<?php echo $conf_color;?> !important;
  color: #ffffff !important;
}
.sidebar_blog_carousel .owl-nav > *.owl-next {
  right: 0;
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .sidebar_blog_list {
    border: 1px solid #e5e5e5;
  }
}

.sidebar_blog_content {
  padding: 22px 20px;
  overflow: hidden;
}
.sidebar_blog_content .post_meta p {
  font-size: 13px;
  line-height: 20px;
}
.sidebar_blog_content .post_title h3 {
  font-size: 14px;
  text-transform: capitalize;
  font-weight: 700;
  line-height: 25px;
  margin-bottom: 8px;
}
.sidebar_blog_content .post_title h3 a:hover {
  color: #<?php echo $conf_color;?>;
}
.sidebar_blog_content .post_comment {
  float: right;
}

.sidebar_blog_thumb a img {
  border-radius: 4px;
}

.sidebar_blog_six .owl-nav > * {
  top: -64px;
}
.sidebar_blog_six .owl-nav > *:hover {
  background: #ffb400 !important;
  border-color: #ffb400 !important;
}
.sidebar_blog_six .post_title h3 a:hover {
  color: #ffb400;
}

.home_blog_section .section_title h2 {
  padding: 0;
}

.blog_carousel_seven .col-lg-4 {
  flex: 0 0 100%;
  width: 100%;
}
.blog_carousel_seven.owl-carousel .owl-nav {
  display: block;
}
.blog_carousel_seven.owl-carousel .owl-nav > * {
  position: absolute;
  top: -53px;
  right: 54px;
  width: 32px;
  height: 32px;
  border: 1px solid #e5e5e5 !important;
  background: #fff;
  border-radius: 100%;
  -webkit-transition: 0.5s;
  transition: 0.5s;
  text-align: center;
  line-height: 30px;
}
@media only screen and (max-width: 767px) {
  .blog_carousel_seven.owl-carousel .owl-nav > * {
    top: -48px;
  }
}
.blog_carousel_seven.owl-carousel .owl-nav > *:hover {
  background: #20a385 !important;
  border-color: #20a385 !important;
  color: #ffffff !important;
}
.blog_carousel_seven.owl-carousel .owl-nav > *.owl-next {
  right: 13px;
}
.blog_carousel_seven .sidebar_blog_list {
  overflow: hidden;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .blog_carousel_seven .sidebar_blog_list {
    border: 0;
  }
}
.blog_carousel_seven .sidebar_blog_content {
  border-bottom: 1px solid #e5e5e5;
  background: #fff;
  width: 90%;
  float: right;
  position: relative;
  top: -40px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .blog_carousel_seven .sidebar_blog_content {
    width: 85%;
  }
}
.blog_carousel_seven .post_title h3 a:hover {
  color: #20a385;
}

.facebook_like_box .fb_iframe_widget {
  width: 100%;
}
.facebook_like_box .fb_iframe_widget span {
  width: 100% !important;
}
.facebook_like_box .fb_iframe_widget span iframe {
  width: 100% !important;
}

/*06. newsletter area css here*/
.newsletter_inner {
  display: flex;
  justify-content: inherit;
  border: 2px solid #fff;
  border-radius: 20px 20px 0 0;
  max-width: 970px;
  margin: 0 auto;
  align-items: center;
}
.newsletter_inner1 {
  display: flex;
  justify-content:inherit;  
  max-width: 1000px;
  margin: 0 auto;
  align-items: center;
}

@media only screen and (max-width: 767px) {
  .newsletter_inner1 {
    flex-direction: column;
  }
}

.news
@media only screen and (max-width: 767px) {
  .newsletter_inner {
    flex-direction: column;
  }
}

.newsletter_content {
  position: relative;
  padding-left: 33px;
}
.newsletter_content::before {
  content: "\f159";
  display: block;
  position: absolute;
  left: 0;
  font-family: 'Material-Design-Iconic-Font';
  font-size: 24px;
  top: 50%;
  transform: translatey(-50%);
}
.newsletter_content h2 {
  font-size: 18px;
  line-height: 24px;
  text-transform: uppercase;
  font-weight: 700;
  margin-bottom: 0;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .newsletter_content h2 {
    font-size: 14px;
    line-height: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .newsletter_content h2 {
    font-size: 13px;
    line-height: 20px;
  }
}

@media only screen and (max-width: 767px) {
  .newsletter_form {
    margin-top: 18px;
    width: 100%;
  }
}
.newsletter_form form {
  display: flex;
  width: 550px;
  background: #fff;
  position: relative;
  border-radius: 30px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .newsletter_form form {
    width: 375px;
  }
}
@media only screen and (max-width: 767px) {
  .newsletter_form form {
    justify-content: center;
    width: 100%;
  }
}
.newsletter_form form input {
  height: 50px;
  width: 100%;
  font-size: 14px;
  padding: 0 60px 0 20px;
  border: 0;
  border-radius: 30px;
}
@media only screen and (max-width: 767px) {
  .newsletter_form form input {
    height: 43px;
  }
}
.newsletter_form form button {
  position: absolute;
  top: 0;
  right: 0;
  width: 60px;
  height: 100%;
  border: 0;
  font-size: 24px;
  color: #<?php echo $conf_color;?>;
  background: inherit;
  text-transform: uppercase;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  margin-left: 8px;
  border-radius: 0 30px 30px 0;
}
.newsletter_form form button:hover {
  color: #262626;
}
@media only screen and (max-width: 767px) {
  .newsletter_form form button {
    font-size: 13px;
  }
}

.newsletter_form form input[type="text"]::placeholder {
  color: #444444;
  opacity: 0.5;
}

/*home three css here*/
.newsletter_three .newsletter_form form button {
  color: #ffb400;
}
.newsletter_three .newsletter_form form button:hover {
  color: #262626;
}

/*home five css here*/
.newsletter_five {
  border: 1px solid #e5e5e5;
  padding: 20px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .newsletter_five {
    padding: 15px 8px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .newsletter_five {
    padding: 25px 20px 30px;
  }
}
.newsletter_five .newsletter_content {
  padding-left: 0;
}
.newsletter_five .newsletter_content::before {
  display: none;
}
.newsletter_five .newsletter_content h2 {
  font-size: 14px;
  margin-bottom: 12px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .newsletter_five .newsletter_content h2 {
    font-size: 12px;
    margin-bottom: 10px;
  }
}
.newsletter_five .newsletter_form form {
  width: 100%;
  border: 1px solid #e5e5e5;
  border-radius: 3px;
}
.newsletter_five .newsletter_form form input {
  height: 41px;
}
.newsletter_five .newsletter_form form button {
  border-left: 1px solid #e5e5e5;
  width: 50px;
  font-size: 20px;
}

/*home six css here*/
.newsletter_six_area {
  background: #f3f3f3;
  padding-top: 50px;
}
.newsletter_six_area .newsletter_form form button {
  color: #ffb400;
}
.newsletter_six_area .newsletter_form form button:hover {
  color: #262626;
}

/*home seven css here*/
.newsletter_seven .newsletter_form form button {
  color: #20a385;
}
.newsletter_seven .newsletter_form form button:hover {
  color: #262626;
}

/*home eight css here*/
.newsletter_eight .newsletter_form form button {
  color: #02a8f3;
}
.newsletter_eight .newsletter_form form button:hover {
  color: #262626;
}

/* 21. shipping css here */
.shipping_area {
  margin-bottom: 20px;
  overflow: hidden;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .shipping_area {
    margin-bottom: 26px;
  }
}
@media only screen and (max-width: 767px) {
  .shipping_area {
    margin-bottom: 24px;
  }
}

.single_shipping {
  display: flex;
  width: 33.33%;
  float: left;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .single_shipping {
    width: 100%;
    justify-content: center;
    margin-bottom: 9px;
  }
  .single_shipping:last-child {
    margin-bottom: 0;
  }
}
@media only screen and (max-width: 767px) {
  .single_shipping {
    margin-bottom: 13px;
    width: 100%;
    justify-content: center;
  }
  .single_shipping:last-child {
    margin-bottom: 0;
  }
}

.shipping_icone {
  margin-right: 8px;
  display: flex;
  align-items: center;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .shipping_icone {
    margin-right: 4px;
  }
}
.shipping_icone i {
  font-size: 24px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .shipping_icone i {
    font-size: 20px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .shipping_icone i {
    font-size: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .shipping_icone i {
    font-size: 20px;
  }
}

.shipping_content p {
  line-height: 28px;
  text-transform: capitalize;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .shipping_content p {
    font-size: 12px;
    line-height: 22px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .shipping_content p {
    font-size: 14px;
  }
}

/*home three css here*/
.shipping_area_two {
  background: url(../img/bg/banner9.jpg) no-repeat scroll center center/cover;
  position: relative;
  padding: 50px 0;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .shipping_area_two {
    padding: 50px 0 20px;
  }
}
@media only screen and (max-width: 767px) {
  .shipping_area_two {
    padding: 50px 0 20px;
  }
}
.shipping_area_two::before {
  position: absolute;
  content: "";
  background: rgba(0, 0, 0, 0.3);
  top: 0;
  right: 0;
  bottom: 0;
  left: 0;
}

.single_shipping_box {
  display: flex;
  align-items: center;
  border: 5px solid rgba(255, 255, 255, 0.1);
  background: rgba(0, 0, 0, 0.3);
  padding: 10px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .single_shipping_box {
    padding: 7px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .single_shipping_box {
    margin-bottom: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .single_shipping_box {
    margin-bottom: 30px;
    justify-content: center;
  }
}
.single_shipping_box:hover .shipping_box_icone {
  background: #ffb400;
  border-color: #ffb400;
}
.single_shipping_box:hover .shipping_box_icone i {
  color: #fff;
}

.shipping_box_icone {
  top: 50%;
  width: 64px;
  height: 64px;
  text-align: center;
  border: 1px solid #fff;
  border-radius: 50%;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .shipping_box_icone {
    width: 55px;
    height: 55px;
  }
}
.shipping_box_icone i {
  font-size: 24px;
  color: #fff;
  border-radius: 50%;
  line-height: 64px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .shipping_box_icone i {
    line-height: 55px;
  }
}

.shipping_box_content {
  margin-left: 15px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .shipping_box_content {
    margin-left: 9px;
  }
}
.shipping_box_content h3 {
  font-size: 13px;
  line-height: 17px;
  margin-bottom: 5px;
  text-transform: uppercase;
  font-weight: 700;
  color: #fff;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .shipping_box_content h3 {
    font-size: 12px;
  }
}
.shipping_box_content p {
  font-size: 13px;
  line-height: 13px;
  color: #fff;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .shipping_box_content p {
    font-size: 12px;
  }
}

/*home four css here*/
.shipping_area_four {
  background: #f3f3f3;
  padding: 50px 0;
}
@media only screen and (max-width: 767px) {
  .shipping_area_four {
    padding: 50px 0 20px;
  }
}
.shipping_area_four .single_shipping_box {
  border: 0;
  background: 0;
  padding: 0;
}
.shipping_area_four .single_shipping_box:hover .shipping_box_icone {
  border-color: #<?php echo $conf_color;?>;
  background: inherit;
}
.shipping_area_four .single_shipping_box:hover .shipping_box_icone i {
  color: #<?php echo $conf_color;?>;
}
.shipping_area_four .shipping_box_icone {
  -webkit-transition: 0.3s;
  transition: 0.3s;
  border: 1px solid #e5e5e5;
}
.shipping_area_four .shipping_box_icone i {
  color: #<?php echo $conf_color;?>;
}
.shipping_area_four .shipping_box_content h3 {
  color: #262626;
}
.shipping_area_four .shipping_box_content p {
  color: #262626;
}

/*home five css here*/
.shipping_area_five {
  border: 1px solid #e5e5e5;
  padding: 0 15px;
}
.shipping_area_five .shipping_box_icone {
  border: 1px solid #e5e5e5;
  -webkit-transition: 0.3s;
  transition: 0.3s;
}
.shipping_area_five .shipping_box_icone i {
  color: #<?php echo $conf_color;?>;
}
.shipping_area_five .shipping_box_content h3 {
  color: #262626;
}
.shipping_area_five .shipping_box_content p {
  color: #262626;
}
.shipping_area_five .single_shipping_box {
  border: 0;
  background: inherit;
  padding: 22px 0;
  border-bottom: 1px solid #e5e5e5;
}
.shipping_area_five .single_shipping_box:last-child {
  border-bottom: 0;
}
.shipping_area_five .single_shipping_box:hover .shipping_box_icone {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
}

.shipping_six .shipping_box_icone i {
  color: #ffb400;
}
.shipping_six .single_shipping_box:hover .shipping_box_icone {
  background: #ffb400;
  border-color: #ffb400;
}

/*testimonial css here*/
.testimonial_area {
  background: url(../img/bg/banner10.jpg) no-repeat scroll center center/cover;
  position: relative;
  padding: 70px 0;
}
.testimonial_area::before {
  position: absolute;
  content: "";
  left: 0;
  top: 0;
  right: 0;
  bottom: 0;
  background: rgba(0, 0, 0, 0.2);
}
.testimonial_area:hover .owl-nav > * {
  opacity: 1;
  visibility: visible;
}

.testimonial_thumb {
  width: 100px;
  float: left;
}
@media only screen and (max-width: 767px) {
  .testimonial_thumb {
    float: inherit;
    margin: 0 auto;
    margin-bottom: 20px;
  }
}
.testimonial_thumb a img {
  border-radius: 4px;
}

.testimonial_body {
  background: rgba(0, 0, 0, 0.8);
  border-radius: 4px;
  padding: 30px;
  padding-left: 60px;
  margin-left: 115px;
  position: relative;
}
@media only screen and (max-width: 767px) {
  .testimonial_body {
    margin-left: 0;
    padding-left: 50px;
  }
}
.testimonial_body::before {
  content: "\f10d";
  font-family: FontAwesome;
  position: absolute;
  left: 28px;
  top: 16px;
  z-index: 11;
  font-size: 22px;
  color: #<?php echo $conf_color;?>;
}
@media only screen and (max-width: 767px) {
  .testimonial_body::before {
    left: 20px;
  }
}
.testimonial_body p {
  color: #fff;
  line-height: 22px;
}
.testimonial_body p a {
  text-transform: uppercase;
  color: #fff;
  font-weight: 700;
}
.testimonial_body p a:hover {
  color: #<?php echo $conf_color;?>;
}
.testimonial_body p span {
  text-transform: capitalize;
  font-style: italic;
}

.testimonial_Carousel .owl-nav > * {
  position: absolute;
  top: 50%;
  transform: translatey(-50%);
  left: -40px;
  width: 32px;
  height: 32px;
  line-height: 30px;
  border: 1px solid #e5e5e5 !important;
  border-radius: 50%;
  background: #fff;
  text-align: center;
  opacity: 0;
  visibility: hidden;
  z-index: 1;
  -webkit-transition: 0.3s;
  transition: 0.3s;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .testimonial_Carousel .owl-nav > * {
    left: 0;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .testimonial_Carousel .owl-nav > * {
    left: 0;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .testimonial_Carousel .owl-nav > * {
    left: 0;
  }
}
@media only screen and (max-width: 767px) {
  .testimonial_Carousel .owl-nav > * {
    left: 0;
  }
}
.testimonial_Carousel .owl-nav > *:hover {
  background: #<?php echo $conf_color;?> !important;
  color: #fff !important;
  border-color: #<?php echo $conf_color;?> !important;
}
.testimonial_Carousel .owl-nav > *.owl-next {
  right: -40px;
  left: auto;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .testimonial_Carousel .owl-nav > *.owl-next {
    right: 0;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .testimonial_Carousel .owl-nav > *.owl-next {
    right: 0;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .testimonial_Carousel .owl-nav > *.owl-next {
    right: 0;
  }
}
@media only screen and (max-width: 767px) {
  .testimonial_Carousel .owl-nav > *.owl-next {
    right: 0;
  }
}

/*brand css here*/
.brand_newsletter_area {
  background: #f3f3f3;
}

.brand_container {
  padding: 30px 0;
}
@media only screen and (max-width: 767px) {
  .brand_container {
    padding: 20px 0;
  }
}
.brand_container .single_brand img {
  width: inherit;
  margin: 0 auto;
}

/*home five css here*/
.brand_carousel {
  border: 1px solid #e5e5e5;
  padding: 20px 0;
}
.brand_carousel .single_brand a img {
  width: inherit;
  margin: 0 auto;
}
.brand_carousel .owl-nav > * {
  position: absolute;
  top: -54px;
  right: 40px;
  width: 32px;
  height: 32px;
  line-height: 30px;
  border: 1px solid #e5e5e5 !important;
  background: #fff;
  text-align: center;
  border-radius: 100%;
  -webkit-transition: 0.5s;
  transition: 0.5s;
}
.brand_carousel .owl-nav > *:hover {
  background: #<?php echo $conf_color;?> !important;
  border-color: #<?php echo $conf_color;?> !important;
  color: #fff !important;
}
@media only screen and (max-width: 767px) {
  .brand_carousel .owl-nav > * {
    top: -47px;
  }
}
.brand_carousel .owl-nav > *.owl-next {
  right: 0;
}

/*home six css here*/
.brand_six .owl-nav > * {
  top: -61px;
}
.brand_six .owl-nav > *:hover {
  background: #ffb400 !important;
  border-color: #ffb400 !important;
}

/*  07. footer area css here */
.footer_top {
  padding: 44px 0 50px;
  border-bottom: 1px solid #e5e5e5;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .footer_top {
    padding: 44px 0 7px;
  }
}
@media only screen and (max-width: 767px) {
  .footer_top {
    padding: 44px 0 12px;
  }
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .widgets_container {
    margin-bottom: 43px;
  }
}
@media only screen and (max-width: 767px) {
  .widgets_container {
    margin-bottom: 37px;
    text-align: center;
  }
}
@media only screen and (max-width: 767px) {
  .widgets_container.contact_us {
    margin-bottom: 44px;
  }
}
.widgets_container.contact_us > a {
  margin-bottom: 19px;
  display: block;
}
@media only screen and (max-width: 767px) {
  .widgets_container.contact_us > a {
    margin-bottom: 15px;
  }
}
@media only screen and (max-width: 767px) {
  .widgets_container.contact_us > a img {
    max-width: 160px;
  }
}
.widgets_container > h3 {
  font-size: 16px;
  font-weight: 700;
  text-transform: uppercase;
  margin-bottom: 25px;
  display: inline-block;
  line-height: 15px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .widgets_container > h3 {
    padding-bottom: 10px;
    margin-bottom: 16px;
  }
}
@media only screen and (max-width: 767px) {
  .widgets_container > h3 {
    margin-bottom: 15px;
  }
}

.footer_contact {
  margin-bottom: 24px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .footer_contact {
    margin-bottom: 16px;
  }
}
@media only screen and (max-width: 767px) {
  .footer_contact {
    margin-bottom: 18px;
  }
}
.footer_contact ul li {
  font-size: 14px;
  line-height: 23px;
  margin-bottom: 10px;
}
@media only screen and (max-width: 767px) {
  .footer_contact ul li {
    line-height: 26px;
    margin-bottom: 5px;
  }
}
.footer_contact ul li:last-child {
  margin-bottom: 0;
}
.footer_contact ul li i {
  font-size: 20px;
  margin-right: 15px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .footer_contact ul li i {
    margin-right: 12px;
              background-color: red;

  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .footer_contact ul li i {
    margin-right: 7px;

  }
}
@media only screen and (max-width: 767px) {
  .footer_contact ul li i {
    margin-right: 6px;
  }
}
.footer_contact ul li a:hover {
  color: #<?php echo $conf_color;?>;

}
.footer_contact ul li span {
  font-weight: 7000;
  margin-right: 20px;


}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .footer_contact ul li span {
    margin-right: 15px;
  }
}
@media only screen and (max-width: 767px) {
  .footer_contact ul li span {
    margin-right: 10px;
  }
}

.social_icone {
  overflow: hidden;
  border-top: 1px solid #e5e5e5;
}
.social_icone ul li {
  width: 50%;
  float: left;
  display: flex;
  align-items: center;
  margin-top: 30px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .social_icone ul li {
    margin-top: 21px;
  }
}
@media only screen and (max-width: 767px) {
  .social_icone ul li {
    margin-top: 24px;
    justify-content: center;
  }
}
.social_icone ul li.share a {
  background: #ffb15a;
}
.social_icone ul li.whatsapp a {
  background: #229954;
}
.social_icone ul li.facebook a {
  background: #082CF7;
}
.social_icone ul li.google_plus a {
  background: #FD0404;
}
.social_icone ul li.instagram a {
  background: #A542C4;
}
.social_icone ul li a {
  width: 32px;
  height: 32px;
  line-height: 32px;
  border-radius: 2px;
  display: block;
  text-align: center;
  color: #fff;
}

.social_title {
  margin-left: 10px;
}
.social_title p {
  text-transform: capitalize;
  margin-bottom: 4px;
  line-height: 13px;
}
.social_title h3 {
  font-size: 14px;
  line-height: 14px;
  text-transform: uppercase;
  margin-bottom: 0;
}

.footer_menu ul li {
  margin-bottom: 5px;
}
.footer_menu ul li:last-child {
  margin-bottom: 0;
}
@media only screen and (max-width: 767px) {
  .footer_menu ul li {
    margin-bottom: 4px;
  }
}
.footer_menu ul li a {
  font-size: 14px;
  line-height: 28px;
}
@media only screen and (max-width: 767px) {
  .footer_menu ul li a {
    line-height: 27px;
  }
}
.footer_menu ul li a:hover {
  color: #<?php echo $conf_color;?>;
}
.footer_menu ul li a i {
  margin-right: 6px;
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .Latest_Posts_wrapper {
    overflow: hidden;
  }
}
@media only screen and (max-width: 767px) {
  .Latest_Posts_wrapper {
    margin-top: 10px;
  }
}

.single_Latest_Posts {
  display: flex;
  margin-bottom: 30px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .single_Latest_Posts {
    width: 33%;
    float: left;
    margin-bottom: 0;
  }
}
.single_Latest_Posts:last-child {
  margin-bottom: 0;
}
@media only screen and (max-width: 767px) {
  .single_Latest_Posts {
    justify-content: center;
  }
}

.Latest_Posts_thumb {
  width: 37%;
}
@media only screen and (max-width: 767px) {
  .Latest_Posts_thumb {
    width: 25%;
  }
}

.Latest_Posts_content {
  width: 65%;
  margin-left: 20px;
}
@media only screen and (max-width: 767px) {
  .Latest_Posts_content {
    text-align: left;
    width: inherit;
  }
}
.Latest_Posts_content h3 {
  font-size: 14px;
  line-height: 17px;
  margin-bottom: 10px;
}
.Latest_Posts_content h3 a:hover {
  color: #<?php echo $conf_color;?>;
}

.footer_tag {
  padding: 49px 0;
}
@media only screen and (max-width: 767px) {
  .footer_tag {
    padding: 44px 0 48px;
  }
}

.footer_tag_menu {
  margin-bottom: 18px;
  display: flex;
  align-items: center;
}
.footer_tag_menu:last-child {
  margin-bottom: 0;
}
@media only screen and (max-width: 767px) {
  .footer_tag_menu {
    flex-direction: column;
    align-items: inherit;
  }
}
.footer_tag_menu h3 {
  display: inline-block;
  font-size: 11px;
  text-transform: uppercase;
  font-weight: 700;
  margin-bottom: 0;
  line-height: 18px;
  margin-right: 20px;
}
@media only screen and (max-width: 767px) {
  .footer_tag_menu h3 {
    margin-bottom: 10px;
    margin-right: 0;
  }
}
.footer_tag_menu ul {
  line-height: 16px;
}
.footer_tag_menu ul li {
  display: inline-block;
}
.footer_tag_menu ul li a {
  text-transform: capitalize;
  padding-right: 10px;
  margin-right: 10px;
  border-right: 1px solid #262626;
  line-height: 16px;
}
.footer_tag_menu ul li a:hover {
  color: #<?php echo $conf_color;?>;
}
.footer_tag_menu ul li:last-child a {
  padding-right: 0;
  margin-right: 0;
  border-right: 0;
}

.footer_bottom {
  padding: 15px 0;
  background: #262626;
}
@media only screen and (max-width: 767px) {
  .footer_bottom {
    padding: 17px 0 23px;
  }
}

@media only screen and (max-width: 767px) {
  .copyright_area {
    text-align: center;
    margin-bottom: 10px;
  }
}
.copyright_area p {
  color: #bcbcbc;
  text-transform: capitalize;
}
.copyright_area p a {
  color: #ffffff;
}
.copyright_area p a:hover {
  color: #<?php echo $conf_color;?>;
}

.footer_payment {
  text-align: right;
}
@media only screen and (max-width: 767px) {
  .footer_payment {
    text-align: center !important;
  }
}

/*home three css here*/
.footer_three .footer_menu ul li a:hover {
  color: #ffb400;
}
.footer_three .Latest_Posts_content h3 a:hover {
  color: #ffb400;
}
.footer_three .footer_tag_menu ul li a:hover {
  color: #ffb400;
}
.footer_three .copyright_area p a:hover {
  color: #ffb400;
}

/*home five css here*/
.footer_top_wrapper {
  background: #f0f0f0;
}

.single_instagram {
  width: 29%;
  display: inline-block;
  margin: 6px 5px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .single_instagram {
    margin: 4px 3px;
  }
}
@media only screen and (max-width: 767px) {
  .single_instagram a img {
    width: 100%;
  }
}

.footer_six_inner {
  background: #262626;
}
.footer_six_inner .footer_contact ul li {
  color: #cfcfcf;
}
.footer_six_inner .social_icone {
  border-top: 1px solid rgba(255, 255, 255, 0.1);
}
.footer_six_inner .social_title p {
  color: #cfcfcf;
}
.footer_six_inner .social_title h3 {
  color: #cfcfcf;
}
.footer_six_inner .widgets_container > h3 {
  color: #ffffff;
}
.footer_six_inner .footer_menu ul li a {
  color: #cfcfcf;
}
.footer_six_inner .footer_menu ul li a:hover {
  color: #ffb400;
}
.footer_six_inner .footer_top {
  border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}
.footer_six_inner .footer_tag_menu h3 {
  color: #cfcfcf;
}
.footer_six_inner .footer_tag_menu ul li a {
  color: #cfcfcf;
  border-right: 1px solid rgba(255, 255, 255, 0.1);
}
.footer_six_inner .footer_tag_menu ul li a:hover {
  color: #ffb400;
}
.footer_six_inner .footer_tag_menu ul li:last-child a {
  border-right: 0;
}

.footer_bottom_six {
  background: #1B1B1B;
}
.footer_bottom_six .copyright_area p a:hover {
  color: #ffb400;
}

/*home seven css here*/
.footer_seven_inner {
  background: #262626;
}
.footer_seven_inner .footer_contact ul li {
  color: #cfcfcf;
}
.footer_seven_inner .social_icone {
  border-top: 1px solid rgba(255, 255, 255, 0.1);
}
.footer_seven_inner .social_title p {
  color: #cfcfcf;
}
.footer_seven_inner .social_title h3 {
  color: #cfcfcf;
}
.footer_seven_inner .widgets_container > h3 {
  color: #ffffff;
}
.footer_seven_inner .footer_menu ul li a {
  color: #cfcfcf;
}
.footer_seven_inner .footer_menu ul li a:hover {
  color: #20a385;
}
.footer_seven_inner .footer_top {
  border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}
.footer_seven_inner .footer_tag_menu h3 {
  color: #cfcfcf;
}
.footer_seven_inner .footer_tag_menu ul li a {
  color: #cfcfcf;
  border-right: 1px solid rgba(255, 255, 255, 0.1);
}
.footer_seven_inner .footer_tag_menu ul li a:hover {
  color: #20a385;
}
.footer_seven_inner .footer_tag_menu ul li:last-child a {
  border-right: 0;
}

.footer_bottom_seven {
  background: #1B1B1B;
}
.footer_bottom_seven .copyright_area p a:hover {
  color: #20a385;
}

/*home eight css here*/
.footer_eight .footer_menu ul li a:hover {
  color: #02a8f3;
}
.footer_eight .footer_tag_menu ul li a:hover {
  color: #02a8f3;
}
.footer_eight .copyright_area p a:hover {
  color: #02a8f3;
}

/*collection area css here*/
.collection_area {
  margin-bottom: 94px;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .collection_area {
    margin-bottom: 74px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .collection_area {
    margin-bottom: 74px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .collection_area {
    margin-bottom: 55px;
  }
}
@media only screen and (max-width: 767px) {
  .collection_area {
    margin-bottom: 53px;
  }
}

@media only screen and (max-width: 767px) {
  .collection_img {
    margin-bottom: 21px;
  }
}
.collection_img img:hover {
  opacity: 0.7;
}

@media only screen and (max-width: 767px) {
  .collection_content {
    text-align: center;
  }
}
.collection_content h1 {
  font-size: 120px;
  color: #a4a4a4;
  font-weight: 700;
  line-height: 100px;
  margin-bottom: 20px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .collection_content h1 {
    font-size: 90px;
    line-height: 80px;
    margin-bottom: 13px;
  }
}
@media only screen and (max-width: 767px) {
  .collection_content h1 {
    font-size: 90px;
    line-height: 80px;
    margin-bottom: 13px;
  }
}
.collection_content h4 {
  font-size: 18px;
  color: #262626;
  font-weight: 500;
  text-transform: capitalize;
  margin-bottom: 23px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .collection_content h4 {
    margin-bottom: 12px;
  }
}
@media only screen and (max-width: 767px) {
  .collection_content h4 {
    margin-bottom: 12px;
  }
}
.collection_content h2 {
  font-size: 36px;
  margin-top: 0;
  margin-bottom: 20px;
  color: #bbbbbb;
  font-weight: 700;
  margin-bottom: 20px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .collection_content h2 {
    margin-bottom: 10px;
    font-size: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .collection_content h2 {
    margin-bottom: 10px;
    font-size: 20px;
    line-height: 28px;
  }
}
.collection_content p {
  line-height: 24px;
  font-size: 16px;
  margin: 0;
}
@media only screen and (max-width: 767px) {
  .collection_content p {
    font-size: 15px;
  }
}
.collection_content a {
  font-size: 16px;
  color: #bbbbbb;
  font-weight: 600;
  padding-bottom: 5px;
  border-bottom: 2px solid #bbbbbb;
  display: inline-block;
  margin-top: 40px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .collection_content a {
    margin-top: 15px;
  }
}
@media only screen and (max-width: 767px) {
  .collection_content a {
    margin-top: 15px;
    font-size: 16px;
  }
}
.collection_content a:hover {
  color: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
}

@media only screen and (max-width: 767px) {
  .collection_2 {
    margin-bottom: 29px;
  }
}
@media only screen and (max-width: 767px) {
  .collection_2 .collection_content {
    margin-bottom: 29px;
  }
}

@media only screen and (max-width: 767px) {
  .collection_4 {
    margin-bottom: 32px;
  }
}
@media only screen and (max-width: 767px) {
  .collection_4 .collection_content {
    margin-bottom: 29px;
  }
}

/*categories section css here*/
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_area {
    margin-top: 68px;
  }
}

.categories_thumb {
  position: relative;
}
@media only screen and (max-width: 767px) {
  .categories_thumb {
    height: 100vh;
  }
}
@media only screen and (max-width: 767px) {
  .categories_thumb a {
    height: 100%;
  }
}
@media only screen and (max-width: 767px) {
  .categories_thumb img {
    height: 100%;
    object-fit: cover;
  }
}

.categories_content {
  position: absolute;
  top: 50%;
  right: 50px;
  transform: translatey(-50%);
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .categories_content {
    right: 20px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_content {
    right: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .categories_content {
    right: 15px;
  }
}
.categories_content h4 {
  color: #bbbbbb;
  font-size: 18px;
  margin-bottom: 15px;
}
@media only screen and (max-width: 767px) {
  .categories_content h4 {
    font-size: 16px;
    margin-bottom: 10px;
  }
}
.categories_content h2 {
  color: #bbbbbb;
  font-size: 35px;
  font-weight: 600;
  line-height: 30px;
  margin-bottom: 10px;
}
@media only screen and (max-width: 767px) {
  .categories_content h2 {
    font-size: 22px;
    margin-bottom: 10px;
  }
}
.categories_content p {
  color: #bbbbbb;
  font-size: 17px;
  width: 440px;
  font-weight: 500;
  margin-top: 30px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_content p {
    width: 310px;
  }
}
@media only screen and (max-width: 767px) {
  .categories_content p {
    font-size: 14px;
    width: 210px;
    line-height: 20px;
    margin-bottom: 5px;
    margin-top: 0;
  }
}
.categories_content a {
  text-transform: capitalize;
  font-size: 16px;
  color: #bbbbbb;
  font-weight: 600;
  padding-bottom: 5px;
  border-bottom: 2px solid #bbbbbb;
}
.categories_content a:hover {
  color: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
}

#fp-nav {
  right: 31px;
}

.categories_area .col-12 {
  padding: 0;
}

.categories_content.content_left {
  left: 60px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .categories_content.content_left {
    left: 30px;
  }
}
@media only screen and (max-width: 767px) {
  .categories_content.content_left {
    left: 30px;
  }
}

/* 10. shop page css here */
.breadcrumbs_area {
  background: #f3f3f3;
}

.breadcrumb_content {
  padding: 18px 0;
}
.breadcrumb_content ul li {
  display: inline-block;
  text-transform: capitalize;
  font-size: 14px;
  margin-right: 3px;
  padding-right: 13px;
  position: relative;
  color: #<?php echo $conf_color;?>;
}
.breadcrumb_content ul li::before {
  position: absolute;
  content: "/";
  right: 0;
  top: 50%;
  transform: translatey(-50%);
}
.breadcrumb_content ul li:last-child {
  margin-right: 0;
}
.breadcrumb_content ul li:last-child::before {
  display: none;
}
.breadcrumb_content ul li a {
  color: #262626;
}
.breadcrumb_content ul li a:hover {
  text-decoration: underline;
}

.sidebar_widget .single_banner {
  border: 0;
}
@media only screen and (max-width: 767px) {
  .sidebar_widget .single_banner {
    margin-bottom: 0;
  }
}
@media only screen and (max-width: 767px) {
  .sidebar_widget .single_banner a {
    width: 100%;
  }
}
@media only screen and (max-width: 767px) {
  .sidebar_widget .single_banner a img {
    width: 100%;
  }
}

.widget_list {
  margin-bottom: 45px;
}
.widget_list:last-child {
  margin-bottom: 0;
}
.widget_list h2 {
  font-size: 14px;
  margin-bottom: 25px;
  padding-bottom: 10px;
  text-transform: uppercase;
  font-weight: 700;
  line-height: 20px;
  border-bottom: 1px solid #e5e5e5;
  color: #<?php echo $conf_color;?>;
  letter-spacing: 1px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .widget_list h2 {
    font-size: 13px;
  }
}
.widget_list > ul > li {
  margin-bottom: 20px;
  position: relative;
}
.widget_list > ul > li:last-child {
  margin-bottom: 0;
}
.widget_list > ul > li > a {
  font-size: 14px;
  display: block;
  line-height: 16px;
}
.widget_list > ul > li > a:hover {
  color: #<?php echo $conf_color;?>;
}
.widget_list > ul > li > a span {
  float: right;
}

.widget_categories {
  border: 1px solid #e5e5e5;
}
.widget_categories h2 {
  background: #262626;
  border-radius: 3px 3px 0 0;
  color: #ffffff;
  padding: 15px 20px;
  border-bottom: 0;
}
.widget_categories ul {
  padding: 0 20px 25px;
}

.ui-slider-horizontal .ui-slider-range {
  background: #262626;
  height: 2px;
}

.ui-slider-horizontal {
  height: 2px;
  background: #dbdbdb;
  border: none;
  width: 92%;
  margin: 0 auto;
  margin-bottom: 22px;
}

.ui-state-default, .ui-widget-content .ui-state-default, .ui-widget-header .ui-state-default {
  background: #fff;
  width: 15px;
  height: 15px;
  top: -7px;
  cursor: pointer;
  border-radius: 50%;
  border: 2px solid #<?php echo $conf_color;?>;
}

.widget_list.widget_filter form {
  padding-top: 10px;
}
.widget_list.widget_filter form input {
  background: none;
  border: none;
  font-size: 12px;
  float: right;
  text-align: right;
  line-height: 31px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .widget_list.widget_filter form input {
    width: 65px;
  }
}
.widget_list.widget_filter form button {
  height: 30px;
  line-height: 30px;
  padding: 0 20px;
  text-transform: capitalize;
  color: #ffffff;
  background: #262626;
  border: 0;
  border-radius: 30px;
  -webkit-transition: 0.3s;
  transition: 0.3s;
}
.widget_list.widget_filter form button:hover {
  background: #<?php echo $conf_color;?>;
}

.recent_product {
  border: 1px solid #e5e5e5;
}
.recent_product h2 {
  background: #262626;
  border-radius: 3px 3px 0 0;
  color: #ffffff;
  padding: 15px 20px;
  border-bottom: 0;
  margin-bottom: 0;
}

.recent_product_container:hover button {
  opacity: 1;
  visibility: visible;
}
.recent_product_container button {
  position: absolute;
  top: 50%;
  transform: translatey(-50%);
  left: 0;
  width: 32px;
  height: 32px;
  line-height: 30px;
  font-size: 16px;
  border: 1px solid #e5e5e5;
  background: #fff;
  text-align: center;
  border-radius: 50%;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  opacity: 0;
  visibility: hidden;
  z-index: 9;
}
.recent_product_container button:hover {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  color: #ffffff;
}
.recent_product_container button.next_arrow {
  right: 0;
  left: auto;
}

.recent_product_list {
  display: flex !important;
  border-bottom: 1px solid #e5e5e5;
  padding: 17px;
}

.recent_product_thumb {
  width: 30%;
}

.recent_product_content {
  width: 60%;
  margin-left: 15px;
}
.recent_product_content h3 {
  font-size: 14px;
  text-transform: capitalize;
  font-weight: 500;
  line-height: 17px;
  margin-bottom: 3px;
}
.recent_product_content h3 a:hover {
  color: #<?php echo $conf_color;?>;
}
.recent_product_content .product_rating {
  margin-bottom: 0;
}
.recent_product_content .price_box {
  margin-bottom: 0;
}
.recent_product_content .price_box span.current_price {
  font-size: 15px;
  line-height: 23px;
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .shop_sidebar_banner {
    text-align: center;
  }
}
@media only screen and (max-width: 767px) {
  .shop_sidebar_banner {
    text-align: center;
  }
}
.shop_sidebar_banner a img:hover {
  opacity: 0.7;
}

.shop_toolbar {
  display: flex;
  align-items: center;
  justify-content: space-between;
  border: 1px solid #e5e5e5;
  padding: 8px 10px;
  margin: 0 0 40px;
}
@media only screen and (max-width: 767px) {
  .shop_toolbar {
    flex-direction: column-reverse;
    padding: 10px 10px 18px;
  }
}

.select_option {
  display: flex;
  align-items: center;
}
@media only screen and (max-width: 767px) {
  .select_option {
    flex-direction: column;
  }
}
.select_option .nice-select {
  border: 0;
  height: 30px;
  line-height: 29px;
}
.select_option .nice-select ul.list {
  top: 114%;
  right: 0;
  width: 200px;
  max-height: 200px;
  overflow: auto;
}

.shop_title {
  margin-bottom: 20px;
}
.shop_title h1 {
  font-size: 33px;
  text-transform: capitalize;
  margin-bottom: 0;
  font-weight: 500;
}

@media only screen and (max-width: 767px) {
  .niceselect_option {
    margin-bottom: 16px;
  }
}

@media only screen and (max-width: 767px) {
  .page_amount {
    margin-bottom: 12px;
  }
}
@media only screen and (max-width: 767px) {
  .page_amount p {
    padding-left: 0;
    margin-left: 0;
    border-left: 0;
  }
}

.product_ratting ul li {
  display: inline-block;
}
.product_ratting ul li a {
  color: #<?php echo $conf_color;?>;
}

@media only screen and (max-width: 767px) {
  .product_list_item .product_thumb {
    margin-bottom: 18px;
  }
}
.product_list_item .product_content h3 {
  margin-bottom: 10px;
}
.product_list_item .product_ratting {
  margin-bottom: 10px;
}

@media only screen and (max-width: 767px) {
  .pagination {
    margin-top: 19px;
  }
}
.pagination ul li {
  display: inline-block;
  width: 30px;
  height: 30px;
  line-height: 30px;
  text-align: center;
  background: #f1f1f1;
  border-radius: 3px;
  margin-left: 3px;
}
.pagination ul li:first-child {
  margin-left: 0;
}
.pagination ul li a {
  display: block;
  border-radius: 3px;
}
.pagination ul li a:hover {
  background: #<?php echo $conf_color;?>;
  color: #ffffff;
}
.pagination ul li.current {
  background: #<?php echo $conf_color;?>;
  color: #ffffff;
}
.pagination ul li.next {
  width: 40px;
}

.shop_toolbar.t_bottom {
  justify-content: center;
  margin-bottom: 0;
  margin-top: 30px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .shop_toolbar.t_bottom {
    margin-bottom: 50px;
  }
}
@media only screen and (max-width: 767px) {
  .shop_toolbar.t_bottom {
    padding: 15px 10px 15px;
    margin-bottom: 50px;
  }
}
@media only screen and (max-width: 767px) {
  .shop_toolbar.t_bottom .pagination {
    margin-top: 0;
  }
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .shop_reverse .tab-content .row {
    flex-direction: row;
  }
}
@media only screen and (max-width: 767px) {
  .shop_reverse .tab-content .row {
    flex-direction: row;
  }
}

@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .grid_view .quick_button {
    bottom: 5px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .grid_view .quick_button a {
    line-height: 37px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .grid_view .action_button ul li a {
    width: 43px;
    height: 40px;
    line-height: 38px;
  }
}
.grid_view .hover_action a {
  width: 43px;
  height: 40px;
  line-height: 38px;
}

/* shop page css here*/
.shop_banner {
  margin-bottom: 45px;
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .shop_reverse .row {
    flex-direction: column-reverse;
  }
}
@media only screen and (max-width: 767px) {
  .shop_reverse .row {
    flex-direction: column-reverse;
  }
}

.shop_wrapper .product_thumb {
  overflow: hidden;
  
}
@media only screen and (max-width: 767px) {
  .shop_wrapper .product_thumb {
    text-align: center;
  }
}

.row.shop_wrapper {
  flex-direction: row;
}

.shop_toolbar_btn > button {
  margin-right: 10px;
  border: 0;
  background: inherit;
}
.shop_toolbar_btn > button.btn-grid-3 {
  background: url(assets/img/icon/bkg_grid.png) no-repeat scroll center center;
  width: 20px;
  height: 20px;
}
.shop_toolbar_btn > button.btn-grid-3.active {
  background: url(assets/img/icon/bkg_grid_hover.png) no-repeat scroll center center !important;
}
.shop_toolbar_btn > button.btn-grid-4 {
  background: url(assets/img/icon/bkg_grid4.png) no-repeat scroll center center;
  width: 26px;
  height: 22px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .shop_toolbar_btn > button.btn-grid-4 {
    display: none;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .shop_toolbar_btn > button.btn-grid-4 {
    display: none;
  }
}
.shop_toolbar_btn > button.btn-grid-4.active {
  background: url(assets/img/icon/bkg_grid4_hover.png) no-repeat scroll center center !important;
}
.shop_toolbar_btn > button.btn-list {
  background: url(assets/img/icon/bkg_list.png) no-repeat scroll center center;
  width: 20px;
  height: 20px;
}
.shop_toolbar_btn > button.btn-list.active {
  background: url(assets/img/icon/bkg_list_hover.png) no-repeat scroll center center !important;
}

.product_content.list_content {
  display: none;
}

.grid_list .product_content.grid_content {
  display: none;
}

.grid_list .product_content.list_content {
  display: block;
  width: 60%;
  margin-left: 30px;
  text-align: left;
  margin-top: 0;
}
@media only screen and (max-width: 767px) {
  .grid_list .product_content.list_content {
    flex: 0 0 100%;
    min-width: 100%;
    margin-left: 0;
    text-align: center;
  }
}
.grid_list .product_content.list_content .product_name h3 {
  margin: 0 0 12px;
}
.grid_list .product_content.list_content .product_ratings {
  margin-bottom: 8px;
}
.grid_list .product_content.list_content .price_box {
  margin-bottom: 15px;
}
.grid_list .product_content.list_content .product_desc {
  margin-top: 16px;
}

.grid_list .single_product {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  padding-bottom: 20px;
  align-items: center;
}
@media only screen and (max-width: 767px) {
  .grid_list .single_product {
    flex-direction: column;
    padding: 10px 18px 18px 18px;
  }
}
.grid_list .single_product .action_links ul li.wishlist, .grid_list .single_product .action_links ul li.compare {
  transform: inherit;
  opacity: inherit;
  visibility: inherit;
}
.grid_list .single_product .action_links ul li.compare {
  transform: inherit;
}

.grid_list .product_thumb {
  margin-bottom: 0;
  min-width: 35%;
  overflow: hidden;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .grid_list .product_thumb {
    flex: 0 0 41.666667%;
    min-width: 41.666667%;
  }
}
@media only screen and (max-width: 767px) {
  .grid_list .product_thumb {
    flex: 0 0 100%;
    min-width: 100%;
    margin-bottom: 25px;
  }
}

.col-cust-5 {
  -webkit-box-flex: 0;
  -ms-flex: 0 0 20%;
  flex: 0 0 20%;
  max-width: max-width;
  padding-right: 15px;
  padding-left: 15px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .col-cust-5 {
    -ms-flex: 0 0 33%;
    flex: 0 0 33%;
  }
}
@media only screen and (max-width: 767px) {
  .col-cust-5 {
    flex: 0 0 50%;
    max-width: 50%;
  }
}
@media only screen and (max-width: 479px) {
  .col-cust-5 {
    flex: 0 0 100%;
    max-width: 100%;
  }
}

.shop_wrapper > div {
  -webkit-transition: all 1s ease;
  transition: all 1s ease;
}

.shop_toolbar_wrapper {
  display: flex;
  justify-content: space-between;
  align-items: center;
  border: 1px solid #ddd;
  padding: 8px 10px;
  margin: 0 0 30px;
}
@media only screen and (max-width: 767px) {
  .shop_toolbar_wrapper {
    flex-direction: column;
    padding: 15px 10px 5px;
  }
}

@media only screen and (max-width: 767px) {
  .shop_toolbar_btn {
    margin-bottom: 20px;
  }
}









.shop_wrapper {
  overflow: hidden;
  position: relative;
 
}
.shop_wrapper .single_product {
  border: 1px solid #eee;
  border-radius: 4px;
  -webkit-transition: all 0.4s ease;
  transition: all 0.4s ease;
  margin-top: 30px;
  -webkit-box-shadow: 0px 0px 20px #00000012;
  box-shadow: 0px 0px 20px #00000012;
  padding: 5px;
  background: #fff;

}
.shop_wrapper .tab-content{
  padding: 15px;
  background-color: #fff;
}

.shop_wrapper .single_product:hover{
  box-shadow:2px 2px 20px  #B3B6B7;
}




@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .shop_wrapper .action_links ul li.add_to_cart a {
    padding: 0 17px;
  }
}
.shop_wrapper .label_product {
  bottom: 40px;
}
.shop_wrapper.grid_list .single_product {
  padding: 10px 20px;
  background-color: #ffffff;
}
@media only screen and (max-width: 767px) {
  .shop_wrapper.grid_list .single_product {
    padding: 10px 20px 20px;
  }
}
.shop_wrapper.grid_4 .price_box span.current_price {
  font-size: 15px;
  margin-right: 3px;
}
.shop_wrapper.grid_4 .price_box span.old_price {
  font-size: 14px;
}
.shop_wrapper.grid_4 .action_links ul li.wishlist a, .shop_wrapper.grid_4 .action_links ul li.compare a {
  width: 37px;
  height: 37px;
  line-height: 37px;
}
.shop_wrapper.grid_4 .action_links ul li.add_to_cart a {
  padding: 0 14px;
  line-height: 36px;
}

/* shop page css end*/
/*shop fullwidth css here*/
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .shop_fullwidth .shop_toolbar.t_bottom {
    margin-bottom: 0;
  }
}
@media only screen and (max-width: 767px) {
  .shop_fullwidth .shop_toolbar.t_bottom {
    margin-bottom: 0;
  }
}

/* 15. product details css here */
#img-1 {
  border: 1px solid #e5e5e5;
}

.header_product {
  border-bottom: 1px solid #e5e5e5;
}

.product_d_right h1 {
  text-transform: capitalize;
  line-height: 20px;
  font-size: 22px;
  font-weight: 400;
  margin-bottom: 18px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .product_d_right h1 {
    font-size: 18px;
  }
}
@media only screen and (max-width: 767px) {
  .product_d_right h1 {
    margin-bottom: 17px;
    font-size: 16px;
  }
}
.product_d_right .product_rating {
  margin-bottom: 16px;
}
@media only screen and (max-width: 767px) {
  .product_d_right .product_rating {
    margin-bottom: 12px;
  }
}
.product_d_right .product_rating ul li.review a {
  margin-left: 10px;
  color: #262626;
}
.product_d_right .product_rating ul li.review a:hover {
  color: #<?php echo $conf_color;?>;
}
.product_d_right .price_box {
  margin-bottom: 14px;
}
@media only screen and (max-width: 767px) {
  .product_d_right .price_box {
    margin-bottom: 9px;
  }
}
.product_d_right .price_box span.current_price {
  font-size: 23px;
}
.product_d_right .price_box span.old_price {
  font-size: 20px;
}
.product_d_right .product_desc {
  margin-bottom: 19px;
  padding-bottom: 24px;
  border-bottom: 1px solid #e5e5e5;
}
@media only screen and (max-width: 767px) {
  .product_d_right .product_desc {
    margin-bottom: 15px;
    padding-bottom: 18px;
  }
}
.product_d_right .product_desc::before {
  display: none;
}
.product_d_right .product_desc p {
  font-size: 14px;
  line-height: 26px;
}
.product_d_right .action_links {
  margin-bottom: 18px;
}
.product_d_right .action_links ul li {
  margin-right: 8px;
}
.product_d_right .action_links ul li.add_to_cart a {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  color: #ffffff;
  padding: 0 27px;
}
.product_d_right .action_links ul li.add_to_cart a:hover {
  background: #262626;
  border-color: #262626;
}
.product_d_right .priduct_social ul li {
  display: inline-block;
  margin-right: 7px;
}
@media only screen and (max-width: 767px) {
  .product_d_right .priduct_social ul li {
    margin-right: 2px;
  }
}
.product_d_right .priduct_social ul li:last-child {
  margin-right: 0;
}
.product_d_right .priduct_social ul li a {
  color: #fff;
  font-size: 12px;
  line-height: 24px;
  padding: 0 8px;
  border-radius: 3px;
  text-transform: capitalize;
  display: block;
}
@media only screen and (max-width: 767px) {
  .product_d_right .priduct_social ul li a {
    padding: 0 5px;
  }
}
.product_d_right .priduct_social ul li a:hover {
  opacity: 0.8;
}
.product_d_right .priduct_social ul li a.facebook {
  background: #3B5999;
}
.product_d_right .priduct_social ul li a.twitter {
  background: #1DA1F2;
}
.product_d_right .priduct_social ul li a.pinterest {
  background: #CB2028;
}
.product_d_right .priduct_social ul li a.google-plus {
  background: #fe6d4c;
}
.product_d_right .priduct_social ul li a.linkedin {
  background: #010103;
}

.product_nav {
  float: right;
  position: relative;
  top: -46px;
}
@media only screen and (max-width: 767px) {
  .product_nav {
    display: none;
  }
}
.product_nav ul li {
  display: inline-block;
  margin-left: 3px;
}
.product_nav ul li:first-child {
  margin-left: 0;
}
.product_nav ul li a {
  background: #ffffff;
  border: 1px solid #e5e5e5;
  border-radius: 3px;
  display: block;
  font-size: 15px;
  height: 30px;
  width: 30px;
  line-height: 28px;
  text-align: center;
}
.product_nav ul li a:hover {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  color: #ffffff;
}

.product_variant.quantity {
  margin-bottom: 25px;
}
@media only screen and (max-width: 767px) {
  .product_variant.quantity {
    margin-bottom: 16px;
  }
}
.product_variant.quantity label {
  color: #3E444A;
  font-weight: 500;
  text-transform: capitalize;
  font-size: 10px;
  margin-bottom: 0;
}
.product_variant.quantity input {
  width: 18px;
  border: 1px solid #ebebeb;
  background: none;
  height: 42px;
  padding: 0 20px;
  border-radius: 5px;
  margin-left: 15px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_variant.quantity input {
    width: 110px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .product_variant.quantity input {
    width: 80px;
  }
}
@media only screen and (max-width: 767px) {
  .product_variant.quantity input {
    width: 65px;
    margin-left: 10px;
    padding: 0 11px;
  }
}
.product_variant.color {
  margin-bottom: 20px;
}
@media only screen and (max-width: 767px) {
  .product_variant.color {
    margin-bottom: 18px;
  }
}
.product_variant.color h3 {
  font-weight: 500;
  text-transform: capitalize;
  font-size: 18px;
  margin-bottom: 0;
  margin-right: 40px;
}
.product_variant.color label {
  font-size: 15px;
  font-weight: 500;
  text-transform: capitalize;
}
.product_variant.color ul li {
  display: inline-block;
  padding: 2px;
  border: 1px solid #ccc;
  margin-right: 5px;
}
.product_variant.color ul li:hover {
  border-color: #fff;
}
.product_variant.color ul li:last-child {
  margin-right: 0;
}
.product_variant.color ul li a {
  width: 20px;
  height: 20px;
  display: block;
}
.product_variant.color ul li.color1 a {
  background: #000000;
}
.product_variant.color ul li.color2 a {
  background: #BEBEBE;
}
.product_variant.color ul li.color3 a {
  background: #FE0000;
}
.product_variant.color ul li.color4 a {
  background: #FFFF01;
}

.product_variant.size {
  margin-bottom: 30px;
}
.product_variant.size label {
  font-size: 15px;
  font-weight: 500;
  text-transform: capitalize;
}

.product_variant.size .niceselect_option {
  float: inherit;
  max-width: 200px;
}
.product_meta {
  margin-bottom: 24px;
}
@media only screen and (max-width: 767px) {
  .product_meta {
    margin-bottom: 15px;
  }
}
.product_meta span {
  font-weight: 500;
  color: #242424;
}
.product_meta span a {
  color: #262626;
  margin-left: 10px;
  font-weight: 400;
}

.product_info_button {
  border-bottom: 1px solid #e5e5e5;
  padding-bottom: 15px;
  margin-bottom: 22px;
}
.product_info_button ul li a {
  display: block;
  float: left;
  text-transform: capitalize;
  font-size: 20px;
  font-weight: 500;
  margin-right: 35px;
  line-height: 26px;
  position: relative;
  padding-bottom: 10px;
}
@media only screen and (max-width: 767px) {
  .product_info_button ul li a {
    margin-right: 25px;
    font-size: 18px;
  }
}
.product_info_button ul li a::before {
  content: "";
  width: 0;
  left: 0;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  bottom: 0;
  height: 2px;
  background: #<?php echo $conf_color;?>;
  position: absolute;
}
.product_info_button ul li a.active {
  color: #<?php echo $conf_color;?>
;
}
@media only screen and (max-width: 479px) {
  .product_info_button ul li a.active {
    margin-bottom: 9px;
  }
}
.product_info_button ul li a.active::before {
  width: 100%;
}
.product_info_button ul li a:hover {
  color: #<?php echo $conf_color;?>
;
}
.product_info_button ul li:last-child a {
  margin-right: 0;
}

.product_review_form button {
  border: none;
  background: #262626;
  color: #ffffff;
  text-transform: uppercase;
  font-weight: 700;
  padding: 5px 15px;
  display: block;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  cursor: pointer;
  margin-top: 20px;
  border-radius: 5px;
}
.product_review_form button:hover {
  background: #<?php echo $conf_color;?>;
  color: #ffffff;
}

.product_info_content p {
  line-height: 28px;
}

.product_d_table {
  padding: 10px 0 22px;
}
.product_d_table table {
  border-top: 1px solid #ddd;
  width: 100%;
}
.product_d_table table tbody tr {
  border-bottom: 1px solid #ddd;
}
.product_d_table table tbody tr td {
  padding: 7px 17px;
}
.product_d_table table tbody tr td:first-child {
  border-right: 1px solid #ddd;
  width: 30%;
  font-weight: 700;
}

.product_d_inner {
  padding: 20px 30px 30px;
  border: 1px solid #e5e5e5;
}

.product_info_inner {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  margin-top: 15px;
}
.product_info_inner .product_ratting {
  margin-bottom: 10px;
}
.product_info_inner .product_ratting p {
  margin-bottom: 5px;
}
.product_info_inner .product_ratting strong {
  margin-top: 10px;
  display: block;
  margin-bottom: 8px;
}

.reviews_wrapper h2 {
  font-size: 18px;
  font-weight: 500;
  text-transform: capitalize;
}
.reviews_wrapper .product_ratting {
  margin-bottom: 20px;
}
.reviews_wrapper .product_ratting h3 {
  font-size: 14px;
  font-weight: 700;
  text-transform: capitalize;
}

.comment_title {
  margin-bottom: 20px;
}

.product_review_form input {
  border: 1px solid #ddd;
  background: none;
  width: 100%;
  height: 40px;
  padding: 0 20px;
}
.product_review_form textarea {
  border: 1px solid #ddd;
  background: none;
  height: 120px;
  resize: none;
  width: 100%;
  margin-bottom: 14px;
  padding: 0 20px;
}
.product_review_form p {
  margin-bottom: 7px;
}

.star_rating {
  float: right;
}
.star_rating ul li {
  display: inline-block;
}
.star_rating ul li a {
  color: #<?php echo $conf_color;?>;
}

.product_d_info {
  margin-bottom: 48px;
}

.reviews_comment_box {
  display: flex;
  margin-bottom: 22px;
}
.reviews_comment_box .comment_text {
  width: 100%;
  border: 1px solid #e5e5e5;
  position: relative;
  margin-left: 21px;
  padding: 12px;
  border-radius: 3px;
}
.reviews_comment_box .comment_text::before {
  background: #fff;
  border-bottom: 1px solid #e5e5e5;
  border-left: 1px solid #e5e5e5;
  content: '';
  display: block;
  height: 10px;
  left: -6px;
  position: absolute;
  top: 10px;
  -webkit-transform: rotate(45deg);
  transform: rotate(45deg);
  width: 10px;
}

.reviews_meta p {
  font-size: 15px;
  margin-bottom: 15px;
}
.reviews_meta p strong {
  text-transform: uppercase;
  font-weight: 500;
}

.s-tab-zoom.owl-carousel .owl-nav {
  display: block;
}
.s-tab-zoom.owl-carousel .owl-nav > * {
  position: absolute;
  top: 50%;
  transform: translatey(-50%);
  width: 32px;
  height: 32px;
  border: 1px solid #e5e5e5 !important;
  background: #ffffff;
  border-radius: 100%;
  transform: translatey(-50%);
  text-align: center;
  line-height: 30px;
  left: -7px;
  font-size: 18px;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  opacity: 0;
  visibility: hidden;
}
.s-tab-zoom.owl-carousel .owl-nav > *:hover {
  background: #<?php echo $conf_color;?> !important;
  border-color: #<?php echo $conf_color;?> !important;
  color: #ffffff !important;
}
.s-tab-zoom.owl-carousel .owl-nav > *.owl-next {
  right: -7px;
  left: auto;
}
.s-tab-zoom.owl-carousel .owl-item.last {
  margin-right: 0 !important;
}

@media only screen and (max-width: 767px) {
  .product-details-tab {
    margin-bottom: 47px;
  }
}
.product-details-tab:hover .s-tab-zoom.owl-carousel .owl-nav > * {
  opacity: 1;
  visibility: visible;
}

.single-zoom-thumb {
  margin-top: 20px !important;
  width: 80%;
  margin: 0 auto;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .single-zoom-thumb {
    width: 85%;
  }
}
@media only screen and (max-width: 767px) {
  .single-zoom-thumb {
    width: 101%;
  }
}
.single-zoom-thumb ul li {
  border: 1px solid #ddd;
}
.single-zoom-thumb ul li a {
  width: 100%;
}

.related_products .section_title {
  margin-bottom: 25px;
}
.related_products .section_title h2 {
  padding: 0;
}
.related_products .product_column3:hover .owl-nav > * {
  opacity: 1;
  visibility: visible;
}
.related_products .product_column3 .owl-nav > * {
  top: 50%;
  transform: translatey(-50%);
  left: 10px;
  opacity: 0;
  visibility: hidden;
}
.related_products .product_column3 .owl-nav > *.owl-next {
  right: 10px;
  left: auto;
}

.upsell_products .section_title {
  margin-bottom: 25px;
}
.upsell_products .section_title h2 {
  padding: 0;
}
.upsell_products .product_column3:hover .owl-nav > * {
  opacity: 1;
  visibility: visible;
}
.upsell_products .product_column3 .owl-nav > * {
  top: 50%;
  transform: translatey(-50%);
  left: 10px;
  opacity: 0;
  visibility: hidden;
}
.upsell_products .product_column3 .owl-nav > *.owl-next {
  right: 10px;
  left: auto;
}

/* 12. product grouped css here */
.grouped_form {
  border: 1px solid #e5e5e5;
  margin-bottom: 25px;
  margin-top: 27px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .grouped_form {
    margin-bottom: 20px;
    margin-top: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .grouped_form {
    margin-bottom: 17px;
    margin-top: 17px;
  }
}
.grouped_form table {
  width: 100%;
}
.grouped_form table tbody tr {
  border-bottom: 1px solid #e5e5e5;
}
.grouped_form table tbody tr td {
  border-right: 1px solid #ddd;
  padding: 11px 5px;
  text-align: center;
}
.grouped_form table tbody tr td input[type="checkbox"] {
  width: 20px;
  height: 21px;
}
.grouped_form table tbody tr td input[type="number"] {
  width: 50px;
  background: inherit;
  border: 1px solid #e5e5e5;
  padding: 0 5px;
  height: 40px;
}
.grouped_form table tbody tr td.grouped-product-list.quantity {
  min-width: 80px;
  text-align: center;
  line-height: 12px;
}
.grouped_form table tbody tr td.grouped-product-list.label {
  min-width: 188px;
  font-weight: 600;
  font-size: 14px;
}
.grouped_form table tbody tr td.grouped-product-list.label a:hover {
  color: #<?php echo $conf_color;?>;
}
.grouped_form table tbody tr td.grouped-product-list.price {
  font-size: 14px;
  font-weight: 600;
  min-width: 190px;
}
.grouped_form table tbody tr td.grouped-product-list.price p {
  font-size: 12px;
  font-weight: 600;
  position: relative;
}
.grouped_form table tbody tr td.grouped-product-list.price p::before {
  color: #ffb400;
  content: '\f058';
  display: inline-block;
  font-family: FontAwesome;
  font-size: 1em;
  position: absolute;
  top: 0;
  left: 40px;
}

.grouped_form table tbody tr td:last-child {
  border-right: 0;
}

.grouped_form table tbody tr:last-child {
  border-bottom: 0;
}

.box_quantity.group button {
  margin-left: 0;
}

/*product grouped css end*/
/*variabla product css here*/
.p_section1.related_product .slick-list {
  padding-bottom: 144px !important;
  margin-bottom: -135px;
}

.variable_product .niceselect_option .list {
  width: 100%;
}

.product_d_meta {
  margin-bottom: 20px;
}
.product_d_meta span {
  display: block;
  line-height: 18px;
  margin-bottom: 17px;
  font-size: 14px;
  font-weight: 400;
}
.product_d_meta span:last-child {
  margin-bottom: 0;
}
.product_d_meta span a:hover {
  color: #<?php echo $conf_color;?>;
}

/*product sidebar css here*/
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .product_sidebar {
    margin-bottom: 50px;
  }
}
@media only screen and (max-width: 767px) {
  .product_sidebar {
    margin-bottom: 50px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .product_sidebar .row {
    flex-direction: column-reverse;
  }
}
@media only screen and (max-width: 767px) {
  .product_sidebar .row {
    flex-direction: column-reverse;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_sidebar .widget_list h2 {
    font-size: 13px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .product_sidebar .product_section .row {
    flex-direction: row;
  }
}
@media only screen and (max-width: 767px) {
  .product_sidebar .product_section .row {
    flex-direction: row;
  }
}
.product_sidebar .product_desc p {
  width: 100%;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_sidebar .action_button ul li a {
    width: 40px;
    height: 35px;
    line-height: 35px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_sidebar .quick_button {
    bottom: 12px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_sidebar .quick_button a {
    line-height: 35px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_sidebar .hover_action a {
    width: 40px;
    height: 35px;
    line-height: 35px;
  }
}
.product_sidebar .product_variant.quantity input {
  width: 90px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_sidebar .product_variant.quantity input {
    width: 60px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .product_sidebar .product_variant.quantity input {
    width: 60px;
  }
}
@media only screen and (max-width: 767px) {
  .product_sidebar .product_variant.quantity input {
    width: 60px;
  }
}
@media only screen and (max-width: 767px) {
  .product_sidebar .product-details-tab {
    margin-bottom: 0;
  }
}
.product_sidebar .price_box span.current_price {
  font-size: 16px;
}
.product_sidebar .price_box span.old_price {
  font-size: 15px;
}
.product_sidebar .price_box span.regular_price {
  font-size: 16px;
}

.footer_widgets.sidebar_widgets .footer_top {
  padding-bottom: 0;
  border-bottom: 0;
}
.footer_widgets.sidebar_widgets .footer_top_inner {
  padding: 56px 0 52px;
  border-top: 1px solid #e5e5e5;
  border-bottom: 1px solid #e5e5e5;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .footer_widgets.sidebar_widgets .footer_top_inner {
    padding: 56px 0 40px;
  }
}
@media only screen and (max-width: 767px) {
  .footer_widgets.sidebar_widgets .footer_top_inner {
    padding: 56px 0 35px;
  }
}

.product_right_sidebar {
  margin-bottom: 50px;
}
@media only screen and (max-width: 767px) {
  .product_right_sidebar .product-details-tab {
    margin-bottom: 45px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .product_right_sidebar .row {
    flex-direction: row;
  }
}
@media only screen and (max-width: 767px) {
  .product_right_sidebar .row {
    flex-direction: row;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_right_sidebar .product_d_right h1 {
    font-size: 18px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .product_right_sidebar .priduct_social ul li {
    margin-right: 4px;
  }
}

/* 13. cart page css here */
.header_cart_page {
  border-bottom: 1px solid #e5e5e5;
}

.other_bread {
  padding-top: 41px;
  padding-bottom: 41px;
}

.table_desc {
  border: 1px solid #e5e5e5;
  margin-bottom: 60px;
  margin-top: 2px;
}
.table_desc .cart_page table {
  width: 100%;
}
.table_desc .cart_page table thead tr th {
  border-bottom: 3px solid #<?php echo $conf_color;?>;
  border-right: 1px solid #e5e5e5;
  font-size: 16px;
  font-weight: 600;
  text-transform: capitalize;
  padding: 10px;
  text-align: center;
}
.table_desc .cart_page table tbody tr td {
  border-bottom: 1px solid #e5e5e5;
  border-right: 1px solid #e5e5e5;
  text-align: center;
  padding: 10px;
}
.table_desc .cart_page table tbody tr td.product_remove {
  min-width: 100px;
}
.table_desc .cart_page table tbody tr td.product_remove a {
  font-size: 20px;
  color: #<?php echo $conf_color;?>;
}
.table_desc .cart_page table tbody tr td.product_remove a:hover {
  color: #262626;
}
.table_desc .cart_page table tbody tr td.product_thumb {
  max-width: 180px;
}
.table_desc .cart_page table tbody tr td.product_name {
  min-width: 180px;
}
.table_desc .cart_page table tbody tr td.product_name a {
  text-transform: capitalize;
  font-size: 14px;
  font-weight: 400;
}
.table_desc .cart_page table tbody tr td.product_name a:hover {
  color: #<?php echo $conf_color;?>;
}
.table_desc .cart_page table tbody tr td.product-price {
  min-width: 130px;
  font-size: 16px;
  font-weight: 500;
}
.table_desc .cart_page table tbody tr td.product_quantity {
  min-width: 180px;
}
.table_desc .cart_page table tbody tr td.product_quantity label {
  font-weight: 600;
  margin-right: 5px;
}
.table_desc .cart_page table tbody tr td.product_quantity input {
  width: 60px;
  height: 40px;
  padding: 0 5px 0 10px;
  background: none;
  border: 1px solid #e5e5e5;
}
.table_desc .cart_page table tbody tr td .product_total {
  min-width: 120px;
}

.cart_page table thead tr:last-child th, .table_desc table tbody tr td:last-child {
  border-right: 0;
}

.cart_submit {
  text-align: right;
  padding: 12px;
}
.cart_submit button {
  background: #262626;
  border: 0;
  color: #ffffff;
  display: inline-block;
  font-size: 12px;
  font-weight: 600;
  height: 38px;
  line-height: 18px;
  padding: 10px 15px;
  text-transform: uppercase;
  cursor: pointer;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  border-radius: 3px;
}
.cart_submit button:hover {
  background: #<?php echo $conf_color;?>;
}

.coupon_inner {
  padding: 10px 20px 25px;
}
.coupon_inner p {
  font-size: 13px;
  margin-bottom: 20px;
}
.coupon_inner button {
  background: #262626;
  border: 0;
  color: #ffffff;
  display: inline-block;
  font-size: 12px;
  font-weight: 600;
  height: 38px;
  line-height: 18px;
  padding: 10px 15px;
  text-transform: uppercase;
  cursor: pointer;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  border-radius: 3px;
}
.coupon_inner button:hover {
  background: #<?php echo $conf_color;?>;
}
.coupon_inner input {
  border: 1px solid #e5e5e5;
  height: 42px;
  background: none;
  padding: 0 20px;
  margin-right: 20px;
  font-size: 12px;
  color: #262626;
}
@media only screen and (max-width: 767px) {
  .coupon_inner input {
    margin-bottom: 24px;
    width: 100%;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .coupon_inner input {
    margin-bottom: 24px;
    width: 100%;
  }
}
.coupon_inner a {
  display: block;
  text-align: right;
  color: #<?php echo $conf_color;?>;
  font-size: 14px;
  font-weight: 500;
  margin-bottom: 20px;
  border-bottom: 1px solid #e5e5e5;
  padding-bottom: 10px;
  border-radius: 3px;
}

.coupon_code {
  border: 1px solid #e5e5e5;
}
@media only screen and (max-width: 767px) {
  .coupon_code.left {
    margin-bottom: 59px;
  }
}
.coupon_code h3 {
  color: #ffffff;
  line-height: 36px;
  padding: 5px 15px;
  background: #262626;
  text-transform: uppercase;
  font-size: 16px;
  font-weight: 600;
}
@media only screen and (max-width: 767px) {
  .coupon_code h3 {
    line-height: 28px;
    padding: 5px 15px;
    font-size: 15px;
  }
}

.cart_subtotal {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-pack: justify;
  -ms-flex-pack: justify;
  justify-content: space-between;
}
.cart_subtotal p {
  font-weight: 600;
  font-size: 14px;
}
.cart_subtotal p.cart_amount {
  font-size: 18px;
  font-weight: 500;
}
@media only screen and (max-width: 767px) {
  .cart_subtotal p.cart_amount {
    font-size: 14px;
  }
}
.cart_subtotal p span {
  margin-right: 30px;
}

.checkout_btn {
  text-align: right;
}
.checkout_btn a {
  background: #<?php echo $conf_color;?>;
  color: #ffffff;
  font-size: 16px;
  padding: 3px 14px;
  line-height: 30px;
  font-weight: 500;
  display: inline-block;
  text-transform: capitalize;
  margin-bottom: 0;
}
.checkout_btn a:hover {
  background: #262626;
}

.coupon_area {
  margin-bottom: 60px;
}

.footer_widgets.other_widgets .footer_top {
  padding-bottom: 0;
  border-bottom: 0;
}
.footer_widgets.other_widgets .footer_top_inner {
  padding: 55px 0 53px;
  border-top: 1px solid #e5e5e5;
  border-bottom: 1px solid #e5e5e5;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .footer_widgets.other_widgets .footer_top_inner {
    padding: 55px 0 59px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .footer_widgets.other_widgets .footer_top_inner {
    padding: 55px 0 40px;
  }
}
@media only screen and (max-width: 767px) {
  .footer_widgets.other_widgets .footer_top_inner {
    padding: 55px 0 35px;
  }
}

/*cart page css end*/
/* 14. checkout page css here */
.user-actions {
  margin-bottom: 20px;
}
.user-actions h3 {
  font-size: 13px;
  font-weight: 400;
  background-color: #f7f6f7;
  padding: 15px 10px;
  border-top: 3px solid #<?php echo $conf_color;?>;
  margin-bottom: 0;
}
.user-actions h3 a {
  color: #<?php echo $conf_color;?>;
}

.checkout_info {
  border: 1px solid #e5e5e5;
  margin-top: 25px;
  padding: 20px 30px;
}
.checkout_info p {
  margin-bottom: 15px;
}
.checkout_info a {
  color: #<?php echo $conf_color;?>;
  margin-top: 15px;
  display: block;
}

.form_group {
  margin-bottom: 20px;
}
.form_group label {
  font-size: 14px;
  display: block;
  line-height: 18px;
  margin-bottom: 8px;
}
.form_group input {
  border: 1px solid #e5e5e5;
  background: none;
  height: 45px;
  width: 350px;
  padding: 0 20px;
}
@media only screen and (max-width: 767px) {
  .form_group input {
    width: 100%;
  }
}
.form_group button {
  display: inline-block;
  width: 80px;
  background: #262626;
  border: 0;
  color: #ffffff;
  font-weight: 600;
  text-transform: uppercase;
  font-size: 13px;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  margin-right: 20px;
  cursor: pointer;
  height: 40px;
  line-height: 40px;
  border-radius: 3px;
}
.form_group button:hover {
  background: #<?php echo $conf_color;?>;
}

.form_group input[type="checkbox"] {
  width: 15px;
  height: 15px;
  margin-right: 10px;
  position: relative;
  top: 3px;
}

.form_group.group_3 {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-align: center;
  -ms-flex-align: center;
  align-items: center;
}
.form_group.group_3 label {
  margin-bottom: 0;
  line-height: 34px;
  cursor: pointer;
}
.form_group.group_3 label:hover {
  color: #<?php echo $conf_color;?>;
}

#checkout_coupon input {
  background: none;
  border: 1px solid #e5e5e5;
  width: 200px;
  height: 45px;
  font-size: 12px;
  padding: 0 20px;
  color: #262626;
}
#checkout_coupon button {
  width: 130px;
  background: #262626;
  color: #ffffff;
  font-weight: 600;
  text-transform: uppercase;
  font-size: 13px;
  cursor: pointer;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  border: 0;
  height: 45px;
  line-height: 45px;
  border-radius: 3px;
  margin-left: 5px;
}
@media only screen and (max-width: 767px) {
  #checkout_coupon button {
    margin-top: 20px;
  }
}
#checkout_coupon button:hover {
  background: #<?php echo $conf_color;?>;
}

.mb-20 {
  margin-bottom: 20px;
}

.checkout_form h3 {
  font-size: 16px;
  line-height: 30px;
  padding: 5px 10px;
  text-transform: uppercase;
  color: #ffffff;
  background: #262626;
  font-weight: 500;
}
.checkout_form input {
  border: 1px solid #e5e5e5;
  background: none;
  height: 40px;
  width: 100%;
  padding: 0 20px;
  color: #262626;
}
.checkout_form .nice-select {
  width: 100%;
}
.checkout_form .nice-select ul.list {
  width: 100%;
  height: 180px;
  overflow: auto;
}
.checkout_form .nice-select::after {
  top: 56%;
}
.checkout_form label {
  font-weight: 600;
  margin-bottom: 8px;
}
.checkout_form label span {
  color: #<?php echo $conf_color;?>;
}
.checkout_form label.righ_0 {
  cursor: pointer;
  font-size: 15px;
  line-height: 27px;
  padding: 5px 10px;
  text-transform: capitalize;
  color: #ffffff;
  background: #262626;
  font-weight: 500;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  margin-bottom: 0;
  border-radius: 5px;
}
@media only screen and (max-width: 767px) {
  .checkout_form label.righ_0 {
    font-size: 13px;
    line-height: 25px;
    padding: 3px 10px;
  }
}
.checkout_form label.righ_0:hover {
  background: #<?php echo $conf_color;?>;
}
.product_variant input[type="checkbox"]{
  width: 30px;
  height: 30px;
  position: relative;
  top: 2px;
  margin-right: 10px;
  background:red ;
}
.checkout_form input[type="checkbox"] {
  width: 15px;
  height: 15px;
  position: relative;
  top: 2px;
  margin-right: 10px;
}

.order_button button {
  cursor: pointer;
  font-size: 16px;
  line-height: 30px;
  padding: 5px 10px;
  text-transform: capitalize;
  color: #ffffff;
  background: #<?php echo $conf_color;?>;
  font-weight: 500;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  margin-bottom: 0;
  border-radius: 5px;
}
.order_button button:hover {
  background: #262626;
}

@media only screen and (max-width: 767px) {
  .order-notes {
    margin-bottom: 58px;
  }
}
.order-notes textarea {
  border: 1px solid #e5e5e5;
  border-radius: 0;
  height: 45px;
  max-width: 100%;
  padding: 0 30px 0 20px;
  background: none;
  font-size: 13px;
  resize: none;
  line-height: 45px;
  width: 100%;
  color: #262626;
}
.order-notes label {
  line-height: 13px;
}

.Checkout_section {
  margin-bottom: 56px;
}
@media only screen and (max-width: 767px) {
  .Checkout_section {
    margin-bottom: 60px;
  }
}

.order_table {
  margin-bottom: 35px;
}
.order_table table {
  width: 100%;
}
.order_table table thead tr th {
  min-width: 50%;
  text-align: center;
  padding: 15px 0;
  border-bottom: 1px solid #ddd;
}
.order_table table tbody tr td {
  min-width: 50%;
  text-align: center;
  padding: 15px 0;
  border-bottom: 1px solid #ddd;
}
.order_table table tfoot tr th {
  min-width: 50%;
  text-align: center;
  padding: 15px 0;
  border-bottom: 1px solid #ddd;
}
.order_table table tfoot tr td {
  min-width: 50%;
  text-align: center;
  padding: 15px 0;
  border-bottom: 1px solid #ddd;
}

.panel-default input[type="radio"] {
  width: 15px;
  height: 15px;
  position: relative;
  top: 2px;
  margin-right: 10px;
}

.panel-default img {
  width: 160px;
}

.order_button button {
  border: 0;
}

.card-body1 {
  margin-bottom: 15px;
}

/*checkout page css end*/
/* 22. wishlist css here */
.table_desc.wishlist table tbody tr:last-child td, .action_links ul li.table_desc.compare table tbody tr:last-child td {
  border-bottom: 0;
}

.table_desc.wishlist table tbody tr td.product_total a, .action_links ul li.table_desc.compare table tbody tr td.product_total a {
  background: #<?php echo $conf_color;?>;
  font-size: 12px;
  font-weight: 700;
  height: 38px;
  line-height: 18px;
  padding: 10px 20px;
  color: #ffffff;
  text-transform: uppercase;
  border-radius: 3px;
}
.table_desc.wishlist table tbody tr td.product_total a:hover, .action_links ul li.table_desc.compare table tbody tr td.product_total a:hover {
  background: #262626;
}

.wishlist_share {
  text-align: center;
  padding: 20px 0;
  border: 1px solid #e5e5e5;
}
.wishlist_share h4 {
  font-size: 18px;
  font-weight: 600;
  text-transform: capitalize;
}
.wishlist_share ul li {
  display: inline-block;
}
.wishlist_share ul li a {
  padding: 0 10px;
  display: block;
}
.wishlist_share ul li a:hover {
  color: #<?php echo $conf_color;?>;
}

.wishlist_area {
  padding-bottom: 60px;
}

/*wishlist css end*/
/* 15. contact page css here */
.contact_area {
  margin-bottom: 60px;
}

.contact_message h3 {
  font-size: 21px;
  text-transform: capitalize;
  font-weight: 600;
  line-height: 20px;
  margin-bottom: 25px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .contact_message h3 {
    margin-bottom: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .contact_message h3 {
    font-size: 20px;
    margin-bottom: 20px;
  }
}
.contact_message p {
  font-size: 14px;
  line-height: 24px;
  margin-bottom: 20px;
}
.contact_message ul li {
  padding: 13px 0;
  border-top: 1px solid #e5e5e5;
}
.contact_message ul li:last-child {
  padding-bottom: 0;
}
.contact_message ul li i {
  margin-right: 10px;
}
.contact_message ul li a {
  color: #<?php echo $conf_color;?>;
}
.contact_message ul li a:hover {
  color: #262626;
}
.contact_message label {
  line-height: 18px;
  font-weight: 500;
  margin-bottom: 10px;
}
.contact_message input {
  border: 1px solid #e5e5e5;
  height: 45px;
  background: #ffffff;
  width: 100%;
  padding: 0 20px;
  color: #262626;
}
.contact_message textarea {
  height: 170px;
  border: 1px solid #e5e5e5;
  background: #ffffff;
  resize: none;
  margin-bottom: 20px;
  width: 100%;
  padding: 10px 20px;
  color: #262626;
}
.contact_message button {
  font-weight: 400;
  height: 42px;
  line-height: 42px;
  padding: 0 30px;
  text-transform: capitalize;
  border: none;
  background: #262626;
  color: #ffffff;
  cursor: pointer;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  border-radius: 4px;
}
.contact_message button:hover {
  background: #<?php echo $conf_color;?>;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .contact_message.content {
    margin-bottom: 52px;
  }
}
@media only screen and (max-width: 767px) {
  .contact_message.content {
    margin-bottom: 52px;
  }
}
.contact_message.form p.form-messege {
  margin-bottom: 0;
}

.contact_map {
  margin-bottom: 57px;
}

.map-area #googleMap {
  height: 460px;
  width: 100%;
}

/*contact page css end*/
/* 17. login page css here */
.account_form h2 {
  font-size: 28px;
  text-transform: capitalize;
  font-weight: 500;
  line-height: 22px;
  margin-bottom: 30px;
}
@media only screen and (max-width: 767px) {
  .account_form h2 {
    font-size: 24px;
    margin-bottom: 20px;
  }
}
.account_form form {
  border: 1px solid #e5e5e5;
  padding: 23px 20px 29px;
  border-radius: 5px;
}
.account_form label {
  font-size: 15px;
  font-weight: 400;
  cursor: pointer;
  line-height: 12px;
  margin-bottom: 12px;
}
.account_form label:hover {
  color: #<?php echo $conf_color;?>;
}
.account_form input {
  border: 1px solid #e5e5e5;
  height: 40px;
  max-width: 100%;
  padding: 0 20px;
  background: none;
  width: 100%;
}
.account_form button {
  background: #<?php echo $conf_color;?>;
  border: 0;
  color: #ffffff;
  display: inline-block;
  font-size: 12px;
  font-weight: 700;
  height: 34px;
  line-height: 21px;
  padding: 5px 20px;
  text-transform: uppercase;
  cursor: pointer;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  margin-left: 20px;
  border-radius: 20px;
}
.account_form button:hover {
  background: #262626;
}

.login_submit label input[type="checkbox"] {
  width: 15px;
  height: 13px;
  margin-right: 3px;
}

.login_submit {
  text-align: right;
}
.login_submit a {
  font-size: 13px;
  float: left;
  line-height: 39px;
}
.login_submit a:hover {
  color: #<?php echo $conf_color;?>;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .login_submit a {
    float: none;
    line-height: 18px;
    display: block;
    margin-bottom: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .login_submit a {
    float: none;
    line-height: 18px;
    display: block;
    margin-bottom: 20px;
  }
}

.customer_login {
  padding-bottom: 60px;
}

.account_form p {
  margin-bottom: 20px;
}

@media only screen and (max-width: 767px) {
  .account_form.register {
    margin-top: 57px;
  }
}

/*login page css end */
/* 16. faq page css here */
.faq_content_area {
  padding-bottom: 56px;
}
@media only screen and (max-width: 767px) {
  .faq_content_area {
    margin-top: 53px;
  }
}

.accordion_area {
  padding-bottom: 60px;
}

.card.card_dipult {
  border: none;
  margin-bottom: 10px;
}

.card.card_dipult:last-child {
  margin-bottom: 0;
}

.card-header.card_accor {
  padding: 0;
  border: none;
}
.card-header.card_accor button {
  height: 45px;
  text-decoration: none;
  cursor: pointer;
  position: relative;
  white-space: initial;
  box-shadow: inherit;
}
@media only screen and (max-width: 767px) {
  .card-header.card_accor button {
    height: 60px;
  }
}
.card-header.card_accor button i {
  position: absolute;
  top: 50%;
  -webkit-transform: translatey(-50%);
  transform: translatey(-50%);
  right: 20px;
}
@media only screen and (max-width: 767px) {
  .card-header.card_accor button i {
    right: 10px;
  }
}
.card-header.card_accor button.btn-link {
  border: 1px solid #e5e5e5;
  width: 100%;
  text-align: left;
  color: #262626;
  font-size: 14px;
  font-weight: 500;
}
.card-header.card_accor button.btn-link.collapsed {
  background: #f2f2f2;
  border: 1px solid #e5e5e5;
  width: 100%;
  text-align: left;
}

.card-header.card_accor button.btn-link i.fa-plus {
  display: none;
}

.card-header.card_accor button.btn-link.collapsed i.fa-plus {
  display: block;
}

.card-header.card_accor button.btn-link.collapsed i.fa-minus {
  display: none;
}

.faq_content_wrapper h4 {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 15px;
  line-height: 18px;
}
@media only screen and (max-width: 767px) {
  .faq_content_wrapper h4 {
    font-size: 14px;
    line-height: 24px;
  }
}
.faq_content_wrapper p {
  font-size: 15px;
}

/*faq page css end*/
/*  18. my account css here */
@media only screen and (max-width: 767px) {
  .dashboard_tab_button {
    margin-bottom: 20px;
  }
}
.dashboard_tab_button ul li {
  margin-bottom: 5px;
}
.dashboard_tab_button ul li a {
  font-size: 14px;
  color: #ffffff;
  font-weight: 500;
  text-transform: capitalize;
  background: #262626;
  border-radius: 0px;
}
.dashboard_tab_button ul li a:hover {
  background: #<?php echo $conf_color;?>;
  color: #ffffff;
}
.dashboard_tab_button ul li a.active {
  background: #<?php echo $conf_color;?>;
}

.main_content_area {
  padding: 60px 0 55px;
}

.dashboard_content h3 {
  font-size: 22px;
  text-transform: capitalize;
  font-weight: 600;
  margin-bottom: 15px;
}
.dashboard_content h4 {
  font-size: 20px;
  text-transform: capitalize;
  font-weight: 500;
  margin-bottom: 10px;
  margin-top: 10px;
}
.dashboard_content a {
  color: #<?php echo $conf_color;?>;
  font-weight: 500;
}
.dashboard_content p a {
  color: #<?php echo $conf_color;?>;
  font-weight: 500;
}

.save_button button {
  color: #<?php echo $conf_color;?>;
  font-weight: 500;
  border: 0;
  background: none;
}
.save_button button:hover {
  color: #262626;
}

.table-responsive table thead {
  background: #f2f2f2;
}
.table-responsive table thead tr th {
  text-align: center;
}
.table-responsive table tbody tr td {
  border-right: 1px solid #e5e5e5;
  font-weight: 500;
  text-transform: capitalize;
  font-size: 14px;
  text-align: center;
  min-width: 150px;
}
.table-responsive table tbody tr td:last-child a {
  color: #<?php echo $conf_color;?>;
}
.table-responsive .table {
  border-left: 1px solid #e5e5e5;
  border-bottom: 1px solid #e5e5e5;
  border-right: 1px solid #e5e5e5;
}

.dashboard_content address {
  font-weight: 500;
}

.input-radio span input[type="radio"], .account_login_form form span input[type="checkbox"] {
  width: 15px;
  height: 15px;
  margin-right: 2px;
  position: relative;
  top: 2px;
}

.input-radio span {
  font-weight: 500;
  padding-right: 10px;
}

.account_login_form form input {
  border: 1px solid #ddd;
  background: none;
  height: 40px;
  margin-bottom: 20px;
  width: 100%;
  padding: 0 20px;
  color: #262626;
}

/*my account css end*/
/* 10. about page css here */
.about_section {
  padding-bottom: 60px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .about_section {
    margin-top: 57px;
  }
}
@media only screen and (max-width: 767px) {
  .about_section {
    margin-top: 57px;
  }
}
.about_section.section_two {
  padding: 0 194px;
}
.about_section.section_two .about_thumb {
  text-align: center;
}
.about_section.section_two .about_content {
  margin-bottom: 25px;
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .about_thumb {
    margin-bottom: 20px;
  }
}
@media only screen and (max-width: 767px) {
  .about_thumb {
    margin-bottom: 19px;
  }
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .about_content {
    text-align: center;
  }
}
@media only screen and (max-width: 767px) {
  .about_content {
    text-align: center;
  }
}
.about_content h1 {
  font-weight: 500;
  line-height: 30px;
  text-transform: capitalize;
  font-size: 30px;
  margin-bottom: 19px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .about_content h1 {
    font-size: 27px;
    line-height: 25px;
    margin-bottom: 11px;
  }
}
@media only screen and (max-width: 767px) {
  .about_content h1 {
    font-size: 20px;
    line-height: 22px;
    margin-bottom: 12px;
  }
}
.about_content p {
  font-size: 15px;
  line-height: 30px;
  margin-bottom: 22px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .about_content p {
    line-height: 28px;
    margin-bottom: 10px;
  }
}
@media only screen and (max-width: 767px) {
  .about_content p {
    font-size: 13px;
    line-height: 24px;
    margin-bottom: 11px;
  }
}

@media only screen and (max-width: 767px) {
  .view__work {
    margin-top: 18px;
  }
}
.view__work a {
  border: 1px solid #bbbbbb;
  height: 40px;
  font-size: 13px;
  font-weight: 500;
  line-height: 38px;
  padding: 0 15px;
  display: inline-block;
  text-transform: uppercase;
  border-radius: 20px;
}
.view__work a:hover {
  background: #<?php echo $conf_color;?>;
  color: #fff;
  border-color: #<?php echo $conf_color;?>;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .view__work a {
    margin-top: 6px;
  }
}
@media only screen and (max-width: 767px) {
  .view__work a {
    height: 33px;
    font-size: 12px;
    line-height: 31px;
  }
}

.counterup_section {
  padding-bottom: 30px;
}

.counter_img {
  margin-right: 20px;
}
@media only screen and (max-width: 767px) {
  .counter_img {
    margin-right: 10px;
  }
}

.single_counterup {
  -webkit-box-pack: center;
  -ms-flex-pack: center;
  justify-content: center;
  background: #f3f3f3;
  padding: 88px 0 80px;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  margin-bottom: 30px;
}

.about_section.section_two {
  padding: 25px 20px 18px;
}

.counter_info h2 {
  font-size: 30px;
  font-weight: 500;
  margin-bottom: 5px;
  line-height: 33px;
  margin-bottom: 0;
}
@media only screen and (max-width: 767px) {
  .counter_info h2 {
    font-size: 22px;
    line-height: 30px;
  }
}
.counter_info p {
  font-size: 12px;
  text-transform: uppercase;
  font-weight: 600;
  margin-bottom: 0;
  line-height: 24px;
}
@media only screen and (max-width: 767px) {
  .counter_info p {
    font-size: 11px;
  }
}

.about_progressbar {
  padding-bottom: 60px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .about_progressbar {
    padding-bottom: 70px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .about_progressbar {
    padding-bottom: 70px;
  }
}
.about_progressbar.about_prog {
  background-color: #<?php echo $conf_color;?>;
  border-radius: 3px;
}
.about_progressbar.about_prog span.progress_persent {
  position: absolute;
  left: 50px;
  text-transform: uppercase;
}
.about_progressbar.porgress_two {
  padding: 5px 20px 35px;
}

@media only screen and (max-width: 767px) {
  .progressbar_inner {
    margin-bottom: 40px;
  }
}
.progressbar_inner h2 {
  font-size: 25px;
  margin-bottom: 40px;
  font-weight: 400;
  line-height: 18px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .progressbar_inner h2 {
    font-size: 21px;
    margin-bottom: 27px;
  }
}
@media only screen and (max-width: 767px) {
  .progressbar_inner h2 {
    font-size: 20px;
    margin-bottom: 30px;
  }
}

.progress_skill {
  position: relative;
  margin-bottom: 40px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .progress_skill {
    margin-bottom: 33px;
  }
}
.progress_skill:last-child {
  margin-bottom: 0;
}
.progress_skill span.progress_discount {
  position: absolute;
  left: -2px;
  background: #262626;
  border-radius: 100%;
  border: 3px solid #7b7b7b;
  color: #fff;
  width: 40px;
  height: 40px;
  top: 50%;
  -webkit-transform: translatey(-50%);
  transform: translatey(-50%);
  text-align: center;
  line-height: 35px;
  z-index: 9;
}
.progress_skill .progress-bar {
  background-color: #7b7b7b;
  text-align: left;
  padding-left: 50px;
}

.progress_skill.one .progress-bar {
  width: 60%;
}

.progress_skill.two .progress-bar {
  width: 90%;
}

.progress_skill.three .progress-bar {
  width: 70%;
}

.progress_skill.four .progress-bar {
  width: 80%;
}

/*about page css end*/
/* 20. services page css here */
.services_gallery {
  padding-bottom: 28px;
}

.services_content h3 {
  font-size: 15px;
  text-transform: capitalize;
  font-weight: 600;
  margin-bottom: 11px;
  line-height: 14px;
}
.services_content h3 a:hover {
  color:#<?php echo $conf_color;?>;
}
.services_content p {
  font-size: 14px;
  font-weight: 400;
  line-height: 24px;
  margin-bottom: 0;
}

.services_thumb {
  margin-bottom: 20px;
}
@media only screen and (max-width: 767px) {
  .services_thumb img {
    width: 100%;
  }
}

.single_services {
  margin-bottom: 25px;
}

.our_services {
  padding: 50px 0 25px;
  background: url(../img/about/service1-img1.jpg) no-repeat scroll center center/cover;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .our_services {
    margin-bottom: 60px;
  }
}
@media only screen and (max-width: 767px) {
  .our_services {
    margin-bottom: 60px;
  }
}

.services_item {
  margin-bottom: 27px;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
}

.services_title {
  text-align: center;
  margin-bottom: 35px;
}
.services_title h2 {
  font-size: 25px;
  text-transform: uppercase;
  font-weight: 700;
  margin-bottom: 11px;
  color: #fff;
}
.services_title p {
  color: #999;
}

.services_icone {
  margin-right: 15px;
}
.services_icone i {
  font-size: 35px;
  line-height: 46px;
  color: #4fc1f0;
}

.services_desc h3 {
  font-size: 13px;
  font-weight: 500;
  color: #fff;
}
.services_desc p {
  font-size: 13px;
  font-weight: 400;
  line-height: 24px;
  margin-bottom: 0;
  color: #999;
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .services_section_thumb {
    margin-bottom: 28px;
  }
}
@media only screen and (max-width: 767px) {
  .services_section_thumb {
    margin-bottom: 28px;
  }
}

@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .unlimited_services {
    margin: 60px 0;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .unlimited_services {
    margin-bottom: 59px;
  }
}
@media only screen and (max-width: 767px) {
  .unlimited_services {
    margin-bottom: 59px;
  }
}

.unlimited_services_content {
  text-align: center;
}
.unlimited_services_content h1 {
  font-weight: 600;
  line-height: 40px;
  text-transform: uppercase;
  font-size: 25px;
  margin-bottom: 20px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .unlimited_services_content h1 {
    line-height: 25px;
    font-size: 20px;
    margin-bottom: 12px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .unlimited_services_content h1 {
    line-height: 21px;
    font-size: 20px;
    margin-bottom: 6px;
  }
}
@media only screen and (max-width: 767px) {
  .unlimited_services_content h1 {
    line-height: 20px;
    font-size: 18px;
    margin-bottom: 6px;
  }
}
.unlimited_services_content p {
  font-size: 15px;
  line-height: 30px;
  margin-bottom: 25px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .unlimited_services_content p {
    font-size: 14px;
    margin-bottom: 15px;
  }
}
@media only screen and (max-width: 767px) {
  .unlimited_services_content p {
    font-size: 13px;
    margin-bottom: 15px;
  }
}

.priceing_table {
  background: url(../img/about/service1-img3.jpg) no-repeat scroll center center/cover;
  padding: 60px 0 30px;
}

.single_priceing {
  background: #fff;
  border-radius: 3px;
  -webkit-box-shadow: 0 1px #FFFFFF inset, 0 1px 3px rgba(34, 25, 25, 0.4);
  box-shadow: 0 1px #FFFFFF inset, 0 1px 3px rgba(34, 25, 25, 0.4);
  text-align: center;
  margin-bottom: 30px;
}

.priceing_title {
  padding: 20px;
  background: #<?php echo $conf_color;?>;
}
.priceing_title h1 {
  color: #fff;
  font-size: 14px;
  font-weight: 600;
  text-transform: uppercase;
  margin-bottom: 0;
}

.priceing_list {
  padding: 0 20px 30px;
}
.priceing_list h1 {
  font-size: 12px;
  font-weight: 500;
  text-transform: uppercase;
  padding: 36px 0 24px;
  margin: 0;
  line-height: 20px;
}
.priceing_list h1 span {
  font-size: 40px;
}
.priceing_list ul li {
  padding: 15px 0;
  border-bottom: 1px solid #e5e5e5;
  line-height: 24px;
}
.priceing_list ul li:first-child {
  border-top: 1px solid #e5e5e5;
}
.priceing_list a {
  margin: 30px 0 0;
  line-height: 38px;
  padding: 0 20px;
  border: 1px solid #262626;
  color: #262626;
  display: inline-block;
  font-size: 12px;
  font-weight: 600;
  border-radius: 30px;
  text-transform: uppercase;
}

.priceing_list a.list_button, .priceing_list a:hover {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  color: #fff;
}

/*services page css end*/
/* 11. blog page css here */
.single_blog {
  padding: 24px 30px 30px;
  border: 1px solid #e5e5e5;
}
@media only screen and (max-width: 767px) {
  .single_blog {
    padding: 20px 20px 23px;
  }
}

.blog_title {
  text-align: center;
  margin-bottom: 26px;
}
@media only screen and (max-width: 767px) {
  .blog_title {
    margin-bottom: 16px;
  }
}
.blog_title span a {
  color: #<?php echo $conf_color;?>;
  text-decoration: underline;
  font-size: 12px;
  font-weight: 700;
  text-transform: uppercase;
  padding: 0 6px;
  margin-bottom: 13px;
  display: inline-block;
  line-height: 25px;
}
@media only screen and (max-width: 767px) {
  .blog_title span a {
    margin-bottom: 10px;
  }
}
.blog_title span a:hover {
  color: #262626;
}
.blog_title h2 {
  font-size: 18px;
  line-height: 24px;
  font-weight: 700;
  text-transform: uppercase;
  letter-spacing: 1px;
  margin-bottom: 10px;
}
@media only screen and (max-width: 767px) {
  .blog_title h2 {
    font-size: 16px;
    margin-bottom: 8px;
    line-height: 18px;
  }
}
.blog_title h2 a:hover {
  color: #<?php echo $conf_color;?>;
}

.blog_post ul li {
  display: inline-block;
  display: inline-block;
  font-size: 13px;
  margin-right: 12px;
  padding-right: 12px;
  position: relative;
}
.blog_post ul li:last-child {
  margin: 0;
  padding: 0;
}
.blog_post ul li:last-child::before {
  display: none;
}
.blog_post ul li::before {
  position: absolute;
  content: "";
  width: 1px;
  height: 12px;
  background: #808080;
  right: 0;
  top: 50%;
  transform: translatey(-50%);
}

.blog_thumb {
  margin-bottom: 24px;
}
@media only screen and (max-width: 767px) {
  .blog_thumb {
    margin-bottom: 18px;
  }
}

.blog_social {
  display: flex;
}
.blog_social ul li {
  display: inline-block;
}
.blog_social ul li a {
  font-size: 13px;
  line-height: 26px;
  height: 26px;
  width: 26px;
  text-align: center;
  color: #353535;
  margin-right: 10px;
  background: #f7f7f7;
  display: block;
  border-radius: 50%;
}
@media only screen and (max-width: 767px) {
  .blog_social ul li a {
    font-size: 12px;
    line-height: 24px;
    height: 22px;
    width: 22px;
    margin-right: 2px;
  }
}
.blog_social ul li a:hover {
  background: #<?php echo $conf_color;?>;
  color: #ffffff;
}
.blog_social p {
  font-size: 15px;
  line-height: 26px;
  margin: 0 20px 0 0;
  text-transform: capitalize;
  font-weight: 700;
}
@media only screen and (max-width: 767px) {
  .blog_social p {
    margin: 0 14px 0 0;
  }
}

.blog_footer {
  display: flex;
  justify-content: space-between;
  margin-top: 30px;
}
@media only screen and (max-width: 767px) {
  .blog_footer {
    margin-top: 22px;
    flex-direction: column;
  }
}

.blog_content {
  text-align: center;
}
.blog_content > p {
  line-height: 22px;
  margin-bottom: 26px;
  font-size: 15px;
}
@media only screen and (max-width: 767px) {
  .blog_content > p {
    margin-bottom: 20px;
    font-size: 14px;
  }
}
.blog_content > a {
  font-weight: 500;
  height: 45px;
  letter-spacing: .2em;
  line-height: 45px;
  text-transform: uppercase;
  background: #262626;
  color: #ffffff;
  display: inline-block;
  font-size: 12px;
  padding: 0 30px;
  border-radius: 3px;
}
@media only screen and (max-width: 767px) {
  .blog_content > a {
    height: 36px;
    line-height: 36px;
    padding: 0 15px;
  }
}
.blog_content > a:hover {
  background: #<?php echo $conf_color;?>;
}

.blog_pagination .pagination {
  justify-content: center;
  border: 1px solid #e5e5e5;
  padding: 10px;
}

.blog_aduio_icone {
  margin-top: 30px;
  margin-bottom: 17px;
}
.blog_aduio_icone audio {
  width: 100%;
}

.blog_thumb_active:hover .owl-nav > * {
  opacity: 1;
  visibility: visible;
  left: 20px;
}
.blog_thumb_active:hover .owl-nav > *.owl-next {
  right: 20px;
}
.blog_thumb_active .owl-nav > * {
  position: absolute;
  top: 50%;
  transform: translateY(-50%);
  width: 40px;
  height: 40px;
  line-height: 38px;
  background: rgba(0, 0, 0, 0.5);
  text-align: center;
  color: #fff;
  font-size: 20px;
  border-radius: 50%;
  left: 50px;
  opacity: 0;
  visibility: hidden;
  -webkit-transition: 0.3s;
  transition: 0.3s;
}
.blog_thumb_active .owl-nav > *:hover {
  background: rgba(234, 0, 13, 0.5);
}
.blog_thumb_active .owl-nav > *.owl-next {
  right: 50px;
  left: auto;
}

@media only screen and (max-width: 767px) {
  .blog_comment {
    text-align: left;
    margin-top: 10px;
  }
}
.blog_comment a {
  font-size: 14px;
}
.blog_comment a:hover {
  color: #<?php echo $conf_color;?>;
}

/*13. blog  sidebar css here*/
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .blog_sidebar_widget {
    margin-top: 50px;
  }
}
@media only screen and (max-width: 767px) {
  .blog_sidebar_widget {
    margin-top: 50px;
  }
}
.blog_sidebar_widget .widget_list {
  border: 1px solid #e5e5e5;
}
.blog_sidebar_widget .widget_list h2 {
  font-size: 14px;
  margin-bottom: 25px;
  padding-bottom: 10px;
  text-transform: uppercase;
  font-weight: 700;
  line-height: 20px;
  border-bottom: 1px solid #e5e5e5;
  background: #262626;
  border-radius: 3px 3px 0 0;
  color: #ffffff;
  padding: 15px 20px;
  border-bottom: 0;
  letter-spacing: 1px;
}
.blog_sidebar_widget .widget_list ul {
  padding: 0 20px 25px;
}
.blog_sidebar_widget .widget_list.widget_tags ul {
  padding: 0 20px 20px;
}

.widget_search form {
  margin: 0 20px 25px;
  position: relative;
}
.widget_search form input {
  width: 100%;
  background: none;
  height: 40px;
  border: 1px solid #e5e5e5;
  border-radius: 0;
  padding: 0 42px 0 15px;
}
.widget_search form button {
  position: absolute;
  right: 6px;
  top: 0;
  border: none;
  font-size: 16px;
  height: 100%;
  cursor: pointer;
  -webkit-transition: .3s;
  transition: .3s;
  background: inherit;
}
.widget_search form button:hover {
  color: #<?php echo $conf_color;?>;
}

.tag_cloud ul li {
  display: inline-block;
}
.tag_cloud ul li a {
  margin: 0 2px 6px 0;
  padding: 3px 12px;
  display: inline-block;
  border: 1px solid #e5e5e5;
}
.tag_cloud ul li a:hover {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
  color: #ffffff;
}

/*blog sidebar css here*/
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .blog_reverse .row {
    flex-direction: column-reverse;
  }
}
@media only screen and (max-width: 767px) {
  .blog_reverse .row {
    flex-direction: column-reverse;
  }
}

/* 12. blog details css here */
.blog_details_wrapper .blog_thumb {
  margin-bottom: 21px;
  width: inherit;
}
.blog_details_wrapper .blog_thumb::before {
  display: none;
}
.blog_details_wrapper .blog_content {
  padding: 0;
  width: inherit;
}
.blog_details_wrapper .blog_content h3 {
  font-size: 24px;
  text-transform: inherit;
  font-weight: 600;
  margin-bottom: 19px;
  line-height: 26px;
  padding-bottom: 0;
}
.blog_details_wrapper .blog_content h3::before {
  display: none;
}
.blog_details_wrapper .post_meta {
  margin-bottom: 14px;
}
.blog_details_wrapper .post_meta span {
  margin-right: 5px;
}
.blog_details_wrapper .post_meta span:last-child {
  margin-right: 0;
}
.blog_details_wrapper .post_meta span a:hover {
  color: #<?php echo $conf_color;?>;
}
.blog_details_wrapper .post_content {
  text-align: left;
}
.blog_details_wrapper .post_content > p {
  line-height: 24px;
  margin-bottom: 10px;
  font-size: 15px;
}
@media only screen and (max-width: 767px) {
  .blog_details_wrapper .post_content > p {
    font-size: 14px;
  }
}
.blog_details_wrapper .post_content blockquote {
  border-left: 4px solid #<?php echo $conf_color;?>;
  font-size: 16px;
  font-weight: 600;
  margin: 20px 0 20px 0;
  padding: 0 20px;
  font-style: italic;
}
@media only screen and (max-width: 767px) {
  .blog_details_wrapper .post_content blockquote {
    font-size: 15px;
  }
}
.blog_details_wrapper .social_sharing {
  display: flex;
}
.blog_details_wrapper .social_sharing p {
  font-size: 14px;
  text-transform: capitalize;
  margin-right: 20px;
  margin-bottom: 0;
  font-weight: 700;
}
@media only screen and (max-width: 767px) {
  .blog_details_wrapper .social_sharing p {
    margin-right: 9px;
    font-size: 13px;
  }
}
.blog_details_wrapper .social_sharing ul li {
  display: inline-block;
}
.blog_details_wrapper .social_sharing ul li a {
  background: #e6e6e6;
  border-radius: 100%;
  display: inline-block;
  font-size: 12px;
  height: 26px;
  line-height: 26px;
  margin-right: 5px;
  text-align: center;
  width: 26px;
}
@media only screen and (max-width: 767px) {
  .blog_details_wrapper .social_sharing ul li a {
    margin-right: 2px;
    font-size: 11px;
    height: 22px;
    width: 22px;
    line-height: 22px;
  }
}
.blog_details_wrapper .social_sharing ul li a:hover {
  color: #ffffff;
  background: #<?php echo $conf_color;?>;
}
.blog_details_wrapper .social_sharing ul li:first-child a {
  padding-left: 0;
  border-left: 0;
}

.entry_content {
  border-bottom: 1px solid #e5e5e5;
  padding-bottom: 26px;
  margin-bottom: 42px;
  margin-top: 19px;
  display: flex;
  justify-content: space-between;
  align-items: center;
}
@media only screen and (max-width: 767px) {
  .entry_content {
    flex-direction: column;
    text-align: left;
    align-items: inherit;
  }
}
.entry_content .post_meta {
  margin-bottom: 0;
}
@media only screen and (max-width: 767px) {
  .entry_content .post_meta {
    margin-bottom: 10px;
  }
}
.entry_content .post_meta span {
  font-weight: 700;
}
.entry_content .post_meta span:hover {
  color: #<?php echo $conf_color;?>;
}

.comments_area {
  padding: 24px 30px 33px;
  border: 1px solid #e5e5e5;
}
@media only screen and (max-width: 767px) {
  .comments_area {
    padding: 24px 20px 33px;
  }
}

.comments_box {
  margin-bottom: 44px;
}
.comments_box h3 {
  font-size: 14px;
  margin: 0 0 20px;
  font-weight: 700;
  line-height: 20px;
  text-transform: uppercase;
  letter-spacing: 1px;
}

.comment_list {
  overflow: hidden;
  margin-bottom: 30px;
}
.comment_list:last-child {
  margin-bottom: 0;
}
.comment_list .comment_thumb {
  display: inline-block;
  float: left;
}
@media only screen and (max-width: 767px) {
  .comment_list .comment_thumb {
    width: 40px;
  }
}
.comment_list .comment_content {
  margin-left: 70px;
  position: relative;
  border: 1px solid #ebebeb;
  border-radius: 3px;
  padding: 15px;
}
@media only screen and (max-width: 767px) {
  .comment_list .comment_content {
    margin-left: 48px;
  }
}
.comment_list .comment_content h5 {
  font-size: 12px;
  font-weight: 600;
  text-transform: uppercase;
  margin-bottom: 5px;
}
.comment_list .comment_content h5 a:hover {
  color: #<?php echo $conf_color;?>;
}
.comment_list .comment_content span {
  line-height: 18px;
  margin-bottom: 8px;
  font-size: 13px;
  font-style: italic;
  display: inline-block;
}
.comment_list .comment_content p {
  margin-bottom: 0;
  font-size: 14px;
}

.comment_reply {
  position: absolute;
  top: 20px;
  right: 12px;
}
@media only screen and (max-width: 767px) {
  .comment_reply {
    top: 13px;
  }
}
.comment_reply a {
  padding: 2px 10px;
  border-radius: 3px;
  color: #fff;
  background: #262626;
  display: block;
}
.comment_reply a:hover {
  background: #<?php echo $conf_color;?>;
}
@media only screen and (max-width: 767px) {
  .comment_reply a {
    padding: 2px 8px;
    font-size: 12px;
    line-height: 21px;
  }
}

.comments_form h3 {
  font-size: 14px;
  margin: 0 0 20px;
  font-weight: 700;
  line-height: 20px;
  text-transform: uppercase;
  letter-spacing: 1px;
}
.comments_form p {
  font-size: 14px;
  line-height: 17px;
  margin-bottom: 12px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .comments_form form .row {
    flex-direction: row;
  }
}
.comments_form form label {
  font-size: 14px;
  line-height: 20px;
  font-weight: 600;
  margin-bottom: 10px;
}
.comments_form form textarea {
  width: 100%;
  height: 200px;
  background: #ffffff;
  border: 1px solid #e5e5e5;
  margin-bottom: 10px;
  resize: none;
  padding: 10px;
}
.comments_form form input {
  width: 100%;
  height: 40px;
  border: 1px solid #e5e5e5;
  margin-bottom: 15px;
  padding: 0 20px;
}
.comments_form form button {
  border: 0;
  line-height: 36px;
  background: #333;
  font-weight: 500;
}
.comments_form form button:hover {
  background: #<?php echo $conf_color;?>;
}

.comment_list.list_two {
  padding-left: 50px;
}
@media only screen and (max-width: 767px) {
  .comment_list.list_two {
    padding-left: 0;
  }
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .related_posts .row {
    flex-direction: row !important;
  }
}
.related_posts > h3 {
  font-size: 14px;
  margin: 0 0 20px;
  font-weight: 700;
  line-height: 20px;
  text-transform: uppercase;
  letter-spacing: 1px;
}

.related_thumb {
  margin-bottom: 20px;
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .related_thumb img {
    width: 100%;
  }
}
@media only screen and (max-width: 767px) {
  .related_thumb img {
    width: 100%;
  }
}

.related_content h4 {
  font-size: 14px;
  font-weight: 700;
  line-height: 19px;
  margin-bottom: 5px;
  text-transform: uppercase;
}
.related_content h4 a:hover {
  color: #<?php echo $conf_color;?>;
}
.related_content span {
  font-size: 13px;
  line-height: 17px;
}
.related_content span i {
  margin-right: 3px;
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .blog_details .blog_sidebar {
    margin-bottom: 0;
  }
}
@media only screen and (max-width: 767px) {
  .blog_details .blog_sidebar {
    margin-bottom: 0;
  }
}

@media only screen and (max-width: 767px) {
  .single_related {
    margin-bottom: 24px;
  }
}

@media only screen and (min-width: 768px) and (max-width: 991px) {
  .single_related.column_3 {
    margin-top: 24px;
  }
}
@media only screen and (max-width: 767px) {
  .single_related.column_3 {
    margin-bottom: 0;
  }
}

/*blog details css end*/
/*  24. modal css here */
.modal-dialog.modal-dialog-centered {
  min-width: 1100px;
}
@media only screen and (min-width: 1200px) and (max-width: 1600px) {
  .modal-dialog.modal-dialog-centered {
    min-width: 1000px;
  }
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .modal-dialog.modal-dialog-centered {
    min-width: 950px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .modal-dialog.modal-dialog-centered {
    min-width: 730px;
  }
}
@media only screen and (max-width: 767px) {
  .modal-dialog.modal-dialog-centered {
    min-width: 90%;
  }
}

.modal_tab_img {
  text-align: center;
  margin-bottom: 10px;
}
.modal_tab_img img {
  margin: 0 auto;
}

.modal_tab_button ul li a {
  padding: 0;
  border: 1px solid #e5e5e5;
  margin: 0 4px;
}
.modal_tab_button ul li a img {
  width: 100%;
}

.modal_title h2 {
  font-size: 16px;
  text-transform: uppercase;
  font-weight: 600;
  margin-bottom: 14px;
  line-height: 26px;
}

.modal_title li a:hover {
color:#<?php echo $conf_color;?>; 

}

.modal_social h2 {
  font-size: 16px;
  text-transform: uppercase;
  font-weight: 600;
  margin-bottom: 15px;
  line-height: 20px;
}
.modal_social ul li {
  display: inline-block;
  margin-right: 3px;
}
.modal_social ul li a {
  text-transform: uppercase;
  display: inline-block;
  width: 38px;
  height: 38px;
  text-align: center;
  line-height: 38px;
  border-radius: 50%;
  font-size: 15px;
  color: #ffffff;
  font-weight: 400;
}
.modal_social ul li.facebook a {
  background: #3c5b9b;
}
.modal_social ul li.facebook a:hover {
  background: #<?php echo $conf_color;?>;
}
.modal_social ul li.twitter a {
  background: #1DA1F2;
}
.modal_social ul li.twitter a:hover {
  background: #<?php echo $conf_color;?>;
}
.modal_social ul li.pinterest a {
  background: #BD081B;
}
.modal_social ul li.pinterest a:hover {
  background: #<?php echo $conf_color;?>;
}
.modal_social ul li.google-plus a {
  background: #DC5043;
}
.modal_social ul li.google-plus a:hover {
  background: #<?php echo $conf_color;?>;
}
.modal_social ul li.linkedin a {
  background: #010103;
}
.modal_social ul li.linkedin a:hover {
  background: #<?php echo $conf_color;?>;
}

.modal_price {
  margin-bottom: 12px;
}
.modal_price span {
  font-weight: 600;
  color: #<?php echo $conf_color;?>;
  font-size: 16px;
}
.modal_price span.old_price {
  color: #262626;
  font-size: 14px;
  font-weight: 400;
  text-decoration: line-through;
  margin-left: 5px;
}

.modal_description p {
  line-height: 24px;
  font-size: 15px;
  margin: 0;
}

.variants_size h2, .variants_color h2 {
  font-size: 16px;
  font-weight: 600;
  text-transform: uppercase;
  margin-bottom: 7px;
  line-height: 20px;
}
.variants_size.mb-15, .mb-15.variants_color {
  margin-bottom: 24px;
}
.variants_size .select_option, .variants_color .select_option {
  width: 100%;
  border-radius: 0;
  margin-bottom: 25px;
}
.variants_size .select_option .list, .variants_color .select_option .list {
  width: 100%;
  border-radius: 0;
}

.modal_add_to_cart {
  margin-bottom: 25px;
}
.modal_add_to_cart form input {
  width: 95px;
  border: 1px solid #e5e5e5;
  background: none;
  padding: 0 10px;
  height: 45px;
}
@media only screen and (max-width: 767px) {
  .modal_add_to_cart  input {
    width: 75px;
  }
}
.modal_add_to_cart  button {
  background: none;
  border: 0;
  margin-left: 10px;
  font-size: 12px;
  font-weight: 700;
  height: 45px;
  width: 230px;
  line-height: 18px;
  padding: 10px 15px;
  text-transform: uppercase;
  background: #262626;
  color: #ffffff;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  cursor: pointer;
}

.modal_add_to_cart1  button {
  background: none;
  border: 0;
  font-size: 12px;
  font-weight: 700;
  height: 45px;
  width: 230px;
  line-height: 18px;
  padding: 10px 15px;
  text-transform: uppercase;
  background: #262626;
  color: #ffffff;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  cursor: pointer;
}

.modal_add_to_cart1 button:hover {
  background: #<?php echo $conf_color;?>;
  color: #ffffff;
  border-color: #<?php echo $conf_color;?>
;
}


@media only screen and (max-width: 767px) {
  .modal_add_to_cart  button {
    width: 130px;
  }
}
.modal_add_to_cart button:hover {
  background: #<?php echo $conf_color;?>;
  color: #ffffff;
  border-color: #<?php echo $conf_color;?>
;
}
.modal_add_to_cart select .select_option option:hover {
  background: #<?php echo $conf_color;?>;
  color: #ffffff;
  border-color: #<?php echo $conf_color;?>
;
}

.modal_body {
  padding: 29px 6px 38px;
}
@media only screen and (max-width: 767px) {
  .modal_body .modal_tab {
    margin-bottom: 60px;
  }
}

.modal-content {
  border-radius: 0;
}

.modal-content button.close {
  position: absolute;
  left: 94%;
  width: 35px;
  height: 35px;
  display: block;
  border: 1px solid #e5e5e5;
  top: 10px;
  border-radius: 50%;
  cursor: pointer;
  font-size: 20px;
  z-index: 9;
}
@media only screen and (max-width: 767px) {
  .modal-content button.close {
    left: 83%;
    width: 29px;
    height: 32px;
    top: 4px;
    margin-bottom: 14px;
  }
}
.modal-content button.close:hover {
  color: #<?php echo $conf_color;?>
;
}

.modal-content button.close1 {
  position: absolute;
  left: 94%;
  width: 30px;
  height: 30px;
  display: block;
  border: 1px solid #D6D2D2;
  color:#fff;
  border-radius: 50%;
  cursor: pointer;
  font-size: 20px;
  z-index: 9;
}

.modal-content button span.close1 {
color:red;
}

.modal-content button.close1:hover {
  color: #<?php echo $conf_color;?>;
}
.modal-content button.close1 {
    color: #000;
    padding: 1px;
      background-color: #F6F4EF;
  }
.modal_add_to_cart.mb-15 {
  margin-bottom: 23px;
}

.modal_description.mb-15 {
  margin-bottom: 20px;
}

.product_navactive.owl-carousel:hover .owl-nav > * {
  opacity: 1;
  visibility: visible;
}
.product_navactive.owl-carousel .owl-nav {
  display: block;
}
.product_navactive.owl-carousel .owl-nav > * {
  position: absolute;
  background: #f2f2f2;
  border-radius: 3px;
  height: 32px;
  top: 50%;
  transform: translatey(-50%);
  width: 32px;
  text-align: center;
  line-height: 32px;
  left: -7px;
  font-size: 18px;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  opacity: 0;
  visibility: hidden;
}
.product_navactive.owl-carousel .owl-nav > *:hover {
  background: #<?php echo $conf_color;?> !important;
  color: #ffffff !important;
}
.product_navactive.owl-carousel .owl-nav > *.owl-next {
  right: -7px;
  left: auto;
}

/*modal css end*/
/*  23. newsletter popup css here */
.newletter-popup {
  background: #fff;
  top: 50% !important;
  margin-top: -179px;
  position: fixed !important;
  padding: 50px;
  text-align: center;
  display: none;
}
@media only screen and (max-width: 767px) {
  .newletter-popup {
    padding: 30px 20px;
    width: 95%;
  }
}

#boxes .newletter-title h2 {
  font-size: 30px;
  text-transform: uppercase;
  margin: 0 0 30px;
}
@media only screen and (max-width: 767px) {
  #boxes .newletter-title h2 {
    font-size: 22px;
    margin: 0 0 10px;
  }
}

#boxes .box-content label {
  font-weight: 400;
  font-size: 14px;
}

#boxes .box-content .newletter-label {
  width: 70%;
  margin-bottom: 36px;
}
@media only screen and (max-width: 767px) {
  #boxes .box-content .newletter-label {
    width: 100%;
  }
}

#frm_subscribe form {
  width: 340px;
  margin: 0 auto;
  position: relative;
}
@media only screen and (max-width: 767px) {
  #frm_subscribe form {
    width: 100%;
  }
}
#frm_subscribe form input {
  background: #EBEBEB;
  padding: 0 122px 0 20px;
  height: 45px;
  border: 0;
  width: 100%;
  color: #747474;
  margin-bottom: 0;
}
@media only screen and (max-width: 767px) {
  #frm_subscribe form input {
    padding: 0 104px 0 20px;
  }
}
#frm_subscribe form a.theme-btn-outlined {
  position: absolute;
  top: 0;
  right: 0;
  height: 100%;
  width: 110px;
  background: #262626;
  cursor: pointer;
  color: #ffffff;
  text-transform: uppercase;
  font-size: 12px;
  font-weight: 600;
  -webkit-transition: 0.3s;
  transition: 0.3s;
  line-height: 45px;
}
#frm_subscribe form a.theme-btn-outlined:hover {
  background: #<?php echo $conf_color;?>;
}
@media only screen and (max-width: 767px) {
  #frm_subscribe form a.theme-btn-outlined {
    width: 90px;
  }
}

#boxes .box-content .subscribe-bottom {
  margin-top: 20px;
}

#boxes .box-content .subscribe-bottom label {
  margin: 0;
  font-size: 13px;
}

#boxes .box-content .subscribe-bottom #newsletter_popup_dont_show_again {
  display: inline-block;
  margin: 0;
}

#boxes #frm_subscribe #notification {
  color: #f00;
}

#boxes #frm_subscribe #notification .success {
  color: #67D7BB;
}

#popup2 {
  position: absolute;
  right: 1px;
  top: 1px;
  text-align: center;
  cursor: pointer;
  font-size: 13px;
  text-transform: capitalize;
  padding: 6px 12px;
  background: #262626;
  font-weight: 600;
  line-height: 17px;
  color: #ffffff;
  display: block;
  transition: 0.3s;
}
#popup2:hover {
  background: #<?php echo $conf_color;?>;
}

/*newsletter popup css end*/
/* 09. error page css heer   */
.header_error {
  border-bottom: 1px solid #e5e5e5;
}

.error_form {
  text-align: center;
}
.error_form h1 {
  font-size: 200px;
  font-weight: 700;
  color: #<?php echo $conf_color;?>;
  letter-spacing: 10px;
  line-height: 160px;
  margin: 0 0 60px;
}
@media only screen and (max-width: 767px) {
  .error_form h1 {
    font-size: 130px;
    line-height: 120px;
    letter-spacing: 4px;
    margin: 0 0 18px;
  }
}
.error_form h2 {
  font-size: 24px;
  text-transform: uppercase;
  font-weight: 500;
  line-height: 30px;
  margin-bottom: 24px;
}
@media only screen and (max-width: 767px) {
  .error_form h2 {
    font-size: 18px;
    line-height: 22px;
    margin-bottom: 23px;
  }
}
.error_form p {
  font-size: 17px;
  font-weight: 400;
  line-height: 26px;
  margin-bottom: 30px;
}
@media only screen and (max-width: 767px) {
  .error_form p {
    font-size: 15px;
    margin-bottom: 28px;
    line-height: 23px;
  }
}
.error_form form {
  width: 450px;
  margin: 0 auto;
  position: relative;
}
@media only screen and (max-width: 767px) {
  .error_form form {
    width: 100%;
  }
}
.error_form form input {
  padding: 0 60px 0 30px;
  background: #f8f8f8;
  border: 1px solid #ddd;
  color: #262626;
  height: 40px;
  width: 100%;
  border-radius: 3px;
}
.error_form form button {
  position: absolute;
  right: 0;
  height: 100%;
  border: none;
  background: no-repeat;
  font-size: 20px;
  color: #262626;
  cursor: pointer;
  -webkit-transition: .3s;
  transition: .3s;
  top: 0;
  text-transform: uppercase;
  padding: 0 15px;
  font-weight: 600;
}
.error_form form button:hover {
  color: #<?php echo $conf_color;?>;
}
.error_form a {
  color: #fff;
  display: inline-block;
  background: #<?php echo $conf_color;?>;
  font-size: 12px;
  font-weight: bold;
  height: 40px;
  line-height: 41px;
  padding: 0 30px;
  text-transform: uppercase;
  margin-top: 35px;
  border-radius: 3px;
}
.error_form a:hover {
  background: #262626;
}

.error_section {
  padding-bottom: 70px;
  padding-top: 59px;
}
@media only screen and (max-width: 767px) {
  .error_section {
    padding-bottom: 60px;
    padding-top: 25px;
  }
}

/*404 page css end*/
/* 25. portfolio css here */
.portfolio_section_area {
  padding-bottom: 30px;
}

.portfolio_button {
  padding: 50px 0;
  background: #f5f5f5;
  margin-bottom: 30px;
}
@media only screen and (max-width: 767px) {
  .portfolio_button {
    padding: 50px 0 40px;
  }
}

.portfolio_tab_button {
  text-align: center;
}
.portfolio_tab_button ul li {
  display: inline-block;
}

.portfolio_link {
  position: absolute;
  top: 50%;
  text-align: center;
  -webkit-transform: translatey(-50%);
  transform: translatey(-50%);
  right: 15px;
  height: 60px;
  width: 60px;
  background-color: #0162bd;
  border: 3px solid #fff;
  border-radius: 50%;
  -webkit-transition: .3s;
  transition: .3s;
  opacity: 0;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .portfolio_link {
    height: 50px;
    width: 50px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .portfolio_link {
    height: 50px;
    width: 50px;
  }
}
@media only screen and (max-width: 767px) {
  .portfolio_link {
    height: 50px;
    width: 50px;
  }
}
.portfolio_link:hover {
  background: #<?php echo $conf_color;?>;
  border-color: #<?php echo $conf_color;?>;
}
.portfolio_link a {
  color: #ffffff;
  font-size: 16px;
  line-height: 56px;
  display: block;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .portfolio_link a {
    line-height: 46px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .portfolio_link a {
    line-height: 46px;
  }
}
@media only screen and (max-width: 767px) {
  .portfolio_link a {
    line-height: 46px;
  }
}

.portfolio_popup {
  position: absolute;
  top: 50%;
  left: 0;
  right: 0;
  text-align: center;
  -webkit-transform: translatey(-50%);
  transform: translatey(-50%);
}
.portfolio_popup a {
  font-size: 16px;
  line-height: 22px;
  color: #ffffff;
  font-weight: 400;
  border-radius: 50%;
  background-color: #0162bd;
  display: inline-block;
  text-align: center;
  -webkit-transition: .3s;
  transition: .3s;
  opacity: 0;
  padding: 0;
}
.portfolio_popup a:hover {
  background: #<?php echo $conf_color;?>;
}

.single_portfolio_inner {
  position: relative;
  margin-bottom: 30px;
}
.single_portfolio_inner:hover .portfolio_link {
  top: 80%;
  opacity: 1;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .single_portfolio_inner:hover .portfolio_link {
    top: 76%;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .single_portfolio_inner:hover .portfolio_link {
    top: 76%;
  }
}
@media only screen and (max-width: 767px) {
  .single_portfolio_inner:hover .portfolio_link {
    top: 76%;
  }
}
.single_portfolio_inner:hover .portfolio_popup a {
  opacity: 1;
  padding: 15px 18px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .single_portfolio_inner:hover .portfolio_popup a {
    padding: 12px 15px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .single_portfolio_inner:hover .portfolio_popup a {
    padding: 12px 15px;
  }
}
@media only screen and (max-width: 767px) {
  .single_portfolio_inner:hover .portfolio_popup a {
    padding: 12px 15px;
  }
}
.single_portfolio_inner:hover .portfolio_content {
  opacity: 1;
  visibility: visible;
}
.single_portfolio_inner:hover .portfolio_thumb::before {
  opacity: 0.5;
}

.portfolio_content {
  background: #f5f5f5;
  padding: 15px 20px;
  opacity: 0;
  visibility: hidden;
  position: absolute;
  z-index: 999;
  width: 100%;
  -webkit-transition: .3s;
  transition: .3s;
}
.portfolio_content > a {
  font-size: 17px;
  font-weight: 700;
  display: block;
  line-height: 29px;
}
@media only screen and (min-width: 992px) and (max-width: 1199px) {
  .portfolio_content > a {
    font-size: 16px;
  }
}
@media only screen and (min-width: 768px) and (max-width: 991px) {
  .portfolio_content > a {
    font-size: 16px;
  }
}
@media only screen and (max-width: 767px) {
  .portfolio_content > a {
    font-size: 16px;
  }
}
.portfolio_content > a:hover {
  color: #<?php echo $conf_color;?>;
}
.portfolio_content span {
  text-transform: capitalize;
  font-weight: 400;
}

.portfolio_thumb {
  position: relative;
}
.portfolio_thumb::before {
  position: absolute;
  content: "";
  width: 100%;
  height: 100%;
  background: #000;
  opacity: 0;
  -webkit-transition: .3s;
  transition: .3s;
}
.portfolio_thumb img {
  width: 100%;
}

.portfolio_tab {
  padding: 0 15px;
}

.portfolio_tab_button button {
  background: #fff;
  border-right: 2px solid #f5f5f5;
  line-height: 45px;
  padding: 0 30px;
  font-size: 12px;
  text-transform: capitalize;
  font-weight: 700;
  position: relative;
  display: inline-block;
  border: none;
  cursor: pointer;
  -webkit-transition: .3s;
  transition: .3s;
}
@media only screen and (max-width: 767px) {
  .portfolio_tab_button button {
    line-height: 38px;
    margin-bottom: 10px;
    margin-right: 10px;
    padding: 0 21px;
  }
}
.portfolio_tab_button button:hover {
  color: #fff;
  background: #0162bd;
}
.portfolio_tab_button button.active {
  color: #fff;
  background: #0162bd;
}
.portfolio_tab_button button::before {
  content: "";
  display: block;
  position: absolute;
  top: 2px;
  right: 2px;
  border-color: transparent;
  border-width: 5px;
  border-style: solid;
  border-top-color: #fff;
  border-right-color: #fff;
  -webkit-transition: .3s;
  transition: .3s;
}

/*portfolio page css end*/

/*# sourceMappingURL=style.css.map */
</style>