<?php 
session_start();
require_once ("../conexion.php");
require_once('../include/sesiones.php');

// Validar y obtener variables del formulario con valores por defecto
$pen_id = isset($_POST['pen_id']) ? $_POST['pen_id'] : ''; // ID del pedido pendiente
$forma_pago = isset($_POST['forma_pago']) ? $_POST['forma_pago'] : ''; // Forma de pago (efectivo, tarjeta, etc.)
$precios = isset($_POST['precios_articulos']) ? $_POST['precios_articulos'] : []; // Precios de los artículos
$precios_combos = isset($_POST['precios_combos']) ? $_POST['precios_combos'] : []; // Precios de los combos
$articulos = isset($_POST['articulos']) ? $_POST['articulos'] : []; // Lista de artículos seleccionados
$combos = isset($_POST['combos']) ? $_POST['combos'] : []; // Lista de combos seleccionados

// Validar que haya al menos un artículo o combo seleccionado
if (empty($articulos) && empty($combos)) {
     echo '<div class="alert alert-warning alert-dismissable">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <strong>Debes selecionar un articulo para realizar el abono </strong>
    </div>';
    exit;
}

// Determinar el medio de pago según la forma de pago
$medio_pago = '';
if ($forma_pago === 'efectivo') {
    $medio_pago = 'Efectivo';
} elseif ($forma_pago === 'transferencia' || $forma_pago === 'tarjeta') {
    // Validar si medio_pago está presente
    $medio_pago = isset($_POST['medio_pago']) ? $_POST['medio_pago'] : '';
}

// Inicialización de variables de totales
$neto = 0;
$descuentof = 0;
$sumador_total = 0;

// Calcular totales de artículos facturados
$sql = mysqli_query($con, "SELECT * FROM pedido_detalle WHERE pedido_pen_id='$pen_id' AND pend_estado='facturado'");
while ($row = mysqli_fetch_array($sql)) {
    $pend_id = $row["pend_id"];
    $vent_cantidad = $row['pend_cantidad'];
    $vent_precio = $row['pend_precio'];
    $vent_descuento = $row['pend_descuento'];

    $total_sab = 0;
    $suma_sab = 0;

    // Calcular precios adicionales por sabores
    $sql1 = mysqli_query($con, "SELECT * FROM sabores_pedido_temp WHERE pend_id='$pend_id'");
    while ($sab = mysqli_fetch_array($sql1)) {
        $sab_precio = $sab["precio"] * $sab['cantidad'] * $vent_cantidad;
        $suma_sab += $sab_precio;
    }

    $total_sab = $suma_sab;
    $vent_precio_total = $vent_precio * $vent_cantidad + $total_sab;
    $descuento = ($vent_descuento / 100) * $vent_precio_total;
    $precio_descuento_t = $vent_precio_total - $descuento;
    
    $neto += $vent_precio_total;
    $descuentof += $descuento;
    $sumador_total = $neto - $descuentof;
}

// Calcular totales de combos facturados
$descuento_combo_total = 0;
$neto_combo = 0;
$sumador_combo = 0;

$sql2 = mysqli_query($con, "SELECT * FROM pedido_detalle_combo WHERE pedido_pen_id='$pen_id' AND pend_estado='facturado'");
while ($row2 = mysqli_fetch_array($sql2)) {
    $pedcom_id = $row2['pedcom_id'];
    $pedcom_cantidad = $row2['pedcom_cantidad'];
    $pend_desc = $row2['pend_desc'];
    $pedcom_precio = $row2['pedcom_precio'];
    
    $precio_total = $pedcom_cantidad * $pedcom_precio;
    $descuento_combo_total += ($pend_desc / 100) * $precio_total;
    $neto_combo += $precio_total;
    $sumador_combo = $neto_combo - $descuento_combo_total;
}

$suma_pedido = $sumador_total + $sumador_combo;

// Obtener el siguiente ID de abono temporal
$can = mysqli_query($con, "SELECT MAX(ped_abo_id) as ped_abo_id FROM pedido_abono_temp") or die(mysqli_error($con)); 
$dato = mysqli_fetch_array($can);
$ped_abo_id = $dato['ped_abo_id'] + 1;

// Calcular cuánto se ha abonado hasta ahora
$tarjer = mysqli_query($con, "SELECT SUM(ped_abono) as total_suma FROM pedido_abono_temp WHERE pedido_pen_id='$pen_id'");
$tarjer = mysqli_fetch_array($tarjer);
$total_suma = isset($tarjer['total_suma']) ? $tarjer['total_suma'] : 0;

// Verificar si ya se abonó el total
$resta_abonos = $suma_pedido - $total_suma;

if ($total_suma >= $suma_pedido) {
    echo '<div class="alert alert-warning alert-dismissable">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <strong>No </strong> puedes realizar más abonos
    </div>';
} else {
    // Registrar abonos para artículos
    foreach ($articulos as $pend_id) {
        $valor = isset($precios[$pend_id]) ? $precios[$pend_id] : 0;

        $regis = mysqli_query($con, "INSERT INTO pedido_abono_temp 
            (ped_abono, forma_pago, medio_pago, pedido_detalle_pend_id, pedido_pen_id, tipo_item)
            VALUES ('$valor', '$forma_pago', '$medio_pago', '$pend_id', '$pen_id', 'articulo')") 
            or die(mysqli_error($con));
    }

    // Registrar abonos para combos
    foreach ($combos as $pedcom_id) {
        $valor = isset($precios_combos[$pedcom_id]) ? $precios_combos[$pedcom_id] : 0;

        $regis = mysqli_query($con, "INSERT INTO pedido_abono_temp 
            (ped_abono, forma_pago, medio_pago, pedido_detalle_pend_id, pedido_pen_id, tipo_item)
            VALUES ('$valor', '$forma_pago', '$medio_pago', '$pedcom_id', '$pen_id', 'combo')") 
            or die(mysqli_error($con));
    }

    // Marcar artículos como abonados
    $number = isset($_POST["articulos"]) ? count($_POST["articulos"]) : 0; 
    for ($i = 0; $i < $number; $i++) {  
        if (trim($_POST["articulos"][$i]) != '') {
            $dato1 = $_POST["articulos"][$i];  
            $sql = mysqli_query($con, "UPDATE pedido_detalle SET pend_abonos='si' WHERE pend_id='$dato1'") 
                or die(mysqli_error($con)); 
        }
    }

    // Marcar combos como abonados
    $number = isset($_POST["combos"]) ? count($_POST["combos"]) : 0; 
    for ($i = 0; $i < $number; $i++) {  
        if (trim($_POST["combos"][$i]) != '') {
            $dato1 = $_POST["combos"][$i];  
            $sql = mysqli_query($con, "UPDATE pedido_detalle_combo SET pend_abonos_combo='si' WHERE pedcom_id='$dato1'") 
                or die(mysqli_error($con)); 
        }
    }

    // Mostrar mensaje de éxito
   echo '<div class="alert alert-success alert-dismissable" id="success-alert">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <strong>Abono </strong>realizado correctamente.
        </div>
        <script>
            setTimeout(function() {
                var alert = document.getElementById("success-alert");
                if (alert) {
                    alert.style.transition = "opacity 0.5s ease";
                    alert.style.opacity = 0;
                    setTimeout(function() { alert.remove(); }, 500);
                }
            }, 2000);
        </script>';

}
?>
