<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:I1')->mergeCells('A2:I2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:I2', 'BDBDBD'); 
cellColor('A1:I1', 'BDBDBD'); 
cellColor('A3:I3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE VENTAS ANULADAS')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta);

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(10);   
$sheet->getColumnDimension('B')->setWidth(25);  
$sheet->getColumnDimension('C')->setWidth(16); 
$sheet->getColumnDimension('D')->setWidth(10); 
$sheet->getColumnDimension('E')->setWidth(30);
$sheet->getColumnDimension('F')->setWidth(10);
$sheet->getColumnDimension('G')->setWidth(10);
$sheet->getColumnDimension('H')->setWidth(10);
$sheet->getColumnDimension('I')->setWidth(15);


    $cel=3;//Numero de fila donde empezara a crear  el reporte

$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";


$total=0;
$query=mysqli_query($con, "SELECT * FROM  ventas where  ven_fecha BETWEEN '$desde' AND '$hasta' and  empresa='$empresa' and sucursal='$sucursal' and ven_estado='anulada' order by ven_n_venta desc ");


while ($roww=mysqli_fetch_array($query))    
{

            $a="A".$cel;
            $b="B".$cel;
            $c="C".$cel;
            $d="D".$cel;
            $e="E".$cel;
            $f="F".$cel;
            $g="G".$cel;
            $h="H".$cel;
            $i="I".$cel;
           
            // Agregar datos
            $sheet->setCellValue($a, '# VENTA')
            ->setCellValue($b, 'CLIENTE')
            ->setCellValue($c, 'FECHA')
            ->setCellValue($d, 'REF')
            ->setCellValue($e, 'PRODUCTOS')
            ->setCellValue($f, 'CANTIDAD')
            ->setCellValue($g, 'VALOR')
            ->setCellValue($h, 'DESC %')
            ->setCellValue($i, 'TOTAL');

            /* color a las celdas con funsion*/            
            cellColor('A'.$cel.':I'.$cel, 'FF4D00');

             $cel+=1;
            $ven_id=$roww['ven_id'];

            $ven_n_venta=$roww['ven_n_venta'];
            $ven_nombre=$roww['ven_nombre'];
            $ven_fecha=$roww['ven_fecha'];


            $desc=0;
            $sumador_articulos=0;
            $sql=mysqli_query($con, "SELECT * from venta_detalle where ventas_ven_id='$ven_id'");
            while ($row=mysqli_fetch_array($sql))
            {
                $vend_referencia=$row['vend_referencia'];
                $vend_nombre=$row['vend_nombre'];
                $vend_cantidad=$row['vend_cantidad'];
                $vend_precio=$row['vend_precio'];
                $vend_iva=$row['vend_iva'];
                $vend_descuento=$row['vend_desc'];
                $ivaf=$vend_iva/100;
                $precio_total=$vend_precio*$vend_cantidad;
                $descuento=($vend_descuento/100)*$precio_total;
                $iva=$vend_precio*$ivaf;
                $sin_iva=$vend_precio-$iva;
                $sumador_articulos+=$precio_total-$descuento;//Sumador
                $desc+=$descuento;

            

                $a="A".$cel;
                $b="B".$cel;
                $c="C".$cel;
                $d="D".$cel;
               
                // Agregar datos
                $sheet->setCellValue($a, $ven_n_venta)
                ->setCellValue($b, $ven_nombre)
                ->setCellValue($c, $ven_fecha)
                ->setCellValue($d, $vend_referencia);

                $e="E".$cel;
                $f="F".$cel;
                $g="G".$cel;
                $h="H".$cel;
                $i="I".$cel;
               
                // Agregar datos
                $sheet->setCellValue($e, $vend_nombre)
                ->setCellValue($f, $vend_cantidad)
                ->setCellValue($g, number_format($vend_precio,0))
                ->setCellValue($h, $vend_descuento)
                ->setCellValue($i, number_format($sumador_articulos,0));
                
                 $cel+=1;

            }

                $sumador_combos=0;
                $sql=mysqli_query($con, "SELECT * from venta_detalle_combo where ven_id='$ven_id'");
                while ($row1=mysqli_fetch_array($sql))
                {
                    $combo_cantidad=$row1["combo_cantidad"];
                    $combo_desc=$row1['combo_desc'];
                    $combo_precio=$row1['combo_precio'];
                    $combo_nombre=$row1['combo_nombre']; 

                    $descuento_item_combo=($combo_desc/100)*$combo_precio;      
                    $precio_total_c=$combo_cantidad*$combo_precio-$descuento_item_combo;
                    $sumador_combos+=$precio_total_c;



                        $a="A".$cel;
                        $b="B".$cel;
                        $c="C".$cel;
                        $d="D".$cel;
                        $e="E".$cel;
                        $f="F".$cel;
                        $g="G".$cel;
                        $h="H".$cel;
                        $i="I".$cel;
                       
                        // Agregar datos
                        $sheet->setCellValue($a, $ven_n_venta)
                        ->setCellValue($b, $ven_nombre)
                        ->setCellValue($c, $ven_fecha)
                        ->setCellValue($d, '')
                        ->setCellValue($e, $combo_nombre)
                        ->setCellValue($f, $combo_cantidad)
                        ->setCellValue($g, number_format($combo_precio,0))
                        ->setCellValue($h, $combo_desc)
                        ->setCellValue($i, number_format($precio_total_c,0));
                        
                      
                        $cel+=1;
              
                }

                           
                   $total+=$sumador_articulos+$sumador_combos;


                    $h="H".$cel;
                    $i="I".$cel;
                   
                    // Agregar datos
                    $sheet->setCellValue($h, 'TOTAL')
                    ->setCellValue($i, number_format($sumador_articulos+$sumador_combos));


                    cellColor('h'.$cel.':I'.$cel, 'BDBDBD');
                      $cel+=1;

                                           
        } 

                    $h="H".$cel;
                    $i="I".$cel;
                      // Agregar datos
                    $sheet->mergeCells("A".($cel).":I".($cel))
                    ->setCellValue($h, '')
                    ->setCellValue($i, '');


                    cellColor('a'.$cel.':I'.$cel, 'FFFFFF');
                     $cel+=1;

                    $h="H".$cel;
                    $i="I".$cel;
                      // Agregar datos
                    $sheet->mergeCells("A".($cel).":F".($cel))
                    ->setCellValue($h, 'TOTAL GENERAL')
                    ->setCellValue($i, number_format($total));


                    cellColor('a'.$cel.':I'.$cel, 'BFBFBF');


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE VENTAS ANULADAS.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>