<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];
$com_id=$_GET['com_id'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:L1')->mergeCells('A2:L2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:L2', 'BDBDBD'); 
cellColor('A1:L1', 'BDBDBD'); 
cellColor('A3:L3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE UTILIDAD COMBOS')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta)
            ->setCellValue('A3', 'CODIGO')
            ->setCellValue('B3', 'NOMBRE')
            ->setCellValue('C3', 'CANTIDAD')
            ->setCellValue('D3', 'PRECIO COSTO')
            ->setCellValue('E3', 'PRECIO VENTA')
            ->setCellValue('F3', 'UTILIDAD');

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(20);   
$sheet->getColumnDimension('B')->setWidth(20);  
$sheet->getColumnDimension('C')->setWidth(20); 
$sheet->getColumnDimension('D')->setWidth(20); 
$sheet->getColumnDimension('E')->setWidth(20);
$sheet->getColumnDimension('F')->setWidth(20);

    $cel=4;//Numero de fila donde empezara a crear  el reporte

$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";

$tot_costo=0;
$tot_venta=0;
$tot_utilidad=0;
$tot_can=0;

$registros=mysqli_query($con,"SELECT *, sum(d.combo_cantidad) as can, AVG(d.combo_precio) as pv from ventas v ,venta_detalle_combo d WHERE v.ven_fecha BETWEEN '$desde' AND '$hasta' and v.sucursal='$sucursal' and v.empresa='$empresa' and d.combo_id='$com_id' and d.ven_id=v.ven_id group by v.ven_id order by can desc") or die(mysqli_error($con));


$total_cantidad=0;
while ($row=mysqli_fetch_array($registros))
{
    $combo_id=$row['combo_id'];
    $combo_cantidad=$row['can']; //3 com
  
    $com0=mysqli_query($con, "SELECT * from combos where com_id='$com_id'");
    $com0=mysqli_fetch_array($com0);
    $com_referencia=$com0['com_referencia'];
    $com_nombre=$com0['com_nombre'];
    $com=mysqli_query($con, "SELECT * from combos_articulos where combos_com_id='$combo_id'");
    $costo_combo=0;
    while ($com1=mysqli_fetch_array($com))
    {
        $coma_art_id=$com1['coma_art_id'];
        $coma_art_cantidad=$com1['coma_art_cantidad'];
        $artc=mysqli_query($con, "SELECT * from articulos where art_id='$coma_art_id'");
        $row1=mysqli_fetch_array($artc);
        $precio_costo=$row1['art_precio_costo'];
        $totalprecio_costo=$precio_costo*$coma_art_cantidad;
        $costo_combo+=$totalprecio_costo;
    } 

    $costo_combo_total=$costo_combo*$combo_cantidad;

    $venta=$combo_cantidad*$row['pv'];

    $uti=$venta-$costo_combo_total;
    $tot_costo+=$costo_combo_total;
    $tot_venta+=$venta; 
    $tot_utilidad+=$uti;

     $total_cantidad+=$combo_cantidad;


            $a="A".$cel;
            $b="B".$cel;
            $c="C".$cel;
            $d="D".$cel;
            $e="E".$cel;
            $f="F".$cel;
           
            // Agregar datos
            $sheet
            ->setCellValue($a, $com_referencia)
            ->setCellValue($b, $com_nombre)
            ->setCellValue($c, $combo_cantidad)
            ->setCellValue($d, number_format($costo_combo_total,0))
            ->setCellValue($e, number_format($venta,0))
            ->setCellValue($f, number_format($uti,0));
            

            $cel+=1;
}

            
            $d="D0".$cel;
            $e="E0".$cel;
            $f="F0".$cel;
            $g="G0".$cel;
            $h="H0".$cel;
            // Agregar datos
            $sheet
            ->setCellValue($d, 'TOTAL')
            ->setCellValue($e, number_format($total_cantidad,0))
            ->setCellValue($f, number_format($tot_costo,0))
            ->setCellValue($g, number_format($tot_venta,0))
            ->setCellValue($h, number_format($tot_utilidad,0));

             $cel+=1;



// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE UTILIDAD COMBOS.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>