<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:G1')->mergeCells('A2:G2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:G2', 'BDBDBD'); 
cellColor('A1:G1', 'BDBDBD'); 
cellColor('A3:G3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE VALOR INVENTARIO')
            ->setCellValue('A2', '')
            ->setCellValue('A3', 'CODIGO')
            ->setCellValue('B3', 'CODIGO DE BARRAS')
            ->setCellValue('C3', 'NOMBRE')
            ->setCellValue('D3', 'COSTO U')
            ->setCellValue('E3', 'CANTIDAD')
            ->setCellValue('F3', 'COSTO TOTAL')
            ->setCellValue('G3', 'VENTA U')
            ->setCellValue('H3', 'ID');

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(15);   
$sheet->getColumnDimension('B')->setWidth(20);  
$sheet->getColumnDimension('C')->setWidth(50); 
$sheet->getColumnDimension('D')->setWidth(20); 
$sheet->getColumnDimension('E')->setWidth(20); 
$sheet->getColumnDimension('F')->setWidth(20); 
$sheet->getColumnDimension('G')->setWidth(20); 
$sheet->getColumnDimension('H')->setWidth(20); 

       $cel=4;//Numero de fila donde empezara a crear  el reporte


$sumador_total_costo=0; 
$sumador_total_venta=0; 


$ordenar=$_GET['ordenar'];
$art_proveedor=$_GET['art_proveedor'];

if($art_proveedor<>null)
{

    $query=mysqli_query($con, "SELECT * from articulos a, articulos_has_bodegas ab where a.art_id=ab.articulos_art_id and a.proveedor_pro_id='$art_proveedor' and ab.bodegas='$bod_id' and a.empresa='$empresa'  group by a.art_id order by a.art_referencia asc");
}
else
{

    $query=mysqli_query($con, "SELECT * from articulos a, articulos_has_bodegas ab where a.art_id=ab.articulos_art_id and ab.bodegas='$bod_id' and a.empresa='$empresa'  group by a.art_id order by a.art_referencia asc");
}



while ($row=mysqli_fetch_array($query))    
{
    $art_id=$row['art_id'];
    $art_referencia=$row['art_referencia'];
    $art_barras=$row['art_barras'];
    $art_nombre=$row['art_nombre'];
    $art_precio_costo=$row['art_precio_costo'];
    $art_pvp=$row['art_pvp'];
    $art_cantidad=$row['art_cantidad'];
    if($art_cantidad<0)
    {
        $art_cantidad1=0;
    }
    else
    {
         $art_cantidad1=$art_cantidad;
    }
    $valor_costo=$art_precio_costo*$art_cantidad1;
    $valor_venta=$art_pvp*$art_cantidad1;
    $sumador_total_costo+=$valor_costo;
    $sumador_total_venta+=$valor_venta;
       
        $a="A".$cel;
        $b="B".$cel;
        $c="C".$cel;
        $d="D".$cel;
        $e="E".$cel;
        $f="F".$cel;
        $g="G".$cel;
        $h="H".$cel;
           
        // Agregar datos
        $sheet
        ->setCellValue($a, $art_referencia)
        ->setCellValue($b, $art_barras)
        ->setCellValue($c, $art_nombre)
        ->setCellValue($d, number_format($art_precio_costo,0))
        ->setCellValue($e, $art_cantidad1)
        ->setCellValue($f, number_format($valor_costo,0))
        ->setCellValue($g, number_format($art_pvp,0))
        ->setCellValue($h, $art_id);

        
        $cel+=1;

      
}
    $e="E".$cel;
    $f="F".$cel;
    $f="G".$cel;

    // Agregar datos
    $sheet->mergeCells("A".($cel).":C".($cel))
    ->setCellValue($e, 'TOTAL GENERAL')
    ->setCellValue($f,  number_format($sumador_total_costo,0))
    ->setCellValue($g,  number_format($sumador_total_venta,0));


    cellColor('A'.$cel.':G'.$cel, 'BDBDBD');


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE VALOR INVENTARIO.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>