<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:D1')->mergeCells('A2:D2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:E2', 'BDBDBD'); 
cellColor('A1:E1', 'BDBDBD'); 
cellColor('A3:E3', 'FF4D00'); 

$sheet->setCellValue('A1', 'REPORTE EGRESOS DE CAJA')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta)
            ->setCellValue('A3', 'N°')
            ->setCellValue('B3', 'FECHA')
            ->setCellValue('C3', 'CONCEPTO')
            ->setCellValue('D3', 'METODO DE PAGO')
            ->setCellValue('E3', 'TOTAL');
           

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(10);   
$sheet->getColumnDimension('B')->setWidth(30);  
$sheet->getColumnDimension('C')->setWidth(40); 
$sheet->getColumnDimension('D')->setWidth(30);
$sheet->getColumnDimension('E')->setWidth(20); 



/*Extraer datos de MYSQL*/
    # conectare la base de datos
    $cel=4;//Numero de fila donde empezara a crear  el reporte


$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";

$sumador_total=0; 
$query=mysqli_query($con, "SELECT * FROM egresos where fecha BETWEEN '$desde' AND '$hastaf' and empresa='$empresa' order by num_e desc");

while ($reg=mysqli_fetch_array($query))    
{
    $num_e=$reg['num_e']; 
    $concepto=$reg['concepto']; 
    $cantidad=$reg['cantidad'];
    $fecha=$reg['fecha'];
    $metodo_pago=$reg['metodo_pago'];
    $banco=$reg['banco'];
    $total=$reg['total'];
   
    $sumador_total+=$total;
   
    $a="A".$cel;
    $b="B".$cel;
    $c="C".$cel;
    $d="D".$cel;
    $e="E".$cel;
 
    // Agregar datos
    $sheet
    ->setCellValue($a, $num_e)
    ->setCellValue($b, $fecha)
    ->setCellValue($c, $concepto)
    ->setCellValue($d, $metodo_pago.'('.$banco.')')
    ->setCellValue($e, number_format($total,0));
   
    $cel+=1;

}
    
    $d="D".$cel;
    $e="E".$cel;

    // Agregar datos
    $sheet->mergeCells("A".($cel).":B".($cel))
    ->setCellValue($d, 'TOTAL GENERAL')
    ->setCellValue($e,  number_format($sumador_total,0));


    cellColor('A'.$cel.':E'.$cel, 'BDBDBD');

        
// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE EGRESOS DE CAJA.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>