<?php
session_start();
require('../fpdf/fpdf.php');
require('plantilla_general.php');
require '../../../conexion.php';
require_once('../../../include/sesiones.php');

$fecha_desde=$_GET['fecha_desde'];
$hora_desde=$_GET['hora_desde'];
$fecha_hasta=$_GET['fecha_hasta'];
$hora_hasta=$_GET['hora_hasta'];
$cliente=$_GET['cliente'];
$sucursal_form=$_GET['sucursal_form'];


$pdf=new PDF_MC_Table();
$pdf->AddPage();
$pdf->SetFont('Arial','',14);
$pdf->AliasNbPages();
$pdf->Cell(0,10,'VENTAS POR IMPUESTO DETALLADO DESDE '.$fecha_desde. ' HASTA ' .$fecha_hasta,0,1);

$sqli=mysqli_query($con, "SELECT * from iva where empresa='$empresa'");
while ($rowi=mysqli_fetch_array($sqli))
{ 
    $iva_porcentaje=$rowi['iva_porcentaje'];
    $iva_nombre=$rowi['iva_nombre'];

    $pdf->SetFont('Arial','',10);
    $pdf->Cell(0,10,'IMPUESTO '.$iva_nombre. ' ('.$iva_porcentaje.')',0,1);
    $pdf->SetFont('Arial','B',8);

    $pdf->SetFillColor(215,235,245);
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(25,4,'CODIGO',1,0,'C',1);
    $pdf->Cell(85,4,'NOMBRE',1,0,'C',1);
    $pdf->Cell(12,4,'UM',1,0,'C',1);
    $pdf->Cell(15,4,'CANT',1,0,'C',1);
    $pdf->Cell(20,4,'BASE' ,1,0,'C',1);
    $pdf->Cell(15,4,'IMP ',1,0,'C',1);
    $pdf->Cell(20,4,'TOTAL',1,0,'C',1);
    $pdf->Ln();


    $sql="SELECT * FROM venta_detalle d
        JOIN ventas v ON d.ventas_ven_id = v.ven_id
    WHERE 
        v.ven_estado <> 'anulada'
        AND d.vend_iva='$iva_porcentaje' AND v.ven_fecha BETWEEN '$fecha_desde' AND '$fecha_hasta'
        AND v.sucursal='$sucursal_form'
        AND v.empresa='$empresa' ";

    if ($facturador=='si') {
        $ven_tipo=implode("','", $_GET["ven_tipo8"]);
        $sql.=" AND ven_tipo IN ('$ven_tipo')";
    }

    $sql.=" ORDER BY d.vend_nombre ASC";
    $query=mysqli_query($con, $sql); 


    $agrupado = [];
    $sumador_subtotal_art=0;
    $sumador_iva_art=0;
    $sumador_articulos_art=0;
    while ($row = mysqli_fetch_array($query)) 
    {
        $vend_art_id = $row['vend_art_id'];
        $vend_referencia = $row['vend_referencia'];
        $vend_nombre = $row['vend_nombre'];
        $vend_unidad = $row['vend_unidad'];
        $vend_cantidad = $row['vend_cantidad'];
        if ($row['vend_x_cantidad']>0){ $vend_x_cantidad=$row['vend_x_cantidad']; } else { $vend_x_cantidad='1';}
        $vend_precio = $row['vend_precio'];
        if ($row['vend_iva']>0){ $vend_iva=$row['vend_iva']; } else { $vend_iva='0';}
        if ($row['vend_desc']>0){ $vend_descuento=$row['vend_desc']; } else { $vend_descuento='0';}
        $iva0=$vend_iva/100; //0.19
        $iva1=1+$iva0; //1.19

        $precio_total_sin_iva_item=($vend_precio/$iva1)*$vend_cantidad; //precio sin iva item 840.336
        $descuento_item=($vend_descuento/100)*$precio_total_sin_iva_item; //descuento_item 84.033
        $precio_real_item=$precio_total_sin_iva_item-$descuento_item; //precio real 4.202
        $total_iva_item=$precio_real_item*$iva0; // total iva item  159.336

        if (!isset($agrupado[$vend_art_id])) 
        {
            $agrupado[$vend_art_id] = [
                'vend_referencia' => $vend_referencia,
                'vend_nombre' => $vend_nombre,
                'vend_unidad' => $vend_unidad,
                'vend_cantidad' => 0,
                'subtotal_art' => 0,
                'iva_art' => 0,
                'total_art' => 0
            ];
        }
        $agrupado[$vend_art_id]['vend_cantidad'] += $vend_cantidad*$vend_x_cantidad;
        $agrupado[$vend_art_id]['subtotal_art'] += $precio_real_item;
        $agrupado[$vend_art_id]['iva_art'] += $total_iva_item;
        $agrupado[$vend_art_id]['total_art'] += $precio_real_item+$total_iva_item;
    }
    // Mostrar en PDF
    $pdf->SetWidths(array(25,85,12,15,20,15,20));
    foreach ($agrupado as $vend_art_id => $datos) 
    {
        $vend_referencia = $datos['vend_referencia'];
        $vend_nombre = $datos['vend_nombre'];
        $vend_unidad = $datos['vend_unidad'];
        $vend_cantidad = $datos['vend_cantidad'];
        $subtotal_art = $datos['subtotal_art'];
        $iva_art = $datos['iva_art'];
        $total_art = $datos['total_art'];

        $sumador_subtotal_art+=$subtotal_art;
        $sumador_iva_art+=$iva_art;
        $sumador_articulos_art+=$total_art;

        $pdf->Row(array(
            $vend_referencia,
            utf8_decode($vend_nombre),
            $vend_unidad,
            number_format($vend_cantidad, 2),
            number_format($subtotal_art, 0),
            number_format($iva_art, 0),
            number_format($total_art, 0)
        ));
    }


    $sqlc="SELECT * FROM venta_detalle_combo d
        INNER JOIN ventas v ON d.ven_id = v.ven_id
        INNER JOIN combos c ON d.combo_id = c.com_id
        WHERE d.combo_iva='$iva_porcentaje' AND v.ven_estado <> 'anulada'
        AND v.ven_fecha BETWEEN '$fecha_desde' AND '$fecha_hasta'
        AND v.sucursal = '$sucursal_form'
        AND v.empresa = '$empresa' ";

    if ($facturador=='si') {
        $ven_tipo=implode("','", $_GET["ven_tipo8"]);
        $sqlc.=" AND ven_tipo IN ('$ven_tipo')";
    }
    $sqlc.=" ORDER BY d.combo_nombre ASC";
    $query_com=mysqli_query($con, $sqlc); 

    $agrupado_combos = [];
    $sumador_subtotal_comb=0;
    $sumador_iva_comb=0;
    $sumador_articulos_comb=0;
    while ($row1 = mysqli_fetch_array($query_com)) 
    {
        $combo_id=$row1["combo_id"];
        $combo_referencia=$row1["combo_referencia"];
        $combo_nombre=$row1['combo_nombre'];
        $combo_unidad='COMB';
        $combo_cantidad=$row1["combo_cantidad"];
        $combo_precio=$row1['combo_precio'];
        if ($row1['combo_iva']>0){ $combo_iva=$row1['combo_iva']; } else { $combo_iva='0';}
        if ($row1['combo_desc']>0){ $combo_desc=$row1['combo_desc']; } else { $combo_desc='0';}
        $iva_c0=$combo_iva/100; //0.19
        $iva_c1=1+$iva_c0; //1.19

        $precio_total_sin_iva_item_com=($combo_precio/$iva_c1)*$combo_cantidad; //precio sin iva  840.336
        $descuento_item_com=($combo_desc/100)*$precio_total_sin_iva_item_com; //descuento_item 84.033
        $precio_real_item_com=$precio_total_sin_iva_item_com-$descuento_item_com; //precio real 4.202
        $total_iva_item_com=$precio_real_item_com*$iva_c0; // total iva item  159.336

        // Agrupar por referencia
        if (!isset($agrupado_combos[$combo_id])) 
        {
            $agrupado_combos[$combo_id] = [
                'combo_referencia' => $combo_referencia,
                'combo_nombre' => $combo_nombre,
                'combo_unidad' => $combo_unidad,
                'combo_cantidad' => 0,
                'subtotal_comb' => 0,
                'iva_comb' => 0,
                'total_comb' => 0
            ];
        }
        $agrupado_combos[$combo_id]['combo_cantidad'] += $combo_cantidad;
        $agrupado_combos[$combo_id]['subtotal_comb'] += $precio_real_item_com;
        $agrupado_combos[$combo_id]['iva_comb'] += $total_iva_item_com;
        $agrupado_combos[$combo_id]['total_comb'] += $precio_real_item_com+$total_iva_item_com;
    }
    // Mostrar en PDF y sumar
    foreach ($agrupado_combos as $combo_id => $data) 
    {
        $combo_referencia = $data['combo_referencia'];
        $combo_nombre = $data['combo_nombre'];
        $combo_cantidad = $data['combo_cantidad'];
        $combo_unidad = $data['combo_unidad'];
        $subtotal_comb = $data['subtotal_comb'];
        $iva_comb = $data['iva_comb'];
        $total_comb = $data['total_comb'];

        $sumador_subtotal_comb+=$subtotal_comb;
        $sumador_iva_comb+=$iva_comb;
        $sumador_articulos_comb+=$subtotal_comb+$iva_comb;
        $pdf->SetWidths(array(25,85,12,15,20,15,20));
        srand(time() * 1000000);
        $pdf->Row(array(
            $combo_referencia,
            utf8_decode($combo_nombre),
            $combo_unidad,
            number_format($combo_cantidad, 2),
            number_format($subtotal_comb, 0),
            number_format($iva_comb, 0),
            number_format($total_comb, 0)
        ));
    }

    $pdf->SetFillColor(135,245,115);
    $pdf->SetFont('Arial','B',7);
    $pdf->Cell(137,4,'TOTAL',1,0,'R',1);
    $pdf->Cell(20,4,number_format($sumador_subtotal_art+$sumador_subtotal_comb,0),1,0,'R',1);
    $pdf->Cell(15,4,number_format($sumador_iva_art+$sumador_iva_comb,0),1,0,'R',1);
    $pdf->Cell(20,4,number_format($sumador_articulos_art+$sumador_articulos_comb,0),1,0,'R',1);
    $pdf->Ln();
}
$pdf->Output();
?>