<?php
session_start();
require('../fpdf/fpdf.php');
require('plantilla_general.php');
require '../../../conexion.php';
require_once('../../../include/sesiones.php');
$fecha_desde=$_GET['fecha_desde'];
$horadesde=$_GET['hora_desde'];
$fecha_hasta=$_GET['fecha_hasta'];
$horahasta=$_GET['hora_hasta'];
$art_categoria=$_GET['art_categoria'];
$vendedores = implode("','", $_GET["vendedor3"]);
$sucursal_form=$_GET['sucursal_form'];


$pdf=new PDF_MC_Table();
$pdf->AddPage();
$pdf->SetFont('Arial','',14);
$pdf->AliasNbPages();
$pdf->Cell(0,10,'VENTAS POR CATEGORIA Y EMPLEADO DESDE'.$fecha_desde. ' HASTA ' .$fecha_hasta,0,1);
 


$sql="SELECT * FROM venta_detalle d
    JOIN ventas v ON d.ventas_ven_id = v.ven_id
    JOIN articulos a ON a.art_id = d.vend_art_id
    JOIN familias f ON f.fam_id = a.familias_fam_id
WHERE 
    v.ven_estado <> 'anulada'
    AND v.ven_fecha BETWEEN '$fecha_desde' AND '$fecha_hasta'
    AND v.sucursal='$sucursal_form'
    AND v.empresa='$empresa'
    AND vendedor IN ('".$vendedores."')";

if ($art_categoria != 0) {
    $sql .= " AND a.familias_fam_id = '$art_categoria'";
}
if ($facturador == 'si') {
    $ven_tipo = implode("','", $_GET["ven_tipo10"]);
    $sql .= " AND v.ven_tipo IN ('$ven_tipo')  ORDER BY f.fam_nombre ASC ";
}

$query = mysqli_query($con, $sql);

$agrupado_categoria = [];
$resumen_categoria = []; // aquí sumaremos totales por proveedor

while ($row = mysqli_fetch_array($query)) {
    $fam_nombre = $row['fam_nombre'];
    $vend_art_id = $row['vend_art_id'];
    $vend_referencia = $row['vend_referencia'];
    $vend_nombre = $row['vend_nombre'];
    $vend_unidad = $row['vend_unidad'];
    $vend_cantidad = $row['vend_cantidad_dev'];
    if ($row['vend_x_cantidad']>0){ $vend_x_cantidad=$row['vend_x_cantidad']; } else { $vend_x_cantidad='1';}
    $vend_precio = $row['vend_precio'];
    $vend_iva = ($row['vend_iva'] > 0) ? $row['vend_iva'] : 0;
    $vend_descuento = ($row['vend_desc'] > 0) ? $row['vend_desc'] : 0;

    $iva0 = $vend_iva / 100;
    $iva1 = 1 + $iva0;

    $precio_total_sin_iva_item = ($vend_precio / $iva1) * $vend_cantidad;
    $descuento_item = ($vend_descuento / 100) * $precio_total_sin_iva_item;
    $precio_real_item = $precio_total_sin_iva_item - $descuento_item;
    $total_iva_item = $precio_real_item * $iva0;

    if (!isset($agrupado_categoria[$fam_nombre][$vend_unidad][$vend_art_id])) {
        $agrupado_categoria[$fam_nombre][$vend_unidad][$vend_art_id] = [
            'vend_referencia' => $vend_referencia,
            'vend_nombre' => $vend_nombre,
            'vend_unidad' => $vend_unidad,
            'vend_cantidad' => 0,
            'subtotal_art' => 0,
            'iva_art' => 0,
            'total_art' => 0
        ];
    }

    $agrupado_categoria[$fam_nombre][$vend_unidad][$vend_art_id]['vend_cantidad'] += $vend_cantidad ;
    $agrupado_categoria[$fam_nombre][$vend_unidad][$vend_art_id]['subtotal_art'] += $precio_real_item;
    $agrupado_categoria[$fam_nombre][$vend_unidad][$vend_art_id]['iva_art'] += $total_iva_item;
    $agrupado_categoria[$fam_nombre][$vend_unidad][$vend_art_id]['total_art'] += $precio_real_item + $total_iva_item;


    // Sumar totales por proveedor
    if (!isset($resumen_categoria[$fam_nombre])) {
        $resumen_categoria[$fam_nombre] = [
            'subtotal' => 0,
            'iva' => 0,
            'total' => 0
        ];
    }

    $resumen_categoria[$fam_nombre]['subtotal'] += $precio_real_item;
    $resumen_categoria[$fam_nombre]['iva'] += $total_iva_item;
    $resumen_categoria[$fam_nombre]['total'] += $precio_real_item + $total_iva_item;
}
    // Mostrar en PDF

$pdf->SetWidths(array(20,17,15,100,20,20));
$sumador_total_general = 0;

foreach ($agrupado_categoria as $fam_nombre => $unidades) {
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->SetFillColor(215,235,245);
    $pdf->Cell(192, 4, utf8_decode("$fam_nombre"), 1, 1, 'C', true);

     // Encabezados de columnas
        $pdf->SetFillColor(235,225,215);
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(20,4,'REF',1,0,'C',1);
        $pdf->Cell(17,4,'CANTIDAD',1,0,'C',1);
        $pdf->Cell(15,4,'UM',1,0,'C',1);
        $pdf->Cell(100,4,'NOMBRE',1,0,'C',1);
        $pdf->Cell(20,4,'PRECIO U',1,0,'C',1);
        $pdf->Cell(20,4,'PRECIO T',1,0,'C',1);
        $pdf->Ln();


    foreach ($unidades as $unidad => $articulos) {
    
       
        if (is_array($articulos) && !empty($articulos)) {
            uasort($articulos, function($a, $b) {
                return strcasecmp($a['vend_nombre'], $b['vend_nombre']);
            });
        }

        foreach ($articulos as $articulo) {
            $vend_referencia = $articulo['vend_referencia'];
            $vend_nombre = $articulo['vend_nombre'];
            $vend_unidad = $articulo['vend_unidad'];
            $vend_cantidad = $articulo['vend_cantidad'];
            $total_art = $articulo['total_art'];

            if (fmod($vend_cantidad, 1) == 0) {
                $vend_cantidad2= number_format($vend_cantidad, 0, '.', ',');
            } else {
                $vend_cantidad2= number_format($vend_cantidad, 2, '.', ',');
            }

            $precio_promedio = $vend_cantidad > 0 ? $total_art / $vend_cantidad : 0;
            $pdf->Row(array(
                $vend_referencia,
                $vend_cantidad2,
                $vend_unidad,
                utf8_decode($vend_nombre),
                number_format($precio_promedio, 0),
                number_format($total_art, 0)
            ));
        }
    }

    // Totales por categoría
    $subtotal = $resumen_categoria[$fam_nombre]['subtotal'];
    $iva = $resumen_categoria[$fam_nombre]['iva'];
    $total = $resumen_categoria[$fam_nombre]['total'];
    $sumador_total_general += $total;

    $pdf->SetFont('Arial','B',7);
    $pdf->SetFillColor(135,245,115);
    $pdf->Cell(152, 4, 'TOTAL '.$fam_nombre, 1, 0, 'R', true);
    $pdf->Cell(40, 4, number_format($total, 0), 1, 1, 'C', true);
    $pdf->Ln(2);
}

$pdf->SetFont('Arial','B',8);
$pdf->SetFillColor(239,215,025);
$pdf->Cell(152, 4, 'TOTAL GENERAL', 1, 0, 'R', 1);
$pdf->Cell(40, 4, number_format($sumador_total_general, 0), 1, 1, 'C', 1);
$pdf->Ln();
$pdf->Cell(0,10,'* Este reporte no toma en cuenta las devoluciones. ' ,0,1);
$pdf->Output();
?>