<?php
session_start();
require('../fpdf/fpdf.php');
require('plantilla_general.php');
require '../../../conexion.php';
require_once('../../../include/sesiones.php');

$desde=$_GET['fecha_desde'];
$horadesde=$_GET['hora_desde'];
$hasta=$_GET['fecha_hasta'];
$horahasta=$_GET['hora_hasta'];
$vendedores = implode("','", $_GET["vendedor4"]);
$sucursal_form=$_GET['sucursal_form'];

$pdf=new PDF_MC_Table();
$pdf->AddPage();
$pdf->SetFont('Arial','',14);
$pdf->AliasNbPages();
$pdf->Cell(0,10,'RESUMEN DE ARTICULOS DESDE '.$desde. ' HASTA ' .$hasta,0,1);
$pdf->SetFillColor(215,235,245);
$pdf->SetFont('Arial','B',8);
$pdf->Cell(20,4,'REF',1,0,'C',1);
$pdf->Cell(115,4,'NOMBRE',1,0,'C',1);
$pdf->Cell(15,4,'UM',1,0,'C',1);
$pdf->Cell(20,4,'CANTIDAD',1,0,'C',1);
$pdf->Cell(20,4,'PRECIO',1,0,'C',1);
$pdf->Ln(); 

$sumadordecantidades_art=0;
$sumadordecantidades_com=0;
$sumadordecantidades_com=0;
$query_str="SELECT * FROM venta_detalle d
    JOIN ventas v ON d.ventas_ven_id = v.ven_id
WHERE 
    v.ven_estado <> 'anulada'
    AND v.ven_fecha BETWEEN '$desde' AND '$hasta'
    AND v.sucursal = '$sucursal_form'
    AND v.empresa = '$empresa' 
    AND vendedor IN ('".$vendedores."')";

if ($facturador=='si') {
    $ven_tipo=implode("','", $_GET["ven_tipo11"]);
    $query_str.=" AND ven_tipo IN ('$ven_tipo')";
}
$query_str.=" ORDER BY d.vend_nombre ASC";
$sql_art=mysqli_query($con, $query_str); 

$agrupado = [];
$sumador_articulos = 0;
while ($row = mysqli_fetch_array($sql_art)) {
    $vend_art_id = $row['vend_art_id'];
    $vend_referencia = $row['vend_referencia'];
    $vend_nombre = $row['vend_nombre'];
    $vend_unidad = $row['vend_unidad'];
    $vend_cantidad = $row['vend_cantidad_dev'];
    if ($row['vend_x_cantidad']>0){ $vend_x_cantidad=$row['vend_x_cantidad']; } else { $vend_x_cantidad='1';}
    $vend_precio = $row['vend_precio'];
    $vend_desc = $row['vend_desc'];

    $precio_con_desc = $vend_precio * (1 - $vend_desc / 100);
    $subtotal = $precio_con_desc * $vend_cantidad;

     $clave = $vend_art_id . '|' . $vend_unidad;  

    if (!isset($agrupado[$clave])) {
        $agrupado[$clave] = [
            'vend_referencia' => $vend_referencia,
            'vend_nombre' => $vend_nombre,
            'vend_unidad' => $vend_unidad,
            'cantidad_total' => 0,
            'total_valor' => 0
        ];
    }
    $agrupado[$clave]['cantidad_total'] += $vend_cantidad*$vend_x_cantidad;
    $agrupado[$clave]['total_valor'] += $subtotal;
}
// Mostrar en PDF
$pdf->SetWidths(array(20,115,15,20,20));
foreach ($agrupado as $clave => $datos) {
    $vend_referencia = $datos['vend_referencia'];
    $vend_nombre = $datos['vend_nombre'];
    $vend_unidad = $datos['vend_unidad'];
    $cant = $datos['cantidad_total'];
    $total = $datos['total_valor'];
    $precio_promedio = $cant > 0 ? $total / $cant : 0;
    $sumador_articulos += $total;
    $sumadordecantidades_art+=$cant;




    $pdf->Row(array(
        $vend_referencia,
        utf8_decode($vend_nombre),
        $vend_unidad,
        number_format($cant, 2),
        number_format($total,0)
    ));
}





$agrupado_combos = [];
$sqlc="SELECT * FROM venta_detalle_combo d
    INNER JOIN ventas v ON d.ven_id = v.ven_id
    INNER JOIN combos c ON d.combo_id = c.com_id
    WHERE v.ven_estado <> 'anulada'
    AND v.ven_fecha BETWEEN '$desde' AND '$hasta'
    AND v.sucursal = '$sucursal_form'
    AND v.empresa = '$empresa'
    AND vendedor IN ('" . $vendedores . "')";

if ($facturador=='si') {
    $ven_tipo=implode("','", $_GET["ven_tipo11"]);
    $sqlc.=" AND ven_tipo IN ('$ven_tipo')";
}
$sqlc.=" ORDER BY d.combo_nombre ASC";
$sql_com=mysqli_query($con, $sqlc);

while ($row1 = mysqli_fetch_array($sql_com)) {
    $combo_id = $row1["combo_id"];
    $combo_referencia = $row1["combo_referencia"];
    $combo_nombre = $row1['combo_nombre'];
    $unidad = 'COMB';
    $cantidad = $row1["combo_cantidad"];
    $precio = $row1['combo_precio'];
    $desc = $row1['combo_desc'];
    // Aplica descuento
    $descuento = ($desc / 100) * $precio;
    $precio_real = $precio - $descuento;
    $total = $precio_real * $cantidad;
    // Agrupar por referencia
    if (!isset($agrupado_combos[$combo_id])) {
        $agrupado_combos[$combo_id] = [
            'combo_referencia' => $combo_referencia,
            'combo_nombre' => $combo_nombre,
            'unidad' => $unidad,
            'cantidad_total' => 0,
            'total_valor' => 0,
        ];
    }
    $agrupado_combos[$combo_id]['cantidad_total'] += $cantidad;
    $agrupado_combos[$combo_id]['total_valor'] += $total;
}
// Mostrar en PDF y sumar
$sumador_combos = 0;
foreach ($agrupado_combos as $combo_id => $data) {
    $cant = $data['cantidad_total'];
    $combo_referencia = $data['combo_referencia'];
    $combo_nombre = $data['combo_nombre'];
    $unidad = $data['unidad'];
    $total = $data['total_valor'];
    $precio_promedio = $cant > 0 ? $total / $cant : 0;
    $sumador_combos += $total;
    $sumadordecantidades_com=$cant;


    $pdf->SetWidths(array(20,115, 15, 20,20 ));
    srand(time() * 1000000);
    $pdf->Row(array(
        $combo_referencia,
        utf8_decode($combo_nombre),
        $unidad,
        number_format($cant, 2),
        number_format($total,0)
    ));
}

$pdf->Cell(150,4,'TOTAL',1,0,'C',1);
$pdf->Cell(20,4,number_format($sumadordecantidades_art+$sumadordecantidades_com,2),1,0,'C',1);
$pdf->Cell(20,4,number_format($sumador_articulos+$sumador_combos,0),1,0,'C',1);
$pdf->Ln();
$pdf->Cell(0,10,'* Este reporte no toma en cuenta las devoluciones. ' ,0,1);

$pdf->Output();
?>