<?php
session_start();
require('../fpdf/fpdf.php');
require('historial_abono_venta_plantilla.php');
require '../../../conexion.php';
require_once('../../../include/sesiones.php');

class PDF_AutoPrint extends PDF_JavaScript
{
    function AutoPrint($printer='')
    {
        // Open the print dialog
        if($printer)
        {
            $printer = str_replace('\\', '\\\\', $printer);
            $script = "var pp = getPrintParams();";
            $script .= "pp.interactive = pp.constants.interactionLevel.full;";
            $script .= "pp.printerName = '$printer'";
            $script .= "print(pp);";
        }
        else
            $script = 'print(true);';
        $this->IncludeJS($script);
    }
}

    $pdf = new PDF_AutoPrint();
    $pdf->AliasNbPages();
    $pdf->AddPage();
    $pdf->SetFont('Times','',10);
    $pdf->Ln();

    $pdf->Image('../../../img/'.$empresa.'.png',10,5,45);
    // Arial bold 15
    $pdf->SetFont('Arial','B',12);
    // Movernos a la derecha
    $pdf->Cell(130);
    $pdf->Cell(50,4,utf8_decode($emp_nombre),0,0,'C');
    $pdf->Ln();
    $pdf->SetFont('Arial','B',9);
    $pdf->Cell(130);
    $pdf->Cell(50,4,'Nit: '.$emp_nit,0,0,'C');
    $pdf->Ln();
    $pdf->Cell(130);
    $pdf->Cell(50,4,utf8_decode("Régimen ").$emp_regimen,0,0,'C');
    $pdf->Ln();
    $pdf->Cell(130);
    $pdf->Cell(50,4,$emp_direccion,0,0,'C');
    $pdf->Ln();
    $pdf->Cell(130);
    $pdf->Cell(50,4,'E-mail:'.$emp_correo,0,0,'C');
    $pdf->Ln();
    $pdf->Cell(130);
    $pdf->Cell(50,4,'Cel:'.$emp_cel.' / Tel:'.$emp_telefono,0,0,'C');
    $pdf->Ln(6);
   

    $ven_id=$_GET['ven_id'];
    $query=mysqli_query($con, "SELECT * , DATE_FORMAT(`ven_fecha`,'%d-%m-%Y') as ven_fecha FROM  ventas where   ven_id='$ven_id' and empresa='$empresa' ");
    $roww=mysqli_fetch_array($query);
    $ven_cc=$roww['ven_cc'];
    $ven_nombre=$roww['ven_nombre'];
    $ven_telefono=$roww['ven_telefono'];
    $ven_n_venta=$roww['ven_n_venta'];
    $ven_forma_de_pago=$roww['ven_forma_de_pago'];
    $fecha=date('Y-m-d');

    $pdf->fact_dev($ven_nombre);
    $pdf->nombre($ven_nombre);
    $pdf->cc($ven_cc);
    $pdf->tel($ven_telefono);
    $pdf->fecha($fecha);
    $pdf->Ln(7);

    
    $pdf->SetFillColor(235,225,215);
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(50,6,'FECHA' ,1,0,'C',1);
    $pdf->Cell(105,6,utf8_decode('DESCRIPCIÓN'),1,0,'C',1);
    $pdf->Cell(35,6,'TOTAL',1,0,'C',1);
    $pdf->Ln();    


        $descuento=0;
        $sumador_total=0;
        $neto=0;
        $descuentof=0;
        $iva_total=0;

        $tt=0;
        $to=0;
        $sql=mysqli_query($con, "SELECT * from  venta_detalle where ventas_ven_id='$ven_id'");
        while ($row=mysqli_fetch_array($sql))
          {
            $vend_referencia=$row['vend_referencia'];
            $vend_nombre=$row['vend_nombre'];
            $vend_cantidad=$row['vend_cantidad'];
            $vend_precio=$row['vend_precio'];
            $vend_iva=$row['vend_iva'];
            $vend_descuento=$row['vend_desc'];

            $ivaf=$vend_iva/100;
            $precio_total=$vend_precio*$vend_cantidad;
            $descuento=($vend_descuento/100)*$precio_total;
            $pt=$precio_total-$descuento;
            $iva=$vend_precio*$ivaf;
            $sin_iva=$vend_precio-$iva;
            $sumador_total+=$precio_total;//Sumador
            $tt=$sin_iva*$vend_cantidad;

            $descuentof+=$descuento;
            $ivat=($vend_precio*$ivaf)*$vend_cantidad;
            $sin_ivat=($vend_precio-$iva)*$vend_cantidad;
            $iva_total+=$ivat;
            $neto+=$sin_ivat;
             
          }
            $to+=$sumador_total;

            $devo_total=0;
                  $sql1=mysqli_query($con, "SELECT * from devolucion where empresa='$empresa' and ventas_ven_id='$ven_id'");
                  while ($row=mysqli_fetch_array($sql1))
                    {
                      $dev_id=$row["dev_id"];
                      $dev_referencia=$row["dev_referencia"];
                      $dev_cantidad=$row['dev_cantidad'];
                      $dev_precio=$row['dev_precio'];
                      $devo_total+=$dev_precio; 
                    }

        $total_abono=0;
        $sql=mysqli_query($con, "SELECT * from  venta_abonos where ventas_ven_id='$ven_id' and veab_abono>0 ");
        while ($row=mysqli_fetch_array($sql))
          {
            $veab_abono=$row['veab_abono'];
            $veab_fecha=$row['veab_fecha'];
            $total_abono+=$veab_abono;

              $pdf->SetWidths(array(50,105,35));
              srand(time()*1000000);
              $pdf->Row(array($veab_fecha,utf8_decode('Abono de la Factura de venta N° '.$ven_n_venta.''),number_format($veab_abono,0)));
          }
          if($ven_forma_de_pago=="Credito")
                  { 
                    $saldo_t=($to-$descuentof)-$total_abono-$devo_total;
                    if ($saldo_t<=0) 
                    {
                       $saldo='0';
                    }
                    else
                    {
                      $saldo=$saldo_t;
                       $saldo; 
                    }
                  }

            $pdf->SetFillColor(255,255,255);
            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(155,4,'TOTAL FACTURADO',1,0,'R',1);
            $pdf->Cell(35,4,number_format($to-$descuentof,0),1,0,'C',1);
            $pdf->Ln();
            $pdf->SetFillColor(255,255,255);
            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(155,4,'DEVOLUCION',1,0,'R',1);
            $pdf->Cell(35,4,number_format($devo_total,0),1,0,'C',1);
            $pdf->Ln();
            $pdf->SetFillColor(255,255,255);
            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(155,4,'TOTAL ABONO',1,0,'R',1);
            $pdf->Cell(35,4,number_format($total_abono,0),1,0,'C',1);
            $pdf->Ln();
            
            $pdf->SetFillColor(254,255,255);
            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(155,4,'SALDO',1,0,'R',1);
            $pdf->SetTextColor(254,0,0);
            $pdf->Cell(35,4,number_format($saldo,0),1,0,'C',1);
            $pdf->SetTextColor(0,0,0);
            $pdf->Ln(5);
            $pdf->Cell(60,2,'Observaciones:',0,0,'L');
            $pdf->Ln(12);
          
            // Movernos a la derecha
            $pdf->Cell(60,2,'',0,0,'L');
            $pdf->Cell(60,0,'___________________________________',0,0,'L');
            $pdf->Cell(70,0,'___________________________________',0,0,'L');
            $pdf->Ln(2);

            $pdf->Cell(73);
            $pdf->Cell(60,2,'Cliente C.C',0,0,'L');
            $pdf->Cell(70,2,'Vendedor C.C',0,0,'L');
            $pdf->Ln(5);

           
     // $pdf->Output('../pdfTemporal/factura'.$ven_id.'.pdf', 'F'); 

    $pdf->Output();
?>