<?php 
session_start(); 
require '../../conexion.php';
require_once('../../include/sesiones.php');

$fecha_desde=$_GET['fecha_desde'];
$fecha_hasta=$_GET['fecha_hasta'];
$proveedor=$_GET['proveedor'];
$vendedores = implode("','", $_GET["vendedor2"]);
$sucursal_form=$_GET['sucursal_form'];

header("Content-Type: application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=reporte_ventas_proveedor.xls");
header("Pragma: no-cache");
header("Expires: 0");

echo "<table border='1' cellspacing='0' cellpadding='3'>";

echo "<tr>
        <td colspan='6' style='font-weight:bold;font-size:14px;text-align:center;border:1px solid #000;'>
            VENTAS POR PROVEEDOR Y EMPLEADO DESDE $fecha_desde HASTA $fecha_hasta
        </td>
      </tr>";

$sql="SELECT * FROM venta_detalle d
    JOIN ventas v ON d.ventas_ven_id = v.ven_id
    JOIN articulos a ON a.art_id = d.vend_art_id
    JOIN proveedor p ON p.pro_id = a.proveedor_pro_id
WHERE 
    v.ven_estado <> 'anulada'
    AND v.ven_fecha BETWEEN '$fecha_desde' AND '$fecha_hasta'
    AND v.sucursal='$sucursal_form'
    AND v.empresa='$empresa'
    AND vendedor IN ('".$vendedores."')";

if ($proveedor != 0) {
    $sql .= " AND a.proveedor_pro_id = '$proveedor'";
}
if ($facturador == 'si') {
    $ven_tipo = implode("','", $_GET["ven_tipo9"]);
    $sql .= " AND v.ven_tipo IN ('$ven_tipo') ORDER BY p.pro_nombre ASC";
}

$query = mysqli_query($con, $sql);

$agrupado_proveedor = [];
$resumen_proveedor = [];

while ($row = mysqli_fetch_array($query)) {

    $pro_nombre = $row['pro_nombre'];
    $vend_art_id = $row['vend_art_id'];
    $vend_referencia = $row['vend_referencia'];
    $vend_nombre = $row['vend_nombre'];
    $vend_unidad = $row['vend_unidad'];
    $vend_cantidad = $row['vend_cantidad_dev'];
    $vend_x_cantidad = ($row['vend_x_cantidad']>0) ? $row['vend_x_cantidad'] : 1;
    $vend_precio = $row['vend_precio'];
    $vend_iva = ($row['vend_iva'] > 0) ? $row['vend_iva'] : 0;
    $vend_descuento = ($row['vend_desc'] > 0) ? $row['vend_desc'] : 0;

    $iva0 = $vend_iva / 100;
    $iva1 = 1 + $iva0;

    $precio_total_sin_iva_item = ($vend_precio / $iva1) * $vend_cantidad;
    $descuento_item = ($vend_descuento / 100) * $precio_total_sin_iva_item;
    $precio_real_item = $precio_total_sin_iva_item - $descuento_item;
    $total_iva_item = $precio_real_item * $iva0;

    if (!isset($agrupado_proveedor[$pro_nombre][$vend_art_id])) {
        $agrupado_proveedor[$pro_nombre][$vend_art_id] = [
            'vend_referencia' => $vend_referencia,
            'vend_nombre' => $vend_nombre,
            'vend_unidad' => $vend_unidad,
            'vend_cantidad' => 0,
            'subtotal_art' => 0,
            'iva_art' => 0,
            'total_art' => 0
        ];
    }

    $agrupado_proveedor[$pro_nombre][$vend_art_id]['vend_cantidad'] += $vend_cantidad * $vend_x_cantidad;
    $agrupado_proveedor[$pro_nombre][$vend_art_id]['subtotal_art'] += $precio_real_item;
    $agrupado_proveedor[$pro_nombre][$vend_art_id]['iva_art'] += $total_iva_item;
    $agrupado_proveedor[$pro_nombre][$vend_art_id]['total_art'] += $precio_real_item + $total_iva_item;

    if (!isset($resumen_proveedor[$pro_nombre])) {
        $resumen_proveedor[$pro_nombre] = ['subtotal'=>0,'iva'=>0,'total'=>0];
    }

    $resumen_proveedor[$pro_nombre]['subtotal'] += $precio_real_item;
    $resumen_proveedor[$pro_nombre]['iva'] += $total_iva_item;
    $resumen_proveedor[$pro_nombre]['total'] += $precio_real_item + $total_iva_item;
}

$sumador_total_general = 0;

foreach ($agrupado_proveedor as $pro_nombre => $articulos) {

    echo "<tr>
            <td colspan='6' style='background:#d7ebf5;
                                   font-weight:bold;
                                   text-align:center;
                                   font-size:13px;
                                   border:1px solid #000;'>
                $pro_nombre
            </td>
          </tr>";

    echo "<tr>
            <td style='background:#ebe1d7;font-weight:bold;border:1px solid #000;text-align:center;'>REF</td>
            <td style='background:#ebe1d7;font-weight:bold;border:1px solid #000;text-align:center;'>CANTIDAD</td>
            <td style='background:#ebe1d7;font-weight:bold;border:1px solid #000;text-align:center;'>UM</td>
            <td style='background:#ebe1d7;font-weight:bold;border:1px solid #000;text-align:center;'>NOMBRE</td>
            <td style='background:#ebe1d7;font-weight:bold;border:1px solid #000;text-align:center;'>PRECIO U</td>
            <td style='background:#ebe1d7;font-weight:bold;border:1px solid #000;text-align:center;'>PRECIO T</td>
          </tr>";

    uasort($articulos, function($a,$b){
        return strcasecmp($a['vend_nombre'], $b['vend_nombre']);
    });

    foreach ($articulos as $art) {
        $precio_promedio = ($art['vend_cantidad'] > 0) ?
                           $art['total_art'] / $art['vend_cantidad'] : 0;

        echo "<tr>
                <td style='border:1px solid #000;text-align:center;'>{$art['vend_referencia']}</td>
                <td style='border:1px solid #000;text-align:center;'>{$art['vend_cantidad']}</td>
                <td style='border:1px solid #000;text-align:center;'>{$art['vend_unidad']}</td>
                <td style='border:1px solid #000;text-align:center;'>{$art['vend_nombre']}</td>
                <td style='border:1px solid #000;text-align:center;'>".number_format($precio_promedio,0)."</td>
                <td style='border:1px solid #000;text-align:center;'>".number_format($art['total_art'],0)."</td>
              </tr>";
    }

    $total = $resumen_proveedor[$pro_nombre]['total'];
    $sumador_total_general += $total;

    echo "<tr>
            <td colspan='5' align='right' 
                style='background:#87f573;font-weight:bold;border:1px solid #000;text-align:right;'>
                TOTAL
            </td>
            <td style='background:#87f573;font-weight:bold;border:1px solid #000;text-align:center;'>
                ".number_format($total,0)."
            </td>
          </tr>";

    echo "<tr><td colspan='6' style='border:none;'></td></tr>";
}

echo "<tr>
        <td colspan='5' align='right'
            style='background:#efd717;font-weight:bold;border:1px solid #000;text-align:right;'>
            TOTAL GENERAL
        </td>
        <td style='background:#efd717;font-weight:bold;border:1px solid #000;text-align:center;'>
            ".number_format($sumador_total_general,0)."
        </td>
      </tr>";

echo "</table>";
?>
