<?php 
session_start(); 
require '../../conexion.php';
require_once('../../include/sesiones.php');

$fecha_desde = $_GET['fecha_desde'];
$hora_desde = $_GET['hora_desde'];
$fecha_hasta = $_GET['fecha_hasta'];
$hora_hasta = $_GET['hora_hasta'];
$sucursal_form = $_GET['sucursal_form'];

$total_general = 0;

// Consulta ventas
$query_str = "SELECT * FROM ventas 
    WHERE TIMESTAMP(ven_fecha, ven_hora) BETWEEN TIMESTAMP('$fecha_desde','$hora_desde') 
    AND TIMESTAMP('$fecha_hasta', '$hora_hasta')
    AND sucursal='$sucursal_form'
    AND empresa='$empresa'
    AND ven_estado<>'anulada'";

if ($facturador == 'si') {
    $ven_tipo = implode("','", $_GET["ven_tipo"]);
    $query_str .= " AND ven_tipo IN ('$ven_tipo')";
}

$query_str .= " ORDER BY ven_id DESC";
$query = mysqli_query($con, $query_str);

// Configuración archivo Excel
header("Content-Type: application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=ventas_detalladas.xls");
header("Pragma: no-cache");
header("Expires: 0");

echo "
<table border='1' cellspacing='0' cellpadding='3' style='border-collapse:collapse;'>
<colgroup>
    <col style='width:80px'>
    <col style='width:120px'>
    <col style='width:100px'>
    <col style='width:250px'>
    <col style='width:120px'>
    <col style='width:120px'>
    <col style='width:120px'>
</colgroup>
";

// TÍTULO
echo "
<tr>
<td colspan='7' style='background:#DDDDDD; font-weight:bold; text-align:center;'>
VENTAS DETALLADAS DESDE $fecha_desde HASTA $fecha_hasta
</td>
</tr>
";

// ENCABEZADOS
echo "
<tr>
<td style='background:#F0F0F0; font-weight:bold; text-align:center;'>ID</td>
<td style='background:#F0F0F0; font-weight:bold; text-align:center;'>Fecha</td>
<td style='background:#F0F0F0; font-weight:bold; text-align:center;'>Hora</td>
<td style='background:#F0F0F0; font-weight:bold; text-align:center;'>Cliente</td>
<td style='background:#F0F0F0; font-weight:bold; text-align:center;'>Tipo</td>
<td style='background:#F0F0F0; font-weight:bold; text-align:center;'>Monto</td>
<td style='background:#F0F0F0; font-weight:bold; text-align:center;'></td>
</tr>
";

// LOOP PRINCIPAL
while ($row = mysqli_fetch_assoc($query)) {

    $ven_id = $row['ven_id'];

    echo "
    <tr>
        <td style='background:#FAFAFA; text-align:center;'>{$row['ven_id']}</td>
        <td style='background:#FAFAFA; text-align:center;'>{$row['ven_fecha']}</td>
        <td style='background:#FAFAFA; text-align:center;'>{$row['ven_hora']}</td>
        <td style='background:#FAFAFA; text-align:center;'>".utf8_decode($row['ven_nombre'])."</td>
        <td style='background:#FAFAFA; text-align:center;'>{$row['ven_tipo']}</td>
        <td style='background:#FAFAFA'></td>
        <td style='background:#FAFAFA'></td>
    </tr>";

    // CABECERA DETALLE
    echo "
    <tr>
        <td style='background:#D7EBF1; font-weight:bold; text-align:center;'>".$row['ven_prefijo'].$row['ven_n_venta']."</td>
        <td colspan='3' style='background:#D7EBF1; font-weight:bold; text-align:center;'>".utf8_decode($row['ven_nombre'])."</td>
        <td style='background:#D7EBF1; font-weight:bold; text-align:center;'>Doc: ".$row['ven_cc']."</td>
        <td style='background:#D7EBF1; font-weight:bold; text-align:center;'>".$row['ven_forma_de_pago']."</td>
        <td style='background:#D7EBF1'></td>
    </tr>";

    echo "
    <tr>
        <td style='background:#EBE1D7; font-weight:bold; text-align:center;'>REF</td>
        <td style='background:#EBE1D7; font-weight:bold; text-align:center;'>NOMBRE</td>
        <td style='background:#EBE1D7; font-weight:bold; text-align:center;'>UM</td>
        <td style='background:#EBE1D7; font-weight:bold; text-align:center;'>CANT</td>
        <td style='background:#EBE1D7; font-weight:bold; text-align:center;'>VALOR U</td>
        <td style='background:#EBE1D7; font-weight:bold; text-align:center;'>DESC %</td>
        <td style='background:#EBE1D7; font-weight:bold; text-align:center;'>TOTAL</td>
    </tr>";

    // Retención
    $ret = mysqli_query($con, "SELECT * FROM retencion_venta WHERE ventas_ven_id='$ven_id'");
    $rets = mysqli_fetch_array($ret);
    $ret_porcentaje = isset($rets['porcentaje']) ? $rets['porcentaje'] : 0;

    // DETALLES ARTICULOS
    $subtotal_art = 0;
    $descuento_art = 0;
    $iva_art = 0;

    $det = mysqli_query($con, "SELECT * FROM venta_detalle WHERE ventas_ven_id='$ven_id'");
    $i = 0;

    while ($d = mysqli_fetch_array($det)) {

        $bg = ($i % 2 == 0) ? "#FFFFFF" : "#FAFAFA";
        $i++;

        $iva0 = $d['vend_iva'] > 0 ? $d['vend_iva']/100 : 0;
        $iva1 = 1 + $iva0;

        $precio_sin_iva_und = $d['vend_precio'] / $iva1;
        $precio_sin_iva_item = $precio_sin_iva_und * $d['vend_cantidad'];
        $descuento_item = ($d['vend_desc'] / 100) * $precio_sin_iva_item;

        $subtotal_art += $precio_sin_iva_item;
        $descuento_art += $descuento_item;
        $iva_art += ($precio_sin_iva_item - $descuento_item) * $iva0;

        echo "
        <tr>
            <td style='background:$bg; text-align:center;'>{$d['vend_referencia']}</td>
            <td style='background:$bg; text-align:center;'>".utf8_decode($d['vend_nombre'])."</td>
            <td style='background:$bg; text-align:center;'>{$d['vend_unidad']}</td>
            <td style='background:$bg; text-align:center;'>{$d['vend_cantidad']}</td>
            <td style='background:$bg; text-align:right;'>".number_format($precio_sin_iva_und,0)."</td>
            <td style='background:$bg; text-align:center;'>{$d['vend_desc']}</td>
            <td style='background:$bg; text-align:right;'>".number_format($precio_sin_iva_item,0)."</td>
        </tr>";
    }

    // DETALLES COMBO
    $subtotal_com = 0;
    $descuento_com = 0;
    $iva_com = 0;

    $comb = mysqli_query($con, "SELECT * FROM venta_detalle_combo WHERE ven_id='$ven_id'");
    while ($c = mysqli_fetch_array($comb)) {

        $iva0 = $c['combo_iva'] > 0 ? $c['combo_iva']/100 : 0;
        $iva1 = 1 + $iva0;

        $precio_sin_iva_und = $c['combo_precio'] / $iva1;
        $precio_sin_iva_item = $precio_sin_iva_und * $c['combo_cantidad'];
        $descuento_item = ($c['combo_desc'] / 100) * $precio_sin_iva_item;

        $subtotal_com += $precio_sin_iva_item;
        $descuento_com += $descuento_item;
        $iva_com += ($precio_sin_iva_item - $descuento_item) * $iva0;

        echo "
        <tr>
            <td style='background:#FFFFFF; text-align:center;'>{$c['combo_referencia']}</td>
            <td style='background:#FFFFFF; text-align:center;'>".utf8_decode($c['combo_nombre'])."</td>
            <td style='background:#FFFFFF; text-align:center;'>Comb</td>
            <td style='background:#FFFFFF; text-align:center;'>{$c['combo_cantidad']}</td>
            <td style='background:#FFFFFF; text-align:right;'>".number_format($precio_sin_iva_und,0)."</td>
            <td style='background:#FFFFFF; text-align:center;'>{$c['combo_desc']}</td>
            <td style='background:#FFFFFF; text-align:right;'>".number_format($precio_sin_iva_item,0)."</td>
        </tr>";
    }

    // RESUMEN
    $subtotal_venta  = $subtotal_art + $subtotal_com;
    $descuento_venta = $descuento_art + $descuento_com;
    $retencion_venta = ($subtotal_venta - $descuento_venta) * ($ret_porcentaje / 100);
    $iva_venta       = $iva_art + $iva_com;
    $total_venta     = ($subtotal_venta - $descuento_venta - $retencion_venta) + $iva_venta;

    echo "
    <tr>
        <td colspan='6' style='background:#FFFFFF; font-weight:bold; text-align:right;'>Subtotal</td>
        <td style='background:#FFFFFF; text-align:right;'>".number_format($subtotal_venta,0)."</td>
    </tr>

    <tr>
        <td colspan='6' style='background:#FFFFFF; font-weight:bold; text-align:right;'>Descuento</td>
        <td style='background:#FFFFFF; text-align:right;'>".number_format($descuento_venta,0)."</td>
    </tr>

    <tr>
        <td colspan='6' style='background:#FFFFFF; font-weight:bold; text-align:right;'>Retención</td>
        <td style='background:#FFFFFF; text-align:right;'>".number_format($retencion_venta,0)."</td>
    </tr>

    <tr>
        <td colspan='6' style='background:#FFFFFF; font-weight:bold; text-align:right;'>Impuesto</td>
        <td style='background:#FFFFFF; text-align:right;'>".number_format($iva_venta,0)."</td>
    </tr>
    ";

    // TOTAL (CORREGIDO)
    echo "
    <tr>
        <td colspan='5' style='background:#87F573; font-weight:bold; text-align:center;'>{$row['ven_fecha']} {$row['ven_hora']}</td>
        <td style='background:#87F573; font-weight:bold; text-align:center;'>TOTAL</td>
        <td style='background:#87F573; font-weight:bold; text-align:right;'>".number_format($total_venta,0)."</td>
    </tr>
    ";

    $total_general += $total_venta;

    echo "<tr><td colspan='7'></td></tr>";
}

// TOTAL GENERAL FINAL
echo "
<tr>
    <td colspan='6' style='background:#FFE96A; font-weight:bold; text-align:right;'>TOTAL GENERAL</td>
    <td style='background:#FFE96A; font-weight:bold; text-align:right;'>".number_format($total_general,0)."</td>
</tr>
";

echo "</table>";

?>
