<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:F1')->mergeCells('A2:F2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:F2', 'BDBDBD'); 
cellColor('A1:F1', 'BDBDBD'); 
cellColor('A3:F3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE VENTAS RESUMEN ARTICULOS')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta)
            ->setCellValue('A3', 'REF')
            ->setCellValue('B3', 'NOMBRE')
            ->setCellValue('C3', 'CANTIDAD')
            ->setCellValue('D3', 'COSTO U')
            ->setCellValue('E3', 'PRECIO U')
            ->setCellValue('F3', 'TOTAL');

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(15);   
$sheet->getColumnDimension('B')->setWidth(40);  
$sheet->getColumnDimension('C')->setWidth(20); 
$sheet->getColumnDimension('D')->setWidth(20); 
$sheet->getColumnDimension('E')->setWidth(20);
$sheet->getColumnDimension('F')->setWidth(20);


    $cel=4;//Numero de fila donde empezara a crear  el reporte

$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";

$tot=0;
        $sql=mysqli_query($con, "SELECT *, sum(vd.vend_cantidad_dev) as can, AVG(vd.vend_costo) as pc, AVG(vd.vend_precio_real) as pv from ventas v, venta_detalle vd WHERE v.ven_fecha BETWEEN '$desde' AND '$hasta' and v.sucursal='$sucursal' and v.empresa='$empresa' and v.ven_id=vd.ventas_ven_id  group by vd.vend_art_id order by can desc ");
        while ($row=mysqli_fetch_array($sql))
        {
            $vend_art_id=$row['vend_art_id'];
            $total=$row['can']*$row['pv'];
            $tot+=$total;
            $sql1=mysqli_query($con, "SELECT * from  articulos where art_id='$vend_art_id' and empresa='$empresa' ");
            $cos=mysqli_fetch_array($sql1);
            $art_referencia=$cos['art_referencia'];
            $art_nombre=$cos['art_nombre'];


            $a="A".$cel;
            $b="B".$cel;
            $c="C".$cel;
            $d="D".$cel;
            $e="E".$cel;
            $f="F".$cel;

            // Agregar datos
            $sheet
            ->setCellValue($a, $art_referencia)
            ->setCellValue($b, $art_nombre)
            ->setCellValue($c, $row['can'])
            ->setCellValue($d, number_format( $row['pc'],0))
            ->setCellValue($e, number_format($row['pv'],0))
            ->setCellValue($f, number_format($total,0));
            
             $cel+=1;
        }  


        $e="E".$cel;
        $f="F".$cel;

        // Agregar datos
        $sheet->mergeCells("A".($cel).":D".($cel))
        ->setCellValue($e, 'TOTAL GENERAL')
        ->setCellValue($f, number_format($tot,0));

        cellColor('A'.$cel.':F'.$cel, 'BDBDBD');

        $cel+=1;


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE VENTAS RESUMEN ARTICULOS.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>