<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:J1')->mergeCells('A2:J2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:J2', 'BDBDBD'); 
cellColor('A1:J1', 'BDBDBD'); 
cellColor('A3:J3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE VENTAS DETALLADAS')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta);

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(10);   
$sheet->getColumnDimension('B')->setWidth(20);  
$sheet->getColumnDimension('C')->setWidth(40); 
$sheet->getColumnDimension('D')->setWidth(20); 
$sheet->getColumnDimension('E')->setWidth(10);
$sheet->getColumnDimension('F')->setWidth(40);
$sheet->getColumnDimension('G')->setWidth(10);
$sheet->getColumnDimension('H')->setWidth(10);
$sheet->getColumnDimension('I')->setWidth(10);
$sheet->getColumnDimension('J')->setWidth(15);

    $cel=3;//Numero de fila donde empezara a crear  el reporte

$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";
$total=0;
$query=mysqli_query($con, "SELECT * FROM ventas where ven_fecha BETWEEN '$desde' AND '$hasta' and sucursal='$sucursal' and empresa='$empresa' and sucursal='$sucursal' and ven_estado<>'anulada'  and ven_nombre<>'CONSUMIDOR FINAL' order by ven_id desc");
       
        while ($roww=mysqli_fetch_array($query))    
        {


            $a="A".$cel;
            $b="B".$cel;
            $c="C".$cel;
            $d="D".$cel;
            $e="E".$cel;
            $f="F".$cel;
            $g="G".$cel;
            $h="H".$cel;
            $i="I".$cel;
            $j="J".$cel;
           
            // Agregar datos
            $sheet->setCellValue($a, '# VENTA')
            ->setCellValue($b, 'CC/NIT')
            ->setCellValue($c, 'CLIENTE')
            ->setCellValue($d, 'FORMA DE PAGO')
            ->setCellValue($e, 'FECHA')
            ->setCellValue($f, 'PRODUCTOS')
            ->setCellValue($g, 'CANTIDAD')
            ->setCellValue($h, 'PRECIO')
            ->setCellValue($i, 'DESC %')
            ->setCellValue($j, 'TOTAL');

            /* color a las celdas con funsion*/            
            cellColor('A'.$cel.':J'.$cel, 'FF4D00');

          
           $cel+=1;

            $ven_id=$roww['ven_id'];
            $ven_n_venta=$roww['ven_n_venta'];
            $ven_nombre=$roww['ven_nombre'];
            $ven_cc=$roww['ven_cc'];
            $ven_forma_de_pago=$roww['ven_forma_de_pago'];
            $ven_fecha=$roww['ven_fecha'];
            $sumador_combo=0;
            $sumador_total=0;

            $neto=0;
            $total_descuento=0;
            $total_iva=0;
            $total_retencion=0;
            $sumador_articulos=0;
            $ret=mysqli_query($con, "SELECT * FROM retencion_venta where ventas_ven_id='$ven_id' ") or die(mysqli_error($con)); 
            $rets=mysqli_fetch_array($ret);
            $ret_porcentaje=$rets['porcentaje'];

            $sql=mysqli_query($con, "SELECT * from venta_detalle where ventas_ven_id='$ven_id'");
                while ($row=mysqli_fetch_array($sql))
                { 
                    $vend_id=$row['vend_id'];
                    $vend_referencia=$row['vend_referencia'];
                    $vend_nombre=$row['vend_nombre'];
                    $vend_cantidad=$row['vend_cantidad'];
                    $vend_precio=$row['vend_precio'];
                    $vend_iva=$row['vend_iva'];
                    $vend_descuento=$row['vend_desc'];
                    $vend_precio_real=$row['vend_precio_real'];
                    
                    $iva0=$vend_iva/100; //0.19
                    $iva1=1+$iva0; //1.19

                    $precio_total_item=$vend_precio*$vend_cantidad;//precio normal 1.000.000
                    $precio_total_sin_iva_item=($vend_precio/$iva1)*$vend_cantidad; //precio sin iva  840.336
                    $descuento_item=($vend_descuento/100)*$precio_total_sin_iva_item; //descuento_item 84.033
                    $total_iva_item=$precio_total_sin_iva_item*$iva0; // total iva  159.336

                    $neto+=$precio_total_sin_iva_item;
                    $total_descuento+=$descuento_item;
                    $total_iva+=$total_iva_item;

                    $sumador_articulos=($neto+$total_iva)-$total_descuento;
                
                    $art=mysqli_query($con,"SELECT * FROM venta_detalle_sabores_productos WHERE vend_id='$vend_id'")or die(mysqli_error($con));
                    while ($row1=mysqli_fetch_array($art))
                                    {
                                      $row1['sab_nombre'];
                                         '-';
                                    }

                        $a="A".$cel;
                        $b="B".$cel;
                        $c="C".$cel;
                        $d="D".$cel;
                        $e="E".$cel;
                        $f="F".$cel;
                        $g="G".$cel;
                        $h="H".$cel;
                        $i="I".$cel;
                        $j="J".$cel;
                       
                        // Agregar datos
                        $sheet->setCellValue($a, $roww['ven_prefijo'].$ven_n_venta)
                        ->setCellValue($b, $ven_cc)
                        ->setCellValue($c, $ven_nombre)
                        ->setCellValue($d, $ven_forma_de_pago)
                        ->setCellValue($e, $ven_fecha)
                        ->setCellValue($f, $vend_nombre)
                        ->setCellValue($g, $vend_cantidad)
                        ->setCellValue($h, number_format($vend_precio))
                        ->setCellValue($i, $vend_descuento)
                        ->setCellValue($j, number_format($precio_total_item,0));
                        
                         $cel+=1;

                }
                $descuento_combo_total=0;
                $neto_combo=0;
                $sql=mysqli_query($con, "SELECT * from venta_detalle_combo where ven_id='$ven_id'");
                while ($row1=mysqli_fetch_array($sql))
                {
                    $vdc_id=$row1['vdc_id'];
                    $combo_desc=$row1['combo_desc'];
                    $combo_cantidad=$row1["combo_cantidad"];
                    $combo_precio=$row1['combo_precio'];
                    $combo_nombre=$row1['combo_nombre'];
                    
                    $precio_total=$combo_cantidad*$combo_precio;
                    $descuento_combo_total+=($combo_desc/100)*$precio_total;

                    $neto_combo+=$precio_total;
                    $sumador_combo=$neto_combo-$descuento_combo_total;
                                   
                    $art=mysqli_query($con,"SELECT * FROM venta_detalle_sabores_combo WHERE vdc_id='$vdc_id'")or die(mysqli_error($con));
                      while ($row1=mysqli_fetch_array($art))
                        {
                          $row1['sab_nombre'];
                           '-';
                        }

                    $a="A".$cel;
                    $b="B".$cel;
                    $c="C".$cel;
                    $d="D".$cel;
                    $e="E".$cel;
                    $f="F".$cel;
                    $g="G".$cel;
                    $h="H".$cel;
                    $i="I".$cel;
                    $j="J".$cel;
                   
                    // Agregar datos
                    $sheet
                    ->setCellValue($a, $ven_n_venta)
                    ->setCellValue($b, $ven_cc)
                    ->setCellValue($c, $ven_nombre)
                    ->setCellValue($d, $ven_forma_de_pago)
                    ->setCellValue($e, $ven_fecha)
                    ->setCellValue($f, $combo_nombre)
                    ->setCellValue($g, $combo_cantidad)
                    ->setCellValue($h, number_format($combo_precio))
                    ->setCellValue($i, $combo_desc,0)
                    ->setCellValue($j, number_format($precio_total,0));
                    
                  
                    $cel+=1;
              
                }

                $total_retencion+=($neto+$sumador_combo-$total_descuento)*($ret_porcentaje/100);
                $sumador_total=$sumador_articulos+$sumador_combo-$total_retencion;

                $total+=$sumador_total;


                    $i="I".$cel;
                    $j="J".$cel;
                   
                    // Agregar datos
                    $sheet->mergeCells("A".($cel).":H".($cel))
                    ->setCellValue($i, 'TOTAL')
                    ->setCellValue($j, number_format($sumador_total));


                    cellColor('I'.$cel.':J'.$cel, 'BDBDBD');
                    $cel+=1;
                       
} 
                    $a="A".$cel;
                    $j="J".$cel;
                   
                    // Agregar datos
                    $sheet->mergeCells("A".($cel).":J".($cel));
                 $cel+=1;
                    

                    $i="I".$cel;
                    $j="J".$cel;
                   
                    // Agregar datos
                    $sheet->mergeCells("A".($cel).":H".($cel))
                    ->setCellValue($i, 'TOTAL GENERAL')
                    ->setCellValue($j, number_format($total));


 cellColor('I'.$cel.':J'.$cel, 'DA8869');


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE VENTAS DETALLADAS.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>