<?php
session_start();
require('../fpdf/fpdf.php');
require('cotizacion3_plantilla.php');
require '../../../conexion.php';
require_once('../../../include/sesiones.php');

class PDF_AutoPrint extends PDF_JavaScript
{
    function AutoPrint($printer='')
    {
        // Open the print dialog
        if($printer)
        {
            $printer = str_replace('\\', '\\\\', $printer);
            $script = "var pp = getPrintParams();";
            $script .= "pp.interactive = pp.constants.interactionLevel.full;";
            $script .= "pp.printerName = '$printer'";
            $script .= "print(pp);";
        }
        else
            $script = 'print(true);';
        $this->IncludeJS($script);
    }
}

$pdf = new PDF_AutoPrint();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Times','',10);
$pdf->Ln();

$pdf->Image('../../../img/'.$empresa.'.png',10,5,60);
   // $pdf->Image('../img/'.$empresa.'.jpg',75,15,60); 
    // Arial bold 15
    $pdf->SetFont('Arial','B',12);
    // Movernos a la derecha
    $pdf->Cell(130);
    $pdf->Cell(50,4,utf8_decode($emp_nombre),0,0,'C');
    $pdf->Ln();
    $pdf->SetFont('Arial','B',9);
    $pdf->Cell(130);
    $pdf->Cell(50,4,'Nit: '.$emp_nit,0,0,'C');
    $pdf->Ln();
    $pdf->Cell(130);
    $pdf->Cell(50,4,utf8_decode("Régimen ").$emp_regimen,0,0,'C');
    $pdf->Ln();
    $pdf->Cell(130);
    $pdf->Cell(50,4,$emp_direccion,0,0,'C');
    $pdf->Ln();
    $pdf->Cell(130);
    $pdf->Cell(50,4,'E-mail:'.$emp_correo,0,0,'C');
    $pdf->Ln();
    $pdf->Cell(130);
    $pdf->Cell(50,4,'Cel:'.$emp_cel.' / Tel:'.$emp_telefono,0,0,'C');
    $pdf->Ln(10);
   
   $to=0;
$cot_id=$_GET['cot_id'];
$query=mysqli_query($con, "SELECT *  , DATE_FORMAT(cot_fecha, '%d-%m-%Y') AS nueva_fecha  from cotizacion where cot_id='$cot_id' ");
$roww=mysqli_fetch_array($query);
$cliente_id=$roww['cliente_id'];
$ven_cc=$roww['cot_cc'];
$ven_nombre=$roww['cot_nombre'];
$cot_dias=$roww['cot_validez'];

$ven_telefono=$roww['cot_telefono'];
$ven_fecha=$roww['nueva_fecha'];
$ven_n_venta=$roww['cot_n_cotizacion'];
$dir=mysqli_query($con,"SELECT * FROM cliente  where clie_id='$cliente_id'  ") or die(mysqli_error($con)); 
$dire=mysqli_fetch_array($dir);
$clie_direccion=$dire['clie_direccion'];



$pdf->nombre($ven_nombre);
$pdf->cc($ven_cc);
$pdf->tel($ven_telefono);
$pdf->fact_dev($ven_n_venta);

$pdf->direccion(strtoupper($clie_direccion));
$pdf->validez(utf8_decode(strtoupper($cot_dias)));
$pdf->fecha($ven_fecha);
//$pdf->vencimiento($hasta);
$pdf->Ln(5);

   // Salto de línea
    $pdf->Ln(7); 
    $pdf->SetFont('Arial','B',10);
    $pdf->Cell(180,4,utf8_decode('A continuación le presentamos nuestra oferta que esperamos sea de su conformidad.'),0,0,'L');
    $pdf->Ln(5);


$hex = $color;
list($r, $g, $b) = sscanf($hex, "#%02x%02x%02x");




    $pdf->SetFillColor($r,$g,$b );
    $pdf->Cell(20,6,'REF' ,1,0,'C',1);
    $pdf->Cell(15,6,'CANT',1,0,'C',1);
    $pdf->Cell(90,6,utf8_decode('DESCRIPCIÓN'),1,0,'C',1);
    $pdf->Cell(25,6,'PRECIO U',1,0,'C',1);
    $pdf->Cell(15,6,'DESC %',1,0,'C',1);
    $pdf->Cell(25,6,'TOTAL',1,0,'C',1);
    $pdf->SetFont('Arial','B',8);
    $pdf->Ln();    

    $cot_id=$roww['cot_id'];

    $descuentof=0;
    $descuento=0;
    $neto=0;
    $sumador_total=0;
    $iva_total=0;

    $total_ret=0;
    $ret=mysqli_query($con, "SELECT * FROM retencion_cotizacion where cotizacion_cot_id='$cot_id' ") or die(mysqli_error($con)); 
    $rets=mysqli_fetch_array($ret);
            
    $ret_porcentaje=$rets['porcentaje'];


    $sql=mysqli_query($con, "SELECT * from  cotizacion_detalle where cotizacion_cot_id='$cot_id' and  empresa='$empresa' ");
    while ($row=mysqli_fetch_array($sql))
    {
    $id=$row["cotd_id"];
    $cotd_id=$row["cotd_id"];
    $cotd_referencia=$row['cotd_referencia'];
    $cotd_nombre=$row['cotd_nombre'];
    $cotd_cantidad=$row['cotd_cantidad'];
    $cotd_precio=$row['cotd_precio'];
    $cotd_iva=$row['cotd_iva'];
    $cotd_descuento=$row['cotd_desc'];

    $iva0=$cotd_iva/100; //0.19
    $iva1=1+$iva0; //1.19

    $precio_u_sin_iva=$cotd_precio/$iva1;
    $precio_retencion=(($precio_u_sin_iva*$ret_porcentaje)/(100-$ret_porcentaje));
    $precio_unidad=(($precio_u_sin_iva*$ret_porcentaje)/(100-$ret_porcentaje))+$precio_u_sin_iva;

    $precio_t_sin_iva=$precio_unidad*$cotd_cantidad;

    $descuento=($cotd_descuento/100)*$precio_t_sin_iva;

    $precio_descuento_t=$precio_t_sin_iva;

    $total_iva_u=$precio_descuento_t*$iva0;

    $iva_total+=$total_iva_u;

    $neto+=$precio_t_sin_iva;

    $descuentof+=$descuento;
    $total_ret+=$precio_retencion*$cotd_cantidad;

    $sumador_total=($neto+$iva_total)-$descuentof;


              $pdf->SetWidths(array(20,15,90,25,15,25));
              srand(time()*1000000);
              $pdf->Row(array($cotd_referencia,$cotd_cantidad,utf8_decode($cotd_nombre),number_format($precio_unidad,0),$cotd_descuento,number_format($precio_t_sin_iva,0)));
          }





    $total_combo=0;
    $sql=mysqli_query($con, "SELECT * from cotizacion_detalle_combo where cot_id='$cot_id'");
    while ($row=mysqli_fetch_array($sql))
    {
        $combo_nombre=$row['combo_nombre'];
        $combo_cantidad=$row['combo_cantidad'];
        $combo_precio=$row['combo_precio'];

        $precio_total=$combo_precio*$combo_cantidad;
        $total_combo+=$precio_total;

        $pdf->SetWidths(array(20,15,90,25,15,25));
        srand(time()*1000000);
        $pdf->Row(array('',$combo_cantidad,utf8_decode($combo_nombre),number_format($combo_precio,0),'',number_format($precio_total,0)));
  }





           
            $to+=$sumador_total+$total_combo;
            $pdf->SetFillColor(255,255,255);
            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(150,4,'',1,0,'C',1);
            $pdf->Cell(15,4,'NETO',1,0,'C',1);
            $pdf->Cell(25,4,number_format($neto+$total_combo,0),1,0,'C',1);
            $pdf->Ln();
           
            $pdf->SetFillColor(255,255,255);
            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(150,4,'',1,0,'C',1);
            $pdf->Cell(15,4,'IMPUESTO',1,0,'C',1);
            $pdf->Cell(25,4,number_format($iva_total,0),1,0,'C',1);
            $pdf->Ln();

            $pdf->SetFillColor(255,255,255);
            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(150,4,'',1,0,'C',1);
            $pdf->Cell(15,4,'RF',1,0,'C',1);
            $pdf->Cell(25,4,number_format($total_ret,0),1,0,'C',1);
            $pdf->Ln();

            $pdf->SetFillColor(255,255,255);
            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(150,4,'',1,0,'C',1);
            $pdf->Cell(15,4,'SUBTOTAL',1,0,'C',1);
            $pdf->Cell(25,4,number_format($sumador_total+$total_combo-$total_ret+$descuentof,0),1,0,'C',1);
            $pdf->Ln();

            $pdf->SetFillColor(255,255,255);
            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(150,4,'',1,0,'C',1);
            $pdf->Cell(15,4,'DESC',1,0,'C',1);
            $pdf->SetTextColor(254,0,0);
            $pdf->Cell(25,4,number_format($descuentof,0),1,0,'C',1);
            $pdf->SetTextColor(0,0,0);
            $pdf->Ln();


            $pdf->SetFillColor(255,255,255);
            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(150,4,'',1,0,'C',1);
            $pdf->Cell(15,4,'TOTAL',1,0,'C',1);
            $pdf->Cell(25,4,number_format($sumador_total+$total_combo-$total_ret,0),1,0,'C',1);
            $pdf->Ln(5);

            $pdf->Cell(35,4,'OBSERVACIONES:',0,0,'L',1);
            $pdf->Ln();
            $pdf->MultiCell(180,4,$roww['observaciones'],0, 1, 'L');

            $pdf->Ln(10);

            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(73);
            $pdf->Cell(60,0,'___________________________________',0,0,'L');
            $pdf->Cell(70,0,'___________________________________',0,0,'L');
            $pdf->Ln(2);

            $pdf->Cell(73);
            $pdf->Cell(60,2,'Cliente C.C',0,0,'L');
            $pdf->Cell(70,2,'Vendedor C.C',0,0,'L');
            $pdf->Ln(5);

            $pdf->SetFont('Arial','B',5);
            $pdf->SetMargins(23, 44, 11.7);
            $pdf->MultiCell(190, 2.5, $condiciones_cot,1, 1, 'L');
            $pdf->Ln(2);
           

         
             $pdf->Cell(180,4,utf8_decode('Impreso por | '.$emp_nombre. '  -  VICPOS  -  V 2.5.'),0,0,'C');

          //  $pdf->AutoPrint();
          //  $pdf->Output();
             $pdf->Output($ven_nombre.'-'.$ven_n_venta.'.pdf', 'I');





?>
