<?php
session_start();
require '../../../conexion.php';
require('../fpdf/fpdf.php');
require('cotizacion1_plantilla.php');
require_once('../../../include/sesiones.php');
    
class PDF_AutoPrint extends PDF_JavaScript
{
    function AutoPrint($printer='')
    {
        if($printer)
        {
            $printer = str_replace('\\', '\\\\', $printer);
            $script = "var pp = getPrintParams();";
            $script .= "pp.interactive = pp.constants.interactionLevel.full;";
            $script .= "pp.printerName = '$printer'";
            $script .= "print(pp);";
        }
        else
            $script = 'print(true);';
        $this->IncludeJS($script);
    }
}

    $pdf = new FPDF( 'P', 'mm', 'A4' ); 
    $pdf->SetAutoPagebreak(False);
    $pdf->SetMargins(0,0,0);
    $pdf->AliasNbPages();
    $pdf->AddPage();
    $pdf = new PDF_AutoPrint();
    
    // nb de page pour le multi-page : 18 lignes
    $cot_id=$_GET['cot_id'];
    $sql = 'SELECT count(*) FROM cotizacion_detalle where cotizacion_cot_id=' .$cot_id;
    $result = mysqli_query($con, $sql)  or die ('Erreur SQL : ' .$sql .mysqli_connect_error() );
    $row_client = mysqli_fetch_row($result);
    mysqli_free_result($result);
     $nb_page = $row_client[0];
    $sql = 'SELECT abs(FLOOR(-' . $nb_page . '/13))';
    $result = mysqli_query($con, $sql)  or die ('Erreur SQL : ' .$sql .mysqli_connect_error() );
    $row_client = mysqli_fetch_row($result);
    mysqli_free_result($result);
    $nb_page = $row_client[0];

    $num_page = 1; 
    $limit_inf = 0; 
    $limit_sup = 13;

    While ($num_page <= $nb_page)
    {
        $pdf->AddPage();
        $pdf->Image('../../../img/'.$empresa.'.png',10,5,60);
        $pdf->Image('../../../img/factura/1.png',100,0,110);
        $pdf->Image('../../../img/factura/2.png',100,31,110);
        $pdf->Image('../../../img/factura/3.png',83,-4,30);
        $pdf->Image('../../../img/factura/4.png',0,281,220);
        $pdf->Image('../../../img/factura/5.png',120,230,100);
        $pdf->SetFont('Arial','B',20);
        // Movernos a la derecha
        $pdf->SetTextColor(255,255,255); 
        $pdf->Cell(130);
        $pdf->Cell(60,4,utf8_decode($emp_nombre),0,0,'R');
        $pdf->Ln();
        $pdf->SetFont('Arial','B',9);
        $pdf->Cell(130);
        $pdf->Cell(60,4,'Nit: '.$emp_nit,0,0,'R');
        $pdf->Ln();
        //   $pdf->Cell(130);
        //   $pdf->Cell(60,4,utf8_decode("Régimen ").$emp_regimen,0,0,'R');
        //   $pdf->Ln();
        $pdf->Cell(130);
        $pdf->Cell(60,4,$emp_direccion,0,0,'R');
        $pdf->Ln();
        $pdf->Cell(130);
        $pdf->Cell(60,4,'E-mail:'.$emp_correo,0,0,'R');
        $pdf->Ln();
        $pdf->Cell(130);
        $pdf->Cell(60,4,'Cel:'.$emp_cel.' / Tel:'.$emp_telefono,0,0,'R');
        $pdf->Ln(5);

        if($emp_regimen=='Comun')
        {
            $pdf->SetFont('Arial','B',6);
            $pdf->Cell(190,4, utf8_decode("RESOL.DIAN ".$ser_resolucion." FECHA ".$ser_fecha." DEL ".$ser_inicio." AL ".$ser_fin." VIGENCIA 24 MESES"), 0, 0, "R");
        }

        $query=mysqli_query($con, "SELECT *  , DATE_FORMAT(cot_fecha, '%d-%m-%Y') AS nueva_fecha  from cotizacion where cot_id='$cot_id' ");
        $roww=mysqli_fetch_array($query);
        $cliente_id=$roww['cliente_id'];
        $ven_cc=$roww['cot_cc'];
        $ven_nombre=$roww['cot_nombre'];
        $ven_fecha=$roww['nueva_fecha'];
        $ven_n_venta=$roww['cot_n_cotizacion'];
        $observaciones=$roww['observaciones'];

        $dir=mysqli_query($con,"SELECT * FROM cliente  where clie_id='$cliente_id'  ") or die(mysqli_error($con)); 
        $dire=mysqli_fetch_array($dir);
        $ven_telefono=$dire['clie_telefono'];
        $clie_direccion=$dire['clie_direccion'];

        $pdf->SetLineWidth(0.1); 
        $pdf->Rect(10, 75, 194, 110, "D");
        // cadre titre des colonnes
        // les traits verticaux colonnes


        $pdf->SetTextColor(0,0,0); 
        $pdf->SetLineWidth(0.1); 
        $pdf->SetFillColor(239);
        //cliente
        $pdf->Rect(10, 40, 120, 30, 0, "DF");
            $pdf->SetFont('Arial','B',10); 
            $pdf->SetXY( 2, 42 ); 
            $pdf->Cell( 25, 6, "Cliente: ", 0, 0, 'R');
            $pdf->SetFont('Arial','B',9); 
            $pdf->SetXY( 30, 42 ); 
            $pdf->MultiCell(100, 5, $ven_nombre."\n", 0, 'J', 1, 1, '' ,'', true);
            $pdf->SetXY( 30, 50 ); 
            $pdf->Cell( 24, 6, 'DOCUMENTO :' .$ven_cc.'', 0, 0, 'L');
            $pdf->SetXY( 30, 55 ); 
            $pdf->Cell(24, 5,'TELEFONO :'.$ven_telefono.'' , 0, 'J', 1, 1, '' ,'', true);
            $pdf->SetXY( 30, 60 ); 
            $pdf->MultiCell(100, 5,'DIRECCION :'.$clie_direccion.'' , 0, 'J', 1, 1, '' ,'', true);
            
            

        //numero factura
        $pdf->Rect(145, 40, 59, 15, 0, "DF");
            $pdf->SetFont('Arial','B',12);
            $pdf->SetTextColor(254,0,0);  
            $pdf->SetXY( 151, 42 ); 
            $pdf->Cell( 25, 6, "COTIZACION: ", 0, 0, 'R');
            $pdf->SetXY( 175, 42 ); 
            $pdf->Cell( 25, 6, $ven_n_venta, 0, 0, 'R');
            $pdf->SetTextColor(0,0,0); 
            $pdf->SetXY( 151, 47 ); 
            $pdf->Cell( 25, 6, "Fecha: ", 0, 0, 'R');
            $pdf->SetXY( 175, 47 ); 
            $pdf->Cell( 25, 6, $ven_fecha, 0, 0, 'R');


            $pdf->Line(30, 80, 30, 185);
            $pdf->Line(45, 80, 45, 185);
            $pdf->Line(135, 80, 135, 185);
            $pdf->Line(135, 80, 135, 185); 
            $pdf->Line(155, 80, 155, 185); 
            $pdf->Line(170, 80, 170, 185); 
            $pdf->Line(185, 80, 185, 185);
          //totales
        $pdf->SetFillColor(239); 
        $pdf->Rect(120, 190, 84, 30, 0, "DF");

        $pdf->SetXY( 10, 75 ); 
        $hex = $color;
        list($r, $g, $b) = sscanf($hex, "#%02x%02x%02x");
        $pdf->SetFont( "Arial", "B", 8 );
        $pdf->SetFillColor($r,$g,$b );
        $pdf->Cell(20,6,'REF' ,1,0,'C',1);
        $pdf->Cell(15,6,'CANT',1,0,'C',1);
        $pdf->Cell(90,6,utf8_decode('DESCRIPCION'),1,0,'C',1);
        $pdf->Cell(20,6,'PRECIO U',1,0,'C',1);
        $pdf->Cell(15,6,'DESC %',1,0,'C',1);
        $pdf->Cell(15,6,'IMP %',1,0,'C',1);
        $pdf->Cell(19,6,'TOTAL',1,0,'C',1);
        $pdf->SetFont('Arial','B',8);
        $pdf->Ln(); 


        // les articles
        $pdf->SetFont('Arial','',7);
        
        // 1ere page = LIMIT 0,18 ;  2eme page = LIMIT 18,36 etc...
        
        $limit_inf;
        $total_ret=0;
        $ret=mysqli_query($con, "SELECT * FROM retencion_cotizacion where cotizacion_cot_id='$cot_id' ") or die(mysqli_error($con)); 
        $rets=mysqli_fetch_array($ret);
            
        $ret_porcentaje=$rets['porcentaje'];
        $sql=mysqli_query($con, "SELECT *,LEFT(cotd_nombre,120) as nombre_c  from  cotizacion_detalle where cotizacion_cot_id='$cot_id' and  empresa='$empresa'  LIMIT  ".$limit_inf." , ".$limit_sup." ");
        $resul=mysqli_num_rows($sql);
        $linea=13-$resul;
        while ($data=mysqli_fetch_array($sql))      
        {
            $nombre_c=$data['nombre_c'];
            $cotd_cantidad=$data['cotd_cantidad'];
            $cotd_precio=$data['cotd_precio'];
            $cotd_iva=$data['cotd_iva'];
            $cotd_descuento=$data['cotd_desc'];

            $nombre = preg_replace("[\n|\r|\n\r]", " ", $nombre_c);


            $iva0=$cotd_iva/100; //0.19
            $iva1=1+$iva0; //1.19

            $precio_u_sin_iva=$cotd_precio/$iva1;
            $precio_retencion=(($precio_u_sin_iva*$ret_porcentaje)/(100-$ret_porcentaje));
            $precio_unidad=(($precio_u_sin_iva*$ret_porcentaje)/(100-$ret_porcentaje))+$precio_u_sin_iva;

            $precio_t_sin_iva=$precio_unidad*$cotd_cantidad;


              $pdf->SetWidths(array(20,15,90,20,15,15,19));
              srand(time()*1000000);
              $pdf->Row(array($data['cotd_referencia'],$data['cotd_cantidad'],$nombre,number_format($precio_unidad,0),$data['cotd_desc'],$data['cotd_iva'],number_format($precio_t_sin_iva,0)));
        
        }
      
     //   $number = $linea;  
     //   if($number > 0)  
     //     {  
     //       for($i=0; $i<$number; $i++)  
       //   {  
         //    $pdf->SetWidths(array(20,15,90,20,15,15,19));
           //   srand(time()*1000000);
         //     $pdf->Row(array('','','','','','',''));
         // } }  
        

        if ($num_page == $nb_page)
        {

    $to=0;
 
    $descuentof=0;
    $descuento=0;
    $neto=0;
    $sumador_total=0;
    $iva_total=0;

    $total_ret=0;
    $ret=mysqli_query($con, "SELECT * FROM retencion_cotizacion where cotizacion_cot_id='$cot_id' ") or die(mysqli_error($con)); 
    $rets=mysqli_fetch_array($ret);
            
    $ret_porcentaje=$rets['porcentaje'];


    $sql=mysqli_query($con, "select * from  cotizacion_detalle where cotizacion_cot_id='$cot_id' and  empresa='$empresa' ");
    while ($row=mysqli_fetch_array($sql))
    {
    $id=$row["cotd_id"];
    $cotd_id=$row["cotd_id"];
    $cotd_referencia=$row['cotd_referencia'];
    $cotd_nombre=$row['cotd_nombre'];
    $cotd_cantidad=$row['cotd_cantidad'];
    $cotd_precio=$row['cotd_precio'];
    $cotd_iva=$row['cotd_iva'];
    $cotd_descuento=$row['cotd_desc'];

    $iva0=$cotd_iva/100; //0.19
    $iva1=1+$iva0; //1.19

    $precio_u_sin_iva=$cotd_precio/$iva1;
    $precio_retencion=(($precio_u_sin_iva*$ret_porcentaje)/(100-$ret_porcentaje));
    $precio_unidad=(($precio_u_sin_iva*$ret_porcentaje)/(100-$ret_porcentaje))+$precio_u_sin_iva;

    $precio_t_sin_iva=$precio_unidad*$cotd_cantidad;

    $descuento=($cotd_descuento/100)*$precio_t_sin_iva;

    $precio_descuento_t=$precio_t_sin_iva-$descuento;

    $total_iva_u=$precio_descuento_t*$iva0;

    $iva_total+=$total_iva_u;

    $neto+=$precio_t_sin_iva;

    $descuentof+=$descuento;
    $total_ret+=$precio_retencion*$cotd_cantidad;

    $sumador_total=($neto+$iva_total)-$descuentof;

      }
    $to+=$sumador_total;



            $pdf->SetLineWidth(0.1);
            $pdf->SetFillColor(239); 
            $pdf->Rect(120, 190, 84, 30, 0,1,"D");
            
            // les titres
            $pdf->SetFont('Arial','B',10); 
            $pdf->SetXY( 150, 190 ); 
            $pdf->Cell( 25, 6, "NETO $", 0, 0, 'R');
            $pdf->SetXY( 180, 190 ); 
            $pdf->Cell( 24, 6, number_format($neto, 0), 0, 0, 'R');

            $pdf->SetXY( 150, 196 ); 
            $pdf->Cell( 25, 6, "IMPUESTO $", 0, 0, 'R');
            $pdf->SetXY( 180, 196 ); 
            $pdf->Cell( 24, 6, number_format($iva_total, 0), 0, 0, 'R');

            $pdf->SetXY( 150, 202 ); 
            $pdf->Cell( 25, 6, "RETEFUENTE $", 0, 0, 'R');
            $pdf->SetXY( 180, 202 ); 
            $pdf->Cell( 24, 6, number_format($total_ret, 0), 0, 0, 'R');

            $pdf->SetFont('Arial','B',12);
            $pdf->SetXY( 150, 208 ); 
            $pdf->Cell( 25, 6, "SUBTOTAL $", 0, 0, 'R');
            $pdf->SetXY( 180, 208 ); 
            $pdf->Cell( 24, 6, number_format($sumador_total-$total_ret+$descuentof, 0), 0, 0, 'R');

            $pdf->SetFont('Arial','B',10);
            $pdf->SetTextColor(140,0,0); 
            $pdf->SetXY( 150, 214 ); 
            $pdf->Cell( 25, 6, "DESCUENTO $", 0, 0, 'R');
            $pdf->SetXY( 180, 214 ); 
            $pdf->Cell( 24, 6, number_format($descuentof, 0), 0, 0, 'R');

            
            $pdf->SetFont('Arial','B',16); 
            $pdf->SetTextColor(255,255,255); 
            $pdf->SetXY( 150, 235 ); 
            $pdf->Cell( 25, 6, "TOTAL $:", 0, 0, 'R');
            $pdf->SetXY( 180, 235 ); 
            $pdf->Cell( 24, 6, number_format($sumador_total-$total_ret, 0), 0, 0, 'R');
        }



        $pdf->SetTextColor(0,0,0); 
        //cliente
        $pdf->SetXY( 120, 268 ); 
        $pdf->SetFont( "Arial", "B", 12 ); 
        $pdf->Cell( 1, 8, 'Vendedor:', 0, 0, 'L');
        $pdf->Cell(120,0,'___________________________________',0,0,'L');

        //observaciones
        $pdf->SetFillColor(255);
        $pdf->SetXY( 10, 190 ); 
        $pdf->SetFont( "Arial", "B",8 ); 
        $pdf->MultiCell(100, 2.5, $observaciones,0, 1, 'L');

        //condiciones
        $pdf->SetFillColor(255);
        $pdf->SetXY( 10, 230 ); 
        $pdf->SetFont( "Arial", "B",6 ); 
        $pdf->MultiCell(100, 2.5, $condiciones_cot,0, 1, 'L');
                
          
        // par page de 18 lignes
        $num_page++; 
        $limit_inf += 13; 
        $limit_sup + 13; 
    }
    
       $pdf->AutoPrint();
       $pdf->Output($ven_nombre.'.pdf', 'I');
?>